/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.webapi.helper;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.stat.TableStat;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.SecurityUtils;
import kd.mpscmm.msplan.webapi.enums.SQLErrorTypeEnum;
import kd.mpscmm.msplan.webapi.extpoint.IScriptCheckExtPlugin;
import kd.mpscmm.msplan.webapi.extpoint.ScriptCheckExtFactory;
import kd.mpscmm.msplan.webapi.helper.CheckToolParam;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class SQLScriptScanHelper {
    private static final Log log = LogFactory.getLog(SQLScriptScanHelper.class);
    private static final String dbSchema = "dbschema";
    private static final String preInsData = "preinsdata";
    private static final String metadata = "metadata";
    private static final String KSQL_PRE = "KSQL_";
    private static final Set<String> ignoreFields = new HashSet<String>(4);
    private static final Set<String> ignoreDbFields = new HashSet<String>(4);
    private static final String customDirPrefix = "mmc_sql_script_temp_";
    private static final String BOS_DEVP_TABLEDICTION = "bos_devp_tablediction";

    public static void main(String[] args) {
        SQLScriptScanHelper.metadataAndSqlCheck4GitBranch("", "patch");
    }

    public static String metadataAndSqlCheck4GitBranch(String buildId, String gitBranch) {
        return SQLScriptScanHelper.metadataAndSqlCheck4GitBranch(buildId, gitBranch, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String metadataAndSqlCheck4GitBranch(String buildId, String gitBranch, String appName) {
        log.info(String.format("metadataAndSqlCheck4GitBranch-begin-------> branch:%s", gitBranch));
        long startTime = System.currentTimeMillis();
        Map<String, List<String>> cloud2apps = SQLScriptScanHelper.initCheckApps(appName);
        StringBuilder error = new StringBuilder();
        Path path = null;
        try {
            path = Files.createTempDirectory(customDirPrefix, new FileAttribute[0]);
            long endCreateTempDir = System.currentTimeMillis();
            log.info(String.format("metadataAndSqlCheck4GitBranch-tempDirectory:%s-------> timecost: %s(MS)", path, endCreateTempDir - startTime));
            SQLScriptScanHelper.downloadMetadataZip(gitBranch, cloud2apps, path);
            long endDownLoad = System.currentTimeMillis();
            log.info(String.format("metadataAndSqlCheck4GitBranch-downloadMetadataZip-------> timecost: %s(MS)", endDownLoad - endCreateTempDir));
            File dir = path.toFile();
            if (dir.listFiles() != null) {
                for (File f : Objects.requireNonNull(dir.listFiles())) {
                    SQLScriptScanHelper.dealZip(f, path);
                }
            }
            long endDealZip = System.currentTimeMillis();
            log.info(String.format("metadataAndSqlCheck4GitBranch-dealZip-------> timecost: %s(MS)", endDealZip - endDownLoad));
            for (Map.Entry<String, List<String>> entry : cloud2apps.entrySet()) {
                for (String app : entry.getValue()) {
                    log.info(String.format("metadataAndSqlCheck4GitBranch-check-------> appId:%s", app));
                    try {
                        if (error.length() > 0) {
                            error.append("\r\n");
                        }
                        error.append(SQLScriptScanHelper.scanMetadataAndSqlFile(path, buildId, gitBranch, app));
                    }
                    catch (Exception e) {
                        log.error(String.format("metadataAndSqlCheck4GitBranch-check-error,appId:%s.", app), (Throwable)e);
                        error.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    }
                }
            }
            log.info("metadataAndSqlCheck4GitBranch-end------->");
        }
        catch (IOException e) {
            log.error("metadataAndSqlCheck4GitBranch-error.", (Throwable)e);
            error.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        finally {
            if (path != null) {
                SQLScriptScanHelper.deleteFile(path.toFile());
            }
        }
        return error.toString();
    }

    public static void deleteFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    SQLScriptScanHelper.deleteFile(f);
                    continue;
                }
                SQLScriptScanHelper.deleteF(f);
            }
        }
        SQLScriptScanHelper.deleteF(file);
    }

    private static void deleteF(File file) {
        boolean isDelete = file.delete();
        for (int count = 1; !isDelete && count < 10; ++count) {
            isDelete = file.delete();
        }
        if (!isDelete) {
            file.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadMetadataZip(String gitBranch, Map<String, List<String>> cloud2apps, Path path) {
        for (Map.Entry<String, List<String>> entry : cloud2apps.entrySet()) {
            String cloud = entry.getKey();
            for (String app : entry.getValue()) {
                try {
                    String urlPath = SQLScriptScanHelper.getArtifactsUrlPath(gitBranch, cloud, app);
                    URL url = new URL(urlPath);
                    URLConnection urlConnection = url.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                    httpURLConnection.setConnectTimeout(5000);
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.setRequestProperty("Charset", "UTF-8");
                    httpURLConnection.connect();
                    int fileLength = httpURLConnection.getContentLength();
                    BufferedInputStream bin = null;
                    try {
                        bin = new BufferedInputStream(httpURLConnection.getInputStream());
                        String fileName = String.format("%s-%s-dm-1.x.zip", cloud, app);
                        File file = new File(path.toFile(), FilenameUtils.getName((String)fileName));
                        FileOutputStream out = new FileOutputStream(file);
                        Throwable throwable = null;
                        try {
                            int size = 0;
                            int len = 0;
                            byte[] buf = new byte[2048];
                            while ((size = bin.read(buf)) != -1) {
                                len += size;
                                ((OutputStream)out).write(buf, 0, size);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (out == null) continue;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)out).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ((OutputStream)out).close();
                        }
                    }
                    finally {
                        if (bin == null) continue;
                        SQLScriptScanHelper.safeClose(bin);
                    }
                }
                catch (Exception e) {
                    log.error("metadataAndSqlCheck4GitBranch-error.", (Throwable)e);
                }
            }
        }
    }

    private static String getArtifactsUrlPath(String gitBranch, String cloud, String app) {
        String artifactsPath = "http://172.17.201.20:31085/artifactory/cosmic-cd/patchscm/smoke/prepare/runtime/datamodel";
        switch (gitBranch) {
            case "feature_sit": {
                artifactsPath = "http://172.17.201.20:31085/artifactory/cosmic-cd/feature_sit_scm/smoke/prepare/runtime/datamodel";
                break;
            }
            case "release": {
                artifactsPath = "http://172.18.1.209:88/baseline/test/prepare/runtime/datamodel";
                break;
            }
        }
        return String.format("%s/%s-%s-dm-1.x.zip", artifactsPath, cloud, app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dealZip(File zipSourceFile, Path targetZipPath) {
        File pathFile = targetZipPath.toFile();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipSourceFile, StandardCharsets.UTF_8);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                InputStream in = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    File outPathFile;
                    String outpath = zipEntryName.replace("/", File.separator);
                    File file = new File(pathFile, SecurityUtils.normalize((String)outpath.substring(0, outpath.lastIndexOf(File.separator))));
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    if ((outPathFile = new File(pathFile, SecurityUtils.normalize((String)outpath))).isDirectory()) continue;
                    FileOutputStream out = new FileOutputStream(outPathFile);
                    Throwable throwable2 = null;
                    try {
                        int len;
                        byte[] bf = new byte[2048];
                        while ((len = in.read(bf)) > 0) {
                            ((OutputStream)out).write(bf, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (Exception e) {
            log.error("metadataAndSqlCheck4GitBranch-error.", (Throwable)e);
        }
        finally {
            if (zipFile != null) {
                SQLScriptScanHelper.safeClose(zipFile);
            }
        }
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    private static Map<String, List<String>> initCheckApps(String appName) {
        HashMap<String, List<String>> cloud2apps = new HashMap<String, List<String>>(2);
        if (StringUtils.isBlank((CharSequence)appName)) {
            List mmc = cloud2apps.computeIfAbsent("mmc", k -> new ArrayList(13));
            mmc.add("fmm");
            mmc.add("mds");
            mmc.add("mps");
            mmc.add("mrp");
            mmc.add("om");
            mmc.add("opm");
            mmc.add("pdm");
            mmc.add("pmqm");
            mmc.add("pmtm");
            mmc.add("pmts");
            mmc.add("pmpd");
            mmc.add("pom");
            mmc.add("sfc");
            List mpscmm = cloud2apps.computeIfAbsent("mpscmm", k -> new ArrayList(13));
            mpscmm.add("msplan");
            List bd = cloud2apps.computeIfAbsent("bd", k -> new ArrayList(13));
            bd.add("mpdm");
            List qmc = cloud2apps.computeIfAbsent("qmc", k -> new ArrayList(13));
            qmc.add("qcp");
            qmc.add("qcpp");
            qmc.add("qcas");
            qmc.add("qcnp");
            qmc.add("qcqi");
            qmc.add("qcqs");
            qmc.add("qcsp");
            qmc.add("qcbd");
            qmc.add("mobqc");
        } else {
            String[] str1 = appName.split("-");
            List appIds = cloud2apps.computeIfAbsent(str1[0], k -> new ArrayList(1));
            appIds.add(str1[1]);
        }
        return cloud2apps;
    }

    private static DynamicObject writeCheckLog(CheckLogEntity checkLogEntity, StringBuilder error, Map<String, Set<String>> errorType2WhiteList) {
        DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"msplan_metasql_checklog");
        data.set("buildId", (Object)checkLogEntity.buildId);
        data.set("gitbranch", (Object)checkLogEntity.gitBranch);
        data.set("appid", (Object)checkLogEntity.appId);
        data.set("exceptioninfo", (Object)(checkLogEntity.exceptionInfo.length() > 2000 ? checkLogEntity.exceptionInfo.substring(0, 2000) : checkLogEntity.exceptionInfo));
        data.set("sqlname", (Object)checkLogEntity.sqlName);
        data.set("sqlrow", (Object)checkLogEntity.sqlRow);
        data.set("id", (Object)ORM.create().genLongId("msplan_metasql_checklog"));
        data.set("level", (Object)checkLogEntity.level);
        data.set("metadatakey", (Object)checkLogEntity.metadataKey);
        data.set("tablename", (Object)checkLogEntity.tableName);
        data.set("errortype", (Object)checkLogEntity.errorType);
        data.set("sql", (Object)(checkLogEntity.sql.length() > 1000 ? checkLogEntity.sql.substring(0, 1000) : checkLogEntity.sql));
        Set<String> whiteList = errorType2WhiteList.get(checkLogEntity.errorType);
        String key = SQLScriptScanHelper.getKeyBySqlErrorType(checkLogEntity.errorType, new CheckToolParam.OnlyGetMap(data));
        boolean isWhiteList = false;
        if (whiteList != null && key != null) {
            String[] str = key.split("\u0001");
            for (String whiteKey : whiteList) {
                String[] s1 = whiteKey.split("\u0001");
                if (str[0].equalsIgnoreCase(s1[0])) {
                    for (int i = 1; i < str.length && i < s1.length; ++i) {
                        if (!str[i].equalsIgnoreCase(s1[i]) || !StringUtils.isNotBlank((CharSequence)s1[i])) continue;
                        isWhiteList = true;
                        break;
                    }
                }
                if (!isWhiteList) continue;
                break;
            }
        }
        data.set("iswhitelist", (Object)isWhiteList);
        if (StringUtils.isNotBlank((CharSequence)checkLogEntity.level) && !"A".equals(checkLogEntity.level) && !isWhiteList) {
            if (error.length() > 0) {
                error.append("\r\n");
            }
            error.append(checkLogEntity.exceptionInfo);
        }
        return data;
    }

    public static String scanMetadataAndSqlFile(Path rootPath, String buildId, String gitBranch, String appId) {
        return SQLScriptScanHelper.scanMetadataAndSqlFile(rootPath, buildId, gitBranch, appId, false, true);
    }

    public static String scanMetadataAndSqlFile(Path rootPath, String buildId, String gitBranch, String appId, boolean is_ignore_null, boolean is_ignore_comp_field) {
        String childPach = String.format("datamodel/1.5/main/%s", appId);
        File rootDir = new File(rootPath.toFile(), childPach);
        StringBuilder error = new StringBuilder();
        CheckLogEntity checkLogEntity = new CheckLogEntity(buildId, gitBranch, appId);
        ArrayList<DynamicObject> checkLogs = new ArrayList<DynamicObject>(16);
        if (Objects.requireNonNull(rootDir.listFiles()).length > 0) {
            String msg;
            String xmlName = appId + ".xml";
            File appXmlFile = null;
            File dbSchemaDir = null;
            File preInsDataDir = null;
            File metadataDir = null;
            for (File file : Objects.requireNonNull(rootDir.listFiles())) {
                String fileName = file.getName();
                if (dbSchema.equalsIgnoreCase(fileName)) {
                    dbSchemaDir = file;
                    continue;
                }
                if (preInsData.equalsIgnoreCase(fileName)) {
                    preInsDataDir = file;
                    continue;
                }
                if (metadata.equalsIgnoreCase(fileName)) {
                    metadataDir = file;
                    continue;
                }
                if (!xmlName.equalsIgnoreCase(fileName)) continue;
                appXmlFile = file;
            }
            if (appXmlFile == null || appXmlFile.isDirectory()) {
                msg = String.format(ResManager.loadKDString((String)"%1$s\u6587\u4ef6\u8def\u5f84\u4e0b\u4e0d\u5b58\u5728%2$s\u5e94\u7528\u811a\u672c\u6ce8\u518c\u7684xml\u6587\u4ef6\u3002", (String)"SQLScriptScanHelper_1", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), rootPath, appId);
                checkLogEntity.setExceptionInfo(msg);
                checkLogs.add(SQLScriptScanHelper.writeCheckLog(checkLogEntity, error, new HashMap<String, Set<String>>(0)));
            } else if (metadataDir == null || !metadataDir.isDirectory()) {
                msg = String.format(ResManager.loadKDString((String)"%1$s\u6587\u4ef6\u8def\u5f84\u4e0b\u4e0d\u5b58\u5728%2$s\u5143\u6570\u636e\u76ee\u5f55\u3002", (String)"SQLScriptScanHelper_2", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), rootPath, metadata);
                checkLogEntity.setExceptionInfo(msg);
                checkLogs.add(SQLScriptScanHelper.writeCheckLog(checkLogEntity, error, new HashMap<String, Set<String>>(0)));
            } else {
                long startTime = System.currentTimeMillis();
                Map<String, Map<String, List<List<String>>>> metaInfoMap = SQLScriptScanHelper.initMetadataFile(metadataDir);
                log.info(String.format("metadataAndSqlCheck4GitBranch-initMetadataFile-appId: %s -------> timecost: %s(MS)", appId, System.currentTimeMillis() - startTime));
                startTime = System.currentTimeMillis();
                Set<String> entityKeys = metaInfoMap.keySet();
                Map<String, LinkedHashSet<String>> sqlMap = SQLScriptScanHelper.readAppXmlFile(appXmlFile);
                log.info(String.format("metadataAndSqlCheck4GitBranch-readAppXmlFile-appId: %s -------> timecost: %s(MS)", appId, System.currentTimeMillis() - startTime));
                startTime = System.currentTimeMillis();
                LinkedHashSet<String> dbSchemaSql = sqlMap.get(dbSchema);
                LinkedHashSet<String> preInsDataSql = sqlMap.get(preInsData);
                LinkedHashMap<String, Set<String>> dbCheckTables = new LinkedHashMap<String, Set<String>>();
                LinkedHashMap<String, Set<String>> preCheckTables = new LinkedHashMap<String, Set<String>>();
                HashMap<String, List<Map<String, Object>>> file2NotUpperInfo = new HashMap<String, List<Map<String, Object>>>(16);
                CheckToolParam checkToolParam = new CheckToolParam(error, checkLogs, checkLogEntity);
                checkToolParam.setFile2NotUpperInfo(file2NotUpperInfo);
                SQLScriptScanHelper.initWhiteList(checkToolParam);
                Map<String, Map<String, String>> table2Columns = SQLScriptScanHelper.getCheckFiles(dbSchemaSql, dbSchemaDir, dbCheckTables, true, checkToolParam);
                SQLScriptScanHelper.getCheckFiles(preInsDataSql, preInsDataDir, preCheckTables, false, checkToolParam);
                SQLScriptScanHelper.addSqlLossErrorMsg(dbSchemaSql, checkToolParam);
                SQLScriptScanHelper.addSqlLossErrorMsg(preInsDataSql, checkToolParam);
                log.info(String.format("metadataAndSqlCheck4GitBranch-checkSQLFile-appId: %s -------> timecost: %s(MS)", appId, System.currentTimeMillis() - startTime));
                startTime = System.currentTimeMillis();
                HashMap<String, String> havCheckTables = new HashMap<String, String>();
                SQLScriptScanHelper.check(entityKeys, dbCheckTables, dbSchema, havCheckTables, is_ignore_null, checkToolParam);
                SQLScriptScanHelper.check(entityKeys, preCheckTables, preInsData, havCheckTables, is_ignore_null, checkToolParam);
                log.info(String.format("metadataAndSqlCheck4GitBranch-checkMetaData-appId: %s -------> timecost: %s(MS)", appId, System.currentTimeMillis() - startTime));
                startTime = System.currentTimeMillis();
                SQLScriptScanHelper.checkTableFields(metaInfoMap, table2Columns, is_ignore_comp_field, checkToolParam);
                log.info(String.format("metadataAndSqlCheck4GitBranch-checkMetaDataField-appId: %s -------> timecost: %s(MS)", appId, System.currentTimeMillis() - startTime));
            }
        }
        long startTime = System.currentTimeMillis();
        QFilter qFilterGitBranch = new QFilter("gitbranch", "=", (Object)gitBranch);
        QFilter qFilterApp = new QFilter("appid", "=", (Object)appId);
        DeleteServiceHelper.delete((String)"msplan_metasql_checklog", (QFilter[])new QFilter[]{qFilterGitBranch, qFilterApp});
        log.info(String.format("metadataAndSqlCheck4GitBranch-deleteCheckLog-appId: %s -------> timecost: %s(MS)", appId, System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        if (!checkLogs.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])checkLogs.toArray(new DynamicObject[0]));
        }
        log.info(String.format("metadataAndSqlCheck4GitBranch-saveCheckLog-appId: %s -------> timecost: %s(MS)", appId, System.currentTimeMillis() - startTime));
        return error.toString();
    }

    private static void initWhiteList(CheckToolParam checkToolParam) {
        QFilter qFilter = new QFilter("gitbranch", "=", (Object)checkToolParam.getCheckLogEntity().gitBranch);
        if (StringUtils.isNotBlank((CharSequence)checkToolParam.getCheckLogEntity().appId)) {
            qFilter.and("appid", "=", (Object)checkToolParam.getCheckLogEntity().appId);
        }
        HashMap<String, Set<String>> errorType2WhiteList = new HashMap<String, Set<String>>(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"initWhiteList", (String)"msplan_metasql_whitelist", (String)"gitbranch,appid,errortype,sqlname,metadatakey,tablename", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row row : dataSet) {
                CheckToolParam.OnlyGetMap onlyGetMap;
                String errorType = row.getString("errortype");
                String key = SQLScriptScanHelper.getKeyBySqlErrorType(errorType, onlyGetMap = new CheckToolParam.OnlyGetMap(row));
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                Set keys = errorType2WhiteList.computeIfAbsent(errorType, k -> new HashSet(8));
                keys.add(key);
            }
        }
        checkToolParam.setErrorType2WhiteList(errorType2WhiteList);
    }

    private static String getKeyBySqlErrorType(String sqlErrorType, CheckToolParam.OnlyGetMap onlyGetMap) {
        IScriptCheckExtPlugin scriptCheckExtPlugin;
        SQLErrorTypeEnum sqlErrorTypeEnum = SQLErrorTypeEnum.getByValue(sqlErrorType);
        String key = null;
        switch (sqlErrorTypeEnum) {
            case TABLE_MISS_ERROR: 
            case FIELD_TYPE_INCONSISTENT: 
            case APPLICATION_INCONSISTENT: 
            case BIZ_CREATE_BOS_TABLE: {
                key = onlyGetMap.getString("appid") + "\u0001" + onlyGetMap.getString("metadatakey") + "\u0001" + onlyGetMap.getString("tablename");
                break;
            }
            case TABLE_NOT_BOUND_META: {
                key = onlyGetMap.getString("appid") + "\u0001" + onlyGetMap.getString("tablename");
                break;
            }
            case SQL_EXCEPTION: 
            case TABLE_FIELD_NOT_UPPER: 
            case SQL_FILE_ENCODING_ERROR: 
            case SQL_VIOLATION_NOTNULL: {
                key = onlyGetMap.getString("appid") + "\u0001" + onlyGetMap.getString("sqlname");
                break;
            }
        }
        if (StringUtils.isBlank(key) && (scriptCheckExtPlugin = ScriptCheckExtFactory.getScriptCheckExtPlugin(sqlErrorType)) != null) {
            key = scriptCheckExtPlugin.getWhiteListUniqueKey(onlyGetMap);
        }
        return key;
    }

    private static void checkTableFields(Map<String, Map<String, List<List<String>>>> metaInfoMap, Map<String, Map<String, String>> table2Columns, boolean is_ignore_comp_field, CheckToolParam checkToolParam) {
        for (Map.Entry<String, Map<String, List<List<String>>>> entry : metaInfoMap.entrySet()) {
            String entity = entry.getKey();
            for (Map.Entry<String, List<List<String>>> info : entry.getValue().entrySet()) {
                String table = info.getKey();
                Map<String, String> columnFields = table2Columns.get(table);
                if (SQLScriptScanHelper.sqlIsNull(columnFields, entity, table, checkToolParam)) continue;
                for (List<String> list : info.getValue()) {
                    String isGl;
                    String displayName = list.get(0);
                    String name = list.get(1);
                    String type = list.get(2);
                    Set<String> toDataType = SQLScriptScanHelper.toDataType(type, is_ignore_comp_field);
                    String fd = list.get(3).toUpperCase(Locale.ENGLISH);
                    String string = isGl = list.size() >= 5 ? list.get(4) : "0";
                    if ("ILocaleString".equalsIgnoreCase(type)) {
                        String localStrTable = String.format("%s_L", table);
                        Map<String, String> cLocalFields = table2Columns.get(localStrTable);
                        if (SQLScriptScanHelper.sqlIsNull(cLocalFields, entity, localStrTable, checkToolParam)) continue;
                        SQLScriptScanHelper.sqlTypeMismatch(cLocalFields, entity, localStrTable, fd, toDataType, displayName, name, type, checkToolParam);
                        if (!"1".equals(isGl)) continue;
                        SQLScriptScanHelper.sqlTypeMismatch(columnFields, entity, table, fd, toDataType, displayName, name, type, checkToolParam);
                        continue;
                    }
                    SQLScriptScanHelper.sqlTypeMismatch(columnFields, entity, table, fd, toDataType, displayName, name, type, checkToolParam);
                }
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : table2Columns.entrySet()) {
            if (entry.getValue().containsKey("P_ALTERPK")) continue;
            String metaEntityKey = SQLScriptScanHelper.getMetadataByTable(metaInfoMap.keySet(), entry.getKey());
            String msg = String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e[%1$s]\uff0c\u6570\u636e\u8868[%2$s]\uff0c\u4e0d\u5b58\u5728\u521b\u5efa\u4e3b\u952e\u811a\u672c\u3002", (String)"SQLScriptScanHelper_3", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), metaEntityKey, entry.getKey());
            CheckLogEntity checkLogEntity = checkToolParam.getCheckLogEntity().origClone(checkToolParam.getCheckLogEntity());
            checkLogEntity.setExceptionInfo(msg);
            checkLogEntity.setErrorType(SQLErrorTypeEnum.TABLE_MISS_ERROR.getValue());
            checkLogEntity.setMetadataKey(metaEntityKey == null ? "" : metaEntityKey);
            checkLogEntity.setTableName(entry.getKey());
            checkToolParam.getCheckLogs().add(SQLScriptScanHelper.writeCheckLog(checkLogEntity, checkToolParam.getError(), checkToolParam.getErrorType2WhiteList()));
        }
        for (Map.Entry<String, Object> entry : checkToolParam.getFile2NotUpperInfo().entrySet()) {
            String fileName = entry.getKey();
            for (Map map : (List)entry.getValue()) {
                String sql = (String)map.get("sql");
                String fileDir = (String)map.get("fileDir");
                Set table = (Set)map.get("table");
                Set set = (Set)map.get("field");
                String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c%1$s/%2$s\uff0c\u6570\u636e\u8868\u540d%3$s\uff0c\u5b57\u6bb5\u540d%4$s\u672a\u5927\u5199\u3002", (String)"SQLScriptScanHelper_18", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), fileDir, fileName, table.toString(), set.toString());
                SQLScriptScanHelper.writeSqlScriptCheckResult(fileName, sql, msg, checkToolParam, SQLErrorTypeEnum.TABLE_FIELD_NOT_UPPER.getValue());
            }
        }
    }

    private static boolean sqlIsNull(Map<String, String> columnFields, String entity, String table, CheckToolParam checkToolParam) {
        if (columnFields == null) {
            if (!table.endsWith("_LK")) {
                String msg = String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e[%1$s]\uff0c\u6570\u636e\u8868[%2$s]\uff0c\u4e0d\u5b58\u5728\u5efa\u8868\u811a\u672c\u3002", (String)"SQLScriptScanHelper_4", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), entity, table);
                CheckLogEntity checkLogEntity = checkToolParam.getCheckLogEntity().origClone(checkToolParam.getCheckLogEntity());
                checkLogEntity.setExceptionInfo(msg);
                checkLogEntity.setErrorType(SQLErrorTypeEnum.TABLE_MISS_ERROR.getValue());
                checkLogEntity.setMetadataKey(entity);
                checkLogEntity.setTableName(table);
                checkToolParam.getCheckLogs().add(SQLScriptScanHelper.writeCheckLog(checkLogEntity, checkToolParam.getError(), checkToolParam.getErrorType2WhiteList()));
            }
            return true;
        }
        return false;
    }

    private static void sqlTypeMismatch(Map<String, String> columnFields, String entity, String table, String fd, Set<String> toDataType, String displayName, String name, String type, CheckToolParam checkToolParam) {
        String dataType = columnFields.getOrDefault(fd, "");
        String[] strs = dataType.split("\u0001");
        if (strs.length < 2) {
            String msg = String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e[%1$s]\uff0c\u6570\u636e\u8868[%2$s]\uff0c\u811a\u672c\u7f3a\u5b57\u6bb5\uff1a%3$s[%4$s-%5$s]\u3002", (String)"SQLScriptScanHelper_5", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), entity, table, displayName, name, fd);
            CheckLogEntity checkLogEntity = checkToolParam.getCheckLogEntity().origClone(checkToolParam.getCheckLogEntity());
            checkLogEntity.setExceptionInfo(msg);
            checkLogEntity.setErrorType(SQLErrorTypeEnum.TABLE_MISS_ERROR.getValue());
            checkLogEntity.setMetadataKey(entity);
            checkLogEntity.setTableName(table);
            checkToolParam.getCheckLogs().add(SQLScriptScanHelper.writeCheckLog(checkLogEntity, checkToolParam.getError(), checkToolParam.getErrorType2WhiteList()));
        } else if (!toDataType.contains(strs[1])) {
            String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c%1$s/%2$s\uff0c\u5143\u6570\u636e[%3$s]\uff0c\u6570\u636e\u8868[%4$s]\uff0c\u5b57\u6bb5\uff1a%5$s[%6$s-%7$s]\u5143\u6570\u636e\u548c\u811a\u672c\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u5143\u6570\u636e\u5b57\u6bb5\u7c7b\u578b\uff1a%8$s\uff0c\u811a\u672c\u5b57\u6bb5\u7c7b\u578b\uff1a%9$s\u3002", (String)"SQLScriptScanHelper_6", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), dbSchema, strs[0], entity, table, displayName, name, fd, type, strs[1]);
            CheckLogEntity checkLogEntity = checkToolParam.getCheckLogEntity().origClone(checkToolParam.getCheckLogEntity());
            checkLogEntity.setExceptionInfo(msg);
            checkLogEntity.setErrorType(SQLErrorTypeEnum.FIELD_TYPE_INCONSISTENT.getValue());
            checkLogEntity.setSqlName(strs[0]);
            checkLogEntity.setLevel("B");
            checkLogEntity.setMetadataKey(entity);
            checkLogEntity.setTableName(table);
            checkToolParam.getCheckLogs().add(SQLScriptScanHelper.writeCheckLog(checkLogEntity, checkToolParam.getError(), checkToolParam.getErrorType2WhiteList()));
        }
    }

    private static void check(Set<String> entityKeys, LinkedHashMap<String, Set<String>> checkTables, String scriptDir, Map<String, String> havCheckTables, boolean is_ignore_null, CheckToolParam checkToolParam) {
        HashSet<String> allTables = new HashSet<String>(16);
        for (Set<String> set : checkTables.values()) {
            allTables.addAll(set);
        }
        SQLScriptScanHelper.batchGetMetadataByTable(entityKeys, havCheckTables, allTables);
        for (Map.Entry entry : checkTables.entrySet()) {
            String scriptName = (String)entry.getKey();
            Set tables = (Set)entry.getValue();
            for (String table : tables) {
                String entity;
                if (havCheckTables.containsKey(table)) {
                    entity = havCheckTables.get(table);
                } else {
                    entity = SQLScriptScanHelper.getMetadataByTable(entityKeys, table);
                    havCheckTables.put(table, entity);
                }
                if (entity == null && (table.endsWith("_BIT") || table.endsWith("_R3") || table.endsWith("_U") || table.endsWith("EXC") || table.endsWith("USEREG"))) {
                    String newTable = table.endsWith("_BIT") ? table.substring(0, table.length() - 4) : (table.endsWith("_R3") || table.endsWith("EXC") ? table.substring(0, table.length() - 3) : (table.endsWith("_U") ? table.substring(0, table.length() - 2) : table.substring(0, table.length() - 6)));
                    if (havCheckTables.containsKey(newTable)) {
                        entity = havCheckTables.get(newTable);
                    } else {
                        entity = SQLScriptScanHelper.getMetadataByTable(entityKeys, newTable);
                        havCheckTables.put(newTable, entity);
                    }
                    if (entity != null) {
                        String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c%1$s/%2$s\uff0c\u5143\u6570\u636e[%3$s]\uff0c\u6570\u636e\u8868[%4$s]--\u4e1a\u52a1\u90e8\u95e8\u7981\u6b62\u521b\u5efa\u5e73\u53f0\u63a7\u5236\u7b56\u7565\u76f8\u5173\u6570\u636e\u8868\u3002", (String)"SQLScriptScanHelper_12", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), scriptDir, scriptName, entity, table);
                        CheckLogEntity checkLogEntity = checkToolParam.getCheckLogEntity().origClone(checkToolParam.getCheckLogEntity());
                        checkLogEntity.setExceptionInfo(msg);
                        checkLogEntity.setErrorType(SQLErrorTypeEnum.BIZ_CREATE_BOS_TABLE.getValue());
                        checkLogEntity.setSqlName(scriptName);
                        checkLogEntity.setLevel("B");
                        checkLogEntity.setMetadataKey(entity);
                        checkLogEntity.setTableName(table);
                        checkToolParam.getCheckLogs().add(SQLScriptScanHelper.writeCheckLog(checkLogEntity, checkToolParam.getError(), checkToolParam.getErrorType2WhiteList()));
                    }
                }
                if (is_ignore_null && entity == null || entity != null && entityKeys.contains(entity) || preInsData.equals(scriptDir) && (table.startsWith("T_BOS") || table.startsWith("T_META_") || table.startsWith("T_BAS_") || table.startsWith("T_PERM_") || table.startsWith("T_BD_DEFAULTCTRL") || table.startsWith("T_CR_CODERULE")) || table.startsWith("T_EVT_") || table.startsWith("T_SCH_") || table.startsWith("T_OPEN_") || table.startsWith("T_BOTP_") || table.startsWith("T_ORG_") || table.startsWith("T_BD_IGNOREREFCHECK") || table.startsWith("T_SBD_BIZTYPE") || table.startsWith("T_BD_BIZTYPE") || table.startsWith("T_BAL_") || table.startsWith("T_WF_") || table.startsWith("T_PRIVACY_") || table.startsWith("T_WARN_") || table.startsWith("T_BD_LINETYPEENTRY") || table.startsWith("T_SVC_") || table.startsWith("T_OPENAPI_")) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c%1$s/%2$s\uff0c\u8868[%3$s]\u6240\u7ed1\u5b9a\u7684\u5143\u6570\u636e[%4$s]\u5728\u5143\u6570\u636e\u76ee\u5f55\u4e2d\u672a\u627e\u5230\u3002", (String)"SQLScriptScanHelper_7", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), scriptDir, scriptName, table, entity);
                CheckLogEntity checkLogEntity = checkToolParam.getCheckLogEntity().origClone(checkToolParam.getCheckLogEntity());
                checkLogEntity.setExceptionInfo(msg);
                checkLogEntity.setErrorType(entity == null ? SQLErrorTypeEnum.TABLE_NOT_BOUND_META.getValue() : SQLErrorTypeEnum.APPLICATION_INCONSISTENT.getValue());
                checkLogEntity.setSqlName(scriptName);
                checkLogEntity.setLevel(entity == null ? "A" : "C");
                checkLogEntity.setMetadataKey(entity == null ? "" : entity);
                checkLogEntity.setTableName(table);
                checkToolParam.getCheckLogs().add(SQLScriptScanHelper.writeCheckLog(checkLogEntity, checkToolParam.getError(), checkToolParam.getErrorType2WhiteList()));
            }
        }
    }

    private static String getMetadataByTable(Set<String> entityKeys, String table) {
        String key = null;
        String selectSql = String.format("select fmainentityid from t_meta_tablediction where upper(ftablename) = '%s'", table);
        ArrayList<String> mainEntityIds = new ArrayList<String>(2);
        try (DataSet dataSet = DB.queryDataSet((String)"SQLScriptScanHelper", (DBRoute)DBRoute.meta, (String)selectSql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String fmainentityid = row.getString("fmainentityid");
                mainEntityIds.add(fmainentityid);
            }
        }
        if (!mainEntityIds.isEmpty()) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fentitykey from t_meta_entityinfo where ", new Object[0]);
            sqlBuilder.appendIn("fentityid", mainEntityIds.toArray());
            try (DataSet data = DB.queryDataSet((String)"SQLScriptScanHelper", (DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder);){
                while (data.hasNext()) {
                    Row row = data.next();
                    key = row.getString("fentitykey");
                    if (!entityKeys.contains(key)) continue;
                    String string = key;
                    return string;
                }
            }
        }
        return key;
    }

    private static void batchGetMetadataByTable(Set<String> entityKeys, Map<String, String> table2entityKey, Set<String> tables) {
        Object fmainentityid;
        if (tables.isEmpty()) {
            return;
        }
        tables = new HashSet<String>(tables);
        SqlBuilder selectSql = new SqlBuilder();
        selectSql.append("select upper(ftablename) as ftablename,fmainentityid from t_meta_tablediction where ", new Object[0]);
        selectSql.appendIn("upper(ftablename)", tables.toArray());
        HashMap<String, Set> table2mainEntityId = new HashMap<String, Set>(tables.size());
        HashSet<String> allMainEntityIds = new HashSet<String>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"SQLScriptScanHelper", (DBRoute)DBRoute.meta, (SqlBuilder)selectSql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                fmainentityid = row.getString("fmainentityid");
                String ftablename = row.getString("ftablename");
                Set mainEntityIds = table2mainEntityId.computeIfAbsent(ftablename, k -> new LinkedHashSet(2));
                mainEntityIds.add(fmainentityid);
                allMainEntityIds.add((String)fmainentityid);
                tables.remove(ftablename);
            }
        }
        selectSql = new SqlBuilder();
        selectSql.append("select fentityid,fentitykey from t_meta_entityinfo where ", new Object[0]);
        selectSql.appendIn("fentityid", allMainEntityIds.toArray());
        HashMap<String, String> entityId2entityKey = new HashMap<String, String>(allMainEntityIds.size());
        HashMap<String, String> notContainEntityId2entityKey = new HashMap<String, String>(4);
        DataSet data = DB.queryDataSet((String)"SQLScriptScanHelper", (DBRoute)DBRoute.meta, (SqlBuilder)selectSql);
        fmainentityid = null;
        try {
            while (data.hasNext()) {
                Row row = data.next();
                String key = row.getString("fentitykey");
                String fentityid = row.getString("fentityid");
                if (entityKeys.contains(key)) {
                    entityId2entityKey.put(fentityid, key);
                    continue;
                }
                notContainEntityId2entityKey.put(fentityid, key);
            }
        }
        catch (Throwable row) {
            fmainentityid = row;
            throw row;
        }
        finally {
            if (data != null) {
                if (fmainentityid != null) {
                    try {
                        data.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)fmainentityid).addSuppressed(row);
                    }
                } else {
                    data.close();
                }
            }
        }
        for (Map.Entry entry : table2mainEntityId.entrySet()) {
            String table = (String)entry.getKey();
            SQLScriptScanHelper.putTable2Entity(entityId2entityKey, (Set)entry.getValue(), table, table2entityKey);
            if (table2entityKey.get(table) != null) continue;
            SQLScriptScanHelper.putTable2Entity(notContainEntityId2entityKey, (Set)entry.getValue(), table, table2entityKey);
        }
        for (String table : tables) {
            table2entityKey.put(table, null);
        }
    }

    private static void putTable2Entity(Map<String, String> entityId2entityKey, Set<String> entityIds, String table, Map<String, String> table2entityKey) {
        for (String entityId : entityIds) {
            String entityKey = entityId2entityKey.get(entityId);
            if (entityKey == null) continue;
            table2entityKey.put(table, entityKey);
            break;
        }
    }

    private static Map<String, Map<String, List<List<String>>>> initMetadataFile(File file) {
        HashMap<String, Map<String, List<List<String>>>> entityKeys = new HashMap<String, Map<String, List<List<String>>>>();
        for (File entity : Objects.requireNonNull(file.listFiles())) {
            String entityobjNumber;
            String entityName = entity.getName();
            if (!entityName.endsWith(".dym") || StringUtils.isBlank((CharSequence)(entityobjNumber = entityName.replace(".dym", "")))) continue;
            MainEntityType mainEntityType = null;
            int waitCount = 0;
            while (mainEntityType == null) {
                try {
                    mainEntityType = EntityMetadataCache.getDataEntityType((String)entityobjNumber);
                }
                catch (KDException e) {
                    break;
                }
                catch (Exception exception) {
                    log.error(String.format("metadataAndSqlCheck4GitBranch-initMetadataFile-getDataEntityType-error, entityNumber: %s.", entityobjNumber), (Throwable)exception);
                    if (++waitCount > 10) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (mainEntityType != null && StringUtils.isNotBlank((CharSequence)mainEntityType.getAlias()) && !entityKeys.containsKey(entityobjNumber)) {
                Map resultMap = entityKeys.computeIfAbsent(entityobjNumber, k -> new HashMap(2));
                SQLScriptScanHelper.buildDataEntityData(mainEntityType.getProperties(), resultMap, mainEntityType.getAlias(), mainEntityType.getPrimaryKey());
                continue;
            }
            if (entityKeys.containsKey(entityobjNumber)) continue;
            entityKeys.put(entityobjNumber, Collections.emptyMap());
        }
        return entityKeys;
    }

    private static void buildDataEntityData(DataEntityPropertyCollection propertyCollection, Map<String, List<List<String>>> resultMap, String tableName, ISimpleProperty primaryKey) {
        DataEntityPropertyCollection entryProperties;
        tableName = tableName.toUpperCase(Locale.ENGLISH);
        List resultList = resultMap.computeIfAbsent(tableName, k -> new ArrayList(16));
        LinkedList<EntryProp> list = new LinkedList<EntryProp>();
        LinkedList<MulBasedataProp> mulBasedataPropList = new LinkedList<MulBasedataProp>();
        ArrayList<String> propertyList = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        HashSet<String> largeTextPro = new HashSet<String>(4);
        for (IDataEntityProperty pro : propertyCollection) {
            if (pro instanceof EntryProp) {
                list.add((EntryProp)pro);
                continue;
            }
            String name = pro.getName();
            String alias = pro.getAlias();
            if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)alias) || ignoreFields.contains(name) && ignoreDbFields.contains(alias)) continue;
            if (pro instanceof MulBasedataProp) {
                mulBasedataPropList.add((MulBasedataProp)pro);
                continue;
            }
            String type = pro.getPropertyType() != null ? pro.getPropertyType().getSimpleName() : "";
            String displayName = pro.getDisplayName() != null ? pro.getDisplayName().toString() : "";
            int tagIdx = name.lastIndexOf("_tag");
            if (tagIdx >= 0 && largeTextPro.contains(name.substring(0, tagIdx))) {
                type = "largeText";
            }
            if (pro instanceof LargeTextProp) {
                largeTextPro.add(name);
            }
            propertyList = new ArrayList<String>(16);
            propertyList.add(displayName);
            propertyList.add(name);
            propertyList.add(type);
            propertyList.add(alias);
            if (pro instanceof MuliLangTextProp) {
                propertyList.add(((MuliLangTextProp)pro).isGL() ? "1" : "0");
            }
            boolean isF7Id = StringUtils.isBlank((CharSequence)displayName) && name.endsWith("_id");
            Integer idx = null;
            if (isF7Id && (idx = (Integer)map.get(name.substring(0, name.lastIndexOf("_id")))) == null) continue;
            if (StringUtils.isNotBlank((CharSequence)pro.getTableGroup())) {
                String table_ext = String.format("%s_%s", tableName, pro.getTableGroup().toUpperCase(Locale.ENGLISH));
                List newRes = resultMap.computeIfAbsent(table_ext, k -> new ArrayList(16));
                if (isF7Id && idx < newRes.size()) {
                    ((List)newRes.get(idx)).set(2, type);
                    continue;
                }
                newRes.add(propertyList);
                map.put(name, newRes.size() - 1);
                continue;
            }
            if (isF7Id && idx < resultList.size()) {
                ((List)resultList.get(idx)).set(2, type);
                continue;
            }
            resultList.add(propertyList);
            map.put(name, resultList.size() - 1);
        }
        for (EntryProp entryProp : list) {
            entryProperties = entryProp._collectionItemPropertyType.getProperties();
            if (!StringUtils.isNotBlank((CharSequence)entryProp._collectionItemPropertyType.getAlias())) continue;
            SQLScriptScanHelper.buildDataEntityData(entryProperties, resultMap, entryProp._collectionItemPropertyType.getAlias(), entryProp._collectionItemPropertyType.getPrimaryKey());
        }
        for (MulBasedataProp prop : mulBasedataPropList) {
            entryProperties = new DataEntityPropertyCollection((List)prop._collectionItemPropertyType.getProperties(), prop.getParent(), true);
            entryProperties.add((Object)primaryKey);
            if (!StringUtils.isNotBlank((CharSequence)prop._collectionItemPropertyType.getAlias())) continue;
            SQLScriptScanHelper.buildDataEntityData(entryProperties, resultMap, prop._collectionItemPropertyType.getAlias(), prop._collectionItemPropertyType.getPrimaryKey());
        }
    }

    private static Map<String, Map<String, String>> getCheckFiles(LinkedHashSet<String> sqlFiles, File sqlDir, LinkedHashMap<String, Set<String>> checkTables, boolean checkTableField, CheckToolParam checkToolParam) {
        HashMap<String, Map<String, String>> table2Columns = new HashMap<String, Map<String, String>>(16);
        if (sqlFiles != null && sqlDir != null) {
            File[] files = sqlDir.listFiles();
            if (files == null) {
                return table2Columns;
            }
            HashMap<String, Integer> sqlFile2Priority = new HashMap<String, Integer>(sqlFiles.size());
            int priority = 1;
            for (String sqlFile : sqlFiles) {
                sqlFile2Priority.put(sqlFile, priority++);
            }
            Arrays.sort(files, (o1, o2) -> {
                Integer p1 = sqlFile2Priority.getOrDefault(o1.getName(), 0);
                Integer p2 = sqlFile2Priority.getOrDefault(o2.getName(), 0);
                return p1.compareTo(p2);
            });
            for (File file : files) {
                String fileName = file.getName();
                if (!sqlFiles.contains(fileName)) continue;
                String detectEncode = SQLScriptScanHelper.detectEncoding(file.getPath());
                if (StandardCharsets.UTF_8.name().equals(detectEncode)) {
                    for (String sql : SQLScriptScanHelper.loadSql(file, checkToolParam)) {
                        Set allTableName = checkTables.computeIfAbsent(fileName, k -> new HashSet(16));
                        boolean isMultipleSql = SQLScriptScanHelper.isMultipleSql(sql);
                        try {
                            allTableName.addAll(SQLScriptScanHelper.getAllTableNameBySQL(fileName, sql, checkTableField, table2Columns, checkToolParam));
                            if (isMultipleSql) {
                                String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c%1$s\uff0c\u6267\u884cSQL\u53e5\u672b\u7f3a\u5c11\u5206\u53f7\uff0c\u8bf7\u68c0\u67e5\u811a\u672c\u7684\u6b63\u786e\u6027\u3002", (String)"SQLScriptScanHelper_11", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), fileName);
                                SQLScriptScanHelper.writeSqlScriptCheckResult(fileName, sql, msg, checkToolParam, SQLErrorTypeEnum.SQL_EXCEPTION.getValue());
                                continue;
                            }
                            SQLScriptScanHelper.sqlScriptCheckExtPoint(fileName, sql, checkToolParam);
                        }
                        catch (Exception exception) {
                            String msg = isMultipleSql ? String.format(ResManager.loadKDString((String)"\u811a\u672c%1$s\uff0c\u6267\u884cSQL\u53e5\u672b\u7f3a\u5c11\u5206\u53f7\uff0c\u8bf7\u68c0\u67e5\u811a\u672c\u7684\u6b63\u786e\u6027\u3002", (String)"SQLScriptScanHelper_11", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), fileName) : String.format(ResManager.loadKDString((String)"\u811a\u672c%1$s\uff0c\u89e3\u6790\u5f02\u5e38\uff1a%2$s\uff0c\u8bf7\u68c0\u67e5\u811a\u672c\u7684\u6b63\u786e\u6027\u3002", (String)"SQLScriptScanHelper_8", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), fileName, exception.getMessage());
                            SQLScriptScanHelper.writeSqlScriptCheckResult(fileName, sql, msg, checkToolParam, SQLErrorTypeEnum.SQL_EXCEPTION.getValue());
                        }
                    }
                    SQLScriptScanHelper.scriptFileCheckExtPoint(file, checkToolParam);
                } else {
                    String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c%1$s\uff0c\u6587\u4ef6\u7f16\u7801\u683c\u5f0f\u4e3a%2$s\uff0c\u8bf7\u4fee\u6539\u4e3a\u6807\u51c6\u7684\u6587\u4ef6\u7f16\u7801\u683c\u5f0fUTF_8\u3002", (String)"SQLScriptScanHelper_10", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), fileName, detectEncode);
                    CheckLogEntity checkLogEntity = checkToolParam.getCheckLogEntity().origClone(checkToolParam.getCheckLogEntity());
                    checkLogEntity.setExceptionInfo(msg);
                    checkLogEntity.setErrorType(SQLErrorTypeEnum.SQL_FILE_ENCODING_ERROR.getValue());
                    checkLogEntity.setSqlName(fileName);
                    checkToolParam.getCheckLogs().add(SQLScriptScanHelper.writeCheckLog(checkLogEntity, checkToolParam.getError(), checkToolParam.getErrorType2WhiteList()));
                }
                sqlFiles.remove(fileName);
            }
        }
        return table2Columns;
    }

    private static void scriptFileCheckExtPoint(File sqlFile, CheckToolParam checkToolParam) {
        for (IScriptCheckExtPlugin scriptCheckExtPlugin : ScriptCheckExtFactory.getAllScriptCheckExtPlugin()) {
            scriptCheckExtPlugin.scriptFileCheckExtPoint(sqlFile, checkToolParam);
        }
    }

    private static void sqlScriptCheckExtPoint(String fileName, String sql, CheckToolParam checkToolParam) {
        Map<String, String> notNullCheckResultMap = SQLScriptScanHelper.checkSQLViolatNotNull(sql);
        SQLScriptScanHelper.inputExecption(fileName, sql, checkToolParam, notNullCheckResultMap);
        for (IScriptCheckExtPlugin scriptCheckExtPlugin : ScriptCheckExtFactory.getAllScriptCheckExtPlugin()) {
            scriptCheckExtPlugin.sqlScriptCheckExtPoint(fileName, sql, checkToolParam);
        }
    }

    public static void writeSqlScriptCheckResult(String fileName, String sql, String exceptionInfo, CheckToolParam checkToolParam, String sqlErrorType) {
        CheckLogEntity checkLogEntity = checkToolParam.getCheckLogEntity().origClone(checkToolParam.getCheckLogEntity());
        checkLogEntity.setExceptionInfo(exceptionInfo);
        checkLogEntity.setErrorType(sqlErrorType);
        checkLogEntity.setSql(sql);
        checkLogEntity.setSqlName(fileName);
        checkToolParam.getCheckLogs().add(SQLScriptScanHelper.writeCheckLog(checkLogEntity, checkToolParam.getError(), checkToolParam.getErrorType2WhiteList()));
    }

    private static void inputExecption(String fileName, String sql, CheckToolParam checkToolParam, Map<String, String> notNullCheckResultMap) {
        if (MapUtils.isNotEmpty(notNullCheckResultMap) && "TRUE".equals(notNullCheckResultMap.get("foundError"))) {
            String errorMsg = notNullCheckResultMap.getOrDefault("msg", "");
            String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c%1$s\uff0c%2$s", (String)"SQLScriptScanHelper_20", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), fileName, errorMsg);
            SQLScriptScanHelper.writeSqlScriptCheckResult(fileName, sql, msg, checkToolParam, SQLErrorTypeEnum.SQL_VIOLATION_NOTNULL.getValue());
        }
    }

    private static Map<String, String> checkSQLViolatNotNull(String sqlScript) {
        String columns;
        String tableName;
        HashMap<String, String> result = new HashMap<String, String>(2);
        String alterTableRegex = "IF NOT EXISTS \\(SELECT 1 FROM [^)]*\\)\\s*ALTER TABLE (\\w+) ADD \\(([^;]+)\\)";
        String createTableRegex = "(IF NOT EXISTS \\(SELECT 1 FROM [^)]*\\)\\s*)?CREATE TABLE (\\w+) \\(([^;]+)\\)";
        Pattern alterTablePattern = Pattern.compile(alterTableRegex, 2);
        Pattern createTablePattern = Pattern.compile(createTableRegex, 2);
        Matcher alterTableMatcher = alterTablePattern.matcher(sqlScript);
        Matcher createTableMatcher = createTablePattern.matcher(sqlScript);
        boolean foundError = false;
        while (alterTableMatcher.find()) {
            tableName = alterTableMatcher.group(1);
            foundError = SQLScriptScanHelper.checkColumns(tableName, columns = alterTableMatcher.group(2), result) || foundError;
        }
        while (createTableMatcher.find()) {
            tableName = createTableMatcher.group(2);
            foundError = SQLScriptScanHelper.checkColumns(tableName, columns = createTableMatcher.group(3), result) || foundError;
        }
        return foundError ? result : Collections.EMPTY_MAP;
    }

    private static boolean checkColumns(String tableName, String columns, Map<String, String> result) {
        String columnRegex = "(\\w+)\\s+(\\w+\\(?\\d*\\)?)\\s+DEFAULT\\s+('')\\s+NOT NULL";
        Pattern columnPattern = Pattern.compile(columnRegex, 2);
        Matcher columnMatcher = columnPattern.matcher(columns);
        boolean foundError = false;
        while (columnMatcher.find()) {
            String columnName = columnMatcher.group(1);
            String defaultValue = columnMatcher.group(3);
            if (!"''".equals(defaultValue)) continue;
            foundError = true;
            result.put("foundError", "TRUE");
            result.put("msg", String.format(ResManager.loadKDString((String)"\u8868 %1$s \u7684\u5b57\u6bb5 %2$s \u8bbe\u7f6e\u4e86NOT NULL\uff0c\u4f46\u9ed8\u8ba4\u503c\u4e3a\u7a7a\u5b57\u7b26\u4e32\u3002", (String)"SQLScriptScanHelper_19", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), tableName, columnName));
        }
        return foundError;
    }

    private static String detectEncoding(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        String defaultEncode = SQLScriptScanHelper.detectDefaultEncoding(path);
        if ("Unsupported charset".equals(defaultEncode)) {
            SortedMap<String, Charset> charsets = Charset.availableCharsets();
            defaultEncode = SQLScriptScanHelper.detectEncoding(path, charsets, Charset.defaultCharset().name());
        }
        return defaultEncode;
    }

    private static String detectDefaultEncoding(Path path) {
        LinkedHashMap<String, Charset> charsets = new LinkedHashMap<String, Charset>(2);
        charsets.put(StandardCharsets.UTF_8.name(), StandardCharsets.UTF_8);
        charsets.put("GBK", Charset.forName("GBK"));
        return SQLScriptScanHelper.detectEncoding(path, charsets, "Unsupported charset");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String detectEncoding(Path path, Map<String, Charset> charsets, String defaultEncode) {
        Iterator<Map.Entry<String, Charset>> iterator = charsets.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Charset> entry = iterator.next();
            Charset charset = entry.getValue();
            try {
                BufferedReader reader = Files.newBufferedReader(path, charset);
                Throwable throwable = null;
                try {
                    String line = reader.readLine();
                    if (line == null) continue;
                    String string = charset.name();
                    return string;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return defaultEncode;
    }

    private static void addSqlLossErrorMsg(LinkedHashSet<String> sqls, CheckToolParam checkToolParam) {
        if (sqls != null) {
            for (String sql : sqls) {
                String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c%s\u5728xml\u6587\u4ef6\u4e2d\u5df2\u6ce8\u518c\uff0c\u4f46\u5728\u811a\u672c\u76ee\u5f55\u4e0b\u672a\u627e\u5230\u3002", (String)"SQLScriptScanHelper_9", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), sql);
                CheckLogEntity checkLogEntity = checkToolParam.getCheckLogEntity().origClone(checkToolParam.getCheckLogEntity());
                checkLogEntity.setExceptionInfo(msg);
                checkLogEntity.setSqlName(sql);
                checkToolParam.getCheckLogs().add(SQLScriptScanHelper.writeCheckLog(checkLogEntity, checkToolParam.getError(), checkToolParam.getErrorType2WhiteList()));
            }
        }
    }

    private static Map<String, LinkedHashSet<String>> readAppXmlFile(File file) {
        HashMap<String, LinkedHashSet<String>> stringListMap = new HashMap<String, LinkedHashSet<String>>();
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document document = reader.read(file);
            Element store = document.getRootElement();
            Iterator it = store.elementIterator();
            while (it.hasNext()) {
                Set sqls;
                Element element = (Element)it.next();
                String data = String.valueOf(element.getData());
                if (data.contains(dbSchema)) {
                    data = data.replaceAll("dbschema/", "");
                    sqls = stringListMap.computeIfAbsent(dbSchema, k -> new LinkedHashSet());
                    sqls.add(data);
                    continue;
                }
                if (!data.contains(preInsData)) continue;
                data = data.replaceAll("preinsdata/", "");
                sqls = stringListMap.computeIfAbsent(preInsData, k -> new LinkedHashSet());
                ((HashSet)sqls).add(data);
            }
        }
        catch (Exception e) {
            log.error("metadataAndSqlCheck4GitBranch-readAppXmlFile-error.", (Throwable)e);
        }
        return stringListMap;
    }

    private static List<String> loadSql(File sqlFile, CheckToolParam checkToolParam) {
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuilder sqlSb = new StringBuilder();
        try {
            try (FileInputStream sqlFileIn = new FileInputStream(sqlFile);){
                byte[] buff = new byte[1024];
                int byteRead = 0;
                while ((byteRead = ((InputStream)sqlFileIn).read(buff)) != -1) {
                    sqlSb.append(new String(buff, 0, byteRead));
                }
            }
            String oriSQL = SQLScriptScanHelper.removeAllNote(sqlSb.toString());
            String[] sqlArr = oriSQL.split("(;\\s*\\r\\n)|(;\\s*\\n)");
            for (int i = 0; i < sqlArr.length; ++i) {
                String sql = sqlArr[i];
                if (sql.replaceAll("\\s*|\r|\n|\t", "").replace("\u200b", "").trim().equals("")) continue;
                sqlList.add(sql);
                if (sqlArr.length != 1 || oriSQL.contains(";")) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c%1$s\uff0c\u6267\u884cSQL\u53e5\u672b\u7f3a\u5c11\u5206\u53f7\uff0c\u8bf7\u68c0\u67e5\u811a\u672c\u7684\u6b63\u786e\u6027\u3002", (String)"SQLScriptScanHelper_11", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), sqlFile.getName());
                SQLScriptScanHelper.writeSqlScriptCheckResult(sqlFile.getName(), sql, msg, checkToolParam, SQLErrorTypeEnum.SQL_EXCEPTION.getValue());
            }
            return sqlList;
        }
        catch (Exception ex) {
            log.error("metadataAndSqlCheck4GitBranch-loadSql-error.", (Throwable)ex);
            String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c%1$s\uff0c\u89e3\u6790\u5f02\u5e38\uff1a%2$s\uff0c\u8bf7\u68c0\u67e5\u811a\u672c\u7684\u6b63\u786e\u6027\u3002", (String)"SQLScriptScanHelper_8", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), sqlFile.getName(), ex.getMessage());
            SQLScriptScanHelper.writeSqlScriptCheckResult(sqlFile.getName(), sqlSb.toString(), msg, checkToolParam, SQLErrorTypeEnum.SQL_EXCEPTION.getValue());
            return sqlList;
        }
    }

    private static String removeAllNote(String sql) {
        sql = SQLScriptScanHelper.removeMultilineNote(sql);
        sql = sql.replaceAll("--.*", "").trim();
        return sql.replace("\ufeff", "").replace("\t", " ");
    }

    private static String removeMultilineNote(String sql) {
        int leftIdx = sql.indexOf("/*");
        int rightIdx = sql.indexOf("*/") + 1;
        while (leftIdx >= 0 && rightIdx > leftIdx) {
            String start = leftIdx > 0 ? sql.substring(0, leftIdx) : "";
            String end = rightIdx + 1 >= sql.length() ? "" : sql.substring(rightIdx + 1);
            sql = start + end;
            leftIdx = sql.indexOf("/*");
            rightIdx = sql.indexOf("*/") + 1;
        }
        return sql;
    }

    private static Set<String> getAllTableNameBySQL(String fileName, String sql, boolean checkTableField, Map<String, Map<String, String>> table2Columns, CheckToolParam checkToolParam) {
        String dataType;
        String columnName;
        Collection<TableStat.Column> columns;
        String sqlType;
        HashSet<String> allTableName = new HashSet<String>();
        if (sql.trim().isEmpty() || sql.replaceAll("\\s*|\r|\n|\t", "").replace("\u200b", "").trim().isEmpty()) {
            return allTableName;
        }
        String oriSql = sql;
        HashSet<String> notUpperTables = new HashSet<String>(2);
        HashSet<String> notUpperFields = new HashSet<String>(4);
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        SQLStatement sqlStatement = parser.parseStatement();
        MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
        sqlStatement.accept((SQLASTVisitor)visitor);
        Map tables = visitor.getTables();
        HashSet<String> tableNames = new HashSet<String>(tables.size());
        HashMap<String, Boolean> iCreateTable = new HashMap<String, Boolean>(tables.size());
        for (Map.Entry entry : tables.entrySet()) {
            String tableName = ((TableStat.Name)entry.getKey()).getName().toUpperCase(Locale.ENGLISH);
            if (tableName.startsWith(KSQL_PRE)) continue;
            tableNames.add(tableName);
            if (((TableStat)entry.getValue()).getCreateCount() > 0) {
                iCreateTable.put(tableName, Boolean.TRUE);
            }
            if (SQLScriptScanHelper.isUpperCase(((TableStat.Name)entry.getKey()).getName())) continue;
            notUpperTables.add(((TableStat.Name)entry.getKey()).getName());
        }
        allTableName.addAll(tableNames);
        String notUpperSql = sql;
        sql = sql.toUpperCase(Locale.ENGLISH);
        int idx = sql.indexOf("ALTER ");
        String string = sqlType = iCreateTable.isEmpty() ? "" : ResManager.loadKDString((String)"\u521b\u5efa\u6570\u636e\u8868", (String)"SQLScriptScanHelper_14", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
        if (sql.contains(" P_ALTERCOLUMN ")) {
            columns = new ArrayList(1);
            idx = sql.indexOf(" P_ALTERCOLUMN ") + 15;
            sql = sql.substring(idx);
            notUpperSql = notUpperSql.substring(idx);
            String[] strs = notUpperSql.split(",");
            String tableName = strs[0].replaceAll("'", "").trim();
            columnName = strs[1].replaceAll("'", "").trim();
            String dataType2 = strs[2].replaceAll("'", "").trim();
            idx = dataType2.indexOf("(");
            if (idx >= 0) {
                dataType2 = dataType2.substring(0, idx);
            }
            TableStat.Column column = new TableStat.Column(tableName, columnName);
            column.setDataType(dataType2);
            columns.add(column);
            sqlType = ResManager.loadKDString((String)"\u4fee\u6539\u5b57\u6bb5", (String)"SQLScriptScanHelper_15", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
        } else if (idx >= 0 && !sql.contains(" INDEX ") && sql.contains(" TABLE ") && (sql.contains(" ADD ") || sql.contains(" ADD("))) {
            columns = new ArrayList(1);
            sql = sql.substring(idx);
            notUpperSql = notUpperSql.substring(idx);
            int start = sql.indexOf(" TABLE ");
            int end = sql.indexOf(" ADD ");
            if (end < 0) {
                end = sql.indexOf(" ADD(");
            }
            String tableName = notUpperSql.substring(start + 6, end).trim();
            Object[] r = SQLScriptScanHelper.getDataType(sql);
            dataType = (String)r[0];
            String columnName2 = notUpperSql.substring(end + 5, (Integer)r[1]).replace("(", "").trim();
            TableStat.Column column = new TableStat.Column(tableName, columnName2);
            column.setDataType(dataType);
            columns.add(column);
            sqlType = ResManager.loadKDString((String)"\u65b0\u589e\u5b57\u6bb5", (String)"SQLScriptScanHelper_16", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
        } else if (sql.contains(" P_ALTERPK ")) {
            columns = new ArrayList(1);
            idx = sql.indexOf(" P_ALTERPK ") + 11;
            sql = sql.substring(idx);
            notUpperSql = notUpperSql.substring(idx);
            String[] strs = notUpperSql.split(",");
            String tableName = strs[1].replaceAll("'", "").trim();
            String dataType3 = strs[2].replaceAll("'", "").trim();
            TableStat.Column column = new TableStat.Column(tableName, "P_ALTERPK");
            column.setDataType(dataType3);
            columns.add(column);
            sqlType = ResManager.loadKDString((String)"\u521b\u5efa\u4e3b\u952e\u7d22\u5f15", (String)"SQLScriptScanHelper_17", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
        } else {
            columns = visitor.getColumns();
        }
        if (!checkTableField && StringUtils.isNotBlank((CharSequence)sqlType)) {
            String msg = String.format(ResManager.loadKDString((String)"\u811a\u672cpreinsdata/%1$s\uff0c\u4e0d\u5141\u8bb8\u9884\u7f6e\u811a\u672c\u6587\u4ef6\u5939\uff08preinsdata\uff09\u5b58\u5728%2$s\u7684\u811a\u672c\uff0c\u8bf7\u8c03\u6574\u811a\u672c\u6587\u4ef6\u4f4d\u7f6e\u3002", (String)"SQLScriptScanHelper_13", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), fileName, sqlType);
            SQLScriptScanHelper.writeSqlScriptCheckResult(fileName, oriSql, msg, checkToolParam, SQLErrorTypeEnum.SQL_EXCEPTION.getValue());
        }
        for (TableStat.Column column : columns) {
            if (column.getName() == null || column.getTable() == null || column.getDataType() == null) continue;
            columnName = column.getName().toUpperCase(Locale.ENGLISH);
            String tableName = column.getTable().toUpperCase(Locale.ENGLISH);
            dataType = column.getDataType().toUpperCase(Locale.ENGLISH);
            if (!tableNames.contains(tableName)) continue;
            if (!SQLScriptScanHelper.isUpperCase(column.getName())) {
                notUpperFields.add(column.getName());
            }
            if (!SQLScriptScanHelper.isUpperCase(column.getTable())) {
                notUpperTables.add(column.getTable());
            }
            if (!checkTableField) continue;
            Map fields = table2Columns.computeIfAbsent(tableName, k -> new HashMap(16));
            fields.put(columnName, String.format("%s\u0001%s", fileName, dataType));
            if (column.isPrimaryKey()) {
                fields.put("P_ALTERPK", columnName);
            }
            if (!iCreateTable.getOrDefault(tableName, Boolean.FALSE).booleanValue() || fields.containsKey("P_ALTERPK") || !sql.contains("CONSTRAINT ") || !sql.contains(" PRIMARY ") || !sql.contains(" KEY ") && !sql.contains(" KEY(")) continue;
            String str = sql.substring(sql.indexOf("KEY") + 3);
            int i = (str = str.replaceAll("CLUSTERED ", "")).indexOf(")");
            if (i >= 0) {
                str = str.substring(0, i);
            }
            str = str.replaceAll("\\(", "");
            str = str.replaceAll("\\)", "").trim();
            fields.put("P_ALTERPK", str);
        }
        if (!(!checkTableField && !StringUtils.isNotBlank((CharSequence)sqlType) || notUpperFields.isEmpty() && notUpperTables.isEmpty())) {
            HashMap<String, Object> notUpperInfo = new HashMap<String, Object>(4);
            notUpperInfo.put("sql", oriSql);
            notUpperInfo.put("table", notUpperTables);
            notUpperInfo.put("field", notUpperFields);
            notUpperInfo.put("fileDir", checkTableField ? dbSchema : preInsData);
            checkToolParam.getFile2NotUpperInfo().computeIfAbsent(fileName, k -> new ArrayList(7)).add(notUpperInfo);
        }
        return allTableName;
    }

    private static boolean isUpperCase(String str) {
        return StringUtils.isBlank((CharSequence)str) || str.equals(str.toUpperCase(Locale.ENGLISH));
    }

    private static boolean isMultipleSql(String sql) {
        String key;
        sql = sql.toUpperCase(Locale.ENGLISH);
        HashSet<String> keyWords = new HashSet<String>(4);
        keyWords.add(" P_ALTERPK ");
        keyWords.add(" INDEX ");
        keyWords.add(" TABLE ");
        keyWords.add(" P_ALTERCOLUMN ");
        keyWords.add("DELETE ");
        keyWords.add("INSERT ");
        keyWords.add("UPDATE ");
        int count = 0;
        Iterator iterator = keyWords.iterator();
        while (iterator.hasNext() && (count += SQLScriptScanHelper.countSubstringOccurrences(sql, key = (String)iterator.next())) <= 1) {
        }
        return count > 1;
    }

    private static int countSubstringOccurrences(String str, String subStr) {
        int count = 0;
        int index = 0;
        boolean isBlankStart = subStr.startsWith(" ");
        while ((index = str.indexOf(subStr, index)) != -1) {
            if (!isBlankStart && index > 0) {
                char c = str.charAt(index - 1);
                if (!Character.isLetter(c)) {
                    ++count;
                }
            } else {
                ++count;
            }
            index += subStr.length();
        }
        return count;
    }

    private static Object[] getDataType(String s) {
        Object[] result = new Object[2];
        if (s.contains(" NVARCHAR(")) {
            result[0] = "NVARCHAR";
            result[1] = s.indexOf(" NVARCHAR(");
        } else if (s.contains(" VARCHAR(")) {
            result[0] = "VARCHAR";
            result[1] = s.indexOf(" VARCHAR(");
        } else if (s.contains(" BIGINT")) {
            result[0] = "BIGINT";
            result[1] = s.indexOf(" BIGINT");
        } else if (s.contains(" INT")) {
            result[0] = "INT";
            result[1] = s.indexOf(" INT");
        } else if (s.contains(" NCLOB")) {
            result[0] = "NCLOB";
            result[1] = s.indexOf(" NCLOB");
        } else if (s.contains(" BLOB ")) {
            result[0] = "BLOB";
            result[1] = s.indexOf(" BLOB");
        } else if (s.contains(" DECIMAL(")) {
            result[0] = "DECIMAL";
            result[1] = s.indexOf(" DECIMAL(");
        } else if (s.contains(" CHAR(")) {
            result[0] = "CHAR";
            result[1] = s.indexOf(" CHAR(");
        } else if (s.contains(" DATETIME")) {
            result[0] = "DATETIME";
            result[1] = s.indexOf(" DATETIME");
        } else {
            throw new RuntimeException(String.format("unimplement data type:%s.", s));
        }
        return result;
    }

    private static Set<String> toDataType(String type, boolean is_ignore_comp_field) {
        HashSet<String> types = new HashSet<String>(2);
        if (StringUtils.equalsIgnoreCase((CharSequence)"long", (CharSequence)type) || StringUtils.equalsIgnoreCase((CharSequence)"DynamicObject", (CharSequence)type)) {
            types.add("BIGINT");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"int", (CharSequence)type) || StringUtils.equalsIgnoreCase((CharSequence)"Integer", (CharSequence)type)) {
            types.add("INT");
            if (is_ignore_comp_field) {
                types.add("BIGINT");
                types.add("DECIMAL");
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"BigDecimal", (CharSequence)type) || StringUtils.equalsIgnoreCase((CharSequence)"Double", (CharSequence)type)) {
            types.add("DECIMAL");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"largeText", (CharSequence)type)) {
            types.add("NCLOB");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"String", (CharSequence)type) || StringUtils.equalsIgnoreCase((CharSequence)"ILocaleString", (CharSequence)type)) {
            types.add("NVARCHAR");
            types.add("VARCHAR");
            if (is_ignore_comp_field) {
                types.add("NCLOB");
                types.add("CHAR");
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"Date", (CharSequence)type) || StringUtils.equalsIgnoreCase((CharSequence)"Timestamp", (CharSequence)type)) {
            types.add("DATETIME");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"Boolean", (CharSequence)type)) {
            types.add("CHAR");
            if (is_ignore_comp_field) {
                types.add("NVARCHAR");
                types.add("VARCHAR");
            }
        } else {
            return types;
        }
        return types;
    }

    static {
        ignoreFields.add("sourcedata");
        ignoreFields.add("bitindex");
        ignoreFields.add("srcindex");
        ignoreFields.add("srccreateorg");
        ignoreDbFields.add("fsourcedataid");
        ignoreDbFields.add("fbitindex");
        ignoreDbFields.add("fsourcebitindex");
        ignoreDbFields.add("fsrccreateorgid");
    }

    public static class CheckLogEntity {
        private final String buildId;
        private final String gitBranch;
        private final String appId;
        private String exceptionInfo = "";
        private String sqlName = "";
        private int sqlRow = 0;
        private String level = "C";
        private String metadataKey = "";
        private String tableName = "";
        private String errorType = "0";
        private String sql = "";

        public CheckLogEntity(String buildId, String gitBranch, String appId) {
            this.buildId = buildId;
            this.gitBranch = gitBranch;
            this.appId = appId;
        }

        public CheckLogEntity origClone(CheckLogEntity checkLogEntity) {
            return new CheckLogEntity(checkLogEntity.buildId, checkLogEntity.gitBranch, checkLogEntity.appId);
        }

        public void setExceptionInfo(String exceptionInfo) {
            this.exceptionInfo = exceptionInfo;
        }

        public void setSqlName(String sqlName) {
            this.sqlName = sqlName;
        }

        public void setSqlRow(int sqlRow) {
            this.sqlRow = sqlRow;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public void setMetadataKey(String metadataKey) {
            this.metadataKey = metadataKey;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }
    }
}

