/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.batchtask;

import java.util.HashMap;
import java.util.Map;
import kd.bos.id.ID;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTaskEvent;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTaskImpl;
import kd.mpscmm.msplan.mservice.service.batchtask.context.CalcContext;
import kd.mpscmm.msplan.mservice.service.batchtask.util.CacheManager;
import kd.mpscmm.msplan.mservice.service.batchtask.util.HeartBeat;

public abstract class BatchTask {
    static Map<String, BatchTask> batchTaskCache = new HashMap<String, BatchTask>(16);

    public abstract CalcContext getContext();

    abstract void setHeartBeat(HeartBeat var1);

    abstract void setHeartCtx(CalcContext var1);

    static BatchTask getBatchTask(String taskId) {
        return batchTaskCache.get(taskId);
    }

    public static BatchTask create(String calcName) {
        String calcId = String.valueOf(ID.genLongId());
        BatchTaskImpl task = new BatchTaskImpl();
        CalcContext newContext = new CalcContext();
        newContext.setCalcName(calcName);
        newContext.setCalcId(calcId);
        ((BatchTask)task).setHeartBeat(new HeartBeat());
        ((BatchTask)task).setHeartCtx(newContext);
        return task;
    }

    public void setTimeOut(long timeOut) {
        HeartBeat heartBeat = new HeartBeat();
        heartBeat.setTimeOut(timeOut);
        this.setHeartBeat(heartBeat);
    }

    public String getCalcId() {
        return this.getContext().getCalcId();
    }

    abstract boolean isFail();

    abstract void taskFail();

    abstract boolean isInterrupt();

    abstract void taskInterrupt();

    public abstract void registBizClass(Class<? extends BatchTaskEvent> var1);

    public abstract void addEvent(Map var1);

    abstract void childTaskFinish(CalcContext var1);

    public abstract void setQueueName(String var1);

    abstract String getQueueName();

    public abstract void startTask() throws Exception;

    public abstract void terminate();

    public static void interrupt(String calcId) {
        new CacheManager(calcId).put("interrupt_msg_key", "1");
    }
}

