/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.batchtask;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.ORM;
import kd.bos.redis.JedisClient;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTaskEvent;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTasks;
import kd.mpscmm.msplan.mservice.service.batchtask.consumer.BatchConsumer;
import kd.mpscmm.msplan.mservice.service.batchtask.context.CalcContext;
import kd.mpscmm.msplan.mservice.service.batchtask.log.BatchTaskEventRecorder;
import kd.mpscmm.msplan.mservice.service.batchtask.log.BatchTaskMainRecorder;
import kd.mpscmm.msplan.mservice.service.batchtask.util.CacheManager;
import kd.mpscmm.msplan.mservice.service.batchtask.util.HeartBeat;
import kd.mpscmm.msplan.mservice.service.batchtask.util.MQManager;
import kd.mpscmm.msplan.mservice.service.batchtask.util.MQUtils;

public class BatchTaskImpl
extends BatchTask {
    private static final Log logger = LogFactory.getLog(BatchTaskImpl.class);
    private CalcContext ctx;
    private HeartBeat heartBeat;
    private boolean fail = false;
    private boolean interrupt = false;
    private boolean taskStart = false;
    private long masterCheckPeriod = 10000L;
    private long masterKeepAlivePeriod = 30000L;
    private int masterKeepAliveTimeout = 78;
    private ScheduledExecutorService executorService;
    private CacheManager cacheManager;
    private String queueName;
    private BatchTaskMainRecorder recorder;
    private final List<Map> needEvents = new LinkedList<Map>();
    private final Map<Long, CalcContext> calEvents = new HashMap<Long, CalcContext>(16);

    BatchTaskImpl() {
    }

    @Override
    public CalcContext getContext() {
        return this.ctx;
    }

    @Override
    public void setHeartBeat(HeartBeat heartBeat) {
        this.heartBeat = heartBeat;
    }

    @Override
    public void setHeartCtx(CalcContext ctx) {
        this.ctx = ctx;
    }

    @Override
    boolean isFail() {
        return this.fail;
    }

    @Override
    void taskFail() {
        logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s',\u72b6\u6001\u76d1\u63a7\u7ebf\u7a0b\u76d1\u6d4b\u5230\u4efb\u52a1\u5931\u8d25", this.ctx.getCalcName(), this.ctx.getCalcId()));
        this.fail = true;
    }

    @Override
    boolean isInterrupt() {
        return this.interrupt;
    }

    @Override
    void taskInterrupt() {
        logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s',\u72b6\u6001\u76d1\u63a7\u7ebf\u7a0b\u76d1\u6d4b\u5230\u4efb\u52a1\u624b\u52a8\u5173\u95ed", this.ctx.getCalcName(), this.ctx.getCalcId()));
        this.interrupt = true;
    }

    @Override
    public void registBizClass(Class<? extends BatchTaskEvent> clazz) {
        this.ctx.setBizClazzName(clazz.getName());
    }

    @Override
    public void addEvent(Map params) {
        this.needEvents.add(params);
    }

    @Override
    synchronized void childTaskFinish(CalcContext ctx) {
        Long id = ctx.getChildId();
        String calcId = ctx.getCalcId();
        this.heartBeat.refresh();
        this.calEvents.remove(id);
        if (this.recorder != null) {
            if (this.needEvents.size() == 0) {
                this.recorder.updateResultLog(100);
            } else {
                this.recorder.updateResultLog((this.needEvents.size() - this.calEvents.size()) * 100 / this.needEvents.size());
            }
        }
        logger.info(String.format("BatchTask\uff0cCalcName:'%s',CalcId:'%s',ChildId:'%s'\uff0c\u4e3b\u8282\u70b9\u6536\u5230\u5b50\u4efb\u52a1\u5b8c\u6210", ctx.getCalcName(), calcId, id));
    }

    @Override
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public void startTask() throws Exception {
        this.recorder = this.createLog();
        StringBuilder errMsg = new StringBuilder();
        if (!this.validation(errMsg)) {
            logger.error(errMsg.insert(0, String.format("BatchTask:CalcName:'%s'\uff0cCalcId:'%s' ,\u542f\u52a8\u5931\u8d25:", this.ctx.getCalcName(), this.ctx.getCalcId())).toString());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"BatchTask:CalcName:'%1$s'\uff0cCalcId:'%2$s' ,\u542f\u52a8\u5931\u8d25: \u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BatchTaskImpl_4", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), this.ctx.getCalcName(), this.ctx.getCalcId()));
        }
        String calcId = this.getCalcId();
        BatchTask.batchTaskCache.put(calcId, this);
        this.cacheManager = new CacheManager(this.ctx.getCalcId());
        this.startCheckThread();
        this.registControlQueue();
        this.ctx.setLogId(this.recorder.getId());
        this.ctx.setTraceID(RequestContext.get().getTraceId());
        this.publishChildTask();
        while (true) {
            if (this.heartBeat.isTimeOut()) {
                this.recorder.errResultLog("B");
                logger.error(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s',\u4efb\u52a1\u8d85\u65f6", this.ctx.getCalcName(), this.ctx.getCalcId()));
                throw new KDBizException("BatchTask timeout\u3002");
            }
            if (this.isFail()) {
                this.recorder.errResultLog("B");
                logger.error(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s',\u4efb\u52a1\u5931\u8d25\uff0c\u4e3b\u8282\u70b9\u5173\u95ed", this.ctx.getCalcName(), this.ctx.getCalcId()));
                String childErrMsg = "";
                if (this.cacheManager != null) {
                    childErrMsg = this.cacheManager.get("fail_msg_key");
                }
                throw new KDBizException(childErrMsg);
            }
            if (this.isInterrupt()) {
                this.recorder.errResultLog("C");
                logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s',\u4efb\u52a1\u624b\u52a8\u505c\u6b62\uff0c\u4e3b\u8282\u70b9\u5173\u95ed", this.ctx.getCalcName(), this.ctx.getCalcId()));
                throw new KDBizException("BatchTask shutdown\u3002");
            }
            if (this.calEventsEmpty()) {
                this.recorder.endResultLog();
                return;
            }
            Thread.sleep(1000L);
        }
    }

    private void registControlQueue() {
        String ctrlQueueType = MQUtils.loadCtrlQueueType();
        if ("MQ".equalsIgnoreCase(ctrlQueueType)) {
            String queuename = MQManager.registControlQueue(this.ctx.getCalcName(), this.ctx.getCalcId(), BatchConsumer.class);
            this.recorder.setControlQueue(queuename);
            logger.info(String.format("BatchTask:CalcName:'%s'\uff0cCalcId:'%s'\uff0cQueueName:'%s',\u6ce8\u518cControlQueue......", this.ctx.getCalcName(), this.ctx.getCalcId(), this.getQueueName()));
        } else {
            BatchConsumer batchConsumer = new BatchConsumer();
            String redisControlQueueName = MQUtils.buildQueueName(this.ctx.getCalcName(), this.ctx.getCalcId());
            this.recorder.setControlQueue(redisControlQueueName);
            ThreadPools.executeOnceIncludeRequestContext((String)redisControlQueueName, () -> {
                try (JedisClient client = this.cacheManager.getJedisClient();){
                    while (true) {
                        BatchTask task;
                        if ((task = BatchTasks.getBatchTask(this.ctx.getCalcId())) == null) {
                            return;
                        }
                        if (BatchTasks.fastFail(task)) {
                            return;
                        }
                        if (BatchTasks.isInterrupt(task)) {
                            return;
                        }
                        List cmds = client.brpop(10, redisControlQueueName);
                        if (cmds == null) continue;
                        batchConsumer.onMessageByRedis(JSON.parseObject((String)((String)cmds.get(1)), CalcContext.class));
                        continue;
                        break;
                    }
                }
            });
        }
    }

    private BatchTaskMainRecorder createLog() {
        DynamicObject log = ORM.create().newDynamicObject("msplan_batchtask_log");
        log.set("jobid", (Object)this.ctx.getCalcId());
        log.set("jobname", (Object)this.ctx.getCalcName());
        log.set("operator", (Object)RequestContext.get().getCurrUserId());
        log.set("status", (Object)"D");
        log.set("starttime", (Object)new Date());
        log.set("progress", (Object)0);
        log.set("bizclass", (Object)this.ctx.getBizClazzName());
        log.set("queuename", (Object)this.getQueueName());
        log.set("traceid", (Object)RequestContext.get().getTraceId());
        log.set("evntcount", (Object)this.needEvents.size());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        BatchTaskMainRecorder recorder = new BatchTaskMainRecorder(log.getLong("id"), System.currentTimeMillis());
        return recorder;
    }

    private void publishChildTask() {
        MessagePublisher pub = MQFactory.get().createSimplePublisher("mmc", this.getQueueName());
        Long id = 0L;
        logger.info(String.format("BatchTask:CalcName:'%s'\uff0cCalcId:'%s',\u4efb\u52a1\u5f00\u59cb.....", this.ctx.getCalcName(), this.ctx.getCalcId()));
        for (Map params : this.needEvents) {
            Long l = id;
            Long l2 = id = Long.valueOf(id + 1L);
            CalcContext childCtx = new CalcContext();
            childCtx.setCalcName(this.ctx.getCalcName());
            childCtx.setCalcId(this.ctx.getCalcId());
            childCtx.setBizClazzName(this.ctx.getBizClazzName());
            childCtx.setLogId(this.ctx.getLogId());
            childCtx.setParams(params);
            childCtx.setChildId(id);
            this.calEvents.put(id, childCtx);
            String paramsJson = "";
            try {
                paramsJson = JSON.toJSONString((Object)params);
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
            new BatchTaskEventRecorder(childCtx.getLogId(), childCtx.getChildId(), System.currentTimeMillis()).mainInitLog(paramsJson);
            pub.publish((Object)childCtx);
        }
        pub.close();
        logger.info(String.format("BatchTask:CalcName:'%s'\uff0cCalcId:'%s',\u4efb\u52a1\u5206\u53d1\u5b8c\u6210", this.ctx.getCalcName(), this.ctx.getCalcId()));
    }

    private void startCheckThread() {
        this.heartBeat.refresh();
        this.executorService = new ScheduledThreadPoolExecutor(1);
        this.cacheManager.put("fail_msg_key", "");
        this.cacheManager.put("fail_tag_key", "0");
        this.cacheManager.put("interrupt_msg_key", "0");
        TimerTask masterCheckTimeTask = new TimerTask(){

            @Override
            public void run() {
                String failTag = BatchTaskImpl.this.cacheManager.get("fail_tag_key");
                String interruptTag = BatchTaskImpl.this.cacheManager.get("interrupt_msg_key");
                if ("1".equals(failTag)) {
                    BatchTaskImpl.this.taskFail();
                    BatchTaskImpl.this.executorService.shutdown();
                }
                if ("1".equals(interruptTag)) {
                    BatchTaskImpl.this.taskInterrupt();
                    BatchTaskImpl.this.executorService.shutdown();
                }
            }
        };
        this.executorService.scheduleAtFixedRate(masterCheckTimeTask, this.masterCheckPeriod, this.masterCheckPeriod, TimeUnit.MILLISECONDS);
        TimerTask masterLiveTimeTask = new TimerTask(){

            @Override
            public void run() {
                BatchTaskImpl.this.cacheManager.put("master_keep_live", "is_live", BatchTaskImpl.this.masterKeepAliveTimeout);
            }
        };
        this.executorService.scheduleAtFixedRate(masterLiveTimeTask, 0L, this.masterKeepAlivePeriod, TimeUnit.MILLISECONDS);
    }

    private synchronized boolean calEventsEmpty() {
        return this.calEvents.isEmpty();
    }

    private synchronized boolean validation(StringBuilder errMsg) {
        if (this.taskStart) {
            errMsg.append(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ecf\u6267\u884c\u3002", (String)"BatchTaskImpl_1", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]));
        } else {
            this.taskStart = true;
        }
        String queueName = this.getQueueName();
        String bizClazzName = this.getContext().getBizClazzName();
        if (StringUtils.isEmpty((CharSequence)queueName)) {
            errMsg.append(ResManager.loadKDString((String)"queueName\u4e3a\u7a7a\u3002", (String)"BatchTaskImpl_2", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)bizClazzName)) {
            errMsg.append(ResManager.loadKDString((String)"bizClazzName\u4e3a\u7a7a\u3002", (String)"BatchTaskImpl_3", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]));
        }
        return errMsg.length() == 0;
    }

    @Override
    public void terminate() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
        if (this.cacheManager != null) {
            this.cacheManager.removeAll();
        }
        if (this.ctx != null) {
            BatchTasks.clear(this.ctx.getCalcName(), this.ctx.getCalcId());
            batchTaskCache.remove(this.ctx.getCalcId());
            logger.info(String.format("BatchTask\uff0cCalcName:'%s'\uff0cCalcId:'%s',\u4efb\u52a1\u7ed3\u675f\u6e05\u9664\u7f13\u5b58", this.ctx.getCalcName(), this.ctx.getCalcId()));
        }
    }

    protected void finalize() throws Throwable {
        this.terminate();
        super.finalize();
    }
}

