/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.batchtask;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;
import kd.mpscmm.msplan.mservice.service.batchtask.context.CalcContext;
import kd.mpscmm.msplan.mservice.service.batchtask.util.CacheManager;
import kd.mpscmm.msplan.mservice.service.batchtask.util.MQUtils;

public final class BatchTasks {
    private static final Log logger = LogFactory.getLog(BatchTasks.class);

    public static BatchTask getBatchTask(String taskId) {
        return BatchTask.getBatchTask(taskId);
    }

    public static void childTaskFinish(BatchTask task, CalcContext ctx) {
        task.childTaskFinish(ctx);
    }

    public static boolean fastFail(BatchTask task) {
        return task.isFail();
    }

    public static boolean isInterrupt(BatchTask task) {
        return task.isInterrupt();
    }

    public static void clear(String calcName, String calcId) {
        CacheManager cacheManager = new CacheManager(calcId);
        try (JedisClient client = cacheManager.getJedisClient();){
            cacheManager.removeAll();
            BatchTasks.clearMQ(calcName, calcId);
            client.del(MQUtils.buildQueueName(calcName, calcId));
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
    }

    private static void clearMQ(String calcName, String calcId) {
    }
}

