/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.batchtask.consumer;

import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTasks;
import kd.mpscmm.msplan.mservice.service.batchtask.context.CalcContext;

public class BatchConsumer
implements MessageConsumer {
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        CalcContext ctx = null;
        if (body instanceof CalcContext) {
            ctx = (CalcContext)body;
        }
        if (ctx == null) {
            acker.discard(messageId);
            return;
        }
        BatchTask task = BatchTasks.getBatchTask(ctx.getCalcId());
        if (task == null) {
            return;
        }
        if (BatchTasks.fastFail(task)) {
            acker.ack(messageId);
            return;
        }
        if (BatchTasks.isInterrupt(task)) {
            acker.ack(messageId);
            return;
        }
        BatchTasks.childTaskFinish(task, ctx);
        acker.ack(messageId);
    }

    public void onMessageByRedis(Object body) {
        CalcContext ctx = null;
        if (body instanceof CalcContext) {
            ctx = (CalcContext)body;
        }
        if (ctx == null) {
            return;
        }
        BatchTask task = BatchTasks.getBatchTask(ctx.getCalcId());
        if (task == null) {
            return;
        }
        if (BatchTasks.fastFail(task)) {
            return;
        }
        if (BatchTasks.isInterrupt(task)) {
            return;
        }
        BatchTasks.childTaskFinish(task, ctx);
    }
}

