/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.batchtask.log;

import java.math.BigDecimal;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BatchTaskEventRecorder {
    private static final Log logger = LogFactory.getLog(BatchTaskEventRecorder.class);
    public static final DBRoute pur = new DBRoute("pur");
    private Long index = 0L;
    private Long parentid = null;
    private Long inittime = null;
    private String addsql = "insert into t_msplan_batchtask_entry(fid, fentryid, fseq ,fentryoperatms, finstanceid,fevntid, fentryresult, fentrydetailmsg,fcontext_tag,fdispatchtime) values (?,?,?,?,?,?,?,?,?,now())";
    private String eventInit = "update t_msplan_batchtask_entry set finstanceid =?, fevntid =?, fentryresult=?, fentrydetailmsg=?,feventruntime=now() where fid = ? and fseq = ?";
    private String updatesql = "update t_msplan_batchtask_entry set fentryresult = ?,fentryoperatms= ? ,fentrydetailmsg = ? where fid = ? and fseq = ?";
    private String endsql = "update t_msplan_batchtask_entry set fentryresult = ?,fentryoperatms= ? ,feventendtime=now(),fentrydetailmsg = ? where fid = ? and fseq = ?";
    private String selectSql = "select fid,fseq,fentryresult from  t_msplan_batchtask_entry where fid = ? and fseq = ? and fentryresult = 'D'";

    public BatchTaskEventRecorder(Long _parentid, Long _seq, Long _inittime) {
        this.inittime = _inittime;
        this.parentid = _parentid;
        this.index = _seq;
    }

    public Long genLong() {
        return ID.genLongId();
    }

    public void updateResultLog(String result, String errorinfo) {
        try (TXHandle h1 = TX.requiresNew();){
            Long currtime = System.currentTimeMillis();
            BigDecimal stepinterval = BigDecimal.valueOf(currtime - this.inittime);
            if (errorinfo == null) {
                errorinfo = ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u3002", (String)"BatchTaskEventRecorder_0", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
            }
            Object[] objs = new Object[]{result, stepinterval, errorinfo, this.parentid, this.index};
            DB.execute((DBRoute)pur, (String)this.updatesql, (Object[])objs);
        }
        catch (Exception ex) {
            logger.error("\u66f4\u65b0Event\u65e5\u5fd7\u51fa\u9519" + ex.getMessage());
        }
    }

    public void endResultLog(String result, String errorinfo) {
        BigDecimal interval = BigDecimal.valueOf(System.currentTimeMillis() - this.inittime);
        try (TXHandle h1 = TX.requiresNew();){
            if (errorinfo == null) {
                errorinfo = ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u3002", (String)"BatchTaskEventRecorder_0", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
            }
            Object[] objs = new Object[]{result, interval, errorinfo, this.parentid, this.index};
            DB.execute((DBRoute)pur, (String)this.endsql, (Object[])objs);
        }
        catch (Exception ex) {
            logger.error("\u66f4\u65b0Event\u65e5\u5fd7\u51fa\u9519" + ex.getMessage());
        }
    }

    public void mainInitLog(String paramsJson) {
        try (TXHandle h1 = TX.requiresNew();){
            Object[] objs = new Object[]{this.parentid, this.genLong(), this.index, 0, "", String.valueOf(this.index), "D", "", paramsJson};
            DB.execute((DBRoute)pur, (String)this.addsql, (Object[])objs);
        }
        catch (Exception ex) {
            logger.error("\u521b\u5efaEvent\u65e5\u5fd7\u51fa\u9519" + ex.getMessage());
        }
    }

    public void createResultLog(String instanceid, String fevntid, String resultinfo, String exceptionInfo) {
        try (TXHandle h1 = TX.requiresNew();){
            Object[] objs = new Object[]{instanceid, fevntid, resultinfo, exceptionInfo, this.parentid, this.index};
            DB.execute((DBRoute)pur, (String)this.eventInit, (Object[])objs);
        }
        catch (Exception ex) {
            logger.error("\u66f4\u65b0Event\u65e5\u5fd7\u51fa\u9519" + ex.getMessage());
        }
    }

    public boolean isResend() {
        DataSet dataSet = DB.queryDataSet((String)"BatchTaskEventRecorder_checkResend", (DBRoute)DBRoute.of((String)"scm"), (String)this.selectSql, (Object[])new Object[]{this.parentid, this.index});
        boolean empty = dataSet.isEmpty();
        dataSet.close();
        return empty;
    }
}

