/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.batchtask.log;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BatchTaskMainRecorder {
    private static final Log logger = LogFactory.getLog(BatchTaskMainRecorder.class);
    public static final DBRoute pur = new DBRoute("pur");
    private Long id = null;
    private Long inittime = null;
    private String updatesql = "update t_msplan_batchtask_log set fduration=?,fprogress=?, finstancecount=(select count(distinct finstanceid) from t_msplan_batchtask_entry where fid=? and fentryresult <> 'D') where fid=?";
    private String endsql = "update t_msplan_batchtask_log set fendtime =? ,fduration=?,fprogress=?,fstatus=?, finstancecount=(select count(distinct finstanceid) from t_msplan_batchtask_entry where fid=? and fentryresult <> 'D')  where fid=?";
    private String errsql = "update t_msplan_batchtask_log set fendtime =?, fstatus=?, finstancecount=(select count(distinct finstanceid) from t_msplan_batchtask_entry where fid=? and fentryresult <> 'D') where fid=?";
    private String setControlQueueSql = "update t_msplan_batchtask_log set fcontrolqueue = ? where fid = ?";

    public BatchTaskMainRecorder(Long _id, Long _inittime) {
        this.inittime = _inittime;
        this.id = _id;
    }

    public void updateResultLog(int fprogress) {
        try (TXHandle h1 = TX.requiresNew();){
            Long currtime = System.currentTimeMillis();
            BigDecimal stepinterval = BigDecimal.valueOf(currtime - this.inittime);
            Object[] objs = new Object[]{stepinterval, fprogress, this.id, this.id};
            DB.execute((DBRoute)pur, (String)this.updatesql, (Object[])objs);
        }
        catch (Exception ex) {
            logger.error("\u66f4\u65b0\u4e3b\u65e5\u5fd7\u51fa\u9519" + ex.getMessage());
        }
    }

    public void endResultLog() {
        try (TXHandle h1 = TX.requiresNew();){
            Long currtime = System.currentTimeMillis();
            BigDecimal stepinterval = BigDecimal.valueOf(currtime - this.inittime);
            Object[] objs = new Object[]{new Date(), stepinterval, 100, "A", this.id, this.id};
            DB.execute((DBRoute)pur, (String)this.endsql, (Object[])objs);
        }
        catch (Exception ex) {
            logger.error("\u66f4\u65b0\u4e3b\u65e5\u5fd7\u51fa\u9519" + ex.getMessage());
        }
    }

    public void errResultLog(String status) {
        try (TXHandle h1 = TX.requiresNew();){
            Object[] objs = new Object[]{new Date(), status, this.id, this.id};
            DB.execute((DBRoute)pur, (String)this.errsql, (Object[])objs);
        }
        catch (Exception ex) {
            logger.error("\u66f4\u65b0\u4e3b\u65e5\u5fd7\u51fa\u9519" + ex.getMessage());
        }
    }

    public void setControlQueue(String queuename) {
        try (TXHandle h1 = TX.requiresNew();){
            Object[] objs = new Object[]{queuename, this.id};
            DB.execute((DBRoute)pur, (String)this.setControlQueueSql, (Object[])objs);
        }
        catch (Exception ex) {
            logger.error("\u66f4\u65b0\u4e3b\u65e5\u5fd7\u51fa\u9519" + ex.getMessage());
        }
    }

    public Long getId() {
        return this.id;
    }
}

