/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.check;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.BroadcastTask;
import kd.bos.schedule.api.ShardingUtil;
import kd.bos.schedule.executor.AbstractTask;
import kd.mpscmm.msplan.mservice.service.check.CheckRedisUtils;
import kd.mpscmm.msplan.mservice.service.check.FullGCUtils;

public class ContainerCheckBatchTask
extends AbstractTask
implements BroadcastTask {
    protected static final Log log = LogFactory.getLog(ContainerCheckBatchTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        String uuid = (String)paramMap.get("uuid");
        String taskId = (String)paramMap.get("taskid");
        String instanceId = Instance.getInstanceId();
        CheckRedisUtils.setCacheValue(CheckRedisUtils.getInsttanceIdKey(taskId, uuid), instanceId);
        if (this.isFullGc(paramMap)) {
            String fullGcKey = CheckRedisUtils.getFullGCKey(taskId, instanceId);
            String lockKey = ContainerCheckBatchTask.class.getName() + "_" + fullGcKey;
            DLock lock = DLock.create((String)lockKey, (String)lockKey);
            lock.lock();
            try {
                if (!this.isExecEndFullGc(fullGcKey)) {
                    this.fullGC();
                    CheckRedisUtils.setCacheValue(fullGcKey, "true");
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public void fullGC() {
        FullGCUtils.doFullGC();
    }

    public boolean isFullGc(Map<String, Object> paramMap) {
        Object value = paramMap.get("isfullgc");
        return value != null && "true".equalsIgnoreCase(value.toString());
    }

    public boolean isExecEndFullGc(String fullGcKey) {
        String value = CheckRedisUtils.getCacheValue(fullGcKey);
        return value != null && "true".equalsIgnoreCase(value);
    }

    public void execute(RequestContext requestContext, Map<String, Object> params, ShardingUtil.BroadcastVO broadcastVO) throws KDException {
        int index = broadcastVO.getIndex();
        int total = broadcastVO.getTotal();
        total = Math.max(total, 1);
        params.put("total", total);
        params.put("index", index);
        this.execute(requestContext, params);
    }
}

