/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.check;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.OperationContextCreator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.memobj.Meminfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class FullGCUtils {
    private static final Log logger = LogFactory.getLog(FullGCUtils.class);
    private static final Pattern pattern = Pattern.compile("[\\S]+");
    private static final String MAGIC = "/";
    private static int PID = -1;

    public static void doFullGC() {
        OperationContextCreator.getOrCreateForBos();
        if (PID < 0) {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                String name = runtime.getName();
                PID = Integer.parseInt(name.substring(0, name.indexOf(64)));
            }
            catch (Exception e) {
                logger.error("mrprunner-get-pid-error:", (Throwable)e);
                PID = 0;
                throw e;
            }
        }
        String params = " -histo:live ";
        try {
            String cmdPath = ConfigurationUtil.getString((String)"JAVA_HOME");
            if (StringUtils.isEmpty((String)cmdPath)) {
                return;
            }
            String cmd = cmdPath.endsWith(MAGIC) ? cmdPath + "bin/jmap" + params + PID : cmdPath + "/bin/jmap" + params + PID;
            Process ps = Runtime.getRuntime().exec(cmd);
            try (InputStream inputStream = ps.getInputStream();
                 InputStreamReader isr = new InputStreamReader(inputStream);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                boolean startinfo = false;
                while ((line = br.readLine()) != null) {
                    if (line.contains("--------------")) {
                        startinfo = true;
                        continue;
                    }
                    if (!startinfo || line.contains("Total") && !line.contains(":")) continue;
                    Matcher matcher = pattern.matcher(line);
                    int index = 1;
                    Meminfo info = new Meminfo();
                    while (matcher.find()) {
                        if (index == 2) {
                            info.setInstances(Integer.parseInt(matcher.group()));
                        }
                        if (index == 3) {
                            info.setBytes(Long.parseLong(matcher.group()));
                        }
                        if (index == 4) {
                            info.setClsName(matcher.group());
                        }
                        ++index;
                    }
                }
            }
        }
        catch (Throwable iex) {
            logger.error("containercheck-fullgc-error:", iex);
            throw new KDException(new ErrorCode("fullgc", iex.getMessage()), new Object[0]);
        }
    }
}

