/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.check;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.MserviceInfo;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;
import kd.mpscmm.msplan.mservice.service.check.CheckRedisUtils;
import kd.mpscmm.msplan.mservice.service.check.ContainerCheckBatchTaskEvent;
import kd.mpscmm.msplan.mservice.service.check.HttpPostUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class MrpContainerCheckTask
extends AbstractTask {
    protected static final Log log = LogFactory.getLog(MrpContainerCheckTask.class);
    private static final String ENTITY_CONTAINERCHECKCONF = "msplan_containercheckconf";
    private static final String KEY_ID = "id";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_CONTAINERCOUNT = "containercount";
    private static final String KEY_TASKCOUNT = "taskcount";
    private static final String KEY_RETRYCOUNT = "retrycount";
    private static final String KEY_SAVEENTRYDAY = "saveentryday";
    private static final String KEY_ISFULLGC = "isfullgc";
    private static final String KEY_MQQUEUE = "mqqueue";
    private static final String KEY_ISRESTART = "isrestart";
    private static final String KEY_RESTARTTYPE = "restarttype";
    private static final String KEY_CUSTOMWAITTIME = "customwaittime";
    private static final String KEY_PARALLELTYPE = "paralleltype";
    private static final String KEY_MONITORUSERNUMBER = "monitorusernumber";
    private static final String KEY_MONITORUSERPS = "monitoruserps";
    private static final String KEY_MONITORURL = "monitorurl";
    private static final String KEY_ISHEALTHCHECK = "ishealthcheck";
    private static final String KEY_HEALTHPROXY = "healthproxy";
    private static final String KEY_ERRORCODE = "checkParam";
    private static final String KEY_APPLYNAME = "mpscmm-msplan-mservice";
    private static final String SQL_DELETEHISDATA = " delete from t_msplan_containercheck_e where fid = ? and fopdate <= ? ";
    private static final String SQL_INSERTDATA = "insert into t_msplan_containercheck_e(fid,fentryid,fseq,fopdate,fopresult,fopdetialinfo_tag,foptimelong,ftraceid) values(?,?,?,now(),?,?,?,?) ";
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final BigDecimal ONE000 = new BigDecimal("1000");
    private static final BigDecimal ONE00 = new BigDecimal("100");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        Object confNumber = paramMap.get(KEY_NUMBER);
        if (confNumber == null || "".equals(confNumber)) {
            throw new KDException(new ErrorCode(KEY_ERRORCODE, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u5ea6\u4f5c\u4e1a->\u6267\u884c\u53c2\u6570->\u81ea\u5b9a\u4e49\u53c2\u6570[%s](\u5bb9\u5668\u68c0\u67e5\u914d\u7f6e\u7f16\u7801)\u3002", (String)"MrpContainerCheckTask_1", (String)KEY_APPLYNAME, (Object[])new Object[0]), KEY_NUMBER)), new Object[0]);
        }
        QFilter filter = new QFilter(KEY_NUMBER, "=", (Object)confNumber.toString());
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObjectCollection confs = QueryServiceHelper.query((String)ENTITY_CONTAINERCHECKCONF, (String)this.getSelectProperties(), (QFilter[])new QFilter[]{filter});
        if (confs == null || confs.isEmpty()) {
            throw new KDException(new ErrorCode(KEY_ERRORCODE, String.format(ResManager.loadKDString((String)"\u5bb9\u5668\u68c0\u67e5\u914d\u7f6e\u7f16\u7801[%s]\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u5904\u4e8e\u53ef\u7528\u72b6\u6001\u3002", (String)"MrpContainerCheckTask_2", (String)KEY_APPLYNAME, (Object[])new Object[0]), confNumber)), new Object[0]);
        }
        long startTime = System.currentTimeMillis();
        DynamicObject conf = (DynamicObject)confs.get(0);
        String errorMsg = "";
        int containerCount = this.getContainerCount(conf);
        String isfullGc = this.getIsFullGc(conf);
        int loopCount = this.getRetryCount(conf);
        int taskCount = this.getTaskCount(conf);
        String currentExecInstanceId = Instance.getInstanceId();
        String lockKeyNumber = MrpContainerCheckTask.class.getName() + "_" + conf.getString(KEY_ID);
        String lockKeyDesc = MrpContainerCheckTask.class.getName() + "_" + conf.getString(KEY_NUMBER);
        HashSet<String> instanceIdSet = new HashSet<String>(16);
        DLock lock = DLock.create((String)lockKeyNumber, (String)lockKeyDesc);
        lock.lock();
        try {
            for (int i = 1; i <= loopCount && !this.isError(errorMsg = this.execTask(conf, instanceIdSet = new HashSet(16), i, taskCount, isfullGc)) && instanceIdSet.size() < containerCount; ++i) {
            }
            if (!this.isError(errorMsg) && instanceIdSet.size() < containerCount) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5bb9\u5668\u68c0\u67e5\u5b58\u5728\u5f02\u5e38\uff0c\u4e00\u5171[%1$s]\u4e2a\u5bb9\u5668\uff0c\u672c\u6b21\u4ec5\u68c0\u67e5\u5230[%2$s]\u4e2a\u5bb9\u5668\u6b63\u5e38\uff0c\u6b63\u5e38\u5bb9\u5668\u5b9e\u4f8b\u4e3a:%3$s", (String)"MrpContainerCheckTask_4", (String)KEY_APPLYNAME, (Object[])new Object[0]), containerCount, instanceIdSet.size(), ((Object)instanceIdSet).toString());
            }
        }
        catch (Exception ex) {
            errorMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            log.error((Throwable)ex);
        }
        finally {
            lock.unlock();
        }
        boolean isSuccessful = true;
        String result = ResManager.loadKDString((String)"\u5bb9\u5668\u8c03\u7528\u68c0\u67e5\u6210\u529f", (String)"MrpContainerCheckTask_5", (String)KEY_APPLYNAME, (Object[])new Object[0]);
        if (this.isError(errorMsg)) {
            result = ResManager.loadKDString((String)"\u5bb9\u5668\u8c03\u7528\u68c0\u67e5\u5931\u8d25", (String)"MrpContainerCheckTask_6", (String)KEY_APPLYNAME, (Object[])new Object[0]);
            isSuccessful = false;
        }
        HashMap<String, BigDecimal> checkResultMap = new HashMap<String, BigDecimal>(16);
        if (this.isHealthCheck(conf)) {
            StringBuilder allContailerInfo = new StringBuilder();
            String healthMsg = this.healthCheck(conf, checkResultMap, allContailerInfo);
            if (this.isError(healthMsg)) {
                errorMsg = errorMsg + ";" + healthMsg;
                isSuccessful = false;
                result = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5065\u5eb7\u5ea6\u68c0\u67e5\u5931\u8d25", (String)"MrpContainerCheckTask_16", (String)KEY_APPLYNAME, (Object[])new Object[0]), result);
            } else {
                result = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5065\u5eb7\u5ea6\u68c0\u67e5\u6210\u529f", (String)"MrpContainerCheckTask_13", (String)KEY_APPLYNAME, (Object[])new Object[0]), result);
            }
            if (allContailerInfo.length() > 1) {
                errorMsg = errorMsg + ";" + allContailerInfo;
            }
        }
        if (isSuccessful) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u540e\u53f0\u4efb\u52a1\u6267\u884c\u5b9e\u4f8b\uff1a%1$s\uff0c\u83b7\u53d6\u5230\u7684\u5bb9\u5668\u5b9e\u4f8b\uff1a%2$s\uff0c\u5065\u5eb7\u5ea6\u68c0\u67e5\u8be6\u60c5\uff1a%3$s", (String)"MrpContainerCheckTask_9", (String)KEY_APPLYNAME, (Object[])new Object[0]), currentExecInstanceId, ((Object)instanceIdSet).toString(), ((Object)checkResultMap).toString());
        } else if (this.isRestart(conf)) {
            String restartMsg = this.restartContainer(conf);
            if (this.isError(restartMsg)) {
                errorMsg = errorMsg + ";" + restartMsg;
                isSuccessful = false;
                result = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5bb9\u5668\u91cd\u542f\u5931\u8d25\u3002", (String)"MrpContainerCheckTask_17", (String)KEY_APPLYNAME, (Object[])new Object[0]), result);
            } else {
                result = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5df2\u89e6\u53d1\u5bb9\u5668\u91cd\u542f\u3002", (String)"MrpContainerCheckTask_8", (String)KEY_APPLYNAME, (Object[])new Object[0]), result);
            }
        }
        this.createOpData(conf, result, errorMsg, this.getExecTimeLong(startTime));
        if (!isSuccessful) {
            throw new KDException(new ErrorCode(KEY_ERRORCODE, String.format(ResManager.loadKDString((String)"MRP\u5bb9\u5668\u68c0\u67e5\u914d\u7f6e\u7f16\u7801[%1$s]\u6267\u884c\u9519\u8bef\uff1a%2$s", (String)"MrpContainerCheckTask_7", (String)KEY_APPLYNAME, (Object[])new Object[0]), confNumber, errorMsg)), new Object[0]);
        }
    }

    private BigDecimal getExecTimeLong(long startTime) {
        long enddate = System.currentTimeMillis() - startTime;
        return new BigDecimal(enddate).divide(ONE000, new MathContext(12));
    }

    private boolean isError(String msg) {
        return msg != null && !"".equals(msg);
    }

    private void createOpData(DynamicObject conf, String result, String detialMsg, BigDecimal execTimeLong) {
        try (TXHandle h1 = TX.requiresNew();){
            Long fentryId = ORM.create().genLongId("msplan_containercheckconf.entryentity");
            String ftraceId = RequestContext.get().getTraceId();
            Object[] objs = new Object[]{conf.getLong(KEY_ID), fentryId, 0, result, detialMsg, execTimeLong, ftraceId};
            DB.execute((DBRoute)scmDBRoute, (String)SQL_INSERTDATA, (Object[])objs);
            this.deleteHisData(conf);
        }
        catch (Exception ex) {
            log.error("\u5bb9\u5668\u68c0\u67e5\u65f6\u63d2\u5165\u6267\u884c\u8bb0\u5f55\u5904\u6240" + ex.getMessage());
        }
    }

    private String getSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_ID);
        sb.append(",").append(KEY_NUMBER);
        sb.append(",").append(KEY_CONTAINERCOUNT);
        sb.append(",").append(KEY_TASKCOUNT);
        sb.append(",").append(KEY_RETRYCOUNT);
        sb.append(",").append(KEY_SAVEENTRYDAY);
        sb.append(",").append(KEY_ISFULLGC);
        sb.append(",").append(KEY_MQQUEUE);
        sb.append(",").append(KEY_ISRESTART);
        sb.append(",").append(KEY_RESTARTTYPE);
        sb.append(",").append(KEY_CUSTOMWAITTIME);
        sb.append(",").append(KEY_PARALLELTYPE);
        sb.append(",").append(KEY_MONITORUSERNUMBER);
        sb.append(",").append(KEY_MONITORUSERPS);
        sb.append(",").append(KEY_MONITORURL);
        sb.append(",").append(KEY_ISHEALTHCHECK);
        sb.append(",").append(KEY_HEALTHPROXY);
        return sb.toString();
    }

    private int getTaskCount(DynamicObject conf) {
        int count = conf.getInt(KEY_TASKCOUNT);
        return count == 0 ? 10 : count;
    }

    private int getContainerCount(DynamicObject conf) {
        int count = conf.getInt(KEY_CONTAINERCOUNT);
        return count == 0 ? 1 : count;
    }

    private int getRetryCount(DynamicObject conf) {
        int count = conf.getInt(KEY_RETRYCOUNT);
        return count == 0 ? 1 : count;
    }

    private void deleteHisData(DynamicObject conf) {
        int count = conf.getInt(KEY_SAVEENTRYDAY);
        if (count >= 99999) {
            return;
        }
        Date minDate = this.getMinDate(count);
        DB.execute((DBRoute)scmDBRoute, (String)SQL_DELETEHISDATA, (Object[])new Object[]{conf.getLong(KEY_ID), minDate});
    }

    private Date getMinDate(int count) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, 0 - count);
        return calendar.getTime();
    }

    private String getIsFullGc(DynamicObject conf) {
        return conf.getBoolean(KEY_ISFULLGC) ? "true" : "false";
    }

    private boolean isRestart(DynamicObject conf) {
        return conf.getBoolean(KEY_ISRESTART);
    }

    private boolean isHealthCheck(DynamicObject conf) {
        return conf.getBoolean(KEY_ISHEALTHCHECK);
    }

    private int getHealthProxy(DynamicObject conf) {
        int proxy = conf.getInt(KEY_HEALTHPROXY);
        return proxy == 0 ? 80 : proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execTask(DynamicObject conf, Set<String> instanceIdSet, int loopCount, int taskCount, String isfullGc) {
        BatchTask task = BatchTask.create("MrpContainerCheckTask");
        task.setQueueName(conf.getString(KEY_MQQUEUE));
        task.registBizClass(ContainerCheckBatchTaskEvent.class);
        String taskId = task.getCalcId();
        int batch = 0;
        String errorMsg = "";
        int newTaskCount = taskCount * loopCount;
        HashSet<String> uuidSet = new HashSet<String>(newTaskCount);
        for (int i = 0; i < newTaskCount; ++i) {
            ++batch;
            HashMap<String, Object> batchParams = new HashMap<String, Object>(16);
            String uuid = String.valueOf(ID.genLongId());
            uuidSet.add(uuid);
            batchParams.put("uuid", uuid);
            batchParams.put("taskid", taskId);
            batchParams.put(KEY_ISFULLGC, isfullGc);
            batchParams.put("batch", batch);
            task.addEvent(batchParams);
        }
        boolean successful = true;
        try {
            log.info(String.format(ResManager.loadKDString((String)"MrpContainerCheckTask_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb\uff0c\u7b2c[%1$s]\u6b21\u91cd\u8bd5\uff0c\u5206\u53d1\u4e3a\u5171[%2$s]\u4e2a\u4efb\u52a1...", (String)"MrpContainerCheckTask_18", (String)KEY_APPLYNAME, (Object[])new Object[0]), loopCount, newTaskCount));
            task.startTask();
            log.info(ResManager.loadKDString((String)"MrpContainerCheckTask_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...", (String)"MrpContainerCheckTask_19", (String)KEY_APPLYNAME, (Object[])new Object[0]));
        }
        catch (Exception exa) {
            log.error(ResManager.loadKDString((String)"MrpContainerCheckTask_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a", (String)"MrpContainerCheckTask_20", (String)KEY_APPLYNAME, (Object[])new Object[0]) + exa.getMessage(), (Throwable)exa);
            successful = false;
            errorMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)exa);
        }
        finally {
            task.terminate();
        }
        if (!successful) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bb9\u5668\u68c0\u67e5\u5206\u5e03\u5f0f\u4efb\u52a1\u5b58\u5728\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7.%1$s", (String)"MrpContainerCheckTask_3", (String)KEY_APPLYNAME, (Object[])new Object[0]), errorMsg));
        }
        for (String uuid : uuidSet) {
            String instanceIdKey = CheckRedisUtils.getInsttanceIdKey(taskId, uuid);
            String instanceId = CheckRedisUtils.getCacheValue(instanceIdKey);
            if (instanceId == null || "".equals(instanceId)) continue;
            instanceIdSet.add(instanceId);
        }
        return errorMsg;
    }

    private boolean isFromMc(DynamicObject conf) {
        String user = conf.getString(KEY_MONITORUSERNUMBER);
        String ps = conf.getString(KEY_MONITORUSERPS);
        return StringUtils.isEmpty((String)user) || StringUtils.isEmpty((String)ps);
    }

    private String getMonitorUserNumber(DynamicObject conf) {
        String user = conf.getString(KEY_MONITORUSERNUMBER);
        if (this.isFromMc(conf)) {
            user = System.getProperty("monitor.user");
        }
        return user;
    }

    private String getMonitorUserPassword(DynamicObject conf) {
        String ps = conf.getString(KEY_MONITORUSERPS);
        if (this.isFromMc(conf)) {
            ps = System.getProperty("monitor.password");
        }
        return ps;
    }

    private String getMonitorURL(DynamicObject conf) {
        String url = conf.getString(KEY_MONITORURL);
        if (StringUtils.isEmpty((String)url)) {
            url = "http://localhost:8080/ierp/monitor/";
        }
        return url;
    }

    private String getRestartType(DynamicObject conf) {
        return conf.getString(KEY_RESTARTTYPE);
    }

    private int getParallelType(DynamicObject conf) {
        return conf.getInt(KEY_PARALLELTYPE);
    }

    private String getAppIds(DynamicObject conf) {
        return System.getProperty("appids");
    }

    private Map<String, JSONObject> getAppInstanceIdMap(DynamicObject conf) {
        String appSplit = System.getProperty("appSplit", "false");
        HashMap<String, JSONObject> instanceMap = new HashMap<String, JSONObject>(16);
        MserviceInfo mservice = ServiceInfoFactory.get();
        List serviceList = mservice.getServiceList();
        HashSet<String> appIds = new HashSet<String>(16);
        String appid = this.getAppIds(conf);
        if (appid != null) {
            appIds.addAll(JSON.parseArray((String)appid, String.class));
        }
        if (appIds.isEmpty()) {
            appIds.add("MRP");
        }
        if (Boolean.parseBoolean(appSplit)) {
            block0: for (ServiceInfo info : serviceList) {
                String[] appIdsArray = info.getAppIds();
                if (appIdsArray == null || appIdsArray.length < 1) continue;
                for (String app : appIdsArray) {
                    if (!appIds.contains(app.toUpperCase())) continue;
                    instanceMap.put(info.getInstanceId(), null);
                    continue block0;
                }
            }
        } else {
            for (ServiceInfo info : serviceList) {
                instanceMap.put(info.getInstanceId(), null);
            }
        }
        log.info("-------------MrpContainerCheckTask.getEsInstanceIdMap end,appSplit=" + appSplit + ",instanceMap=" + ((Object)instanceMap).toString());
        return instanceMap;
    }

    private String[] convertAppInstanceIdMap(Map<String, JSONObject> instanceMap) {
        Set<String> ids = instanceMap.keySet();
        return ids.toArray(new String[ids.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String healthCheck(DynamicObject conf, Map<String, BigDecimal> healthMap, StringBuilder allContailerInfo) {
        String exp;
        String esUser = System.getProperty("monitor.es.user");
        String esPs = System.getProperty("monitor.es.password");
        String esURL = System.getProperty("monitor.es.url");
        if (esURL.endsWith("/")) {
            esURL = esURL.substring(0, esURL.length() - 1);
        }
        if (StringUtils.isEmpty((String)esUser) || StringUtils.isEmpty((String)esPs) || StringUtils.isEmpty((String)esURL)) {
            return ResManager.loadKDString((String)"MC\u53c2\u6570\u672a\u914d\u7f6e\u3010monitor.es.user\u53camonitor.es.password\u3011\uff0c\u65e0\u6cd5\u8fdb\u884c\u5065\u5eb7\u5ea6\u68c0\u67e5\u3002", (String)"MrpContainerCheckTask_12", (String)KEY_APPLYNAME, (Object[])new Object[0]);
        }
        log.info("-------------MrpContainerCheckTask.healthCheck-----begin-------");
        log.info("-------------MrpContainerCheckTask.healthCheck-----esUser:" + esUser);
        log.info("-------------MrpContainerCheckTask.healthCheck-----esURL:" + esURL);
        RestHighLevelClient client = null;
        StringBuilder errorMsg = new StringBuilder();
        BigDecimal healthProxy = new BigDecimal(this.getHealthProxy(conf));
        try {
            Map<String, JSONObject> instanceMap = this.getAppInstanceIdMap(conf);
            log.info("-------------MrpContainerCheckTask.healthCheck-----instanceMap:" + instanceMap.toString());
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esUser, esPs));
            HttpHost httpHost = HttpHost.create((String)esURL);
            client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{httpHost}).setHttpClientConfigCallback(arg_0 -> MrpContainerCheckTask.lambda$healthCheck$0((CredentialsProvider)credentialsProvider, arg_0)));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String index = "*-metrics-" + dateFormat.format(new Date());
            SearchRequest search = new SearchRequest(new String[]{index});
            SearchSourceBuilder builder = new SearchSourceBuilder();
            builder.sort("timestamp", SortOrder.DESC).size(100);
            search.source(builder);
            SearchResponse search2 = client.search(search, RequestOptions.DEFAULT);
            int size = 0;
            for (SearchHit hit : search2.getHits().getHits()) {
                JSONObject obj = JSONObject.parseObject((String)hit.getSourceAsString());
                String instanceId = obj.getString("instanceId");
                allContailerInfo.append("-------------MrpContainerCheckTask.healthCheck-----instanceId(").append(++size);
                allContailerInfo.append("):").append(instanceId);
                allContailerInfo.append(",obj=").append(obj).append("\r\n");
                if (!instanceMap.containsKey(instanceId) || instanceMap.get(instanceId) != null) continue;
                instanceMap.put(instanceId, obj);
            }
            boolean isExists = true;
            for (Map.Entry<String, JSONObject> en : instanceMap.entrySet()) {
                BigDecimal jvmProxy;
                JSONObject healthJs = en.getValue();
                if (healthJs == null) {
                    log.info("-------------MrpContainerCheckTask.healthCheck-----\u5bb9\u5668:" + en.getKey() + "\u4e0d\u5b58\u5728");
                    isExists = false;
                    continue;
                }
                if (!isExists) {
                    log.info(allContailerInfo.toString());
                }
                if ((jvmProxy = this.getJVMOldGenUsageProxy(healthJs)) == null || jvmProxy.compareTo(BigDecimal.ZERO) == 0) {
                    log.info("-------------MrpContainerCheckTask.healthCheck-----instanceId:" + en.getKey() + ",detial:" + healthJs);
                }
                healthMap.put(en.getKey(), jvmProxy);
                if (jvmProxy == null || healthProxy == null || jvmProxy.compareTo(healthProxy) <= 0) continue;
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u5bb9\u5668\uff1a%1$s JVM\u8001\u5e74\u4ee3\u5185\u5b58\u4f7f\u7528\u7387\u5927\u4e8e\u767e\u5206\u4e4b%2$s\uff0c\u4e0d\u7b26\u5408\u5065\u5eb7\u5ea6\u8981\u6c42\u3002", (String)"MrpContainerCheckTask_11", (String)KEY_APPLYNAME, (Object[])new Object[0]), en.getKey(), healthProxy));
            }
            if (isExists) {
                allContailerInfo.setLength(0);
            }
        }
        catch (Exception e) {
            exp = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            log.error(exp);
            errorMsg.append(exp);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    exp = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    log.warn(exp);
                }
            }
        }
        log.info("-------------MrpContainerCheckTask.healthCheck-----end-------");
        return errorMsg.toString();
    }

    private BigDecimal getJVMOldGenUsageProxy(JSONObject healthJs) {
        BigDecimal usage = null;
        usage = healthJs.containsKey((Object)"kd.metrics.jvm.memory.pools.PS-Old-Gen.usage") ? healthJs.getBigDecimal("kd.metrics.jvm.memory.pools.PS-Old-Gen.usage") : healthJs.getBigDecimal("kd.metrics.jvm.memory.pools.G1-Old-Gen.usage");
        return usage == null ? BigDecimal.ZERO : usage.multiply(ONE00);
    }

    private boolean isErrorHttpResult(String result) {
        return result.contains("error:");
    }

    private String restartContainer(DynamicObject conf) {
        log.info("-------------MrpContainerCheckTask.restartContainer-----begin------------");
        try {
            Map<String, JSONObject> instanceMap = this.getAppInstanceIdMap(conf);
            if (instanceMap == null || instanceMap.isEmpty()) {
                return " not find appInstanceIds ";
            }
            String[] applyIds = this.convertAppInstanceIdMap(instanceMap);
            String restartURL = this.getRestartURL(conf);
            String restartReport = this.genRestartReport(conf, applyIds);
            log.info("-------------MrpContainerCheckTask.restartContainer-----restartURL:" + restartURL);
            log.info("-------------MrpContainerCheckTask.restartContainer-----restartReport:" + restartReport);
            String restartResult = HttpPostUtils.sendPost(restartURL, restartReport);
            log.info("-------------MrpContainerCheckTask.restartContainer-----restartResult:" + restartResult);
            if (this.isErrorHttpResult(restartResult)) {
                return String.format(ResManager.loadKDString((String)"\u8c03\u7528\u5bb9\u5668\u91cd\u542f\u670d\u52a1\u65f6\u53d1\u751f\u5931\u8d25\uff1a%1$s", (String)"MrpContainerCheckTask_15", (String)KEY_APPLYNAME, (Object[])new Object[0]), restartResult);
            }
            JSONObject resultJs = JSONObject.parseObject((String)restartResult);
            if (!resultJs.getBooleanValue("status")) {
                return String.format(ResManager.loadKDString((String)"\u8c03\u7528\u5bb9\u5668\u91cd\u542f\u670d\u52a1\u65f6\u53d1\u751f\u5931\u8d25\uff1a%1$s", (String)"MrpContainerCheckTask_15", (String)KEY_APPLYNAME, (Object[])new Object[0]), resultJs.getString("code") + "_" + resultJs.getString("message"));
            }
            String datas = resultJs.getString("data");
            log.info("-------------MrpContainerCheckTask.restartContainer-----restartDatas:" + datas);
            if (StringUtils.isEmpty((String)datas)) {
                return String.format(ResManager.loadKDString((String)"\u8c03\u7528\u5bb9\u5668\u91cd\u542f\u670d\u52a1\u65f6\u53d1\u751f\u5931\u8d25\uff1a%1$s", (String)"MrpContainerCheckTask_15", (String)KEY_APPLYNAME, (Object[])new Object[0]), "not find data");
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return String.format(ResManager.loadKDString((String)"\u8c03\u7528\u5bb9\u5668\u91cd\u542f\u670d\u52a1\u65f6\u53d1\u751f\u5931\u8d25\uff1a%1$s", (String)"MrpContainerCheckTask_15", (String)KEY_APPLYNAME, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        log.info("-------------MrpContainerCheckTask.restartContainer-----end------------");
        return "";
    }

    private JSONObject genAuthJson(DynamicObject conf) {
        JSONObject authJson = new JSONObject();
        authJson.put("username", (Object)this.getMonitorUserNumber(conf));
        authJson.put("password", (Object)this.getMonitorUserPassword(conf));
        return authJson;
    }

    private String genQueryAppSplitsReport(DynamicObject conf) {
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("auth", (Object)this.genAuthJson(conf));
        bodyJson.put("properties", (Object)"appSplit");
        return bodyJson.toJSONString();
    }

    private String genRestartReport(DynamicObject conf, String[] appNams) {
        JSONObject typeJson = new JSONObject();
        typeJson.put("selectAppNames", (Object)appNams);
        String restartType = this.getRestartType(conf);
        typeJson.put("restartType", (Object)restartType);
        typeJson.put("parallelType", (Object)this.getParallelType(conf));
        if ("2".equals(restartType)) {
            typeJson.put("customWaitTime", (Object)conf.getInt(KEY_CUSTOMWAITTIME));
        }
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("auth", (Object)this.genAuthJson(conf));
        bodyJson.put("scrollRestartForm", (Object)typeJson);
        return bodyJson.toJSONString();
    }

    private String getQueryAppSplitsURL(DynamicObject conf) {
        return this.getMonitorURL(conf) + "external/getServiceList";
    }

    private String getRestartURL(DynamicObject conf) {
        return this.getMonitorURL(conf) + "external/scrollRestart";
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$healthCheck$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder f) {
        return f.setDefaultCredentialsProvider(credentialsProvider);
    }
}

