/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datafetch;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;

public class DataFetcher {
    public DataSet getDataSet(Long modelId, Set<Long> masterIdSet) {
        return DataSourceFetchDataUtil.getDataSetByModel(modelId, masterIdSet);
    }

    public DataSet getDataSet(Long modelId) {
        return DataSourceFetchDataUtil.getDataSetByModel(modelId, null);
    }

    public Map getDataMap(Set<Long> sDSID) {
        if (sDSID == null) {
            return null;
        }
        HashMap<Long, JSONArray> mData = new HashMap<Long, JSONArray>(sDSID.size());
        for (Long lDSID : sDSID) {
            if (lDSID <= 0L) continue;
            DataSet dsData = this.getDataSet(lDSID);
            RowMeta rmData = dsData.getRowMeta();
            String[] fieldNameArray = rmData == null ? new String[]{} : rmData.getFieldNames();
            JSONArray jsonArrData = new JSONArray();
            while (dsData.hasNext()) {
                Row rData = dsData.next();
                JSONObject jsonObjData = new JSONObject();
                for (String fieldName : fieldNameArray) {
                    jsonObjData.put(fieldName, rData.get(fieldName));
                }
                jsonArrData.add((Object)jsonObjData);
            }
            dsData.close();
            mData.put(lDSID, jsonArrData);
        }
        return mData;
    }

    public DataSet getDataSet(List<Long> modelIds, Set<Long> masterIdSet) {
        DataSet ds = null;
        for (Long modelId : modelIds) {
            if (ds == null) {
                ds = DataSourceFetchDataUtil.getDataSetByModel(modelId, masterIdSet);
                continue;
            }
            ds.union(DataSourceFetchDataUtil.getDataSetByModel(modelId, masterIdSet));
        }
        return ds;
    }
}

