/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datafetch.algo;

import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.mpscmm.msplan.mservice.service.reportext.OrgConvertHelper;

public class GetOrgConvertMapFunction
extends MapFunction {
    private RowMeta rowMeta;
    private int targetFieldIndex;
    private String fromOrg;
    private String fromOrgType;
    private String toOrgType;

    public GetOrgConvertMapFunction(RowMeta rowMeta, String targetField, String fromOrg, String fromOrgType, String toOrgType) {
        this.rowMeta = rowMeta;
        this.targetFieldIndex = rowMeta.getFieldIndex(targetField);
        this.fromOrg = fromOrg;
        this.fromOrgType = fromOrgType;
        this.toOrgType = toOrgType;
    }

    public Object[] map(Row row) {
        Object[] newRow = null;
        if (row == null || this.rowMeta == null) {
            return newRow;
        }
        if (this.rowMeta.getFieldIndex(this.fromOrg, false) == -1) {
            return newRow;
        }
        newRow = new Object[this.rowMeta.getFieldCount()];
        for (int i = 0; i < this.rowMeta.getFieldCount(); ++i) {
            newRow[i] = this.targetFieldIndex == i ? this.getValue(row, this.fromOrg, this.fromOrgType, this.toOrgType) : row.get(i);
        }
        return newRow;
    }

    private Long getValue(Row data, String fromOrg, String fromOrgType, String toOrgType) {
        long realMftOrgId = GetOrgConvertMapFunction.getRealId(fromOrg, data);
        if (realMftOrgId != 0L) {
            return OrgConvertHelper.getCacheConvertOrgId(realMftOrgId, fromOrgType, toOrgType);
        }
        return 0L;
    }

    private static Long getRealId(String field, Row data) {
        long realId = 0L;
        if ((field = field.trim()) != null && (field.matches("[1-9]+[0-9]*") || "0".equals(field))) {
            return Long.parseLong(field);
        }
        if (field != null && data != null && data.get(field) != null && (realId = data.getLong(field).longValue()) != 0L) {
            return realId;
        }
        return 0L;
    }

    public RowMeta getResultRowMeta() {
        Field[] fields = this.rowMeta.getFields();
        fields[this.targetFieldIndex].setDataType((DataType)DataType.LongType);
        return new RowMeta(fields);
    }
}

