/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datafetch.custom;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.MapFunction;
import kd.bos.algo.RowMeta;
import kd.mpscmm.msplan.mservice.service.datafetch.custom.CustomMethodStruct;
import kd.mpscmm.msplan.mservice.service.datafetch.custom.strategy.GetInventoryOrgByProductOrgStrategy;
import kd.mpscmm.msplan.mservice.service.datafetch.custom.strategy.GetPurchaseOrgByProductOrgStrategy;
import kd.mpscmm.msplan.mservice.service.datafetch.custom.strategy.GetRelationOrgStrategy;
import kd.mpscmm.msplan.mservice.service.datafetch.custom.strategy.ICustomMethodStrategy;

public class CustomMethodUtils {
    private static Map<String, ICustomMethodStrategy> supportMethodMap = new HashMap<String, ICustomMethodStrategy>(16);

    public static MapFunction buildAlgoMapFunction(RowMeta rowMeta, String targetField, CustomMethodStruct struct) {
        String method = struct.getMethodName();
        MapFunction function = null;
        if (CustomMethodUtils.isSupport(method)) {
            ICustomMethodStrategy strategy = supportMethodMap.get(method);
            function = strategy.buildAlgoMapFunction(rowMeta, targetField, struct.getParams());
        }
        return function;
    }

    public static CustomMethodStruct getCustomMethodStructByCalFields(String formulaSrcField) {
        char[] formulas = formulaSrcField.toCharArray();
        StringBuilder currentMethods = new StringBuilder();
        boolean isLeftBraketBalance = false;
        boolean isRightBraketBalance = false;
        boolean isMethodResove = true;
        CustomMethodStruct currentMethodStruct = new CustomMethodStruct();
        int paramCounts = -1;
        StringBuilder currentParam = new StringBuilder();
        int currentParamIndex = 0;
        for (char formula : formulas) {
            if ((formula >= 'a' && formula <= 'z' || formula >= 'A' && formula <= 'Z') && isMethodResove) {
                currentMethods.append(formula);
                continue;
            }
            if (formula == '(' && !isLeftBraketBalance) {
                String method = currentMethods.toString();
                currentMethodStruct = CustomMethodUtils.getEmptyMethodStruct(method);
                if (currentMethodStruct == null) {
                    return null;
                }
                paramCounts = currentMethodStruct.getParams() == null ? 0 : currentMethodStruct.getParams().length;
                isLeftBraketBalance = true;
                isMethodResove = false;
                currentMethods.setLength(0);
                continue;
            }
            if (!isLeftBraketBalance || isRightBraketBalance) break;
            if (formula != '\uff0c' && formula != ',' && formula != ')') {
                currentParam.append(formula);
                continue;
            }
            if (formula != ')' && currentParamIndex < paramCounts) {
                currentMethodStruct.getParams()[currentParamIndex++] = currentParam.toString().trim();
                currentParam.setLength(0);
                continue;
            }
            if (formula != ')' || currentParamIndex >= currentMethodStruct.getParams().length) continue;
            currentMethodStruct.getParams()[currentParamIndex++] = currentParam.toString().trim();
            isRightBraketBalance = true;
            break;
        }
        if (isLeftBraketBalance && isRightBraketBalance && currentMethodStruct.getParams().length == currentParamIndex) {
            return currentMethodStruct;
        }
        return null;
    }

    private static CustomMethodStruct getEmptyMethodStruct(String method) {
        CustomMethodStruct struct = null;
        if (CustomMethodUtils.isSupport(method)) {
            ICustomMethodStrategy strategy = supportMethodMap.get(method);
            struct = strategy.buildEmptyMethodStruct();
        }
        return struct;
    }

    private static boolean isSupport(String methodName) {
        return supportMethodMap.containsKey(methodName);
    }

    static {
        supportMethodMap.put("GetRelationOrg", new GetRelationOrgStrategy());
        supportMethodMap.put("GetInwareOrgByOrg", new GetInventoryOrgByProductOrgStrategy());
        supportMethodMap.put("GetPurChaseOrgByOrg", new GetPurchaseOrgByProductOrgStrategy());
    }
}

