/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datafetch.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprParser;
import kd.bos.formula.excel.MapExecuteContext;
import kd.bos.formula.excel.VerifyVisitor;
import kd.bos.formula.excel.Visitor;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;
import kd.mpscmm.msplan.mservice.service.datafetch.custom.CustomMethodStruct;
import kd.mpscmm.msplan.mservice.service.datafetch.custom.CustomMethodUtils;
import kd.mpscmm.msplan.mservice.service.datafetch.model.FetchDataQueryModule;
import org.apache.commons.lang.math.NumberUtils;

public class DataSourceFetchDataUtil {
    public static final String DEST_MT_FIELD = "entryentity.material";
    public static final String DEST_CHILD_MT_FIELD = "entryentity.comboxmateriel";
    private static final Log log = LogFactory.getLog(DataSourceFetchDataUtil.class);

    public static DataSet getDataSetByModel(Long modelId, Set<Long> masterIdSet) {
        FetchDataQueryModule queryMD = DataSourceFetchDataUtil.getQueryModuleByModel(modelId, masterIdSet);
        DataSet ds = QueryServiceHelper.queryDataSet((String)DataSourceFetchDataUtil.class.getName(), (String)queryMD.getMt(), (String)queryMD.getOql(), (QFilter[])queryMD.getqFilters(), null);
        return DataSourceFetchDataUtil.getDataSetByModel(queryMD, ds);
    }

    public static DataSet getDataSetByModel(Long modelId, Set<Long> masterIdSet, QFilter filter) {
        FetchDataQueryModule queryMD = DataSourceFetchDataUtil.getQueryModuleByModel(modelId, masterIdSet, filter);
        DataSet ds = QueryServiceHelper.queryDataSet((String)DataSourceFetchDataUtil.class.getName(), (String)queryMD.getMt(), (String)queryMD.getOql(), (QFilter[])queryMD.getqFilters(), null);
        return DataSourceFetchDataUtil.getDataSetByModel(queryMD, ds);
    }

    public static DataSet getDataSetByModel(FetchDataQueryModule queryMD, DataSet ds) {
        LinkedList<String> allField = new LinkedList<String>(queryMD.getSelFields());
        Map<String, CustomMethodStruct> customMethodStructMap = queryMD.getCustomMethodStructMap();
        for (Map.Entry<String, CustomMethodStruct> entry : customMethodStructMap.entrySet()) {
            String targetField = entry.getKey();
            allField.add(targetField);
            CustomMethodStruct customMethodStruct = entry.getValue();
            MapFunction function = CustomMethodUtils.buildAlgoMapFunction((ds = ds.addNullField(targetField)).getRowMeta(), targetField, customMethodStruct);
            if (function == null) continue;
            ds = ds.map(function);
        }
        ds = ds.select(allField.toArray(new String[0]));
        return ds;
    }

    public static Set<String> getFields(String value) {
        HashSet<String> keyWordset = new HashSet<String>(4);
        keyWordset.add("and");
        keyWordset.add("or");
        keyWordset.add("in");
        keyWordset.add("is");
        keyWordset.add("null");
        HashSet<String> fieldList = new HashSet<String>(16);
        char[] fields = value.toCharArray();
        StringBuilder fieldName = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            char field = fields[i];
            if (fieldName.length() > 0 && (field >= 'a' && field <= 'z' || field >= 'A' && field <= 'Z' || field >= '0' && field <= '9' || field == '.' || field == '_')) {
                fieldName.append(field);
                continue;
            }
            if (field >= 'a' && field <= 'z' || field >= 'A' && field <= 'Z') {
                fieldName.append(field);
                continue;
            }
            if (fieldName.length() > 0 && (field == '(' || field == '\'' || field == '\"')) {
                fieldName.setLength(0);
                continue;
            }
            if (fieldName.length() > 0 && !keyWordset.contains(fieldName.toString())) {
                fieldList.add(fieldName.toString());
                fieldName.setLength(0);
                continue;
            }
            if (!keyWordset.contains(fieldName.toString())) continue;
            fieldName.setLength(0);
        }
        if (fieldName.length() > 0 && !keyWordset.contains(fieldName.toString())) {
            fieldList.add(fieldName.toString());
            fieldName.setLength(0);
        }
        return fieldList;
    }

    public static FetchDataQueryModule getQueryModuleByModel(Long modelId, Set<Long> masterIdSet) {
        return DataSourceFetchDataUtil.getQueryModuleByModel(modelId, masterIdSet, null);
    }

    public static FetchDataQueryModule getQueryModuleByModel(Long modelId, Set<Long> masterIdSet, QFilter filter) {
        DynamicObject mrpDs = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"mrp_resource_dataconfig");
        DynamicObject transferDyn = mrpDs.getDynamicObject("billfieldtransfer");
        transferDyn = BusinessDataServiceHelper.loadSingle((Object)transferDyn.getLong("id"), (String)"mrp_billfieldtransfer");
        DynamicObjectCollection fieldMappingAll = transferDyn.getDynamicObjectCollection("entryentity");
        String filterContent = mrpDs.getString("filter_tag");
        DynamicObject srcBillEntity = transferDyn.getDynamicObject("srcbill");
        MainEntityType srcType = MetadataServiceHelper.getDataEntityType((String)srcBillEntity.getString("id"));
        String srcTypeName = srcType.getName();
        String algoStr = "";
        HashMap<String, CustomMethodStruct> customMethodStructMap = new HashMap<String, CustomMethodStruct>(16);
        QFilter tmpFilter = null;
        if (!StringUtils.isEmpty((CharSequence)filterContent)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterContent, FilterCondition.class);
            FilterBuilder fb = new FilterBuilder(srcType, filterCondition);
            UserService userService = new UserService();
            fb.setUserService((IUserService)userService);
            fb.buildFilter(false);
            tmpFilter = fb.getQFilter();
            filter = filter != null ? filter.and(tmpFilter) : tmpFilter;
        }
        if (filter == null) {
            filter = new QFilter("1", "=", (Object)"1", true);
        }
        Map<String, IDataEntityProperty> allFields = DataSourceFetchDataUtil.getAllEntityProp(srcType);
        HashSet<String> formulaSrcFields = new HashSet<String>(8);
        HashMap<Object, String> formulaDestToSrcMap = new HashMap<Object, String>(8);
        for (DynamicObject mapping : fieldMappingAll) {
            String destField = mapping.getString("destfieldflag");
            String srcField = mapping.getString("sourcefieldflag");
            String formula = mapping.getString("calculateexc_tag");
            String type = mapping.getString("converttype");
            if (StringUtils.isEmpty((CharSequence)srcField)) {
                String formulaStr;
                if (Objects.equals(type, "2")) {
                    CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)formula, CRValByConditions.class);
                    MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)srcTypeName);
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("CASE");
                    for (CRValByCondition item : valByConditions.getItems()) {
                        String upperCase;
                        FilterCondition filterCondition = item.getCondition().getFilterCondition();
                        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
                        String[] strings = filterBuilder.buildFilterScript();
                        String conditionFormula = strings[0];
                        String valFormula = item.getFormula().getExpression();
                        valFormula = valFormula.replace(srcTypeName + ".", "");
                        IDataEntityProperty prop = allFields.get(valFormula);
                        if (DEST_MT_FIELD.equalsIgnoreCase(destField) || DEST_CHILD_MT_FIELD.equalsIgnoreCase(destField)) {
                            valFormula = DataSourceFetchDataUtil.transMaterial(masterIdSet, filter, allFields, valFormula);
                        }
                        if ((upperCase = valFormula.toUpperCase(Locale.ENGLISH)).startsWith("NOW(") || upperCase.startsWith("DATE(") || upperCase.startsWith("TO_DATE(") || upperCase.startsWith("DATEADD(")) {
                            valFormula = "cast(" + valFormula + " AS Timestamp)";
                        }
                        valFormula = DataSourceFetchDataUtil.getFormulaVariable(valFormula, formulaSrcFields);
                        conditionFormula = DataSourceFetchDataUtil.getConditionFormulaVariable(conditionFormula, formulaSrcFields, mainEntityType);
                        sb.append(" WHEN ").append(conditionFormula).append(" THEN ").append(valFormula);
                    }
                    String formulaStr2 = sb.append(" END").toString();
                    formulaDestToSrcMap.put(destField, formulaStr2);
                    continue;
                }
                boolean isUnSet = StringUtils.isEmpty((CharSequence)formula);
                JSONObject jo = isUnSet ? null : JSON.parseObject((String)formula);
                String string = formulaStr = jo == null ? null : jo.getString("expression");
                if (formulaStr == null || StringUtils.isEmpty((CharSequence)formulaStr)) {
                    throw new KDBizException(new ErrorCode("EMPTY_FIELD_CONTENT", String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u3010%1$s, id: %2$s\u3011\u7684\u53d6\u6570\u8bbe\u7f6e\u3010%3$s, id: %4$s\u3011\u5b57\u6bb5\u3010%5$s\u3011\u672a\u8bbe\u7f6e\u3002", (String)"DataSourceFetchDataUtil_0", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), mrpDs.getString("name"), mrpDs.getString("id"), transferDyn.getString("name"), transferDyn.getString("id"), destField)), new Object[0]);
                }
                if (StringUtils.isBlank((CharSequence)formulaStr)) continue;
                formulaStr = formulaStr.replace(srcTypeName + ".", "");
                IDataEntityProperty prop = allFields.get(formulaStr);
                if (DEST_MT_FIELD.equalsIgnoreCase(destField) || DEST_CHILD_MT_FIELD.equalsIgnoreCase(destField)) {
                    formulaStr = DataSourceFetchDataUtil.transMaterial(masterIdSet, filter, allFields, formulaStr);
                }
                if (Objects.equals(type, "3") && !NumberUtils.isNumber((String)formulaStr)) {
                    formulaStr = String.format("'%s'", formulaStr);
                } else if (!Objects.equals(type, "3")) {
                    formulaStr = DataSourceFetchDataUtil.getFormulaVariable(formulaStr, formulaSrcFields);
                }
                formulaDestToSrcMap.put(destField, formulaStr);
                continue;
            }
            String formulaStr = srcField;
            IDataEntityProperty prop = allFields.get(formulaStr);
            if (DEST_MT_FIELD.equalsIgnoreCase(destField) || DEST_CHILD_MT_FIELD.equalsIgnoreCase(destField)) {
                formulaStr = DataSourceFetchDataUtil.transMaterial(masterIdSet, filter, allFields, formulaStr);
            }
            formulaStr = DataSourceFetchDataUtil.getFormulaVariable(formulaStr, formulaSrcFields);
            formulaDestToSrcMap.put(destField, formulaStr);
        }
        ArrayList<String> selFields = new ArrayList<String>(16);
        StringBuilder queryField = new StringBuilder();
        for (String src : formulaSrcFields) {
            queryField.append(src).append(", ");
        }
        for (DynamicObject mapping : fieldMappingAll) {
            String col = mapping.getString("destfieldflag");
            String formulaSrcField = (String)formulaDestToSrcMap.get(col);
            if (formulaSrcField == null) {
                selFields.add("null " + col);
                continue;
            }
            CustomMethodStruct customMethod = CustomMethodUtils.getCustomMethodStructByCalFields(formulaSrcField);
            if (customMethod != null) {
                customMethodStructMap.put(col, customMethod);
                continue;
            }
            selFields.add(String.format("(%s) AS %s", formulaSrcField, col));
        }
        queryField.setLength(queryField.length() - 2);
        String oql = queryField.toString();
        oql = DataSourceFetchDataUtil.getFieldsSet(oql, algoStr);
        log.info(String.format("-----getQueryModuleByModel----------filter = %s,oql = %s,algoStr = %s,selFields = %s", filter, oql, algoStr, selFields));
        return new FetchDataQueryModule(srcTypeName, oql, new QFilter[]{filter}, selFields, algoStr, customMethodStructMap);
    }

    public static String getConditionFormulaVariable(String formula, Set<String> vars, MainEntityType mainEntityType) {
        Expr expr = ExprParser.parse((String)formula);
        VerifyVisitor visitor = new VerifyVisitor((ExecuteContext)new MapExecuteContext());
        expr.accept((Visitor)visitor);
        List invalidSymboList = visitor.getInvalidSymboList();
        for (String s : invalidSymboList) {
            String absoluteFieldName = s = s.toLowerCase(Locale.ENGLISH);
            String[] str = s.split("\\.");
            if (str.length > 1 && mainEntityType.findProperty(str[0]) != null) {
                StringBuilder sb = new StringBuilder(BillFieldEntityHelper.getAbsolutePropertyName((IDataEntityProperty)mainEntityType.findProperty(str[0])).toLowerCase(Locale.ENGLISH));
                for (int i = 1; i < str.length; ++i) {
                    sb.append('.').append(str[i]);
                }
                absoluteFieldName = sb.toString();
            } else {
                if (mainEntityType.findProperty(s) == null) continue;
                absoluteFieldName = BillFieldEntityHelper.getAbsolutePropertyName((IDataEntityProperty)mainEntityType.findProperty(s)).toLowerCase(Locale.ENGLISH);
            }
            vars.add(absoluteFieldName);
            if (absoluteFieldName.equals(s)) continue;
            formula = formula.replaceAll("\\(" + s + " ", "(" + absoluteFieldName + " ");
            formula = formula.replaceAll(" " + s + "\\)", " " + absoluteFieldName + ")");
            formula = formula.replaceAll(" " + s + " ", " " + absoluteFieldName + " ");
        }
        int firstIdx = formula.indexOf("trim(EMPTY_TO_TEXT(");
        String nullStr = " is not null";
        StringBuilder sb = new StringBuilder();
        while (firstIdx >= 0) {
            int nullIdx;
            sb.setLength(0);
            int comIdx = -1;
            int bracketIdx = -1;
            int countBracket = 0;
            for (int i = firstIdx + 19; i < formula.length(); ++i) {
                if (formula.charAt(i) == ',') {
                    comIdx = i;
                } else if (formula.charAt(i) == ')') {
                    ++countBracket;
                }
                if (countBracket != 2) continue;
                bracketIdx = i;
                break;
            }
            if ((nullIdx = formula.indexOf("!= ''", bracketIdx)) < 0) {
                nullIdx = formula.indexOf("= ''", bracketIdx);
                nullIdx += 4;
                nullStr = " is null";
            } else {
                nullIdx += 5;
            }
            sb.append(formula.substring(0, firstIdx)).append(formula.substring(firstIdx + 19, comIdx)).append(nullStr).append(formula.substring(nullIdx, formula.length()));
            formula = sb.toString();
            firstIdx = formula.indexOf("trim(EMPTY_TO_TEXT(");
        }
        return formula;
    }

    public static String getFieldsSet(String oql, String algoStr) {
        StringBuilder fieldsbuilder = new StringBuilder();
        fieldsbuilder.append(oql);
        String[] fields = oql.split("[,]");
        HashSet<String> fieldSet = new HashSet<String>(fields.length);
        for (String field : fields) {
            fieldSet.add(field.trim());
        }
        Set<String> fieldList = DataSourceFetchDataUtil.getFields(algoStr);
        for (String field : fieldList) {
            if (fieldSet.contains(field)) continue;
            fieldsbuilder.append(',').append(field);
        }
        return fieldsbuilder.toString();
    }

    public static String transMaterial(Set<Long> masterIdSet, QFilter filter, Map<String, IDataEntityProperty> allFields, String formulaStr) {
        boolean hasMaterialFilter;
        boolean hasMtField = false;
        IDataEntityProperty prop = allFields.get(formulaStr);
        String formula = formulaStr;
        if (prop == null) {
            int indexOf;
            while ((indexOf = formula.lastIndexOf(46)) > -1 && (prop = allFields.get(formula = formula.substring(0, indexOf))) == null) {
            }
        }
        if (prop instanceof MaterielProp) {
            formulaStr = formula;
            String baseEntityId = ((MaterielProp)prop).getBaseEntityId();
            if (!"bd_material".equalsIgnoreCase(baseEntityId)) {
                formulaStr = formulaStr + ".masterid";
            }
            hasMtField = true;
        } else if (prop instanceof MasterBasedataProp) {
            formulaStr = formula;
            hasMtField = true;
        }
        boolean bl = hasMaterialFilter = masterIdSet != null;
        if (hasMaterialFilter) {
            if (hasMtField) {
                if (filter == null) {
                    filter = new QFilter(formulaStr, "in", masterIdSet);
                } else {
                    filter.and(new QFilter(formulaStr, "in", masterIdSet));
                }
            } else if (filter == null) {
                filter = new QFilter("1", "!=", (Object)"1", true);
            } else {
                filter.and(new QFilter("1", "!=", (Object)"1", true));
            }
        }
        return formulaStr;
    }

    public static Map<String, IDataEntityProperty> getAllEntityProp(MainEntityType mainType) {
        HashMap<String, IDataEntityProperty> result = new HashMap<String, IDataEntityProperty>(32);
        String name = mainType.getName();
        Map allEntities = mainType.getAllEntities();
        for (Map.Entry entry : allEntities.entrySet()) {
            EntityType value = (EntityType)entry.getValue();
            String entryName = value.getName();
            if (name.equals(entryName)) {
                result.putAll(value.getFields());
                continue;
            }
            Map fields = value.getFields();
            for (Map.Entry e : fields.entrySet()) {
                String entryKey = entryName + "." + (String)e.getKey();
                result.put(entryKey, (IDataEntityProperty)e.getValue());
            }
        }
        return result;
    }

    public static String getFormulaVariable(String formula, Set<String> vars) {
        Expr expr = ExprParser.parse((String)formula);
        VerifyVisitor visitor = new VerifyVisitor((ExecuteContext)new MapExecuteContext());
        expr.accept((Visitor)visitor);
        List invalidSymboList = visitor.getInvalidSymboList();
        for (String s : invalidSymboList) {
            vars.add(s.toLowerCase(Locale.ENGLISH));
        }
        return formula;
    }
}

