/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datasync;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.CacheHint;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msplan.mservice.datasync.api.IMMCDataSyncService;
import kd.mpscmm.msplan.mservice.service.datasync.DataVersionSyncHisEntrySorter;
import kd.mpscmm.msplan.mservice.service.datasync.MMCSnapDataVisitor;
import kd.mpscmm.msplan.mservice.service.datasync.func.DataSyncHistoryUpdater;
import kd.mpscmm.msplan.mservice.service.datasync.func.DataSyncRunnable;

public class MMCDataSyncService
implements IMMCDataSyncService {
    private static Log logger = LogFactory.getLog(MMCDataSyncService.class);
    private static CacheFactory fac = CacheFactory.getCommonCacheFactory();
    private static DistributeSessionlessCache cache = fac.getDistributeSessionlessCache("MMC-DATASYNC");
    private static final DBRoute mmcRoute = new DBRoute("scm");
    private static long TS_20201231 = 1612022400000L;

    private Map<String, Object> callImpl(FuncImpl impl) {
        try {
            Map<String, Object> ret = impl.apply();
            return ret;
        }
        catch (Throwable e) {
            logger.error("mmc-datasync, system failed", e);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("ok", Boolean.FALSE);
            ret.put("ec", "99999");
            ret.put("em", "mmc-datasync, system-failed, class: " + e.getClass().getName() + ", msg: " + e.getMessage());
            return ret;
        }
    }

    public Map<String, Object> executeDataQuery(Long versionId, String metaKey, String selectFields, QFilter[] filters, String orderBys) {
        return this.callImpl(() -> this.executeDataQueryImpl(versionId, metaKey, selectFields, filters, orderBys));
    }

    public Map<String, Object> executeDataQuery(Long versionId, String metaKey, String selectFields, QFilter[] filters) {
        return this.callImpl(() -> this.executeDataQueryImpl(versionId, metaKey, selectFields, filters, null));
    }

    public Map<String, Object> executeDataQueryWithHisVersion(Long versionId, Long hisEntryId, String metaKey, String selectFields, QFilter[] filters, String orderBys) {
        return this.callImpl(() -> {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            DataSet ds = new MMCSnapDataVisitor().localFastDataVisit(versionId, hisEntryId, metaKey, selectFields, filters, orderBys);
            ret.put("ok", Boolean.TRUE);
            ret.put("id", ds.cache(new CacheHint()).getCacheId());
            return ret;
        });
    }

    private Map<String, Object> executeDataQueryImpl(Long versionId, String metaKey, String selectFields, QFilter[] filters, String orderBys) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        DynamicObject hisEntry = MMCSnapDataVisitor.loadLatestHisEntry(versionId);
        if (hisEntry == null) {
            ret.put("ok", Boolean.FALSE);
            ret.put("ec", "10002");
            ret.put("em", ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u5386\u53f2\u7248\u672c\u3002", (String)"MMCDataSyncService_0", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]));
            return ret;
        }
        DataSet ds = new MMCSnapDataVisitor().localFastDataVisit(versionId, null, metaKey, selectFields, filters, orderBys);
        ret.put("ok", Boolean.TRUE);
        ret.put("id", ds.cache(new CacheHint()).getCacheId());
        return ret;
    }

    public Map<String, Object> addDataVersion(Long versionId) {
        return this.callImpl(() -> this.addDataVersionImpl(versionId));
    }

    private Map<String, Object> addDataVersionImpl(Long versionId) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (!MMCDataSyncService.tryLock(versionId)) {
            ret.put("ok", Boolean.FALSE);
            ret.put("ec", "10000");
            ret.put("em", ResManager.loadKDString((String)"\u7248\u672c\u88ab\u9501\u5b9a\uff0c\u8bf7\u91ca\u653e\u7248\u672c\u9501\u540e\u8fdb\u884c\u6570\u636e\u540c\u6b65\u3002", (String)"MMCDataSyncService_1", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]));
            return ret;
        }
        DynamicObject dataVer = BusinessDataServiceHelper.loadSingle((Object)versionId, (String)"msplan_ds_version");
        DynamicObjectCollection hisEntrys = dataVer.getDynamicObjectCollection("hisentity");
        if (!hisEntrys.isEmpty()) {
            hisEntrys.sort((Comparator)new DataVersionSyncHisEntrySorter());
            if ("A".equals(((DynamicObject)hisEntrys.get(0)).getString("syncstatus")) && MMCDataSyncService.exist(versionId)) {
                ret.put("ok", Boolean.FALSE);
                ret.put("ec", "10001");
                ret.put("em", ResManager.loadKDString((String)"\u6570\u636e\u7248\u672c\u540c\u6b65\u4e2d\uff0c\u8bf7\u7b49\u5f85\u672c\u6b21\u540c\u6b65\u5b8c\u6210\u518d\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", (String)"MMCDataSyncService_2", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]));
                return ret;
            }
        }
        DynamicObject newHisEntry = (DynamicObject)hisEntrys.getDynamicObjectType().createInstance();
        newHisEntry.set("startdatetime", (Object)System.currentTimeMillis());
        newHisEntry.set("syncstatus", (Object)"A");
        newHisEntry.set("executor", (Object)RequestContext.get().getCurrUserId());
        newHisEntry.set("versioneditor", dataVer.get("modifier"));
        newHisEntry.set("versionedittime", dataVer.get("modifytime"));
        hisEntrys.add((Object)newHisEntry);
        hisEntrys.sort((Comparator)new DataVersionSyncHisEntrySorter());
        int i = 0;
        for (DynamicObject entry : hisEntrys) {
            entry.set("seq", (Object)i++);
        }
        MMCDataSyncService.regist(versionId);
        BusinessDataWriter.save((IDataEntityType)dataVer.getDataEntityType(), (Object[])new Object[]{dataVer});
        ThreadPools.executeOnceIncludeRequestContext((String)("mmc-datasync-" + versionId), (Runnable)new DataSyncRunnable(dataVer, newHisEntry));
        ThreadPools.executeOnceIncludeRequestContext((String)("mmc-datasync-log-saver-" + versionId), (Runnable)new DataSyncHistoryUpdater(dataVer));
        ret.put("ok", Boolean.TRUE);
        return ret;
    }

    public Map<String, Object> stopDataVersion(Long versionId, Long hisEntryID) {
        return this.callImpl(() -> this.stopDataVersionImpl(versionId, hisEntryID));
    }

    private Map<String, Object> stopDataVersionImpl(Long versionId, Long hisEntryID) {
        MMCDataSyncService.releasLock(versionId);
        StringBuilder sql = new StringBuilder();
        Long hisEntryId = hisEntryID;
        sql.setLength(0);
        sql.append("update t_msplan_dv_hisentry set fsyncstatus = 'C' where fsyncstatus = 'A' and fentryid = ").append(hisEntryId);
        DB.execute((DBRoute)mmcRoute, (String)sql.toString());
        sql.setLength(0);
        sql.append("update t_msplan_dv_detail set fhisstatus = 'C' where fhisstatus = 'A' and fentryid = ").append(hisEntryId);
        DB.execute((DBRoute)mmcRoute, (String)sql.toString());
        BaseDataServiceHelper.clearCache((DynamicObject)BusinessDataServiceHelper.loadSingle((Object)versionId, (String)"msplan_ds_version"));
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("ok", Boolean.TRUE);
        return ret;
    }

    public Map<String, Object> activeMinorDataVersion(Long versionId, int minorVersion) {
        return this.callImpl(() -> this.activeMinorDataVersionImpl(versionId, minorVersion));
    }

    private Map<String, Object> activeMinorDataVersionImpl(Long versionId, int minorVersion) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        return ret;
    }

    public Map<String, Object> removeMinorDataVersion(Long versionId, int minorVersion) {
        return this.callImpl(() -> this.removeMinorDataVersionImpl(versionId, minorVersion));
    }

    private Map<String, Object> removeMinorDataVersionImpl(Long versionId, int minorVersion) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        return ret;
    }

    public Map<String, Object> queryDataSyncActionStatus(Long versionId) {
        return this.callImpl(() -> this.queryDataSyncActionStatusImpl(versionId));
    }

    private Map<String, Object> queryDataSyncActionStatusImpl(Long versionId) {
        HashMap<String, Object> ret;
        block31: {
            ret = new HashMap<String, Object>();
            HashMap<String, Object> desc = new HashMap<String, Object>();
            ret.put("desc", desc);
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT TOP 1 fentryid, fsyncstatus FROM t_msplan_dv_hisentry WHERE fid = ").append(versionId);
            sql.append(" ORDER BY fstartdatetime DESC");
            try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)mmcRoute, (String)sql.toString());){
                if (ds.hasNext()) {
                    sql.setLength(0);
                    Row row = ds.next();
                    Long hisEntryId = row.getLong("fentryid");
                    String syncStatus = row.getString("fsyncstatus");
                    desc.put("status", syncStatus);
                    sql.append("SELECT fdetailid, fhissettings, fhisentity, fhisstatus, fhisstarttime, fhisfinishtime FROM t_msplan_dv_detail WHERE fentryid = ");
                    sql.append(hisEntryId);
                    try (DataSet e_ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)mmcRoute, (String)sql.toString());){
                        int progress;
                        ArrayList entrys = new ArrayList(1);
                        int notFinishCount = 0;
                        while (e_ds.hasNext()) {
                            Timestamp end;
                            Timestamp start;
                            HashMap<String, Object> entry = new HashMap<String, Object>();
                            Row next = e_ds.next();
                            entry.put("detailid", next.getLong("fdetailid"));
                            entry.put("hissettings", next.getLong("fhissettings"));
                            entry.put("hisentity", next.getString("fhisentity"));
                            String status = next.getString("fhisstatus");
                            entry.put("hisstatus", status);
                            if ("A".equals(status)) {
                                ++notFinishCount;
                            }
                            if ((start = next.getTimestamp("fhisstarttime")) != null) {
                                entry.put("hisstarttime", start.getTime());
                            }
                            if ((end = next.getTimestamp("fhisfinishtime")) != null) {
                                entry.put("hisfinishtime", end.getTime());
                            }
                            entrys.add(entry);
                        }
                        int allCount = entrys.size();
                        if (allCount > 0) {
                            int item = 100 / allCount;
                            int start = 100 - item * allCount;
                            progress = start + (allCount - notFinishCount) * item;
                        } else {
                            progress = 0;
                        }
                        desc.put("entrys", entrys);
                        desc.put("progress", progress);
                        desc.put("current", cache.get(MMCDataSyncService.getExecutionLogKey(versionId)));
                        break block31;
                    }
                }
                desc.put("status", "N");
            }
        }
        ret.put("ok", Boolean.TRUE);
        return ret;
    }

    public Map<String, Object> queryLatestSnapTableName(Long versionId, String dbRouteKey, String tableName) {
        return this.callImpl(() -> this.queryLatestSnapTableNameImpl(versionId, dbRouteKey, tableName));
    }

    private Map<String, Object> queryLatestSnapTableNameImpl(Long versionId, String dbRouteKey, String tableName) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("ok", Boolean.TRUE);
        DynamicObject hisEntry = MMCSnapDataVisitor.loadLatestHisEntry(versionId);
        if (hisEntry == null) {
            return ret;
        }
        String key = dbRouteKey + "." + tableName;
        StringBuilder sql = new StringBuilder();
        sql.append("select fsyncentitytag, ftextfield from t_msplan_dv_syncinfo");
        sql.append(" where fentryid = ").append(hisEntry.getLong("id"));
        sql.append(" and fsyncentitytag = '").append(key).append("' ");
        Throwable throwable = null;
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)sql.toString());){
            if (ds.hasNext()) {
                ret.put("tableName", ds.next().getString("ftextfield"));
                HashMap<String, Object> hashMap = ret;
                return hashMap;
            }
            try {
                DynamicObject version = (DynamicObject)hisEntry.getParent();
                String msg = String.format("SYNC_TABLE_NOT_FOUND, ver: %s, oldRoute: %s, oldTable: %s", version.getString("number"), dbRouteKey, tableName);
                throw new KDBizException(msg);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Map<String, Object> clearDatas(Long hisEntryId) {
        return this.callImpl(() -> this.clearDatasImpl(hisEntryId));
    }

    public Map<String, Object> clearDatasImpl(Long hisEntryId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fsyncentitytag, ftextfield from t_msplan_dv_syncinfo");
        sql.append(" where fentryid = ").append(hisEntryId);
        HashSet<String> tables = new HashSet<String>();
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)sql.toString());){
            while (ds.hasNext()) {
                Row row = ds.next();
                String oldTableName = row.getString("fsyncentitytag");
                String tableName = row.getString("ftextfield");
                String dbRouteKey = oldTableName.split("\\.")[0];
                tables.add(dbRouteKey + "." + tableName);
            }
        }
        int count = 0;
        while (!tables.isEmpty() && count != tables.size()) {
            count = tables.size();
            Iterator iter = tables.iterator();
            while (iter.hasNext()) {
                String tableName;
                String next = (String)iter.next();
                String[] splits = next.split("\\.");
                String dbRouteKey = splits[0];
                if (this.dropTable(dbRouteKey, tableName = splits[1])) {
                    iter.remove();
                    continue;
                }
                if (!this.dropTable("scm", tableName)) continue;
                iter.remove();
            }
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("ok", Boolean.TRUE);
        return ret;
    }

    public Map<String, Object> batchClearDatas(Long[] hisEntryIds, Long startTime, Long finishTime) {
        return this.callImpl(() -> this.batchClearDatasImpl(hisEntryIds, startTime, finishTime));
    }

    public Map<String, Object> batchClearDatasImpl(Long[] hisEntryIds, Long startTime, Long finishTime) {
        if (hisEntryIds != null) {
            logger.warn(String.format("mmc-datasync-batch-table-clear, startTime: %s, finishTime: %s", startTime, finishTime));
            for (Long hisEntryId : hisEntryIds) {
                this.clearDatasImpl(hisEntryId);
            }
        } else if (startTime != null && finishTime != null) {
            this.dropTableByTimeSpan(startTime, finishTime);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("ok", Boolean.TRUE);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private void dropTableByTimeSpan(Long startTime, Long finishTime) {
        HashMap dropTables = new HashMap();
        long min = (startTime - TS_20201231) / 1000L;
        long max = (finishTime - TS_20201231) / 1000L;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter startFilter = new QFilter("hisentity.startdatetime", ">=", (Object)new Date(startTime));
        filters.add(startFilter);
        QFilter endFilter = new QFilter("hisentity.startdatetime", "<=", (Object)new Date(finishTime));
        filters.add(endFilter);
        ORM orm = ORM.create();
        HashSet<String> usedDBRouteKeys = new HashSet<String>();
        DataSet ds = orm.queryDataSet(this.getClass().getName(), "msplan_ds_version", "id, hisentity.tblsubentryentity.syncentity", filters.toArray(new QFilter[0]));
        Object object = null;
        try {
            while (ds.hasNext()) {
                String[] parts;
                Row row = ds.next();
                String old = row.getString("hisentity.tblsubentryentity.syncentity");
                if (old == null || (parts = old.split("\\.")).length < 2 || usedDBRouteKeys.contains(parts[0])) continue;
                usedDBRouteKeys.add(parts[0]);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        for (String dbRouteKey : usedDBRouteKeys) {
            Object tableName22;
            Set set = (Set)dropTables.get(dbRouteKey);
            if (set == null) {
                HashSet hashSet = new HashSet();
                dropTables.put(dbRouteKey, hashSet);
            }
            String sql = "SELECT TABLE_NAME FROM KSQL_USERTABLES WHERE TABLE_NAME like 't_mmc_dc_%' or TABLE_NAME LIKE 'T_MMC_DC_%';";
            try {
                DataSet ds2 = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute(dbRouteKey), (String)sql);
                Throwable throwable = null;
                try {
                    while (ds2.hasNext()) {
                        void var15_20;
                        tableName22 = ds2.next().getString(0);
                        if (!this.isNeedDrop((String)tableName22, min, max)) continue;
                        var15_20.add(tableName22);
                    }
                }
                catch (Throwable tableName22) {
                    throwable = tableName22;
                    throw tableName22;
                }
                finally {
                    if (ds2 == null) continue;
                    if (throwable != null) {
                        try {
                            ds2.close();
                        }
                        catch (Throwable tableName22) {
                            throwable.addSuppressed(tableName22);
                        }
                        continue;
                    }
                    ds2.close();
                }
            }
            catch (Throwable e) {
                logger.warn(String.format("mmc-datasync-batch\uff0c failed to load table names from KSQL_USERTABLS, dbRouteKey: %s, ", dbRouteKey));
                sql = "SELECT TABLE_SCHEMA, TABLE_NAME FROM information_schema.tables WHERE TABLE_NAME like 't_mmc_dc_%' or TABLE_NAME LIKE 'T_MMC_DC_%';";
                try {
                    DataSet ds3 = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)sql);
                    tableName22 = null;
                    try {
                        while (ds3.hasNext()) {
                            void var15_24;
                            String tableName3;
                            Row row = ds3.next();
                            dbRouteKey = row.getString("TABLE_SCHEMA");
                            Set set2 = (Set)dropTables.get(dbRouteKey = dbRouteKey.substring(dbRouteKey.lastIndexOf(95)));
                            if (set2 == null) {
                                HashSet hashSet = new HashSet();
                                dropTables.put(dbRouteKey, hashSet);
                            }
                            if (!this.isNeedDrop(tableName3 = ds3.next().getString("TABLE_NAME"), min, max)) continue;
                            var15_24.add(tableName3);
                        }
                    }
                    catch (Throwable throwable) {
                        tableName22 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (ds3 != null) {
                            if (tableName22 != null) {
                                try {
                                    ds3.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)tableName22).addSuppressed(throwable);
                                }
                            } else {
                                ds3.close();
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    logger.warn("mmc-datasync-batch\uff0c failed to load table names from MYSQL sys schema.");
                }
                break;
            }
        }
        String dropSql = "DROP TABLE %s;";
        for (Map.Entry entry : dropTables.entrySet()) {
            DBRoute route = new DBRoute((String)entry.getKey());
            for (String tableName : (Set)entry.getValue()) {
                try {
                    DB.execute((DBRoute)route, (String)String.format(dropSql, tableName));
                }
                catch (Throwable e) {
                    logger.warn(String.format("mmc-datasync-batch, failed to drop table, db: %s, table: %s.", entry.getKey(), tableName), e);
                }
                try {
                    DB.execute((DBRoute)route, (String)String.format(dropSql, tableName + "_l"));
                }
                catch (Throwable e) {
                    logger.warn(String.format("mmc-datasync-batch, failed to drop multilang table, db: %s, table: %s.", entry.getKey(), tableName), e);
                }
            }
        }
    }

    private boolean isNeedDrop(String tableName, long min, long max) {
        if ((tableName = tableName.toLowerCase(Locale.ENGLISH)).startsWith("t_mmc_dc_")) {
            int idx = (tableName = tableName.substring("t_mmc_dc_".length())).indexOf(95);
            if (idx > 0) {
                tableName = tableName.substring(0, idx);
                try {
                    long act = Long.parseLong(tableName);
                    return min <= act && act <= max;
                }
                catch (Throwable e) {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    private boolean dropTable(String dbRouteKey, String tableName) {
        boolean ret = false;
        String dropSql = "DROP TABLE %s;";
        try {
            DB.execute((DBRoute)new DBRoute(dbRouteKey), (String)String.format(dropSql, tableName));
            ret = true;
        }
        catch (Throwable e) {
            logger.warn(String.format("mmc-datasync, failed to drop table, db: %s, table: %s.", dbRouteKey, tableName), e);
        }
        try {
            DB.execute((DBRoute)new DBRoute(dbRouteKey), (String)String.format(dropSql, tableName + "_l"));
        }
        catch (Throwable e) {
            logger.warn(String.format("mmc-datasync, failed to drop multilang table, db: %s, table: %s.", dbRouteKey, tableName), e);
        }
        return ret;
    }

    public static boolean tryLock(Long versionId) {
        boolean ret;
        String lockKey = String.valueOf(versionId) + "_lock";
        boolean bl = ret = cache.get(lockKey) == null;
        if (ret) {
            cache.put(lockKey, (Object)"1");
        }
        return ret;
    }

    public static void regist(Long versionId) {
        cache.put(String.valueOf(versionId), "executor", (Object)"1");
        cache.expireAfter(String.valueOf(versionId), 43200);
    }

    private static String getExecutionLogKey(Long versionId) {
        return versionId + ".execution";
    }

    public static void releasLock(Long versionId) {
        String lockKey = String.valueOf(versionId) + "_lock";
        cache.remove(lockKey);
        cache.remove(String.valueOf(versionId));
        cache.remove(MMCDataSyncService.getExecutionLogKey(versionId));
    }

    public static boolean exist(Long versionId) {
        String val = (String)cache.get(String.valueOf(versionId), "executor");
        return "1".equals(val);
    }

    public static void refreshStepLogString(Long versionId, String text) {
        cache.put(MMCDataSyncService.getExecutionLogKey(versionId), (Object)text);
    }

    public Map<String, Object> stopDataVersion(Long versionId) {
        return this.callImpl(() -> this.stopDataVersionImpl(versionId));
    }

    private Map<String, Object> stopDataVersionImpl(Long versionId) {
        MMCDataSyncService.releasLock(versionId);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT TOP 1 fentryid FROM t_msplan_dv_hisentry where fid = ").append(versionId);
        sql.append(" ORDER BY fstartdatetime DESC");
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)mmcRoute, (String)sql.toString());){
            if (ds.hasNext()) {
                Row row = ds.next();
                Long hisEntryId = row.getLong("fentryid");
                sql.setLength(0);
                sql.append("update t_msplan_dv_hisentry set fsyncstatus = 'C' where fsyncstatus = 'A' and fentryid = ").append(hisEntryId);
                DB.execute((DBRoute)mmcRoute, (String)sql.toString());
                sql.setLength(0);
                sql.append("update t_msplan_dv_detail set fhisstatus = 'C' where fhisstatus = 'A' and fentryid = ").append(hisEntryId);
                DB.execute((DBRoute)mmcRoute, (String)sql.toString());
            }
        }
        BaseDataServiceHelper.clearCache((DynamicObject)BusinessDataServiceHelper.loadSingle((Object)versionId, (String)"msplan_ds_version"));
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("ok", Boolean.TRUE);
        return ret;
    }

    @FunctionalInterface
    private static interface FuncImpl {
        public Map<String, Object> apply();
    }
}

