/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datasync;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.SqlRequest;
import kd.bos.orm.query.SqlTreeNode;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.util.StringUtils;
import kd.bos.util.ThreadLocals;
import kd.mpscmm.msplan.mservice.service.datasync.DataVersionSyncHisEntrySorter;
import kd.mpscmm.msplan.mservice.service.datasync.delegate.DataSyncORMImpl;
import kd.mpscmm.msplan.mservice.service.datasync.delegate.MsPlanEntityTypeCacheMap;

public class MMCSnapDataVisitor {
    private static final Log logger = LogFactory.getLog(MMCSnapDataVisitor.class);
    private static final ThreadLocal<Map<String, IDataEntityType>> tlEntityTypeCache = ThreadLocals.create(() -> new HashMap(20));

    public DataSet localFastDataVisit(Long versionId, Long hisEntryId, String metaKey, String selectFields, QFilter[] filters, String orderBys) {
        DynamicObject hisEntry = hisEntryId == null || hisEntryId == 0L ? MMCSnapDataVisitor.loadLatestHisEntry(versionId) : this.loadSpecifiedHisEntry(versionId, hisEntryId);
        if (hisEntry == null) {
            return null;
        }
        return this.doDataVisit(hisEntry, metaKey, selectFields, filters, orderBys);
    }

    public static DynamicObject loadLatestHisEntry(Long versionId) {
        if (versionId == null) {
            return null;
        }
        String fields = "id, datasyncselector.fbasedataid, hisentity.syncstatus, hisentity.startdatetime, hisentity.activestatus";
        DynamicObject dataVer = BusinessDataServiceHelper.loadSingleFromCache((Object)versionId, (String)"msplan_ds_version", (String)(fields = fields + ", subentryentity.hismainentity, subentryentity.hisfilter_tag, subentryentity.hisstatus, billstatusfield, billstatus"));
        if (dataVer == null) {
            return null;
        }
        String status = dataVer.getString("billstatus");
        int useStatus = dataVer.getInt("billstatusfield");
        if (!"C".equals(status) || useStatus != 1) {
            return null;
        }
        DynamicObjectCollection hisEntrys = dataVer.getDynamicObjectCollection("hisentity");
        hisEntrys.sort((Comparator)new DataVersionSyncHisEntrySorter());
        for (DynamicObject e : hisEntrys) {
            if (!"A".equals(e.getString("activestatus"))) continue;
            return e;
        }
        return null;
    }

    private DynamicObject loadSpecifiedHisEntry(Long versionId, Long hisEntryId) {
        QFilter[] filters;
        String fields = "id, datasyncselector.fbasedataid, hisentity.syncstatus, hisentity.startdatetime, hisentity.activestatus";
        DynamicObject dataVer = BusinessDataServiceHelper.loadSingleFromCache((String)"msplan_ds_version", (String)(fields = fields + ", subentryentity.hismainentity, subentryentity.hisfilter_tag, subentryentity.hisstatus, billstatusfield, billstatus"), (QFilter[])(filters = new QFilter[]{new QFilter("id", "=", (Object)versionId), new QFilter("hisentity.id", "=", (Object)hisEntryId)}));
        if (dataVer == null) {
            return null;
        }
        DynamicObjectCollection entrys = dataVer.getDynamicObjectCollection("hisentity");
        if (entrys == null || entrys.isEmpty()) {
            return null;
        }
        return (DynamicObject)entrys.get(0);
    }

    private DataSet doDataVisit(DynamicObject hisEntry, String metaKey, String selectFields, QFilter[] customFilters, String orderBys) {
        Object entityType;
        DynamicObjectCollection hisSettings = hisEntry.getDynamicObjectCollection("subentryentity");
        QFilter defaultFilter = null;
        for (DynamicObject hisSettingsEntry : hisSettings) {
            String filterVal;
            String status;
            entityType = hisSettingsEntry.getDynamicObject("hismainentity");
            if (!metaKey.equals(entityType.getString("number")) || !"S".equals(status = hisSettingsEntry.getString("hisstatus")) || StringUtils.isEmpty((String)(filterVal = hisSettingsEntry.getString("hisfilter_tag")))) continue;
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterVal, FilterCondition.class);
            FilterBuilder fb = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)metaKey), filterCondition);
            TimeService timeService = new TimeService();
            fb.setTimeService((ITimeService)timeService);
            UserService userService = new UserService();
            fb.setUserService((IUserService)userService);
            fb.buildFilter(false);
            if (defaultFilter == null) {
                defaultFilter = fb.getQFilter();
                continue;
            }
            defaultFilter = defaultFilter.or(fb.getQFilter());
        }
        HashMap<String, String> tables = new HashMap<String, String>();
        DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)("select fsyncentitytag, ftextfield from t_msplan_dv_syncinfo where fentryid = " + hisEntry.getLong("id")));
        entityType = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                String tag = row.getString("fsyncentitytag");
                String tableName = row.getString("ftextfield");
                tables.put(tag.toLowerCase(), tableName);
            }
        }
        catch (Throwable row) {
            entityType = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (entityType != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)entityType).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        MsPlanEntityTypeCacheMap entityTypeCache = new MsPlanEntityTypeCacheMap(tlEntityTypeCache.get(), tables);
        DataSyncORMImpl impl = new DataSyncORMImpl(entityTypeCache);
        QFilter[] actFilters = customFilters;
        try {
            SqlTreeNode root = impl.getQuerySql(metaKey, selectFields, actFilters, null, 0, -1);
            MMCSnapDataVisitor.logSql(root, metaKey);
        }
        catch (Throwable e) {
            logger.error(String.format("mmc-datasync-fetch-datas-parseSQLFailed-%s", e.getMessage()), e);
        }
        String id = UUID.randomUUID().toString();
        logger.warn(String.format("mmc-datasync-fetch-datas-by-delegate, id: %s, meta: %s, fields: %s, orderBys: %s", id, metaKey, selectFields, orderBys));
        DataSet ds2 = impl.queryDataSet(this.getClass().getName(), metaKey, selectFields, false, actFilters, orderBys);
        logger.warn(String.format("mmc-datasync-fetch-datas-by-delegate, id: %s, ret-is-empty: %s", id, ds2.isEmpty()));
        if (ds2.isEmpty()) {
            Algo algo = Algo.create((String)this.getClass().getName());
            DataSetBuilder builder = algo.createDataSetBuilder(ds2.getRowMeta());
            ds2.close();
            ds2 = builder.build();
        }
        return ds2;
    }

    public static void logSql(SqlTreeNode node, String mt) {
        List children;
        SqlRequest req = node.getValue();
        if (req != null) {
            String msg = String.format("mmc-datasync-fetch-sql-origin, mt: %s, route: %s, sql: %s, ppk: %s", mt, req.getDbRoute(), req.getSql(), req.getParentFK());
            logger.warn(msg);
            System.out.println(msg);
        }
        if ((children = node.getChildren()) == null) {
            return;
        }
        for (SqlTreeNode c : children) {
            MMCSnapDataVisitor.logSql(c, mt);
        }
    }
}

