/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datasync.delegate;

import java.lang.reflect.Method;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.impl.ORMImplSnapshot;
import kd.bos.orm.impl.ORMOptimization;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.SqlTreeNode;
import kd.bos.orm.query.multi.MultiQuery;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msplan.mservice.service.datasync.delegate.MsPlanEntityTypeCacheMap;

public class DataSyncORMImpl
extends ORMImplSnapshot {
    private static Log logger = LogFactory.getLog(DataSyncORMImpl.class);
    private MsPlanEntityTypeCacheMap entityTypeCache;
    private static Method M_isQuerySingleDB;

    public DataSyncORMImpl(MsPlanEntityTypeCacheMap entityTypeCache) {
        super((Map)entityTypeCache, new ORMHint(), new ORMOptimization());
        this.entityTypeCache = entityTypeCache;
    }

    protected DataSet queryDataSet(String algoKey, String entityName, String selectFields, boolean shouldSelectPK, QFilter[] filters, String groupBys, QFilter[] havings, String orderBys, int from, int length, Distinctable distinctable) {
        int top;
        if (from < 0) {
            from = 0;
        }
        if (length < 0) {
            top = -1;
            length = Integer.MAX_VALUE;
        } else {
            top = from + length;
        }
        MultiQuery mq = this.doCreateMultiQuery(entityName, selectFields, shouldSelectPK, filters, groupBys, havings, orderBys, top, from, length, distinctable);
        try {
            SingleQuery[] queries = mq.getQueries();
            for (int i = 0; i < queries.length; ++i) {
            }
        }
        catch (Throwable e) {
            throw new KDBizException(e, new ErrorCode("FAILED_TO_PROXY_QUERY", "FAILED_TO_PROXY_QUERY"), new Object[0]);
        }
        DataSet ds = mq.query(algoKey);
        if (!(this.isQuerySingleDB(mq) || from <= 0 && top == -1)) {
            ds = ds.range(from, length);
        }
        return ds;
    }

    private boolean isQuerySingleDB(MultiQuery mq) {
        return mq.isQueryWithTop();
    }

    public SqlTreeNode getQuerySql(String entityName, String selectFields, QFilter[] filters, String orderBys, int from, int length) {
        return this.getQuerySql(entityName, selectFields, false, filters, null, null, orderBys, from, length, null);
    }

    protected SqlTreeNode getQuerySql(String entityName, String selectFields, boolean shouldSelectPK, QFilter[] filters, String groupBys, QFilter[] havings, String orderBys, int from, int length, Distinctable distinctable) {
        int top;
        if (from < 0) {
            from = 0;
        }
        if (length < 0) {
            top = -1;
            length = Integer.MAX_VALUE;
        } else {
            top = from + length;
        }
        MultiQuery mq = this.createMultiQuery(entityName, selectFields, shouldSelectPK, filters, groupBys, havings, orderBys, top, distinctable);
        return mq.getQuerySql();
    }

    private MultiQuery createMultiQuery(String entityName, String selectFields, boolean shouldSelectPK, QFilter[] filters, String groupBys, QFilter[] havings, String orderBys, int top, Distinctable distinctable) {
        return this.doCreateMultiQuery(entityName, selectFields, shouldSelectPK, filters, groupBys, havings, orderBys, top, 0, 0, distinctable);
    }

    private MultiQuery doCreateMultiQuery(String entityName, String selectFields, boolean shouldSelectPK, QFilter[] filters, String groupBys, QFilter[] havings, String orderBys, int top, int start, int length, Distinctable distinctable) {
        IDataEntityType value = this.entityTypeCache.get(entityName);
        if (value == null) {
            try {
                value = (IDataEntityType)MetadataServiceHelper.getDataEntityType((String)entityName).clone();
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("CLONE_FAILED_ON_DATAENTITY", entityName), new Object[0]);
            }
            this.entityTypeCache.put(entityName, value);
            value = this.entityTypeCache.get(entityName);
        }
        DBRoute dbRoute = new DBRoute(value.getDBRouteKey());
        MultiQuery mq = MultiQuery.create((DBRoute)dbRoute, (IDataEntityType)value, (String)selectFields, (boolean)shouldSelectPK, (QFilter[])filters, (String)groupBys, (QFilter[])havings, (String)orderBys, (int)top, (int)start, (int)length, (Map)this.entityTypeCache, (ORMHint)this.ormHint, (ORMOptimization)this.optimization, (Distinctable)distinctable);
        return mq;
    }
}

