/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datasync.delegate;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;

public class MsPlanEntityTypeCacheMap
implements Map<String, IDataEntityType> {
    private Map<String, IDataEntityType> globalCache;
    private Map<String, IDataEntityType> instanceCache = new HashMap<String, IDataEntityType>();
    private Map<String, String> tables;

    public MsPlanEntityTypeCacheMap(Map<String, IDataEntityType> globalCache, Map<String, String> tables) {
        this.globalCache = globalCache;
        this.tables = tables;
    }

    public IDataEntityType putInstanceCache(String key, IDataEntityType value) {
        return this.instanceCache.put(key.toLowerCase(), value);
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.globalCache.isEmpty() && this.instanceCache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        String lk = ((String)key).toLowerCase();
        return this.globalCache.containsKey(lk) || this.instanceCache.containsKey(lk);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.globalCache.containsValue(value) || this.instanceCache.containsValue(value);
    }

    @Override
    public IDataEntityType get(Object key) {
        if (key == null) {
            return null;
        }
        String lk = ((String)key).toLowerCase();
        IDataEntityType dt = this.instanceCache.get(lk);
        if (dt != null) {
            return dt;
        }
        return this.globalCache.get(lk);
    }

    @Override
    public IDataEntityType put(String key, IDataEntityType value) {
        value = this.cloneDT(value);
        IDataEntityType dt = this.get(key = key.toLowerCase());
        if (dt != null) {
            return dt;
        }
        IDataEntityType dt2 = this.instanceCache.remove(key);
        IDataEntityType dt1 = this.globalCache.put(key, value);
        return dt2 == null ? dt1 : dt2;
    }

    private IDataEntityType cloneDT(IDataEntityType value) {
        try {
            value = (IDataEntityType)value.clone();
            this.updateTableName(value);
            return value;
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException("FAILED TO DELEGATE DataEntityType, " + value.getName());
        }
    }

    private void updateTableName(IDataEntityType value) {
        if (value instanceof DynamicObjectType) {
            IDataEntityType p;
            DynamicObjectType dt = (DynamicObjectType)value;
            String dbRouteKey = dt.getDBRouteKey();
            String tableName = value.getAlias();
            if (StringUtils.isEmpty((String)tableName)) {
                return;
            }
            if (StringUtils.isEmpty((String)dbRouteKey) && StringUtils.isEmpty((String)(dbRouteKey = (p = dt.getParent()).getDBRouteKey()))) {
                return;
            }
            String newTableName = this.tables.get(dbRouteKey.toLowerCase() + "." + tableName.toLowerCase());
            if (StringUtils.isEmpty((String)newTableName)) {
                return;
            }
            dt.setAlias(newTableName);
            DataEntityPropertyCollection c = dt.getProperties();
            int len = c.size();
            for (int i = 0; i < len; ++i) {
                DynamicComplexProperty dcp;
                IDataEntityProperty p2 = (IDataEntityProperty)c.get(i);
                if (p2 instanceof DynamicComplexProperty) {
                    dcp = (DynamicComplexProperty)p2;
                    dt = (DynamicObjectType)this.cloneDT(dcp.getComplexType());
                    dcp.setComplexType((IDataEntityType)dt);
                    this.updateTableName((IDataEntityType)dt);
                    continue;
                }
                if (!(p2 instanceof DynamicCollectionProperty)) continue;
                dcp = (DynamicCollectionProperty)p2;
                dt = (DynamicObjectType)this.cloneDT(dcp.getItemType());
                dcp.setItemType((IDataEntityType)dt);
                this.updateTableName((IDataEntityType)dt);
            }
        }
    }

    @Override
    public IDataEntityType remove(Object key) {
        if (key == null) {
            return null;
        }
        String lk = ((String)key).toLowerCase();
        IDataEntityType dt1 = this.globalCache.remove(lk);
        IDataEntityType dt2 = this.instanceCache.remove(lk);
        return dt2 == null ? dt1 : dt2;
    }

    @Override
    public void putAll(Map<? extends String, ? extends IDataEntityType> m) {
        this.instanceCache.clear();
        for (Map.Entry<? extends String, ? extends IDataEntityType> entry : m.entrySet()) {
            this.globalCache.put(entry.getKey().toLowerCase(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.globalCache.clear();
        this.instanceCache.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>(this.globalCache.size() + this.instanceCache.size());
        set.addAll(this.globalCache.keySet());
        set.addAll(this.instanceCache.keySet());
        return set;
    }

    @Override
    public Collection<IDataEntityType> values() {
        HashSet<IDataEntityType> set = new HashSet<IDataEntityType>(this.globalCache.size() + this.instanceCache.size());
        set.addAll(this.globalCache.values());
        set.addAll(this.instanceCache.values());
        return set;
    }

    @Override
    public Set<Map.Entry<String, IDataEntityType>> entrySet() {
        HashSet<Map.Entry<String, IDataEntityType>> set = new HashSet<Map.Entry<String, IDataEntityType>>(this.globalCache.size() + this.instanceCache.size());
        set.addAll(this.globalCache.entrySet());
        set.addAll(this.instanceCache.entrySet());
        return set;
    }
}

