/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datasync.func;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.database.DataEntityTypeMap;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.database.DbMetadataDatabase;
import kd.bos.dataentity.metadata.database.DbMetadataRelation;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.database.DbMetadataTableCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.SplitTable;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msplan.mservice.service.datasync.MMCDataSyncService;
import kd.mpscmm.msplan.mservice.service.datasync.func.ColumnDesc;
import kd.mpscmm.msplan.mservice.service.datasync.func.DataSyncRunnable;
import kd.mpscmm.msplan.mservice.service.datasync.model.ICallableResult;
import kd.mpscmm.msplan.mservice.service.datasync.utils.MMFilterUtil;
import kd.mpscmm.msplan.mservice.service.datasync.utils.MetaTableUtil;

public abstract class AbstractEntitySyncCallable<P extends MainEntityType, V extends ICallableResult>
implements Callable<V> {
    private static Log logger = LogFactory.getLog(AbstractEntitySyncCallable.class);
    private static long TS_20201231 = 1612022400000L;
    private static final int DEFAULT_BATCH = 5000;
    protected RequestContext rc = RequestContext.get();
    protected ORM orm = ORM.create();
    protected P bt;
    protected DynamicObject newHisEntry;
    protected FilterCondition[] filters;
    protected AtomicInteger offset;
    protected long ts;
    protected Throwable error;
    protected Map<String, String> tableNames;
    protected Map<String, Set<Object>> parentIds = new HashMap<String, Set<Object>>();
    protected EntityMetadata entityMetadata;
    protected Map<String, Integer> rowCounts = new HashMap<String, Integer>();

    protected AbstractEntitySyncCallable(P bt, DynamicObject newHisEntry, FilterCondition[] filters, AtomicInteger offset) {
        this.bt = bt;
        this.newHisEntry = newHisEntry;
        this.filters = filters;
        this.offset = offset;
        this.tableNames = new HashMap<String, String>();
        this.ts = newHisEntry.getDate("startdatetime").getTime() - TS_20201231;
        this.ts /= 1000L;
    }

    protected DynamicObject createSubEntry() {
        DynamicObject subEntry = this.newHisEntry.getDynamicObjectCollection("subentryentity").addNew();
        return subEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> createTmpTables() {
        HashMap<String, String> currentTableNames = new HashMap<String, String>();
        try {
            AtomicInteger atomicInteger = this.offset;
            synchronized (atomicInteger) {
                String id = MetadataDao.getIdByNumber((String)this.bt.getName(), (MetaCategory)MetaCategory.Entity);
                this.entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
                String dbKey = this.entityMetadata.getDBRouteKey();
                DBConfig dbCfg = DataSourceFactory.getDBConfig((String)this.rc.getTenantId(), (String)dbKey, (String)this.rc.getAccountId());
                List entityList = this.entityMetadata.getEntitys();
                block7: for (Entity entity : entityList) {
                    String old = entity.getTableName();
                    String key = dbKey + "." + old;
                    if (kd.bos.util.StringUtils.isEmpty((String)old)) continue;
                    String tblName = this.tableNames.get(key) != null ? this.tableNames.get(key) : this.genTableName(dbKey);
                    entity.setTableName(tblName);
                    currentTableNames.put(key, tblName);
                    List splits = entity.getSplitTables();
                    for (SplitTable splitTable : splits) {
                        currentTableNames.put(dbKey + "." + old + "_" + splitTable.getSuffix(), tblName + "_" + splitTable.getSuffix());
                    }
                    List entityItem = entity.getItems();
                    for (EntityItem item : entityItem) {
                        if (!(item instanceof MuliLangTextField)) continue;
                        currentTableNames.put(dbKey + "." + old + "_l", tblName + "_l");
                        continue block7;
                    }
                }
                block10: for (Entity entity : entityList) {
                    String pkFieldName;
                    String tableName = entity.getTableName();
                    if (kd.bos.util.StringUtils.isEmpty((String)tableName) || !(entity instanceof BillEntity) || kd.bos.util.StringUtils.isEmpty((String)(pkFieldName = ((BillEntity)entity).getPkFieldName()))) continue;
                    List items = entity.getItems();
                    Iterator iter = items.iterator();
                    while (iter.hasNext()) {
                        String string;
                        EntityItem next = (EntityItem)iter.next();
                        if (!(next instanceof Field) || !pkFieldName.equalsIgnoreCase(string = ((Field)next).getFieldName())) continue;
                        iter.remove();
                        continue block10;
                    }
                }
                for (Entity entity : entityList) {
                    try {
                        new MetaTableUtil().createTable(this.entityMetadata, entity, Boolean.FALSE);
                    }
                    catch (Exception e) {
                        new MetaTableUtil().createTable(this.entityMetadata, entity, Boolean.FALSE);
                    }
                }
                String alterSql = "EXEC p_AlterColumn '%s', '%s', '%s%s', '', %s, %s;";
                for (Map.Entry entry : currentTableNames.entrySet()) {
                    logger.warn(String.format("mmc-datasync-table-mapping, %s, %s", entry.getKey(), entry.getValue()));
                    String oldTableName = ((String)entry.getKey()).split("\\.")[1];
                    Map<String, ColumnDesc> srcDefines = this.getColLengthByTable(dbKey, oldTableName, (String)entry.getValue(), dbCfg);
                    Map<String, ColumnDesc> currentDefines = this.getColLengthByTable(dbKey, (String)entry.getValue(), (String)entry.getValue(), dbCfg);
                    for (Map.Entry entry2 : currentDefines.entrySet()) {
                        ColumnDesc vals = (ColumnDesc)entry2.getValue();
                        ColumnDesc oldCol = srcDefines.get(entry2.getKey());
                        if (oldCol == null) continue;
                        Integer srcLen = oldCol.getDataLen();
                        Integer newLen = vals.getDataLen();
                        if (srcLen == null || newLen == null || srcLen < newLen || srcLen < 0 || newLen < 0) continue;
                        String dataLen = null;
                        String type = "'0100'";
                        String defaultVal = "''' '''";
                        if ("NVARCHAR2".equalsIgnoreCase(vals.getDataType())) {
                            vals.setDataType("NVARCHAR");
                        } else if ("VARCHAR".equals(vals.getDataType())) {
                            vals.setDataType("NVARCHAR");
                        } else if ("VARCHAR2".equalsIgnoreCase(vals.getDataType())) {
                            vals.setDataType("NVARCHAR");
                        } else if ("DECIMAL".equalsIgnoreCase(vals.getDataType()) || "NUMERIC".equalsIgnoreCase(vals.getDataType())) {
                            if (vals.getPrecision() == null || vals.getScale() == null || oldCol.getPrecision() == null || oldCol.getScale() == null || vals.getPrecision() >= oldCol.getPrecision() && vals.getScale() >= oldCol.getScale()) continue;
                            type = "'1111'";
                            defaultVal = "'0'";
                            dataLen = "(" + oldCol.getPrecision() + ", " + oldCol.getScale() + ")";
                        } else {
                            if (!StringUtils.containsIgnoreCase((CharSequence)vals.getDataType(), (CharSequence)"CHARACTER") || newLen >= srcLen) continue;
                            vals.setDataType("NVARCHAR");
                        }
                        String tblName = vals.getNewTableName();
                        String colName = vals.getColName();
                        String dataType = vals.getDataType();
                        if (dataLen == null) {
                            dataLen = "(" + String.valueOf(srcLen) + ")";
                        }
                        DB.execute((DBRoute)new DBRoute(dbKey), (String)String.format(alterSql, tblName, colName, dataType, dataLen, type, defaultVal));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("mmc-datasync, failed to copy table.", (Throwable)e);
            this.error = e;
        }
        return currentTableNames;
    }

    private String genTableName(String dbKey) {
        String tblName = "t_mmc_dc_" + this.ts + "_" + this.offset.incrementAndGet();
        String sql = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s'";
        DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute(dbKey), (String)String.format(sql, tblName));
        while (ds.hasNext()) {
            ds.close();
            tblName = "t_mmc_dc_" + this.ts + "_" + this.offset.incrementAndGet();
            ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute(dbKey), (String)String.format(sql, tblName));
        }
        ds.close();
        return tblName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ColumnDesc> getColLengthByTable(String dbRouteKey, String tblName, String newTblName, DBConfig dbCfg) {
        DataSet ds;
        String sql;
        HashMap<String, ColumnDesc> ret = new HashMap<String, ColumnDesc>();
        if (DBType.MySQL.equals((Object)dbCfg.getDBType())) {
            sql = "SELECT COLUMN_NAME, ISNULL(CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION) AS 'DATA_LENGTH', DATA_TYPE";
            sql = sql + ", NUMERIC_PRECISION as 'DATA_PRECISION', NUMERIC_SCALE as 'DATA_SCALE' FROM information_schema.columns WHERE";
            sql = sql + " TABLE_SCHEMA='%s' AND (TABLE_NAME = '%s' OR TABLE_NAME = '%s')";
            ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute(dbRouteKey), (String)String.format(sql, dbCfg.getSchema(), tblName.toUpperCase(), tblName.toLowerCase()));
        } else if (DBType.PostgreSQL.equals((Object)dbCfg.getDBType())) {
            sql = "SELECT COLUMN_NAME, DATA_TYPE,CHARACTER_MAXIMUM_LENGTH AS DATA_LENGTH ,NUMERIC_PRECISION AS DATA_PRECISION,";
            sql = sql + "NUMERIC_SCALE AS DATA_SCALE FROM KSQL_USERCOLUMNS WHERE TABLE_NAME = '%s' OR TABLE_NAME = '%s'";
            ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute(dbRouteKey), (String)String.format(sql, tblName.toUpperCase(), tblName.toLowerCase()));
        } else {
            sql = "SELECT COLUMN_NAME, DATA_LENGTH, DATA_TYPE, DATA_PRECISION, DATA_SCALE FROM KSQL_USERCOLUMNS WHERE TABLE_NAME = '%s' OR TABLE_NAME = '%s'";
            ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute(dbRouteKey), (String)String.format(sql, tblName.toUpperCase(), tblName.toLowerCase()));
        }
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                ColumnDesc col = new ColumnDesc();
                col.setNewTableName(newTblName);
                col.setColName(row.getString("COLUMN_NAME").toUpperCase());
                col.setDataType(row.getString("DATA_TYPE").toUpperCase());
                col.setDataLen(row.getInteger("DATA_LENGTH"));
                col.setPrecision(row.getInteger("DATA_PRECISION"));
                col.setScale(row.getInteger("DATA_SCALE"));
                String name = row.getString("COLUMN_NAME").toUpperCase();
                ColumnDesc old = (ColumnDesc)ret.get(name);
                if (old == null) {
                    ret.put(name, col);
                    continue;
                }
                if (old.getDataLen() == null || col.getDataLen() == null || old.getDataLen() >= col.getDataLen()) continue;
                ret.put(name, col);
            }
        }
        finally {
            ds.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDataSync() {
        Object subCols;
        DbMetadataColumnCollection cols;
        StringBuilder insertSql;
        FilterCondition[] querySql;
        String tableName;
        String oldTableName;
        if (this.error != null) {
            return;
        }
        String dbRouteKey = this.bt.getDBRouteKey();
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        RefObject ref = new RefObject(null);
        DataEntityTypeMap.Build(this.bt, (RefObject)ref);
        DbMetadataDatabase db = (DbMetadataDatabase)ref.argvalue;
        DbMetadataTableCollection oldTables = db.getTables();
        MainEntityType bt2 = (MainEntityType)((Entity)this.entityMetadata.getEntitys().get(0)).buildDataEntityType();
        ref = new RefObject(null);
        DataEntityTypeMap.Build((IDataEntityType)bt2, (RefObject)ref);
        db = (DbMetadataDatabase)ref.argvalue;
        DbMetadataTableCollection tables = db.getTables();
        ArrayList<Object[]> sqls = new ArrayList<Object[]>();
        ArrayList<Object[]> subEntitySqls = new ArrayList<Object[]>();
        HashMap<String, DbMetadataTable> extendTables = new HashMap<String, DbMetadataTable>();
        for (int i = 0; i < oldTables.size(); ++i) {
            DbMetadataTable table = (DbMetadataTable)tables.get(i);
            DbMetadataTable oldTable = (DbMetadataTable)oldTables.get(i);
            oldTableName = oldTable.getName();
            if (oldTableName.equals(tableName = table.getName()) || !DB.exitsTable((DBRoute)dbRoute, (String)tableName)) continue;
            querySql = new StringBuilder();
            insertSql = new StringBuilder();
            cols = oldTable.getColumns();
            HashSet<String> colFilter = new HashSet<String>();
            for (int j = 0; j < cols.size(); ++j) {
                DbMetadataColumn col = (DbMetadataColumn)cols.get(j);
                String colName = col.getName();
                String group = col.getTableGroup();
                if (colFilter.contains(colName)) continue;
                colFilter.add(colName);
                if (!kd.bos.util.StringUtils.isEmpty((String)group)) {
                    String tableName2 = tableName + "_" + group;
                    String oldTableName2 = oldTableName + "_" + group;
                    DbMetadataTable extendTable = (DbMetadataTable)extendTables.get(tableName2);
                    if (extendTable == null) {
                        extendTable = new DbMetadataTable();
                        extendTables.put(tableName2, extendTable);
                        extendTable.setParentRelation(oldTable.getParentRelation());
                        extendTable.setDataEntityTypeMap(col.getTable().getDataEntityTypeMap());
                        extendTable.setName(oldTableName2);
                        subCols = new DbMetadataColumnCollection(extendTable);
                        extendTable.setColumns((DbMetadataColumnCollection)subCols);
                        DbMetadataColumn pk = oldTable.getPrimaryKey();
                        DbMetadataColumn clonePk = pk.clone(pk.getName(), pk.getEnableNull());
                        extendTable.setPrimaryKey(clonePk);
                        subCols.add(clonePk);
                        DbMetadataRelation relation = oldTable.getParentRelation();
                        if (relation != null) {
                            DbMetadataColumn fk = relation.getChildColumn();
                            subCols.add(fk.clone(fk.getName(), fk.getEnableNull()));
                        }
                    }
                    extendTable.getColumns().add(col.clone(col.getName(), col.getEnableNull()));
                    continue;
                }
                if (col.getClrType() == ILocaleString.class) continue;
                if (querySql.length() == 0) {
                    querySql.append("select ");
                } else {
                    querySql.append(',');
                }
                querySql.append(colName);
                if (insertSql.length() == 0) {
                    insertSql.append("insert into ");
                    insertSql.append(tableName).append('(');
                } else {
                    insertSql.append(',');
                }
                insertSql.append(colName);
            }
            querySql.append(" from ").append(oldTableName);
            insertSql.append(") (%s)");
            if (oldTable.isSubEntry()) {
                subEntitySqls.add(new Object[]{querySql.toString(), insertSql.toString(), oldTable, tableName, Boolean.FALSE});
                continue;
            }
            sqls.add(new Object[]{querySql.toString(), insertSql.toString(), table.getName(), oldTable, Boolean.FALSE});
        }
        for (Map.Entry entry : extendTables.entrySet()) {
            DbMetadataTable table = (DbMetadataTable)entry.getValue();
            oldTableName = table.getName();
            tableName = (String)entry.getKey();
            querySql = new StringBuilder();
            insertSql = new StringBuilder();
            cols = table.getColumns();
            for (int j = 0; j < cols.size(); ++j) {
                DbMetadataColumn col = (DbMetadataColumn)cols.get(j);
                String colName = col.getName();
                if (querySql.length() == 0) {
                    querySql.append("select ");
                } else {
                    querySql.append(',');
                }
                querySql.append(colName);
                if (insertSql.length() == 0) {
                    insertSql.append("insert into ");
                    insertSql.append(tableName).append('(');
                } else {
                    insertSql.append(',');
                }
                insertSql.append(colName);
            }
            querySql.append(" from ").append(oldTableName);
            insertSql.append(") (%s)");
            if (table.isSubEntry()) {
                subEntitySqls.add(new Object[]{querySql.toString(), insertSql.toString(), table, tableName, Boolean.TRUE});
                continue;
            }
            sqls.add(new Object[]{querySql.toString(), insertSql.toString(), tableName, table, Boolean.TRUE});
        }
        int batch = 5000;
        StringBuilder placeHolder = new StringBuilder(" where %s in (?");
        for (int i = 1; i < batch; ++i) {
            placeHolder.append(",?");
        }
        placeHolder.append(')');
        logger.warn(String.format("mmc-datasync, resolve-bt: %s, sqls.size: %s, extendTables.size: %s", this.bt.getName(), sqls.size(), extendTables.size()));
        StringBuilder fields = new StringBuilder("id");
        HashSet<String> fieldsFilter = new HashSet<String>();
        StringBuilder filterStr = new StringBuilder();
        if (this.filters != null) {
            for (FilterCondition f : this.filters) {
                if (f == null) {
                    filterStr.setLength(0);
                    break;
                }
                QFilter parsed = DataSyncRunnable.parse2QFilter(this.bt, f);
                if (parsed == null) continue;
                this.appendColsByFilter(parsed, fields, fieldsFilter);
                if (filterStr.length() > 0) {
                    filterStr.append(" or ");
                }
                filterStr.append('(');
                MMFilterUtil.qfilter2String(filterStr, parsed);
                filterStr.append(')');
            }
        }
        try (DataSet main = this.orm.queryDataSet(this.getClass().getName(), this.bt.getName(), fields.toString(), new QFilter[0]);
             DataSet rs = main;){
            if (filterStr.length() > 0) {
                rs = rs.filter(filterStr.toString());
            }
            HashSet<Object> ids = new HashSet<Object>(batch);
            while (rs.hasNext()) {
                Object id = rs.next().get("id");
                ids.add(id);
                if (ids.size() != batch) continue;
                this.copyDatas(ids, sqls, dbRoute, placeHolder.toString());
            }
            if (!ids.isEmpty()) {
                batch = ids.size();
                placeHolder = new StringBuilder(" where %s in (?");
                for (int i = 1; i < batch; ++i) {
                    placeHolder.append(",?");
                }
                placeHolder.append(')');
                this.copyDatas(ids, sqls, dbRoute, placeHolder.toString());
            }
        }
        logger.warn(String.format("mmc-datasync-execute-main-%s, finished", this.bt.getName()));
        batch = 5000;
        for (Object[] pair : subEntitySqls) {
            String querySql2 = (String)pair[0];
            String insertSql2 = (String)pair[1];
            DbMetadataTable table = (DbMetadataTable)pair[2];
            String tableName2 = (String)pair[3];
            DbMetadataRelation relation = table.getParentRelation();
            DbMetadataTable parent = relation.getParentTable();
            DbMetadataColumn fk = relation.getChildColumn();
            StringBuilder rcQuery = new StringBuilder();
            rcQuery.append("select count(1) from ").append(table.getName());
            rcQuery.append(" where ");
            rcQuery.append(table.getPrimaryKey().getName());
            rcQuery.append(" in (select ");
            rcQuery.append(fk.getName());
            rcQuery.append(" from ");
            rcQuery.append(parent.getName());
            rcQuery.append(") and ");
            rcQuery.append(table.getPrimaryKey().getName());
            rcQuery.append(" not in (");
            rcQuery.append("select ").append(table.getPrimaryKey().getName()).append(" from ").append(tableName2).append(")");
            DataSet rcDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)rcQuery.toString());
            subCols = null;
            try {
                if (rcDs.hasNext()) {
                    Integer rc = rcDs.next().getInteger(0);
                    Integer old = this.rowCounts.get(tableName2);
                    if (old == null) {
                        old = 0;
                    }
                    this.rowCounts.put(tableName2, rc + old);
                }
            }
            catch (Throwable throwable) {
                subCols = throwable;
                throw throwable;
            }
            finally {
                if (rcDs != null) {
                    if (subCols != null) {
                        try {
                            rcDs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)subCols).addSuppressed(throwable);
                        }
                    } else {
                        rcDs.close();
                    }
                }
            }
            StringBuilder selection = new StringBuilder();
            selection.append(querySql2);
            selection.append(" where ");
            selection.append(table.getPrimaryKey().getName());
            selection.append(" in (select ");
            selection.append(fk.getName());
            selection.append(" from ");
            selection.append(parent.getName());
            selection.append(") and ");
            selection.append(table.getPrimaryKey().getName());
            selection.append(" not in (");
            selection.append("select ").append(table.getPrimaryKey().getName()).append(" from ").append(tableName2).append(')');
            insertSql2 = String.format(insertSql2, selection.toString());
            DB.execute((DBRoute)dbRoute, (String)insertSql2);
            Long versionId = ((DynamicObject)this.newHisEntry.getParent()).getLong("id");
            if (!MMCDataSyncService.exist(versionId)) {
                throw new KDBizException(new ErrorCode("DATASYNC_MANU_STOPPED", ResManager.loadKDString((String)"\u53d6\u6d88\u64cd\u4f5c\u3002", (String)"AbstractEntitySyncCallable_0", (String)"mpscmm-msplan-mservice", (Object[])new Object[0])), new Object[0]);
            }
            this.updateStepLog(tableName2);
            this.collectBasedataIds(dbRoute, (String)pair[3], table, (Boolean)pair[4]);
        }
    }

    private void appendColsByFilter(QFilter parsed, StringBuilder fields, Set<String> fieldsFilter) {
        if (parsed == null) {
            return;
        }
        String p = parsed.getProperty();
        if (!"1".equals(p) && !"id".equalsIgnoreCase(p) && fieldsFilter.add(p)) {
            fields.append(", ").append(p);
        }
        List allFilters = parsed.getNests(true);
        for (QFilter.QFilterNest sub : allFilters) {
            this.appendColsByFilter(sub.getFilter(), fields, fieldsFilter);
        }
    }

    private void copyDatas(Set<Object> ids, List<Object[]> sqls, DBRoute dbRoute, String placeHolder) {
        for (Object[] pair : sqls) {
            String relationKey;
            String querySql = (String)pair[0];
            String insertSql = (String)pair[1];
            DbMetadataTable oldTable = (DbMetadataTable)pair[3];
            String tableName = (String)pair[2];
            if (oldTable.getParentRelation() != null) {
                DbMetadataColumn relationCol = oldTable.getParentRelation().getChildColumn();
                relationKey = relationCol.getName();
            } else {
                relationKey = oldTable.getPrimaryKey().getName();
            }
            StringBuilder rcQuery = new StringBuilder();
            rcQuery.append("select count(1) from ").append(oldTable.getName());
            rcQuery.append(String.format(placeHolder, relationKey));
            rcQuery.append(" and ").append(relationKey).append(" not in (select ").append(relationKey).append(" from ").append(tableName).append(')');
            try (DataSet rcDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)rcQuery.toString(), (Object[])ids.toArray());){
                if (rcDs.hasNext()) {
                    Integer rc = rcDs.next().getInteger(0);
                    Integer old = this.rowCounts.get(tableName);
                    if (old == null) {
                        old = 0;
                    }
                    this.rowCounts.put(tableName, rc + old);
                }
            }
            StringBuilder subQuery = new StringBuilder();
            subQuery.append(querySql);
            subQuery.append(String.format(placeHolder, relationKey));
            subQuery.append(" and ").append(relationKey).append(" not in (select ").append(relationKey).append(" from ").append(tableName).append(')');
            insertSql = String.format(insertSql, subQuery.toString());
            DB.execute((DBRoute)dbRoute, (String)insertSql, (Object[])ids.toArray());
            DynamicObject version = (DynamicObject)this.newHisEntry.getParent();
            Long versionId = version.getLong("id");
            if (!MMCDataSyncService.exist(versionId)) {
                String name = version.getString("name");
                throw new KDBizException(new ErrorCode("DATASYNC_MANU_STOPPED", String.format(ResManager.loadKDString((String)"\u6570\u636e\u7248\u672c\uff1a\uff08%1$s\uff09-%2$s\uff0c\u540c\u6b65\u8fd0\u7b97\u88ab\u7ec8\u6b62\u6216\u5b9e\u4f8b\u7f13\u5b58\u88ab\u6e05\u9664\u3002", (String)"AbstractEntitySyncCallable_3", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), name, versionId)), new Object[0]);
            }
            this.updateStepLog(tableName);
            this.collectBasedataIds(dbRoute, (String)pair[2], oldTable, (Boolean)pair[4]);
        }
        ids.clear();
    }

    protected void collectBasedataIds(DBRoute dbRoute, String tableName, DbMetadataTable table, boolean isSplitTable) {
    }

    protected abstract V createEmptyResult();

    protected void updateStepLog(String tableName) {
        Long versionId = ((DynamicObject)this.newHisEntry.getParent()).getLong("id");
        Integer rc = this.rowCounts.get(tableName);
        if (rc == null) {
            rc = 0;
        }
        MMCDataSyncService.refreshStepLogString(versionId, String.format(ResManager.loadKDString((String)"\u6b63\u5728\u540c\u6b65\u201c%1$s\u201d\u5b9e\u4f53\u6570\u636e\uff0c\u5df2\u540c\u6b65\u6570\u636e\u884c\u6570\uff1a\u201c%2$s\u201d\u3002", (String)"AbstractEntitySyncCallable_4", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), this.bt.getName(), rc));
    }

    /*
     * Exception decompiling
     */
    @Override
    public final V call() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

