/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datasync.func;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.FlexProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.service.datasync.func.AbstractEntitySyncCallable;
import kd.mpscmm.msplan.mservice.service.datasync.model.BillSyncResult;

public class BillEntitySyncCallable
extends AbstractEntitySyncCallable<BillEntityType, BillSyncResult> {
    private static final Log logger = LogFactory.getLog(BillEntitySyncCallable.class);
    private Map<BasedataEntityType, Set<Object>> relations;

    public BillEntitySyncCallable(BillEntityType bt, DynamicObject newHisEntry, FilterCondition[] filters, AtomicInteger offset) {
        super(bt, newHisEntry, filters, offset);
    }

    @Override
    protected BillSyncResult createEmptyResult() {
        BillSyncResult result = new BillSyncResult();
        this.relations = result.getRelations();
        return result;
    }

    @Override
    protected void collectBasedataIds(DBRoute dbRoute, String tableName, DbMetadataTable table, boolean isSplitTable) {
        tableName = tableName.toLowerCase(Locale.ENGLISH);
        DbMetadataColumnCollection cols = table.getColumns();
        HashSet<String> usableCols = new HashSet<String>();
        for (DbMetadataColumn col : cols) {
            boolean isSplitCol;
            String group = col.getTableGroup();
            boolean bl = isSplitCol = !StringUtils.isEmpty((String)group);
            if (isSplitCol) {
                if (!tableName.endsWith("_" + group.toLowerCase(Locale.ENGLISH))) continue;
                usableCols.add(col.getName().toLowerCase());
                continue;
            }
            if (isSplitTable) continue;
            usableCols.add(col.getName().toLowerCase());
        }
        StringBuilder sql = new StringBuilder("select distinct ");
        boolean isFirstField = true;
        IDataEntityType entityType = table.getDataEntityTypeMap().getDataEntityType();
        DataEntityPropertyCollection props = entityType.getProperties();
        for (IDataEntityProperty prop : props) {
            MainEntityType mt;
            String field;
            if (StringUtils.isEmpty((String)prop.getAlias()) || prop instanceof FlexProp) continue;
            IDataEntityType type = null;
            if (prop instanceof IComplexProperty) {
                type = ((IComplexProperty)prop).getComplexType();
            }
            if (type == null || !usableCols.contains(field = prop.getAlias().toLowerCase()) || !((mt = MetadataServiceHelper.getDataEntityType((String)type.getName())) instanceof BasedataEntityType)) continue;
            if (!isFirstField) {
                sql.append(", ");
            } else {
                isFirstField = false;
            }
            sql.append(field);
            Set<Object> ids = this.relations.get(mt);
            if (ids != null) continue;
            try {
                ids = new HashSet<Object>();
                this.relations.put((BasedataEntityType)mt.clone(), ids);
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("CLONE_NOT_SUPPORTED", "bt: " + mt.getName()), new Object[0]);
            }
        }
        sql.append(" from ").append(tableName);
        if (isFirstField) {
            logger.warn(String.format("mmc-datasync-bill-sync-collect-basedatas-ignored, tbl: %s", tableName, sql.toString()));
            return;
        }
        sql.setLength(0);
        isFirstField = true;
        for (Map.Entry<BasedataEntityType, Set<Object>> entry : this.relations.entrySet()) {
            if (!isFirstField) {
                sql.append(", ");
            } else {
                isFirstField = false;
            }
            sql.append('(').append(entry.getKey()).append(", ").append(entry.getValue().size()).append(')');
        }
        logger.warn(String.format("mmc-datasync-bill-sync-collect-basedatas, tbl: %s, sums: %s", tableName, sql.toString()));
    }
}

