/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datasync.func;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.impl.RequestContextRunnable;

public class ContextAwareableThreadFactory
implements ThreadFactory {
    private AtomicInteger atomicInteger = new AtomicInteger(0);
    private String poolName;
    private Thread.UncaughtExceptionHandler handler;
    private RequestContext rc;

    public ContextAwareableThreadFactory(String poolName, Thread.UncaughtExceptionHandler handler) {
        this.poolName = poolName;
        this.handler = handler;
        this.rc = RequestContext.get();
        if (this.rc == null) {
            throw new KDBizException(new ErrorCode("EMPTY_REQUEST_CONTEXT", "EMPTY_REQUEST_CONTEXT"), new Object[0]);
        }
    }

    @Override
    public Thread newThread(Runnable runnable) {
        runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)new RequestContextRunnable(runnable, RequestContext.copy((RequestContext)this.rc)));
        Thread worker = new Thread(runnable, this.poolName + "-" + this.atomicInteger.incrementAndGet());
        worker.setUncaughtExceptionHandler(this.handler);
        return worker;
    }
}

