/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datasync.func;

import com.alibaba.fastjson.JSON;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.WaitingRejectedHandler;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.service.datasync.MMCDataSyncService;
import kd.mpscmm.msplan.mservice.service.datasync.func.BasedataEntitySyncCallable;
import kd.mpscmm.msplan.mservice.service.datasync.func.BillEntitySyncCallable;
import kd.mpscmm.msplan.mservice.service.datasync.func.ContextAwareableThreadFactory;
import kd.mpscmm.msplan.mservice.service.datasync.model.ICallableResult;
import kd.mpscmm.msplan.mservice.service.datasync.utils.DataSyncUtils;

public class DataSyncRunnable
implements Runnable,
Thread.UncaughtExceptionHandler {
    private static final Log logger = LogFactory.getLog(DataSyncRunnable.class);
    private static final Set<String> EXCLUDE_ENTITIES = DataSyncRunnable.newSet("bos_billmainentity");
    private final Map<MainEntityType, List<FilterCondition>> filters = new HashMap<MainEntityType, List<FilterCondition>>();
    private final Map<MainEntityType, List<DynamicObject>> settingsMap = new HashMap<MainEntityType, List<DynamicObject>>();
    private final Map<MainEntityType, List<DynamicObject>> hisMap = new HashMap<MainEntityType, List<DynamicObject>>();
    private final Set<BillEntityType> bills = new HashSet<BillEntityType>();
    private final Set<BasedataEntityType> basedatas = new HashSet<BasedataEntityType>();
    private final AtomicInteger offset = new AtomicInteger();
    private final DynamicObject dataVer;
    private final DynamicObject newHisEntry;
    private final Map<String, DynamicObject> dataStatsEntrys = new HashMap<String, DynamicObject>();
    private final Map<Long, String> settingsFilters = new HashMap<Long, String>();
    private String finalStatus = "S";

    public DataSyncRunnable(DynamicObject dataVer, DynamicObject newHisEntry) {
        this.dataVer = dataVer;
        this.newHisEntry = newHisEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            try {
                DynamicObjectCollection settingsList = this.dataVer.getDynamicObjectCollection("datasyncselector");
                for (DynamicObject settings : settingsList) {
                    BasedataEntityType bt;
                    List<Object> list;
                    MainEntityType mainType;
                    settings = settings.getDynamicObject("fbasedataid");
                    DynamicObject et = settings.getDynamicObject("entitytype");
                    String etStr = et.getString("number");
                    try {
                        mainType = MetadataServiceHelper.getDataEntityType((String)etStr);
                        mainType = (MainEntityType)mainType.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        logger.error(String.format("mmc-datasync, clone-not-supported, mt: %s", etStr), (Throwable)e);
                        continue;
                    }
                    catch (Throwable e) {
                        logger.error(String.format("mmc-datasync, unknown-entity-type: %s, class: null", etStr), e);
                        continue;
                    }
                    Long id = settings.getLong("id");
                    String filterStr = BusinessDataServiceHelper.loadSingle((Object)id, (String)"msplan_ds_settings", (String)"id, filtervalue_tag").getString("filtervalue_tag");
                    this.settingsFilters.put(id, filterStr);
                    FilterCondition f = this.parseFilter(mainType, filterStr);
                    if (this.filters.get(mainType) != null) {
                        this.filters.get(mainType).add(f);
                    } else {
                        list = new ArrayList<FilterCondition>();
                        list.add(f);
                        this.filters.put(mainType, list);
                    }
                    if (mainType instanceof BasedataEntityType) {
                        bt = (BasedataEntityType)mainType;
                        this.basedatas.add(bt);
                    } else if (mainType instanceof BillEntityType) {
                        bt = (BillEntityType)mainType;
                        this.bills.add((BillEntityType)bt);
                    } else {
                        logger.warn(String.format("mmc-datasync, unknown-entity-type: %s, class: %s", etStr, mainType.getClass()));
                    }
                    list = this.settingsMap.get(mainType);
                    if (list == null) {
                        list = new ArrayList();
                        this.settingsMap.put(mainType, list);
                    }
                    list.add(settings);
                }
                Long versionId = this.dataVer.getLong("id");
                this.execute(versionId, this.bills, "bill", (type, ver, filters, offset, creates) -> new BillEntitySyncCallable((BillEntityType)type, ver, filters, offset), result -> this.mergeFilters(result.getRelations()));
                this.execute(versionId, this.basedatas, "metadata", (type, ver, filters, offset, creates) -> new BasedataEntitySyncCallable((BasedataEntityType)type, ver, filters, offset, creates), result -> {});
                this.newHisEntry.set("syncstatus", (Object)this.finalStatus);
                if ("S".equals(this.finalStatus)) {
                    this.newHisEntry.set("activestatus", (Object)"A");
                    DynamicObjectCollection hisEntrys = this.dataVer.getDynamicObjectCollection("hisentity");
                    for (int i = 1; i < hisEntrys.size(); ++i) {
                        DynamicObject e = (DynamicObject)hisEntrys.get(i);
                        String status = e.getString("activestatus");
                        if (!"A".equals(status)) continue;
                        e.set("activestatus", (Object)"B");
                        break block18;
                    }
                    break block18;
                }
                this.newHisEntry.set("activestatus", (Object)"B");
            }
            catch (Throwable e) {
                try {
                    this.newHisEntry.set("syncstatus", (Object)"F");
                    this.newHisEntry.set("activestatus", (Object)"B");
                    String msgTag = "msg: " + String.valueOf(e.getMessage());
                    if (msgTag.length() > 255) {
                        msgTag = msgTag.substring(0, 254);
                    }
                    this.newHisEntry.set("synclog", (Object)msgTag);
                    this.newHisEntry.set("synclog_tag", (Object)DataSyncUtils.getStackTrace(e));
                }
                catch (Throwable throwable) {
                    this.newHisEntry.set("finishdatetime", (Object)System.currentTimeMillis());
                    BusinessDataWriter.save((IDataEntityType)this.dataVer.getDataEntityType(), (Object[])new Object[]{this.dataVer});
                    MMCDataSyncService.releasLock(this.dataVer.getLong("id"));
                    throw throwable;
                }
                this.newHisEntry.set("finishdatetime", (Object)System.currentTimeMillis());
                BusinessDataWriter.save((IDataEntityType)this.dataVer.getDataEntityType(), (Object[])new Object[]{this.dataVer});
                MMCDataSyncService.releasLock(this.dataVer.getLong("id"));
            }
        }
        this.newHisEntry.set("finishdatetime", (Object)System.currentTimeMillis());
        BusinessDataWriter.save((IDataEntityType)this.dataVer.getDataEntityType(), (Object[])new Object[]{this.dataVer});
        MMCDataSyncService.releasLock(this.dataVer.getLong("id"));
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        logger.error("mmc-datasync, uncaught-error, thread: " + t.getName(), e);
    }

    private <P extends MainEntityType, V extends ICallableResult> void execute(Long versionId, Set<P> metas, String typeWord, TaskCreator<P, V> creator, TaskResolver<V> resolver) {
        if (!MMCDataSyncService.exist(versionId)) {
            for (MainEntityType bt : metas) {
                this.initHisEntrys(this.newHisEntry, bt);
                this.updateCancelHisEntry(this.newHisEntry, bt);
            }
            return;
        }
        String poolName = String.format("MMC-%s-DataSync-Executor-%s", typeWord, this.dataVer.getString("number"));
        int poolSize = 1;
        int maxSize = 1;
        ExecutorService executor = ThreadLifeCycleManager.wrapExecutorService((ExecutorService)new ThreadPoolExecutor(poolSize, maxSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(Integer.getInteger("threadpool.fix.maxqueue.size", 100000)), new ContextAwareableThreadFactory(poolName, this), (RejectedExecutionHandler)new WaitingRejectedHandler()));
        HashMap<MainEntityType, Future<V>> futures = new HashMap<MainEntityType, Future<V>>(metas.size());
        for (MainEntityType bt : metas) {
            if (EXCLUDE_ENTITIES.contains(bt.getName())) continue;
            this.initHisEntrys(this.newHisEntry, bt);
            List<FilterCondition> tmp = this.filters.get(bt);
            Future<V> result = executor.submit(creator.createTask(bt, this.newHisEntry, tmp == null ? new FilterCondition[]{} : tmp.toArray(new FilterCondition[0]), this.offset, this.dataStatsEntrys));
            futures.put(bt, result);
        }
        executor.shutdown();
        try {
            int seconds = 0;
            while (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                if ((seconds += 5) % 60 == 0) {
                    logger.warn(String.format("mmc-datasync, %s executor not finished after %s seconds", typeWord, seconds));
                }
                if (MMCDataSyncService.exist(versionId)) continue;
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        for (Map.Entry entry : futures.entrySet()) {
            MainEntityType bt = (MainEntityType)entry.getKey();
            Future future = (Future)entry.getValue();
            if (future.isDone()) {
                Throwable e;
                ICallableResult result = null;
                try {
                    result = (ICallableResult)future.get();
                    e = result.getError();
                }
                catch (Throwable ex) {
                    e = ex;
                }
                if (e != null) {
                    this.updateFailHisEntry(this.newHisEntry, bt, result, e);
                    continue;
                }
                resolver.resolveTask(result);
                this.updateSuccessHisEntry(this.newHisEntry, bt, result);
                continue;
            }
            if (!future.isCancelled()) continue;
            this.updateCancelHisEntry(this.newHisEntry, bt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHisEntrys(DynamicObject newHisEntry, MainEntityType bt) {
        DynamicObject dynamicObject = this.dataVer;
        synchronized (dynamicObject) {
            List<DynamicObject> settingList = this.settingsMap.get(bt);
            if (settingList == null) {
                this.hisMap.put(bt, new ArrayList());
                return;
            }
            DynamicObjectCollection subs = newHisEntry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject settings : settingList) {
                DynamicObject logEntry = (DynamicObject)subs.getDynamicObjectType().createInstance();
                logEntry.set("hissettings", (Object)settings);
                logEntry.set("hisstatus", (Object)"A");
                logEntry.set("hisstarttime", (Object)new Timestamp(System.currentTimeMillis()));
                logEntry.set("hismainentity", (Object)settings.getDynamicObject("entitytype"));
                String filterStr = this.settingsFilters.get(settings.getLong("id"));
                logEntry.set("hisfilter", filterStr == null ? null : filterStr.substring(0, Math.min(filterStr.length(), 254)));
                logEntry.set("hisfilter_tag", (Object)filterStr);
                DynamicObjectCollection fields = settings.getDynamicObjectCollection("entryentity");
                ArrayList<String> list = new ArrayList<String>();
                for (DynamicObject row : fields) {
                    String key = row.getString("field");
                    list.add(key);
                }
                String allTags = JSON.toJSONString(list);
                logEntry.set("hiscols", (Object)allTags.substring(0, Math.min(254, allTags.length())));
                logEntry.set("hiscols_tag", (Object)allTags);
                subs.add((Object)logEntry);
                List<DynamicObject> entrys = this.hisMap.get(bt);
                if (entrys == null) {
                    entrys = new ArrayList<DynamicObject>();
                    this.hisMap.put(bt, entrys);
                }
                entrys.add(logEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSuccessHisEntry(DynamicObject newHisEntry, MainEntityType bt, ICallableResult result) {
        DynamicObject dynamicObject = this.dataVer;
        synchronized (dynamicObject) {
            List<DynamicObject> entrys = this.hisMap.get(bt);
            for (DynamicObject logEntry : entrys) {
                logEntry.set("hisfinishtime", (Object)new Timestamp(System.currentTimeMillis()));
                logEntry.set("hisstatus", (Object)"S");
            }
            this.updateTableRecords(result);
        }
    }

    private void updateTableRecords(ICallableResult result) {
        if (result == null) {
            return;
        }
        Map<String, String> tables = result.getTableNames();
        if (tables == null) {
            return;
        }
        Map<String, Integer> rowCounts = result.getRowCounts();
        DynamicObjectCollection subs = this.newHisEntry.getDynamicObjectCollection("tblsubentryentity");
        for (Map.Entry<String, String> entry : tables.entrySet()) {
            String key = entry.getKey();
            DynamicObject logEntry = this.dataStatsEntrys.get(key);
            if (logEntry == null) {
                logEntry = (DynamicObject)subs.getDynamicObjectType().createInstance();
                this.dataStatsEntrys.put(key, logEntry);
                subs.add((Object)logEntry);
            }
            logEntry.set("syncentity", (Object)key);
            String newTableName = entry.getValue();
            logEntry.set("tablename", (Object)newTableName);
            int last = logEntry.getInt("datacount");
            Integer rc = rowCounts == null || !rowCounts.containsKey(newTableName) ? Integer.valueOf(0) : rowCounts.get(newTableName);
            logEntry.set("datacount", (Object)(last + rc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFailHisEntry(DynamicObject newHisEntry, MainEntityType bt, ICallableResult result, Throwable e) {
        DynamicObject dynamicObject = this.dataVer;
        synchronized (dynamicObject) {
            this.finalStatus = "F";
            List<DynamicObject> entrys = this.hisMap.get(bt);
            for (DynamicObject logEntry : entrys) {
                logEntry.set("hisfinishtime", (Object)new Timestamp(System.currentTimeMillis()));
                logEntry.set("hisstatus", (Object)"F");
            }
            DynamicObjectCollection subs = newHisEntry.getDynamicObjectCollection("tblsubentryentity");
            String key = bt.getName();
            DynamicObject logEntry = this.dataStatsEntrys.get(key);
            if (logEntry == null) {
                logEntry = (DynamicObject)subs.getDynamicObjectType().createInstance();
                this.dataStatsEntrys.put(key, logEntry);
                subs.add((Object)logEntry);
            }
            logEntry.set("syncentity", (Object)(key.equals(bt.getName()) ? key : bt.getName() + "." + key));
            String msgTag = "msg: " + String.valueOf(e.getMessage());
            if (msgTag.length() > 255) {
                msgTag = msgTag.substring(0, 254);
            }
            logEntry.set("logdetail", (Object)msgTag);
            logEntry.set("logdetail_tag", (Object)DataSyncUtils.getStackTrace(e));
            this.updateTableRecords(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCancelHisEntry(DynamicObject newHisEntry, MainEntityType bt) {
        DynamicObject dynamicObject = this.dataVer;
        synchronized (dynamicObject) {
            this.finalStatus = "C";
            List<DynamicObject> entrys = this.hisMap.get(bt);
            for (DynamicObject logEntry : entrys) {
                logEntry.set("hisfinishtime", (Object)new Timestamp(System.currentTimeMillis()));
                logEntry.set("hisstatus", (Object)"C");
            }
        }
    }

    private void mergeFilters(Map<BasedataEntityType, Set<Object>> relations) {
        for (Map.Entry<BasedataEntityType, Set<Object>> entry : relations.entrySet()) {
            List<FilterCondition> list;
            BasedataEntityType key = entry.getKey();
            Set<Object> val = entry.getValue();
            if (val == null || val.isEmpty() || (list = this.filters.get(key)) != null) continue;
            list = new ArrayList<FilterCondition>();
            this.filters.put((MainEntityType)key, list);
            this.basedatas.add(key);
        }
    }

    private FilterCondition parseFilter(MainEntityType mainType, String filterContent) {
        if (StringUtils.isEmpty((String)filterContent)) {
            return null;
        }
        return (FilterCondition)SerializationUtils.fromJsonString((String)filterContent, FilterCondition.class);
    }

    public static QFilter parse2QFilter(MainEntityType mainType, FilterCondition condition) {
        FilterBuilder fb = new FilterBuilder(mainType, condition);
        TimeService timeService = new TimeService();
        fb.setTimeService((ITimeService)timeService);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        return fb.getQFilter();
    }

    public static Set<String> newSet(String ... args) {
        return new HashSet<String>(Arrays.asList(args));
    }

    @FunctionalInterface
    private static interface TaskResolver<T> {
        public void resolveTask(T var1);
    }

    @FunctionalInterface
    private static interface TaskCreator<P extends MainEntityType, T extends ICallableResult> {
        public Callable<T> createTask(P var1, DynamicObject var2, FilterCondition[] var3, AtomicInteger var4, Map<String, DynamicObject> var5);
    }
}

