/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.datasync.utils;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.util.DateUtil;

public class MMFilterUtil {
    private static final ThreadLocal<SimpleDateFormat> thSDF = ThreadLocals.create(() -> DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss"));
    private static final Set<Class<?>> numberClsSet = new HashSet();

    private static boolean isNumber(Class<?> cls) {
        return numberClsSet.contains(cls);
    }

    private static String toSqlValueString(Object value) {
        String v = String.valueOf(value);
        return v.replaceAll("'", "''");
    }

    public static void qfilter2String(StringBuilder s, QFilter filter) {
        Object value = filter.getValue();
        if (filter.isJoinSQLFilter()) {
            s.append(filter.getProperty());
        } else {
            String cp = filter.getCP();
            s.append(filter.getProperty()).append(' ').append(cp);
            if (filter.isExpressValue()) {
                s.append(String.valueOf(value));
            } else if (cp.equalsIgnoreCase("in") || cp.equalsIgnoreCase("not in")) {
                s.append(" (").append(MMFilterUtil.parametertoString(value)).append(')');
            } else if (!cp.equalsIgnoreCase("is null") && !cp.equalsIgnoreCase("is not null")) {
                if (value instanceof QEmptyValue) {
                    s.delete(s.length() - cp.length(), s.length());
                    s.append("is null");
                } else {
                    String val = MMFilterUtil.parametertoString(value);
                    s.append(' ').append(val);
                }
            }
        }
        List nests = filter.getNests(false);
        if (!nests.isEmpty()) {
            MMFilterUtil.resloveNests(s, nests, nest -> {
                String c = nest.isAnd() ? "AND" : "OR";
                s.append(' ').append(c).append(' ');
                s.append('(');
                MMFilterUtil.qfilter2String(s, nest.getFilter());
                s.append(')');
                return null;
            });
        }
    }

    public static String parametertoString(Object value) {
        QParameter p = MMFilterUtil.getInQParameter(value);
        if (p == null) {
            return "";
        }
        Object[] params = p.getParameters();
        StringBuilder s = new StringBuilder(params.length * 10);
        for (Object param : params) {
            if (s.length() > 0) {
                s.append(',');
            }
            if (param == null) {
                s.append("''");
                continue;
            }
            Class<?> cls = param.getClass();
            if (MMFilterUtil.isNumber(cls) || cls == Boolean.class) {
                s.append(param);
                continue;
            }
            if (Date.class.isAssignableFrom(cls)) {
                s.append("TO_DATE('").append(thSDF.get().format((Date)param)).append("', 'yyyy-MM-dd HH:mm:ss')");
                continue;
            }
            if (cls.isArray()) {
                int n = Array.getLength(param);
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        s.append(',');
                    }
                    s.append(MMFilterUtil.parametertoString(Array.get(param, i)));
                }
                continue;
            }
            s.append('\'').append(MMFilterUtil.toSqlValueString(param)).append('\'');
        }
        return s.toString();
    }

    public static void resloveNests(StringBuilder s, List<QFilter.QFilterNest> nests, Function<QFilter.QFilterNest, Void> nestFun) {
        boolean withOr = false;
        boolean allOr = true;
        for (QFilter.QFilterNest nest : nests) {
            if (nest.isAnd()) {
                allOr = false;
                continue;
            }
            withOr = true;
        }
        if (withOr) {
            s.insert(0, '(');
        }
        if (allOr) {
            for (QFilter.QFilterNest nest : nests) {
                nestFun.apply(nest);
            }
        } else {
            boolean preIsAnd = true;
            for (QFilter.QFilterNest nest : nests) {
                boolean and = nest.isAnd();
                if (!preIsAnd && and) {
                    s.insert(0, '(');
                    s.append(')');
                }
                nestFun.apply(nest);
                preIsAnd = and;
            }
        }
        if (withOr) {
            s.append(')');
        }
    }

    static QParameter getInQParameter(Object value) {
        if (value == null) {
            return null;
        }
        Object[] params = MMFilterUtil.getWithoutDuplicateInValues(value);
        int c = params.length;
        if (c > 0) {
            String sql = MMFilterUtil.multiParamsSQL(c);
            return new QParameter(sql, params);
        }
        return null;
    }

    static String multiParamsSQL(int c) {
        StringBuilder s = new StringBuilder(c * 2);
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append('?');
        }
        return s.toString();
    }

    public static Object[] getWithoutDuplicateInValues(Object values) {
        if (values == null) {
            return null;
        }
        Object[] params = null;
        if (values.getClass().isArray()) {
            int c = Array.getLength(values);
            HashSet<Object> set = new HashSet<Object>(c);
            for (int i = 0; i < c; ++i) {
                set.add(Array.get(values, i));
            }
            c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else if (values instanceof Set) {
            params = ((Set)values).toArray(new Object[((Set)values).size()]);
        } else if (values instanceof Collection) {
            HashSet set = new HashSet((Collection)values);
            int c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else if (values instanceof Iterable) {
            HashSet set = new HashSet(16);
            for (Object item : (Iterable)values) {
                set.add(item);
            }
            int c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else {
            params = new Object[]{values};
        }
        return params;
    }

    static {
        numberClsSet.add(Integer.TYPE);
        numberClsSet.add(Long.TYPE);
        numberClsSet.add(Short.TYPE);
        numberClsSet.add(Float.TYPE);
        numberClsSet.add(Double.TYPE);
        numberClsSet.add(Integer.class);
        numberClsSet.add(Long.class);
        numberClsSet.add(Short.class);
        numberClsSet.add(Float.class);
        numberClsSet.add(Double.class);
        numberClsSet.add(BigDecimal.class);
    }
}

