/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.metadatascan;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import kd.mpscmm.msplan.mservice.service.metadatascan.utils.FileUtils;

public class MetaPath {
    private String path1;
    private String path2;
    private String filePath;
    private String zipPath;
    private String zipName;

    public String getZipName() {
        return this.zipName;
    }

    public void setZipName(String zipName) {
        this.zipName = zipName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getZipPath() {
        return this.zipPath;
    }

    public void setZipPath(String zipPath) {
        this.zipPath = zipPath;
    }

    public String getPath1() {
        return this.path1;
    }

    public void setPath1(String path1) {
        this.path1 = path1;
    }

    public String getPath2() {
        return this.path2;
    }

    public void setPath2(String path2) {
        this.path2 = path2;
    }

    public void buildFile() throws IOException {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMdHmmss");
        String uuid = UUID.randomUUID().toString().substring(1, 5);
        Date date = new Date();
        String dir = format.format(date) + uuid;
        this.filePath = FileUtils.createFilePath(dir);
        this.zipPath = FileUtils.createLastZipPath();
        this.path1 = this.filePath + File.separator + "current";
        this.path2 = this.filePath + File.separator + "last";
    }

    public boolean downCurFile(String zipUrl) {
        HashMap<String, String> errorMap = new HashMap<String, String>(16);
        this.zipName = FileUtils.downLoadFile(zipUrl, this.path1, errorMap);
        String msg = (String)errorMap.get("msg");
        return zipUrl != null && this.zipName != null && !"error".equals(msg);
    }

    public boolean downLastFile(String zipUrl) {
        HashMap<String, String> errorMap = new HashMap<String, String>(16);
        this.zipName = FileUtils.downLoadFile(zipUrl, this.path2, errorMap);
        String msg = (String)errorMap.get("msg");
        return zipUrl != null && this.zipName != null && !"error".equals(msg);
    }
}

