/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.metadatascan.task;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.mpscmm.metadatascan.CompareDTO;
import kd.mpscmm.metadatascan.MetadataDTO;
import kd.mpscmm.msplan.mservice.service.metadatascan.MetaPath;
import kd.mpscmm.msplan.mservice.service.metadatascan.utils.FileUtils;
import kd.mpscmm.msplan.mservice.service.metadatascan.utils.MetadataCheckUtils;
import kd.mpscmm.msplan.mservice.service.metadatascan.utils.MetadataRefCheckUtils;

public class ScanRunnable
implements Callable<String> {
    private MetadataDTO metadataDTO;
    private final String TRUE = "true";
    private static final Log logger = LogFactory.getLog(ScanRunnable.class);

    public ScanRunnable(MetadataDTO metadataDTO) {
        this.metadataDTO = metadataDTO;
    }

    @Override
    public String call() {
        String result = "";
        MetaPath metaPath = new MetaPath();
        String zipUrl = this.getCurrentZipUrl(this.metadataDTO);
        String lastZipUrl = this.getLastZipUrl(this.metadataDTO);
        logger.info("zipUrl\u8def\u5f84\u4e3a\uff1a " + zipUrl + " lastZipUrl\u8def\u5f84\u4e3a\uff1a " + lastZipUrl);
        try {
            metaPath.buildFile();
            boolean res = metaPath.downCurFile(zipUrl);
            if (!res) {
                return ResManager.loadKDString((String)"\u6ca1\u6709\u53d1\u73b0\u5143\u6570\u636ezip\u5305\uff0c\u505c\u6b62\u626b\u63cf", (String)"ScanRunnable_1", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
            }
            metaPath.downLastFile(lastZipUrl);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ResManager.loadKDString((String)"\u6ca1\u6709\u53d1\u73b0\u5143\u6570\u636ezip\u5305\uff0c\u505c\u6b62\u626b\u63cf", (String)"ScanRunnable_1", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
        }
        List<Map<String, Object>> diffMetas = this.buildDiffMeta(metaPath);
        if (CollectionUtils.isNotEmpty(diffMetas)) {
            result = MetadataRefCheckUtils.checkRefMetadata(diffMetas);
        }
        return result;
    }

    private String getLastZipUrl(MetadataDTO metadataDTO) {
        String url = "http://172.17.201.20:31085/artifactory/cosmic-cd/patchscm/test/prepare/runtime/datamodel";
        switch (metadataDTO.getBranch()) {
            case "feature_sit": {
                url = "http://172.17.201.20:31085/artifactory/cosmic-cd/feature_sit_scm/test/prepare/runtime/datamodel";
            }
        }
        return String.format("%s/%s-%s-dm-1.x.zip", url, metadataDTO.getCloud(), metadataDTO.getAppid());
    }

    private String getCurrentZipUrl(MetadataDTO metadataDTO) {
        String url = "http://172.17.201.20:31085/artifactory/cosmic-cd/patchscm/smoke/prepare/runtime/datamodel";
        switch (metadataDTO.getBranch()) {
            case "feature_sit": {
                url = "http://172.17.201.20:31085/artifactory/cosmic-cd/feature_sit_scm/smoke/prepare/runtime/datamodel";
            }
        }
        return String.format("%s/%s-%s-dm-1.x.zip", url, metadataDTO.getCloud(), metadataDTO.getAppid());
    }

    private List<Map<String, Object>> buildDiffMeta(MetaPath metaPath) {
        List<String> file1 = FileUtils.getFileList(metaPath.getPath1());
        List<String> file2 = FileUtils.getFileList(metaPath.getPath2());
        LinkedHashMap<String, Map<String, Object>> compareFile = new LinkedHashMap<String, Map<String, Object>>();
        LinkedHashMap<String, Map<String, Object>> appFile = new LinkedHashMap<String, Map<String, Object>>();
        FileUtils.getCompareFile(compareFile, appFile, file1, 1);
        FileUtils.getCompareFile(compareFile, appFile, file2, 2);
        Map<String, String> appInfo = FileUtils.getAppNumber(appFile);
        CompareDTO compareDTO = new CompareDTO();
        compareDTO.setCompareFile(compareFile);
        compareDTO.setAppInfo(appInfo);
        List<Map<String, Object>> diffMetas = MetadataCheckUtils.getDiffMetas(compareDTO);
        diffMetas.removeIf(diffMeta -> StringUtils.isBlank(diffMeta.get("desc")));
        diffMetas.removeIf(diffMeta -> "2".equals((String)diffMeta.get("status")));
        diffMetas.removeIf(diffMeta -> ((List)diffMeta.get("diffs")).isEmpty());
        diffMetas.removeIf(diffMeta -> ((List)diffMeta.get("diffs")).stream().allMatch(l -> !l.getType().equals("key_modify")));
        return diffMetas;
    }
}

