/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.metadatascan.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msplan.mservice.service.metadatascan.utils.FilenameUtils;
import kd.mpscmm.msplan.mservice.service.metadatascan.utils.MetadataSerializerUtils;

public class FileUtils {
    private static final Log logger = LogFactory.getLog(FileUtils.class);

    public static List<String> getFileList(String path) {
        ArrayList<String> list = new ArrayList<String>(10);
        File file = new File(FilenameUtils.getName(path));
        if (file.exists()) {
            File[] files = file.listFiles();
            assert (files != null);
            for (File file1 : files) {
                if (file1.isDirectory()) {
                    FileUtils.getFileList(file1.getAbsolutePath());
                    continue;
                }
                list.add(file1.getAbsolutePath());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getCompareFile(Map<String, Map<String, Object>> mapValidCheckFileInfo, Map<String, Map<String, Object>> appFile, List<String> fileList, int type) {
        ArrayList<String> fileSuffix = new ArrayList<String>(3);
        fileSuffix.add("dym");
        fileSuffix.add("dymx");
        fileSuffix.add("app");
        for (String filePath : fileList) {
            File file = new File(FilenameUtils.getName(filePath));
            String fileName = file.getName();
            String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            String name = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.lastIndexOf("."));
            if (fileSuffix.contains(fileType)) {
                if (fileType.equalsIgnoreCase("app")) {
                    Map mapAppTemp = appFile.computeIfAbsent(name, k -> new HashMap());
                    if (type == 1) {
                        mapAppTemp.put("path1", filePath);
                        continue;
                    }
                    if (type != 2) continue;
                    mapAppTemp.put("path2", filePath);
                    continue;
                }
                Map mapTemp = mapValidCheckFileInfo.computeIfAbsent(name, k -> new HashMap());
                if (type == 1) {
                    mapTemp.put("path1", filePath);
                    continue;
                }
                if (type != 2) continue;
                mapTemp.put("path2", filePath);
                continue;
            }
            if (!fileType.equalsIgnoreCase("zip")) continue;
            FileInputStream in = null;
            ZipInputStream zipIn = null;
            ZipEntry zEntry = null;
            try {
                in = new FileInputStream(file);
                zipIn = new ZipInputStream(in);
                zEntry = zipIn.getNextEntry();
                if (zEntry == null) {
                    logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + filePath);
                    continue;
                }
                while (null != zEntry) {
                    if (!zEntry.isDirectory()) {
                        String zipfileName = zEntry.getName();
                        String zipfileType = zipfileName.substring(zipfileName.lastIndexOf(".") + 1, zipfileName.length());
                        name = zipfileName.substring(zipfileName.lastIndexOf("/") + 1, zipfileName.lastIndexOf("."));
                        if (fileSuffix.contains(zipfileType)) {
                            if (zipfileType.equalsIgnoreCase("app")) {
                                Map mapAppTemp = appFile.computeIfAbsent(name, k -> new HashMap());
                                if (type == 1) {
                                    mapAppTemp.put("path1", filePath);
                                    mapAppTemp.put("subpath1", zipfileName);
                                } else if (type == 2) {
                                    mapAppTemp.put("path2", filePath);
                                    mapAppTemp.put("subpath2", zipfileName);
                                }
                            } else {
                                Map mapTemp = mapValidCheckFileInfo.computeIfAbsent(name, k -> new HashMap());
                                if (type == 1) {
                                    mapTemp.put("path1", filePath);
                                    mapTemp.put("subpath1", zipfileName);
                                } else if (type == 2) {
                                    mapTemp.put("path2", filePath);
                                    mapTemp.put("subpath2", zipfileName);
                                }
                            }
                        }
                    }
                    zEntry = zipIn.getNextEntry();
                }
            }
            catch (FileNotFoundException e) {
                logger.error("getCompareFile1", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("getCompareFile2", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (zipIn == null) continue;
                try {
                    zipIn.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static String getFileContent(String path, String subPath) {
        String dym = null;
        if (!StringUtils.isBlank((CharSequence)subPath)) {
            File zip = new File(path);
            try (ZipFile zipFile = new ZipFile(zip);
                 InputStream zipInputStream = zipFile.getInputStream(zipFile.getEntry(subPath));){
                dym = FileUtils.readContent(zipInputStream);
            }
            catch (IOException e) {
                logger.error("getFileContent1 " + e);
            }
        } else if (!StringUtils.isBlank((CharSequence)path)) {
            File zip = new File(path);
            try (FileInputStream fInput = new FileInputStream(zip);){
                dym = FileUtils.readContent(fInput);
            }
            catch (IOException e) {
                logger.error("getFileContent2 " + e);
            }
        }
        return dym;
    }

    public static String readContent(InputStream zipIn) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = zipIn.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    public static Map<String, String> getAppNumber(Map<String, Map<String, Object>> appFile) {
        LinkedHashMap<String, String> appInfo = new LinkedHashMap<String, String>(appFile.size());
        for (Map.Entry<String, Map<String, Object>> entry : appFile.entrySet()) {
            String path = (String)entry.getValue().get("path1");
            String subpath = (String)entry.getValue().get("subpath1");
            if (path == null || subpath == null) {
                path = (String)entry.getValue().get("path2");
                subpath = (String)entry.getValue().get("subpath2");
            }
            String appContent = FileUtils.getFileContent(path, subpath);
            String appId = MetadataSerializerUtils.getAppId(appContent);
            appInfo.put(appId, entry.getKey());
        }
        return appInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downLoadFile(String zipUrl, String fileDir, Map<String, String> error) {
        logger.info("\u5f00\u59cb\u4e0b\u8f7dzip\u5305,\u5730\u5740\u4e3a: " + zipUrl);
        long start = System.currentTimeMillis();
        BufferedInputStream ins = null;
        OutputStream out = null;
        String name = null;
        try {
            URL last = new URL(zipUrl);
            URLConnection urlConnection = last.openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setReadTimeout(10000);
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            String headerField = httpURLConnection.getHeaderField(0);
            logger.info("headerField\uff1a " + headerField);
            String result = "Not Found";
            if (headerField.endsWith(result)) {
                error.put("msg", "error");
                logger.info("\u5143\u6570\u636e\u5305\u4e0d\u5b58\u5728\uff0c\u505c\u6b62\u626b\u63cf");
                String string = null;
                return string;
            }
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.connect();
            ins = new BufferedInputStream(httpURLConnection.getInputStream());
            String[] split = zipUrl.trim().split("/");
            name = split[split.length - 1];
            String path = fileDir + File.separator + name;
            File file = new File(FilenameUtils.getName(path));
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(file);
            int len = 0;
            byte[] buf = new byte[2048];
            while ((len = ins.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            long end = System.currentTimeMillis();
            logger.info("zip\u5305\u4e0b\u8f7d\u5b8c\u6210\uff0c\u8017\u65f6\uff1a " + (end - start) / 1000L + " s");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    logger.error("downLoadFile()-ins", (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error("downLoadFile()-out", (Throwable)e);
                }
            }
        }
        return name;
    }

    public static String createFilePath(String dir) throws IOException {
        File file = new File("../");
        String metaPath = null;
        String parentPath = file.getCanonicalPath();
        logger.info("parentPath\u8def\u5f84\u4e3a\uff1a " + parentPath);
        metaPath = parentPath + File.separator + "metascan" + File.separator + "data" + File.separator + dir;
        logger.info("metaPath\u8def\u5f84\u4e3a\uff1a " + metaPath);
        String lastPath = metaPath + File.separator + "baseline";
        String basePath = metaPath + File.separator + "last";
        File last = new File(FilenameUtils.getName(lastPath));
        File base = new File(FilenameUtils.getName(basePath));
        if (!last.exists() && !last.mkdirs()) {
            logger.error("\u521b\u5efalast\u6587\u4ef6\u5939\u5931\u8d25");
        }
        if (!base.exists() && !base.mkdirs()) {
            logger.error("\u521b\u5efabaseline\u6587\u4ef6\u5939\u5931\u8d25");
        }
        return metaPath;
    }

    public static String createLastZipPath() throws IOException {
        File file = new File("../");
        String metaPath = null;
        String parentPath = file.getCanonicalPath();
        logger.info("\u8865\u4e01\u5305parentPath\u8def\u5f84\u4e3a\uff1a " + parentPath);
        metaPath = parentPath + File.separator + "metascan" + File.separator + "data" + File.separator + "zip";
        logger.info("\u8865\u4e01\u5305\u8def\u5f84\u4e3a\uff1a " + metaPath);
        File zipPath = new File(metaPath);
        if (!zipPath.exists() && !zipPath.mkdirs()) {
            logger.error("\u521b\u5efa\u8865\u4e01\u5305zipPath\u6587\u4ef6\u5939\u5931\u8d25");
        }
        return metaPath;
    }

    public static void deleteFile(String path) {
        boolean delete;
        File file = new File(FilenameUtils.getName(path));
        if (file.exists() && (delete = file.delete())) {
            logger.info("\u5220\u9664yaml\u6587\u4ef6\u5939\u6210\u529f");
        }
    }
}

