/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.metadatascan.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.IDcDescReadPlugin;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.deploy.DeployAppMetadata;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.devportal.DesignAppMetaL;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.DesignEntityMetaL;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.DesignFormMetaL;
import kd.bos.service.metadata.EntityMetadataDiff;
import kd.bos.service.metadata.FormMetadataDiff;
import kd.mpscmm.metadatascan.CompareDTO;
import kd.mpscmm.msplan.mservice.service.metadatascan.entity.CheckMetadataSerializer;
import kd.mpscmm.msplan.mservice.service.metadatascan.utils.FileUtils;

public class MetadataCheckUtils {
    private static final Log logger = LogFactory.getLog(MetadataCheckUtils.class);
    private static Map<String, Object> baseMeta = new ConcurrentHashMap<String, Object>(16);
    private static Map<String, String> billName = new ConcurrentHashMap<String, String>(16);

    public static List<Map<String, Object>> getDiffMetas(CompareDTO compareDTO) {
        logger.info("\u5f00\u59cb\u8fdb\u884c\u5143\u6570\u636e\u517c\u5bb9\u6027\u626b\u63cf");
        ArrayList<Map<String, Object>> lstMetas = new ArrayList<Map<String, Object>>();
        LinkedHashMap type = new LinkedHashMap();
        LinkedHashMap dymxInfo = new LinkedHashMap();
        compareDTO.setType(type);
        compareDTO.setDymxInfo(dymxInfo);
        Map compareFile = compareDTO.getCompareFile();
        Object[] keys = compareDTO.getCompareFile().keySet().toArray();
        Arrays.sort(keys);
        long start = System.currentTimeMillis();
        for (int i = 0; i < keys.length; ++i) {
            String dym2;
            Map temp = (Map)compareFile.get(keys[i]);
            String path1 = (String)temp.get("path1");
            String subpath1 = (String)temp.get("subpath1");
            String path2 = (String)temp.get("path2");
            String subpath2 = (String)temp.get("subpath2");
            String dym1 = FileUtils.getFileContent(path1, subpath1);
            List<Map<String, Object>> lstDiffMetaInfos = MetadataCheckUtils.getDiffMetaInfo(dym1, dym2 = FileUtils.getFileContent(path2, subpath2), subpath1, subpath2, compareDTO);
            if (lstDiffMetaInfos.isEmpty()) continue;
            lstMetas.addAll(lstDiffMetaInfos);
        }
        MetadataCheckUtils.handleNumber(lstMetas);
        long end = System.currentTimeMillis();
        logger.info("\u5143\u6570\u636e\u626b\u63cf\u5b8c\u6bd5\uff0c\u8017\u65f6\uff1a " + (end - start) / 1000L + "s");
        return lstMetas;
    }

    private static void handleNumber(List<Map<String, Object>> list) {
        for (Map<String, Object> metas : list) {
            String number = (String)metas.get("number");
            String s = number.trim().split("\\.")[0];
            if (billName.get(s) == null) continue;
            metas.put("name", billName.get(s));
        }
    }

    private static List<Map<String, Object>> getDiffMetaInfo(String dym1, String dym2, String subpath1, String subpath2, CompareDTO compareDTO) {
        ArrayList<Map<String, Object>> lstDiffMetaInfos = new ArrayList<Map<String, Object>>();
        Map appInfo = compareDTO.getAppInfo();
        Map type = compareDTO.getType();
        Map dymxInfo = compareDTO.getDymxInfo();
        Map formMetaMap = compareDTO.getFormMetaMap();
        String number = "";
        String appId = "";
        String name = "";
        try {
            Long l;
            Map formMeta;
            String s;
            String number1;
            String s2;
            if (StringUtils.isBlank((CharSequence)dym1) || StringUtils.isBlank((CharSequence)dym2)) {
                return lstDiffMetaInfos;
            }
            DeployMetadata deploy1 = MetadataCheckUtils.getDeployMetadata(dym1);
            DeployMetadata deploy2 = MetadataCheckUtils.getDeployMetadata(dym2);
            if (!StringUtils.isBlank((CharSequence)subpath2)) {
                name = subpath2.substring(subpath2.lastIndexOf("/") + 1, subpath2.length());
            }
            if (!StringUtils.isBlank((CharSequence)subpath1)) {
                name = subpath1.substring(subpath1.lastIndexOf("/") + 1, subpath1.length());
            }
            if (deploy1 != null && deploy2 != null && deploy1.getVersion() == deploy2.getVersion()) {
                logger.info("\u6b63\u5728\u626b\u63cf\u7f16\u7801\u4e3a: " + name + " \u7684\u5143\u6570\u636e");
                logger.info("\u5143\u6570\u636e\u7248\u672c\u6ca1\u6709\u53d8\u5316\uff0c\u65e0\u9700\u5bf9\u6bd4\u5dee\u5f02\uff1a" + deploy1.getVersion() + "---" + deploy2.getVersion());
                return lstDiffMetaInfos;
            }
            DesignFormMeta dfm1 = null;
            DesignEntityMeta dem1 = null;
            DesignFormMetaL dfmL1 = null;
            DesignEntityMetaL demL1 = null;
            DesignFormMeta dfm2 = null;
            DesignEntityMeta dem2 = null;
            DesignFormMetaL dfmL2 = null;
            DesignEntityMetaL demL2 = null;
            String dataFormXml1 = null;
            String dataFormXml2 = null;
            String dataEntityXml1 = null;
            String dataEntityXml2 = null;
            String modelType = null;
            boolean enableExtend1 = true;
            boolean enableExtend2 = true;
            if (deploy1 != null) {
                for (AbstractDesignMeta meta : deploy1.getDesignMetas()) {
                    if (meta instanceof DesignFormMeta) {
                        dfm1 = (DesignFormMeta)meta;
                        number = dfm1.getNumber();
                        appId = dfm1.getBizappId();
                        if (number != null && appId != null) {
                            dymxInfo.put(number, appId);
                        }
                        dataFormXml1 = dfm1.getDataXml();
                        modelType = dfm1.getModelType();
                        if (modelType != null) {
                            type.put(number, modelType);
                        }
                        enableExtend1 = ((DesignFormMeta)meta).isExtended();
                    }
                    if (meta instanceof DesignFormMetaL) {
                        dfmL1 = (DesignFormMetaL)meta;
                        number = dfmL1.getNumber();
                        appId = (String)dymxInfo.get(number);
                        dataFormXml1 = dfmL1.getDataXml();
                        String dfmL1Name = dfmL1.getName();
                        if (dfmL1Name != null && number != null) {
                            s2 = number.trim().split("\\.")[0];
                            billName.put(s2, dfmL1Name);
                        }
                    }
                    if (meta instanceof DesignEntityMeta) {
                        dem1 = (DesignEntityMeta)meta;
                        dataEntityXml1 = dem1.getDataXml();
                    }
                    if (!(meta instanceof DesignEntityMetaL)) continue;
                    demL1 = (DesignEntityMetaL)meta;
                    dataEntityXml1 = demL1.getDataXml();
                    String demL1Name = demL1.getName();
                    number1 = demL1.getNumber();
                    if (demL1Name == null || number1 == null) continue;
                    s = number1.trim().split("\\.")[0];
                    billName.put(s, demL1Name);
                }
            }
            if (deploy2 != null) {
                for (AbstractDesignMeta meta : deploy2.getDesignMetas()) {
                    String name1;
                    if (meta instanceof DesignFormMeta) {
                        dfm2 = (DesignFormMeta)meta;
                        number = dfm2.getNumber();
                        dataFormXml2 = dfm2.getDataXml();
                        appId = dfm2.getBizappId();
                        if (number != null && appId != null) {
                            dymxInfo.put(number, appId);
                        }
                        if ((modelType = dfm2.getModelType()) != null) {
                            type.put(number, modelType);
                        }
                        enableExtend2 = ((DesignFormMeta)meta).isExtended();
                    }
                    if (meta instanceof DesignFormMetaL) {
                        dfmL2 = (DesignFormMetaL)meta;
                        number = dfmL2.getNumber();
                        appId = (String)dymxInfo.get(number);
                        dataFormXml2 = dfmL2.getDataXml();
                        name1 = dfmL2.getName();
                        if (name1 != null && number != null) {
                            s2 = number.trim().split("\\.")[0];
                            billName.put(s2, name1);
                        }
                    }
                    if (meta instanceof DesignEntityMeta) {
                        dem2 = (DesignEntityMeta)meta;
                        dataEntityXml2 = dem2.getDataXml();
                    }
                    if (!(meta instanceof DesignEntityMetaL)) continue;
                    demL2 = (DesignEntityMetaL)meta;
                    dataEntityXml2 = demL2.getDataXml();
                    name1 = demL2.getName();
                    number1 = demL2.getNumber();
                    if (name1 == null || number1 == null) continue;
                    s = number1.trim().split("\\.")[0];
                    billName.put(s, name1);
                }
            }
            if (!enableExtend1 && !enableExtend2) {
                logger.warn(number + "\u6269\u5c55\u6027\u5904\u4e8e\u5173\u95ed\u72b6\u6001\uff0c\u65e0\u9700\u5bf9\u6bd4\u5dee\u5f02");
                return lstDiffMetaInfos;
            }
            if (StringUtils.isNotBlank((Object)formMetaMap) && (formMeta = (Map)formMetaMap.get(name)) != null && (l = (Long)formMeta.get("version")) >= deploy1.getVersion()) {
                logger.info("\u7f16\u7801\u4e3a\uff1a " + number + " \u7684\u5143\u6570\u636e\u88ab\u8ba4\u4e3a\u65e0\u5f71\u54cd\uff0c \u4e0d\u9700\u8981\u5bf9\u6bd4\u5dee\u5f02 ");
                return lstDiffMetaInfos;
            }
            if (modelType == null) {
                modelType = (String)type.get(number);
            }
            if (modelType == null) {
                logger.warn("\u6ca1\u6709\u51c6\u5907\u597d\uff08" + number + "\uff09\u7684\u6a21\u578b\u7c7b\u578b\u3002\u6000\u7591dymx\u6587\u4ef6\u5185\u5bb9\u6709\u9519\u8bef");
                modelType = "DynamicFormModel";
            }
            Map<String, Object> formMetaDiffInfo = MetadataCheckUtils.buildMapRet("FormMetadata");
            formMetaDiffInfo.put("number", name);
            formMetaDiffInfo.put("app", appInfo.get(appId));
            formMetaDiffInfo.put("version", deploy1.getVersion());
            try {
                String key;
                CheckMetadataSerializer metaSerializer = new CheckMetadataSerializer(modelType);
                AbstractMetadata formMeta1 = (AbstractMetadata)metaSerializer.deserializeFromXml(dataFormXml1, null);
                AbstractMetadata formMeta2 = (AbstractMetadata)metaSerializer.deserializeFromXml(dataFormXml2, null);
                if (dfm1 != null && formMeta1.getParentId() != null && compareDTO.isEnableTemplate()) {
                    String inheritPath1 = formMeta1.getInheritPath();
                    logger.info("FormMetadata->inheritPath1: " + inheritPath1);
                    if (inheritPath1 != null && baseMeta.get(key = (inheritPath1.contains(",") ? inheritPath1.trim().split(",")[0] : inheritPath1) + "form") != null) {
                        formMeta1 = (AbstractMetadata)metaSerializer.deserializeFromXml(dataFormXml1, baseMeta.get(key));
                    }
                }
                if (dfm2 != null && formMeta2.getParentId() != null && compareDTO.isEnableTemplate()) {
                    String inheritPath2 = formMeta2.getInheritPath();
                    logger.info("FormMetadata->inheritPath2: " + inheritPath2);
                    if (inheritPath2 != null && baseMeta.get(key = (inheritPath2.contains(",") ? inheritPath2.trim().split(",")[0] : inheritPath2) + "form") != null) {
                        formMeta2 = (AbstractMetadata)metaSerializer.deserializeFromXml(dataFormXml2, baseMeta.get(key));
                    }
                }
                String formMetaDiff = metaSerializer.buildDiffXml(formMeta1, formMeta2);
                formMetaDiffInfo.put("detail", formMetaDiff);
                DcxmlSerializer xmlSerializer = new DcxmlSerializer(metaSerializer.getBinder());
                FormMetadataDiff formDiffPlugin = new FormMetadataDiff();
                formMetaDiffInfo.put("desc", xmlSerializer.getDiffDesc(formMetaDiff, (Object)formMeta2, (IDcDescReadPlugin)formDiffPlugin));
                formMetaDiffInfo.put("compatibility", formDiffPlugin.isCompatibility());
                formMetaDiffInfo.put("diffs", formDiffPlugin.getDFS());
                if (!formDiffPlugin.getDFS().isEmpty()) {
                    logger.info("\u6b63\u5728\u626b\u63cf\u7f16\u7801\u4e3a: " + name + " \u7684\u5143\u6570\u636e");
                }
                lstDiffMetaInfos.add(formMetaDiffInfo);
            }
            catch (Exception e) {
                String error = ResManager.loadKDString((String)"\u5b9e\u4f53\u5143\u6570\u636e\u517c\u5bb9\u6027\u68c0\u67e5\u5f02\u5e38\uff0c\u9519\u8bef\u5185\u5bb9\uff1a", (String)"MetadataCheckUtils_6", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
                logger.error(error);
                formMetaDiffInfo.put("status", "2");
                formMetaDiffInfo.put("error", error);
                lstDiffMetaInfos.add(formMetaDiffInfo);
            }
            Map<String, Object> entityMetaDiffInfo = MetadataCheckUtils.buildMapRet("EntityMetadata");
            entityMetaDiffInfo.put("number", name);
            entityMetaDiffInfo.put("app", appInfo.get(appId));
            entityMetaDiffInfo.put("version", deploy1.getVersion());
            try {
                if (dataEntityXml1 != null || dataEntityXml2 != null) {
                    String key;
                    CheckMetadataSerializer metaSerializer2 = new CheckMetadataSerializer(modelType);
                    AbstractMetadata entityMeta1 = (AbstractMetadata)metaSerializer2.deserializeFromXml(dataEntityXml1, null);
                    AbstractMetadata entityMeta2 = (AbstractMetadata)metaSerializer2.deserializeFromXml(dataEntityXml2, null);
                    String inheritPath1 = entityMeta1.getInheritPath();
                    String inheritPath2 = entityMeta2.getInheritPath();
                    if (dem1 != null && entityMeta1.getParentId() != null && compareDTO.isEnableTemplate()) {
                        logger.info("EntityMetadata->inheritPath1: " + inheritPath1);
                        logger.info("EntityMetadata->inheritPath2: " + inheritPath2);
                        if (inheritPath1 != null && baseMeta.get(key = (inheritPath1.contains(",") ? inheritPath1.trim().split(",")[0] : inheritPath1) + "entity") != null) {
                            entityMeta1 = (AbstractMetadata)metaSerializer2.deserializeFromXml(dataEntityXml1, baseMeta.get(key));
                        }
                    }
                    if (dem2 != null && entityMeta2.getParentId() != null && compareDTO.isEnableTemplate() && inheritPath2 != null && baseMeta.get(key = (inheritPath2.contains(",") ? inheritPath2.trim().split(",")[0] : inheritPath2) + "entity") != null) {
                        entityMeta2 = (AbstractMetadata)metaSerializer2.deserializeFromXml(dataEntityXml2, baseMeta.get(key));
                    }
                    String entityMetaDiff = metaSerializer2.buildDiffXml(entityMeta1, entityMeta2);
                    entityMetaDiffInfo.put("detail", entityMetaDiff);
                    DcxmlSerializer xmlSerializer2 = new DcxmlSerializer(metaSerializer2.getBinder());
                    EntityMetadataDiff entityDiffPlugin = new EntityMetadataDiff();
                    entityMetaDiffInfo.put("desc", xmlSerializer2.getDiffDesc(entityMetaDiff, (Object)entityMeta2, (IDcDescReadPlugin)entityDiffPlugin));
                    entityMetaDiffInfo.put("compatibility", entityDiffPlugin.isCompatibility());
                    entityMetaDiffInfo.put("diffs", entityDiffPlugin.getDFS());
                    if (!entityDiffPlugin.getDFS().isEmpty()) {
                        logger.info("\u6b63\u5728\u626b\u63cf\u7f16\u7801\u4e3a: " + name + " \u7684\u5143\u6570\u636e");
                    }
                    lstDiffMetaInfos.add(entityMetaDiffInfo);
                }
            }
            catch (Exception e) {
                String error = ResManager.loadKDString((String)"\u5b9e\u4f53\u5143\u6570\u636e\u517c\u5bb9\u6027\u68c0\u67e5\u5f02\u5e38\uff0c\u9519\u8bef\u5185\u5bb9\uff1a", (String)"MetadataCheckUtils_6", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
                logger.error(error, (Throwable)e);
                entityMetaDiffInfo.put("status", "2");
                entityMetaDiffInfo.put("error", error);
                lstDiffMetaInfos.add(entityMetaDiffInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u517c\u5bb9\u6027\u68c0\u67e5\u5f02\u5e38", (Throwable)e);
        }
        return lstDiffMetaInfos;
    }

    private static DeployMetadata getDeployMetadata(String dym) {
        DcxmlSerializer designMetaSerializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        designMetaSerializer.setColloctionIgnorePKValue(true);
        return (DeployMetadata)designMetaSerializer.deserializeFromString(dym, null);
    }

    public static Map<String, Object> buildMapRet(String diffType) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("difftype", diffType);
        result.put("status", "0");
        return result;
    }

    public static String getTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    public static Map<String, Map<String, Object>> getAppInfo(Map<String, Map<String, Object>> appFile) {
        LinkedHashMap<String, Map<String, Object>> appInfos = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> appInfo : appFile.entrySet()) {
            Map<String, Object> value = appInfo.getValue();
            String path1 = (String)value.get("path1");
            String subPath1 = (String)value.get("subpath1");
            String path2 = (String)value.get("path2");
            String subPath2 = (String)value.get("subpath2");
            String appContent = null;
            appContent = path1 == null || subPath1 == null ? FileUtils.getFileContent(path2, subPath2) : FileUtils.getFileContent(path1, subPath1);
            if (appContent == null) continue;
            MetadataCheckUtils.getAppByContent(appInfos, appContent);
        }
        return appInfos;
    }

    public static void getAppByContent(Map<String, Map<String, Object>> appInfos, String content) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployAppMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployAppMetadata deployMeta = (DeployAppMetadata)serializer.deserializeFromString(content, null);
        List designMetas = deployMeta.getDesignMetas();
        String number = null;
        String name = null;
        String appId = null;
        for (AbstractDesignMeta meta : designMetas) {
            if (meta instanceof DesignAppMeta) {
                number = meta.getNumber();
                appId = ((DesignAppMeta)meta).getBizappId();
                continue;
            }
            if (!(meta instanceof DesignAppMetaL)) continue;
            name = ((DesignAppMetaL)meta).getName();
        }
        if (appId != null) {
            LinkedHashMap<String, String> value = new LinkedHashMap<String, String>();
            value.put(number, name);
            appInfos.put(appId, value);
        }
    }
}

