/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.metadatascan.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MetadataRefCheckUtils {
    private static final Log logger = LogFactory.getLog(MetadataRefCheckUtils.class);

    public static String checkRefMetadata(List<Map<String, Object>> diffMetas) {
        StringBuilder builder = new StringBuilder();
        for (Map<String, Object> diffMeta : diffMetas) {
            String number = String.valueOf(diffMeta.get("number"));
            String desc = String.valueOf(diffMeta.get("desc"));
            List<String> alterFields = MetadataRefCheckUtils.findAlterFields(desc);
            if (!number.contains(".dym")) continue;
            String mainentity = number.split("\\.")[0];
            String idByNumber = MetadataDao.getIdByNumber((String)mainentity, (MetaCategory)MetaCategory.Entity);
            QFilter filter = new QFilter("bizappid.bizcloud.number", "in", (Object)Lists.newArrayList((Object[])new String[]{"MPSCMM", "MMC"}));
            DynamicObjectCollection objects = QueryServiceHelper.query((String)"bos_entityobject", (String)"id,name,bizappid.number,number", (QFilter[])filter.toArray());
            Set numbers = objects.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
            Map<String, String> namemap = objects.stream().collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("name")));
            Map<String, String> appmap = objects.stream().collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("bizappid.number")));
            for (String entitynumber : numbers) {
                try {
                    List collect;
                    HashMap collect2;
                    EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)entitynumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
                    boolean b = entityMetadata.getItems().stream().anyMatch(e -> {
                        BasedataField basedataField;
                        boolean match = false;
                        if (e instanceof BasedataField && Objects.nonNull((basedataField = (BasedataField)e).getBaseEntityId())) {
                            match = basedataField.getBaseEntityId().equals(idByNumber);
                        }
                        return match;
                    });
                    if (!b || (collect2 = (collect = entityMetadata.getItems().stream().filter(e -> {
                        BasedataField basedataField;
                        boolean match = false;
                        if (e instanceof BasedataField && Objects.nonNull((basedataField = (BasedataField)e).getBaseEntityId())) {
                            match = basedataField.getBaseEntityId().equals(idByNumber);
                        }
                        return match;
                    }).collect(Collectors.toList())).stream().collect(HashMap::new, (m1, e1) -> {
                        if (e1 instanceof BasedataField) {
                            BasedataField basedataField = (BasedataField)e1;
                            List refProps = basedataField.getRefProps();
                            if (alterFields.stream().anyMatch(a -> refProps.stream().anyMatch(r -> r.getName().contains((CharSequence)a)))) {
                                List collect1 = refProps.stream().map(p -> p.getName()).collect(Collectors.toList());
                                m1.put(basedataField.getKey(), Joiner.on((String)",").join(collect1));
                            }
                        }
                    }, (m2, m1) -> m2.putAll(m1))).isEmpty()) continue;
                    String formatstr = ResManager.loadKDString((String)"\u5143\u6570\u636e\uff08%1$s\uff09\u5b57\u6bb5\uff08%2$s\uff09\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u8bc4\u4f30\u662f\u5426\u5bf9\u5e94\u7528\uff08%3$s\uff09\u4e0b\u5143\u6570\u636e\uff08%4$s\uff09\u5b57\u6bb5\uff08%5$s\uff09\u7684\u5f15\u7528\u5c5e\u6027\u4ea7\u751f\u5f71\u54cd\u3002", (String)"MetadataRefCheckUtils_1", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
                    String result = String.format(formatstr, number, Joiner.on((String)",").join(alterFields), appmap.get(entitynumber), entitynumber, Joiner.on((String)",").join(collect2.keySet()));
                    builder.append(result);
                }
                catch (Exception e2) {
                    logger.error(e2.getMessage(), (Throwable)e2);
                }
            }
        }
        return builder.toString();
    }

    private static List<String> findAlterFields(String desc) {
        ArrayList<String> ls = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\((.*?)\\)");
        Matcher matcher = pattern.matcher(desc);
        while (matcher.find()) {
            String match = matcher.group(1);
            ls.add(match);
        }
        return ls;
    }
}

