/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.mrp;

import java.util.Date;
import java.util.Map;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msplan.mservice.service.mrp.runner.CacheManager;
import kd.mpscmm.msplan.mservice.service.mrp.runner.IExecuteLogRecorder;
import kd.mpscmm.msplan.mservice.service.mrp.runner.StepLogRecorder;

public class ExecutionEnv {
    private boolean isMasterStopped = false;
    private boolean isWorkerStopped = false;
    private boolean isManuStopped = false;
    private String logEntityNumber;
    private DynamicObject runLog;
    private IExecuteLogRecorder logRecorder;
    private ORM orm;
    private Map<String, String> params;
    private Long runLogId;

    private ExecutionEnv(String logEntityNumber) {
        this.logEntityNumber = logEntityNumber;
        this.orm = ORM.create();
        this.runLog = ORM.create().newDynamicObject(logEntityNumber);
        this.runLogId = this.orm.genLongId(logEntityNumber);
        this.runLog.set("id", (Object)this.runLogId);
        this.runLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        this.runLog.set("calculatestatus", (Object)"D");
        this.runLog.set("ctrlstrategy", (Object)"7");
        String number = CodeRuleServiceHelper.getNumber((String)logEntityNumber, (DynamicObject)this.runLog, (String)String.valueOf(RequestContext.get().getOrgId()));
        this.runLog.set("number", (Object)number);
        this.runLog.set("startdate", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.runLog});
        this.initLogRecorder();
    }

    private ExecutionEnv(String logEntityNumber, Long envId) {
        this.logEntityNumber = logEntityNumber;
        this.orm = ORM.create();
        this.runLog = this.orm.queryOne(logEntityNumber, new QFilter[]{new QFilter("id", "=", (Object)envId)});
        this.runLogId = envId;
        this.loadCacheParams();
        this.initLogRecorder();
    }

    private void initLogRecorder() {
        this.logRecorder = new StepLogRecorder(this.orm, this.runLog);
    }

    public static ExecutionEnv initEnvByMaster(String logEntityNumber) {
        return new ExecutionEnv(logEntityNumber);
    }

    public static ExecutionEnv loadEnv(String logEntityNumber, Long envId) {
        return new ExecutionEnv(logEntityNumber, envId);
    }

    public void setMasterStopped() {
        this.isMasterStopped = true;
    }

    public void setManuStopped() {
        this.isManuStopped = true;
    }

    public boolean isManuStopped() {
        return this.isManuStopped;
    }

    public void setWorkerStopped() {
        this.isWorkerStopped = true;
    }

    public void testEnvStatus() {
        if (this.isManuStopped) {
            throw new KDBizException("manu stopped.");
        }
        if (this.isWorkerStopped) {
            throw new KDBizException("worker stopped.");
        }
        if (this.isMasterStopped) {
            throw new KDBizException("master stopped.");
        }
    }

    public String getLogEntityNumber() {
        return this.logEntityNumber;
    }

    public Long getCtxId() {
        return this.runLog.getLong("id");
    }

    public IExecuteLogRecorder createLogRecorder() {
        return this.logRecorder;
    }

    public DynamicObject getRunLog() {
        return this.runLog;
    }

    public Map<String, String> getParams() {
        if (this.params == null) {
            this.loadCacheParams();
        }
        return this.params;
    }

    public String getParam(String key) {
        String value;
        if (this.params == null) {
            this.loadCacheParams();
        }
        value = StringUtils.isEmpty((CharSequence)(value = this.params.get(key))) ? "" : value;
        return value;
    }

    public final void loadCacheParams() {
        DistributeSessionlessCache cache = CacheManager.getCache();
        this.params = cache.getAll(this.getCacheKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCache() {
        DistributeSessionlessCache cache = CacheManager.getCache();
        String lockKey = String.format("ExecutionEnv-%s-%d", this.logEntityNumber, this.runLogId);
        DLock lock = DLock.create((String)lockKey, (String)lockKey);
        lock.lock();
        try {
            cache.put(this.getCacheKey(), this.params);
        }
        finally {
            lock.unlock();
        }
    }

    public void clearCache() {
        DistributeSessionlessCache cache = CacheManager.getCache();
        cache.remove(this.getCacheKey());
    }

    private String getCacheKey() {
        return String.format("msStepCache-%d", this.runLogId);
    }
}

