/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.mrp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.mpscmm.msplan.mservice.mrp.api.IMRPBOMCheckService;
import kd.mpscmm.msplan.mservice.service.mrp.TNode;

public class MRPBOMCheckServiceImpl
implements IMRPBOMCheckService {
    public String bomCyclicCheck(String bomJson) {
        JSONObject jsonObject;
        JSONObject result = new JSONObject();
        JSONArray datas = new JSONArray();
        result.put("success", (Object)"1");
        result.put("data", (Object)datas);
        if (StringUtils.isBlank((CharSequence)bomJson)) {
            throw new KDBizException("bomJson is empty.");
        }
        JSONArray boms = JSONArray.parseArray((String)bomJson);
        HashMap<String, TNode> nodes = new HashMap<String, TNode>();
        HashMap<String, Set> mGroups = new HashMap<String, Set>();
        ArrayList<Set> groups = new ArrayList<Set>(10);
        HashMap<String, List<Integer>> pid2Rows = new HashMap<String, List<Integer>>(boms.size());
        HashMap<String, List<Integer>> cid2Rows = new HashMap<String, List<Integer>>(boms.size());
        HashMap<String, Map<Long, List<Integer>>> bomId2Rows = new HashMap<String, Map<Long, List<Integer>>>(boms.size());
        for (int i = 0; i < boms.size(); ++i) {
            Object obj = boms.get(i);
            if (!(obj instanceof JSONObject)) continue;
            jsonObject = (JSONObject)obj;
            String cId = String.valueOf(jsonObject.get((Object)"entrymaterialid"));
            String pId = String.valueOf(jsonObject.get((Object)"materialid"));
            Long replaceId = jsonObject.containsKey((Object)"entryreplaceplan") ? jsonObject.getLong("entryreplaceplan") : 0L;
            if (replaceId > 0L) {
                Set group = mGroups.computeIfAbsent(replaceId.toString(), k -> new HashSet(5));
                group.add(cId);
                Map map = bomId2Rows.computeIfAbsent(String.valueOf(jsonObject.get((Object)"id")), k -> new HashMap(4));
                List bomRows = map.computeIfAbsent(replaceId, k -> new ArrayList(16));
                bomRows.add(i);
            }
            List pRows = pid2Rows.computeIfAbsent(pId, k -> new ArrayList(16));
            pRows.add(i);
            List cRows = cid2Rows.computeIfAbsent(cId, k -> new ArrayList(16));
            cRows.add(i);
        }
        for (Set group : mGroups.values()) {
            if (groups.isEmpty()) {
                groups.add(group);
                continue;
            }
            HashSet merge = new HashSet(group);
            ArrayList<Set> copyGroups = new ArrayList<Set>(10);
            for (int i = 0; i < groups.size(); ++i) {
                Set old = (Set)groups.get(i);
                boolean isInteracted = false;
                for (String mId : group) {
                    if (!old.contains(mId)) continue;
                    isInteracted = true;
                    break;
                }
                if (isInteracted) {
                    merge.addAll(old);
                    continue;
                }
                copyGroups.add(old);
            }
            if (copyGroups.size() != groups.size()) {
                copyGroups.add(merge);
                groups = copyGroups;
                continue;
            }
            groups.add(group);
        }
        for (Object obj : boms) {
            String cId;
            String pId;
            if (!(obj instanceof JSONObject) || (pId = String.valueOf((jsonObject = (JSONObject)obj).get((Object)"materialid"))).equals(cId = String.valueOf(jsonObject.get((Object)"entrymaterialid")))) continue;
            this.buildStruct(nodes, pId, cId, jsonObject, boms, datas, pid2Rows, cid2Rows);
        }
        HashSet<String> check = new HashSet<String>(16);
        ArrayList<TNode> cycleChecker = new ArrayList<TNode>();
        for (Set group : groups) {
            check.clear();
            for (String m1 : group) {
                for (String m2 : group) {
                    if (StringUtils.equals((CharSequence)m1, (CharSequence)m2)) continue;
                    TNode n1 = nodes.get(m1);
                    TNode n2 = nodes.get(m2);
                    if (n1 == null || n2 == null) continue;
                    String key1 = String.format("%s\u0001\u0001\u0001%s", m1, m2);
                    String key2 = String.format("%s\u0001\u0001\u0001%s", m2, m1);
                    cycleChecker.clear();
                    if (check.contains(key1) || check.contains(key2)) continue;
                    if (TNode.isAncestor(n1, n2, cycleChecker)) {
                        this.appendReplaceErrorMsg(cycleChecker, group, m2, datas, boms, pid2Rows, cid2Rows, bomId2Rows);
                    } else if (TNode.isAncestor(n2, n1, cycleChecker)) {
                        this.appendReplaceErrorMsg(cycleChecker, group, m1, datas, boms, pid2Rows, cid2Rows, bomId2Rows);
                    }
                    check.add(key1);
                    check.add(key2);
                }
            }
        }
        return result.toJSONString();
    }

    private void appendReplaceErrorMsg(List<TNode> cycleChecker, Set<String> group, String cId, JSONArray datas, JSONArray boms, Map<String, List<Integer>> pid2Rows, Map<String, List<Integer>> cid2Rows, Map<String, Map<Long, List<Integer>>> bomId2Rows) {
        ArrayList<String> mIds = new ArrayList<String>(cycleChecker.size());
        for (TNode n : cycleChecker) {
            mIds.add(n.toString());
        }
        JSONObject newObj = this.appendMaterialMsg(new ArrayList<String>(group), datas);
        HashSet check = new HashSet(group.size());
        ArrayList<JSONObject> currentEntrys = new ArrayList<JSONObject>(16);
        for (String c : group) {
            if (check.contains(c)) continue;
            List<Integer> list = cid2Rows.get(c);
            if (list != null) {
                for (Integer idx : list) {
                    Map<Long, List<Integer>> map = bomId2Rows.get(String.valueOf(boms.getJSONObject(idx.intValue()).get((Object)"id")));
                    if (map == null) continue;
                    for (List<Integer> entry : map.values()) {
                        boolean isMatch = true;
                        ArrayList<JSONObject> current = new ArrayList<JSONObject>(entry.size());
                        HashSet<String> currentCheck = new HashSet<String>(entry.size());
                        for (Integer i : entry) {
                            JSONObject bom = boms.getJSONObject(i.intValue());
                            String mid = String.valueOf(bom.get((Object)"entrymaterialid"));
                            if (!group.contains(mid)) {
                                isMatch = false;
                                break;
                            }
                            current.add(bom);
                            currentCheck.add(mid);
                        }
                        if (!isMatch) continue;
                        currentEntrys.addAll(current);
                        check.addAll(currentCheck);
                    }
                }
            }
            check.add(c);
        }
        this.appendErrorMsg(cId, mIds, currentEntrys, newObj, boms, pid2Rows, cid2Rows);
    }

    private void buildStruct(HashMap<String, TNode> nodes, String pId, String cId, JSONObject jsonObject, JSONArray boms, JSONArray datas, Map<String, List<Integer>> pid2Rows, Map<String, List<Integer>> cid2Rows) {
        TNode cn;
        TNode pn;
        ArrayList<TNode> cycleChecker = new ArrayList<TNode>();
        boolean isCheck = true;
        if (nodes.containsKey(pId)) {
            pn = nodes.get(pId);
            if (nodes.containsKey(cId)) {
                cn = nodes.get(cId);
                int cLevel = cn.getLevel();
                int pLevel = pn.getLevel();
                if (pLevel > cLevel && TNode.isAncestor(pn, cn, cycleChecker)) {
                    ArrayList<String> mIds = new ArrayList<String>(cycleChecker.size());
                    for (TNode n : cycleChecker) {
                        mIds.add(n.toString());
                    }
                    ArrayList<String> all = new ArrayList<String>(2);
                    all.add(pId);
                    all.add(cId);
                    JSONObject newObj = this.appendMaterialMsg(all, datas);
                    this.appendErrorMsg(cId, mIds, Collections.singletonList(jsonObject), newObj, boms, pid2Rows, cid2Rows);
                    isCheck = false;
                }
            } else {
                cn = new TNode(cId);
            }
        } else {
            pn = new TNode(pId);
            cn = nodes.containsKey(cId) ? nodes.get(cId) : new TNode(cId);
        }
        if (isCheck) {
            pn.addChild(cn);
        }
        nodes.put(cId, cn);
        nodes.put(pId, pn);
    }

    private JSONObject appendMaterialMsg(List<String> all, JSONArray datas) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("materials", all);
        datas.add((Object)jsonObject);
        return jsonObject;
    }

    private void appendErrorMsg(String cId, List<String> mIds, List<JSONObject> currentEntrys, JSONObject newObj, JSONArray boms, Map<String, List<Integer>> pid2Rows, Map<String, List<Integer>> cid2Rows) {
        String p = cId;
        ArrayList<JSONObject> list = new ArrayList<JSONObject>(mIds.size());
        newObj.put("boms", list);
        for (String c : mIds) {
            HashSet rows = new HashSet(pid2Rows.getOrDefault(p, new ArrayList(2)));
            ArrayList<Integer> cRows = new ArrayList<Integer>(rows.size());
            for (Integer idx : (List)cid2Rows.getOrDefault(c, new ArrayList(2))) {
                if (!rows.contains(idx)) continue;
                cRows.add(idx);
            }
            for (Integer idx : cRows) {
                list.add(boms.getJSONObject(idx.intValue()));
            }
            p = c;
        }
        list.addAll(currentEntrys);
    }
}

