/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.mrp;

import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msplan.mservice.mrp.api.IMRPCalcRuntimeService;
import kd.mpscmm.msplan.mservice.service.datasync.utils.DataSyncUtils;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.runner.CacheManager;
import kd.mpscmm.msplan.mservice.service.mrp.runner.CalcStateManager;
import kd.mpscmm.msplan.mservice.service.mrp.runner.ConfigStepMSRunner;
import kd.mpscmm.msplan.mservice.service.mrp.step.ICalcStep;

public class MRPCalcRuntimeService
implements IMRPCalcRuntimeService {
    private static final Log logger = LogFactory.getLog(MRPCalcRuntimeService.class);

    public Long initRuntime(String logEntityNumber) {
        ExecutionEnv ctx = ExecutionEnv.initEnvByMaster(logEntityNumber);
        return ctx.getCtxId();
    }

    public Long startCalc(Long bizPlanId, Long planOrgId, String planOrgName, String runMode, String runModeName, String logEntityNumber) {
        return new ConfigStepMSRunner(bizPlanId, planOrgId, planOrgName, runMode, runModeName).run(logEntityNumber);
    }

    public Long startCalc(Long ctxId, Long bizPlanId, Long planOrgId, String planOrgName, String runMode, String runModeName, String logEntityNumber) {
        return new ConfigStepMSRunner(bizPlanId, planOrgId, planOrgName, runMode, runModeName).run(logEntityNumber, ctxId);
    }

    public void stopCalc(Long envId) {
        CalcStateManager.setManuTerminated(String.valueOf(envId));
    }

    public String runStep(String stepImplClass, int stepIdx, String logEntityNumber, Long envId) {
        String runStepId = ID.genStringId();
        DistributeSessionlessCache cache = CacheManager.getCache();
        ExecutionEnv ctx = ExecutionEnv.loadEnv(logEntityNumber, envId);
        CalcStateManager manager = new CalcStateManager(ctx);
        manager.startWorkerCheckThread(runStepId);
        ThreadPools.executeOnce((String)"MRPCalcRuntimeService:runStep", () -> {
            String calcMsg = "";
            String success = "true";
            try {
                calcMsg = MRPCalcRuntimeService.doRunStep(manager, ctx, stepImplClass, stepIdx, logEntityNumber, envId, runStepId);
            }
            catch (Throwable e) {
                calcMsg = e.getMessage();
                success = "false";
            }
            cache.put(runStepId + "msg", (Object)(calcMsg + ""));
            cache.put(runStepId, (Object)success);
        });
        return runStepId;
    }

    private static String doRunStep(CalcStateManager manager, ExecutionEnv ctx, String stepImplClass, int stepIdx, String logEntityNumber, Long envId, String runStepId) {
        try {
            Class<?> localStepClass = Class.forName(stepImplClass);
            Object inst = localStepClass.newInstance();
            if (inst instanceof ICalcStep) {
                ICalcStep localStep = (ICalcStep)inst;
                String calcMsg = localStep.doWork(ctx, stepIdx);
                ctx.refreshCache();
                String string = calcMsg;
                return string;
            }
            try {
                throw new KDBizException("wrong impl");
            }
            catch (Throwable e) {
                logger.error("--------mrprunner-remote-ms-call-failed----------", e);
                manager.setTerminated(DataSyncUtils.getStackTrace(e));
                throw new KDBizException("error");
            }
        }
        finally {
            manager.stopWorkerThread();
        }
    }
}

