/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.mrp.planorder;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.common.cache.PlanOrderCacheMrg;
import kd.mpscmm.common.consts.DropPlanOrderConst;
import kd.mpscmm.common.consts.PlanOrderConst;
import kd.mpscmm.common.entity.planorder.PushOrderResult;
import kd.mpscmm.msplan.mrp.business.helper.BOTPHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mservice.mrp.algoregister.api.IDropDataCtrlService;
import kd.mpscmm.msplan.mservice.mrp.planorder.api.IPlanOrderDropService;

public class PlanOrderDropServiceImpl
implements IPlanOrderDropService {
    private static final Log log = LogFactory.getLog(PlanOrderDropServiceImpl.class);
    private static final String MRP_DROPPLANORDERLOG = "mrp_dropplanorderlog";

    public void canelDropPlanOrder(List<Long> targetOrderIds, String entityNumber) {
        if (targetOrderIds == null || targetOrderIds.size() <= 0) {
            return;
        }
        DynamicObject[] loginfos = BusinessDataServiceHelper.load((String)MRP_DROPPLANORDERLOG, (String)"billno,dropqty,planorderid,dropstatus,targetorderid,targetorder,soureorder", (QFilter[])new QFilter[]{new QFilter("targetorderid", "in", targetOrderIds)});
        HashMap<Long, Boolean> isCanelMap = new HashMap<Long, Boolean>(loginfos.length);
        HashMap datas = new HashMap(loginfos.length);
        ArrayList<Long> planOrderIds = new ArrayList<Long>(loginfos.length);
        for (DynamicObject loginfo : loginfos) {
            if (DropPlanOrderConst.DropStatusEnum.C.name().equals(loginfo.getString("dropstatus"))) {
                isCanelMap.put(loginfo.getLong("targetorderid"), Boolean.TRUE);
                continue;
            }
            if (!DropPlanOrderConst.DropStatusEnum.D.name().equals(loginfo.getString("dropstatus"))) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("billno", loginfo.getString("billno"));
            data.put("dropqty", loginfo.getBigDecimal("dropqty"));
            data.put("targetorderid", loginfo.getLong("targetorderid"));
            data.put("targetorder", loginfo.getLong("targetorder"));
            data.put("soureorder", loginfo.getLong("soureorder"));
            datas.put(loginfo.getLong("targetorderid") + "_" + loginfo.getLong("planorderid"), data);
            planOrderIds.add(loginfo.getLong("planorderid"));
        }
        if (datas == null || datas.size() <= 0) {
            return;
        }
        try (TXHandle h0 = TX.requiresNew();){
            try {
                String selectFields = "id,billno,dropstatus,schedule,qty,billstatus,materialspread,entryentity,proorpurorg,bom,orderqty,unfoldbomdate,startdate,material,dropqty,ordertype,tracknumber,billtype,org,planscope,unit,configuredcode,supplier,planoperatenum";
                DynamicObject[] planOrders = BusinessDataServiceHelper.load((String)entityNumber, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", planOrderIds)});
                HashMap<Long, DynamicObject> planOrderMaps = new HashMap<Long, DynamicObject>(planOrders.length);
                for (DynamicObject planOrder : planOrders) {
                    Long orderId = planOrder.getLong("id");
                    planOrderMaps.put(orderId, planOrder);
                }
                HashMap<Long, Map> dropLogMap = new HashMap<Long, Map>(datas.size());
                ArrayList<DynamicObject> planOrderLists = new ArrayList<DynamicObject>(datas.size());
                for (Map.Entry data : datas.entrySet()) {
                    String key = (String)data.getKey();
                    String[] id = key.split("_");
                    Long targetorderid = Long.valueOf(id[0]);
                    Boolean isCanel = (Boolean)isCanelMap.get(targetorderid);
                    if (isCanel != null && isCanel.booleanValue()) continue;
                    HashMap<Long, Map> repeatdropLogMap = new HashMap<Long, Map>(datas.size());
                    Long planorderid = Long.valueOf(id[1]);
                    Map repeatdropLog = (Map)dropLogMap.get(planorderid);
                    Map dropLog = (Map)data.getValue();
                    DynamicObject planOrder = (DynamicObject)planOrderMaps.get(planorderid);
                    PlanOrderHelper.updateDropLogInfo((Map)dropLog, (DynamicObject)planOrder);
                    BigDecimal qty = (BigDecimal)dropLog.get("dropqty");
                    BigDecimal dropQty = planOrder.getBigDecimal("dropqty");
                    String billstatus = planOrder.getString("billstatus");
                    String schedule = planOrder.getString("schedule");
                    BigDecimal newdropQty = dropQty.subtract(qty);
                    if ("D".equals(billstatus)) {
                        planOrder.set("billstatus", (Object)BillStatus.C.name());
                    }
                    if (dropQty.compareTo(qty) < 0) continue;
                    planOrder.set("dropqty", (Object)newdropQty);
                    if (newdropQty.compareTo(BigDecimal.ZERO) > 0) {
                        planOrder.set("dropstatus", (Object)PlanOrderConst.DropStatusEnum.C.name());
                    } else if (newdropQty.compareTo(BigDecimal.ZERO) == 0) {
                        planOrder.set("dropstatus", (Object)PlanOrderConst.DropStatusEnum.A.name());
                    }
                    if (StringUtils.isNotBlank((CharSequence)schedule)) {
                        planOrder.set("schedule", (Object)" ");
                    }
                    planOrderLists.add(planOrder);
                    if (repeatdropLog == null) {
                        dropLogMap.put(planorderid, dropLog);
                    } else {
                        repeatdropLogMap.put(planorderid, dropLog);
                    }
                    PlanOrderHelper.recordDropPlanorderLog(repeatdropLogMap, (String)DropPlanOrderConst.DropStatusEnum.C.name(), (String)" ");
                }
                PlanOrderHelper.recordDropPlanorderLog(dropLogMap, (String)DropPlanOrderConst.DropStatusEnum.C.name(), (String)" ");
                SaveServiceHelper.save((DynamicObject[])planOrderLists.toArray(new DynamicObject[0]));
            }
            catch (Throwable throwable) {
                h0.markRollback();
                if (h0 != null) {
                    if (var8_9 != null) {
                        try {
                            h0.close();
                        }
                        catch (Throwable throwable2) {
                            var8_9.addSuppressed(throwable2);
                        }
                    } else {
                        h0.close();
                    }
                }
                return;
            }
        }
    }

    public Map<String, Object> dropPlanOrder(List<Long> orderIds, String entityNumber, DynamicObject dropConfigure, Map<Long, BigDecimal> planOrderIdQty) {
        return this.dropPlanOrder(orderIds, entityNumber, dropConfigure, planOrderIdQty, null);
    }

    public Map<String, Object> dropPlanOrder(List<Long> orderIds, String entityNumber, DynamicObject dropConfigure, Map<Long, BigDecimal> planOrderIdQty, ConvertRuleElement loadRule) {
        Long proorpurorg;
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        StringBuilder selectfield = new StringBuilder("id,billno,dropstatus,schedule,qty,billstatus,materialspread,entryentity,proorpurorg,bom,orderqty,unfoldbomdate,startdate,material,dropqty,ordertype,tracknumber,billtype,org,planscope,unit,configuredcode,supplier,planoperatenum");
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)entityNumber, (String)selectfield.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", orderIds)});
        if (orders == null || orders.length == 0) {
            return result;
        }
        HashMap<Long, String> errorMap = new HashMap<Long, String>(8);
        result.put("error", errorMap);
        ArrayList<Long> successIds = new ArrayList<Long>(100);
        result.put("success", successIds);
        HashMap<Long, Map> orgOrderIdByTypeMaps = new HashMap<Long, Map>(orders.length);
        HashMap orderIdByTypeMaps = Maps.newHashMapWithExpectedSize((int)orders.length);
        HashMap<Long, String> orderIdNumberMap = new HashMap<Long, String>(orders.length);
        HashMap<String, ConvertRuleElement> orderIdloadRuleMap = new HashMap<String, ConvertRuleElement>(orders.length);
        Long defOrg = 0L;
        Map<Long, DynamicObject> orderMap = Arrays.stream(orders).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        for (DynamicObject order : orders) {
            String ordertype = order.getString("ordertype");
            if (StringUtils.isBlank((CharSequence)ordertype)) continue;
            Long orderId = order.getLong("id");
            List planorderIds = orderIdByTypeMaps.computeIfAbsent(ordertype, k -> new ArrayList());
            planorderIds.add(orderId);
            proorpurorg = order.getDynamicObject("proorpurorg").getLong("id");
            Map orgDataMap = orgOrderIdByTypeMaps.computeIfAbsent(proorpurorg, k -> new HashMap());
            List list = orgDataMap.computeIfAbsent(ordertype, k -> new ArrayList());
            list.add(orderId);
            orgDataMap.put(ordertype, list);
            orderIdNumberMap.put(orderId, order.getString("billno"));
            orgOrderIdByTypeMaps.put(proorpurorg, orgDataMap);
            if (loadRule != null) {
                orderIdloadRuleMap.put(ordertype, loadRule);
            }
            defOrg = proorpurorg;
        }
        boolean isDefDropConfigure = false;
        if (dropConfigure != null) {
            isDefDropConfigure = true;
        }
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = new QFilter("createorg", "in", orgOrderIdByTypeMaps.keySet());
        QFilter qFilterCtrlstrategy = new QFilter("ctrlstrategy", "=", (Object)"7");
        if (orgOrderIdByTypeMaps.size() > 1 && QueryServiceHelper.exists((String)"msplan_dropconfigure", (QFilter[])new QFilter[]{qFilterOrg, qFilterStatus, qFilterEnable, qFilterCtrlstrategy})) {
            for (Map.Entry map : orgOrderIdByTypeMaps.entrySet()) {
                proorpurorg = (Long)map.getKey();
                if (!isDefDropConfigure) {
                    dropConfigure = PlanOrderHelper.getDropConfigure((Long)proorpurorg, null);
                }
                if (dropConfigure == null) {
                    String error = ResManager.loadKDString((String)"\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u6295\u653e\u914d\u7f6e\u3002", (String)"PlanOrderDropServiceImpl_0", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
                    HashMap<Long, String> hashMap = new HashMap<Long, String>(((Map)map.getValue()).size());
                    for (List planorderIds : ((Map)map.getValue()).values()) {
                        this.setError(error, planorderIds, orderIdNumberMap, errorMap, hashMap);
                    }
                    PlanOrderHelper.recordDropFailLog(orderIds, hashMap, orderMap, (String)entityNumber, planOrderIdQty);
                    continue;
                }
                for (Map.Entry entry : ((Map)map.getValue()).entrySet()) {
                    String ordertype = (String)entry.getKey();
                    List orderIdsList = (List)entry.getValue();
                    this.dealPlanOrderByOrderType(proorpurorg, ordertype, orderIdsList, orderIdloadRuleMap, dropConfigure, orderIds, orderMap, entityNumber, planOrderIdQty, orderIdNumberMap, errorMap, selectfield, successIds, loadRule);
                }
            }
        } else {
            for (Map.Entry entry : orderIdByTypeMaps.entrySet()) {
                if (!isDefDropConfigure) {
                    dropConfigure = PlanOrderHelper.getDropConfigure((Long)defOrg, null);
                }
                if (dropConfigure == null) {
                    String error = ResManager.loadKDString((String)"\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u6295\u653e\u914d\u7f6e\u3002", (String)"PlanOrderDropServiceImpl_0", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
                    HashMap<Long, String> errMapToLog = new HashMap<Long, String>(orderIdByTypeMaps.size());
                    this.setError(error, (List)entry.getValue(), orderIdNumberMap, errorMap, errMapToLog);
                    PlanOrderHelper.recordDropFailLog(orderIds, errMapToLog, orderMap, (String)entityNumber, planOrderIdQty);
                    continue;
                }
                String ordertype = (String)entry.getKey();
                List orderIdsList = (List)entry.getValue();
                this.dealPlanOrderByOrderType(defOrg, ordertype, orderIdsList, orderIdloadRuleMap, dropConfigure, orderIds, orderMap, entityNumber, planOrderIdQty, orderIdNumberMap, errorMap, selectfield, successIds, loadRule);
            }
        }
        return result;
    }

    private void dealPlanOrderByOrderType(Long proorpurorg, String ordertype, List<Long> orderIdsList, Map<String, ConvertRuleElement> orderIdloadRuleMap, DynamicObject dropConfigure, List<Long> orderIds, Map<Long, DynamicObject> orderMap, String entityNumber, Map<Long, BigDecimal> planOrderIdQty, Map<Long, String> orderIdNumberMap, Map<Long, String> errorMap, StringBuilder selectfield, List<Long> successIds, ConvertRuleElement loadRule) {
        String targetEntity = null;
        if (orderIdloadRuleMap.get(ordertype) == null) {
            targetEntity = PlanOrderHelper.getTargetEntityByorderType((String)ordertype, (DynamicObject)dropConfigure);
            List rules = BOTPHelper.getRules((String)entityNumber, (String)targetEntity);
            Map ruleIds = BOTPHelper.excludeConvertRule((List)rules, orderIdsList, (String)entityNumber);
            if (orderIdsList != null && orderIdsList.size() > 0) {
                String error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u5339\u914d\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u6216\u8005\u539f\u59cb\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528\u3002", (String)"PlanOrderDropServiceImpl_1", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
                HashMap<Long, String> errMapToLog = new HashMap<Long, String>(orderIdsList.size());
                this.setError(error, orderIdsList, orderIdNumberMap, errorMap, errMapToLog);
                PlanOrderHelper.recordDropFailLog(orderIds, errMapToLog, orderMap, (String)entityNumber, planOrderIdQty);
                return;
            }
            for (Map.Entry rule : ruleIds.entrySet()) {
                ConvertRuleElement key = (ConvertRuleElement)rule.getKey();
                ArrayList<Long> planorderIds = new ArrayList<Long>((Collection)rule.getValue());
                this.dealLoadRuleData(key, planorderIds, orderIdNumberMap, errorMap, entityNumber, planOrderIdQty, selectfield, successIds, dropConfigure, orderMap);
            }
        } else {
            this.dealLoadRuleData(loadRule, orderIdsList, orderIdNumberMap, errorMap, entityNumber, planOrderIdQty, selectfield, successIds, dropConfigure, orderMap);
        }
    }

    private void dealLoadRuleData(ConvertRuleElement loadRule, List<Long> orderIdsList, Map<Long, String> orderIdNumberMap, Map<Long, String> errorMap, String entityNumber, Map<Long, BigDecimal> planOrderIdQty, StringBuilder selectfield, List<Long> successIds, DynamicObject dropConfigure, Map<Long, DynamicObject> orderMap) {
        String billtoconfig = loadRule.getId();
        String targetEntity = loadRule.getTargetEntityNumber();
        List planOrderIds = new ArrayList(orderIdsList.size());
        String sourceLoadField = PlanOrderHelper.getSourceLoadField((ConvertRuleElement)loadRule);
        if (StringUtils.isBlank((CharSequence)sourceLoadField)) {
            String error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u4e0b\u6e38\u5355\u636e\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u7684\u8f6c\u6362\u89c4\u5219\u672a\u8bbe\u7f6e\u6765\u6e90\u5b57\u6bb5\uff0c\u8bf7\u53c2\u8003\u9884\u8bbe\u8f6c\u6362\u89c4\u5219\u914d\u7f6e\u3002", (String)"PlanOrderDropServiceImpl_2", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
            HashMap<Long, String> errMapToLog = new HashMap<Long, String>(orderIdsList.size());
            this.setError(error, orderIdsList, orderIdNumberMap, errorMap, errMapToLog);
            PlanOrderHelper.recordDropFailLog(orderIdsList, errMapToLog, orderMap, (String)entityNumber, planOrderIdQty);
            return;
        }
        HashMap<Long, BigDecimal> planOrderIdQtyMap = new HashMap(orderIdsList.size());
        if (planOrderIdQty != null && planOrderIdQty.size() > 0) {
            planOrderIdQtyMap = planOrderIdQty;
        }
        HashMap<Long, Map<String, Object>> dropLogMap = new HashMap<Long, Map<String, Object>>(orderIdsList.size());
        PushOrderResult dropPlanOrderResult = PlanOrderHelper.dropPlanOrder(orderIdsList, (String)entityNumber, (String)selectfield.toString(), planOrderIdQtyMap, dropLogMap, (String)targetEntity);
        Map errors = dropPlanOrderResult.getErrorMap();
        String type = PlanOrderCacheMrg.getType4PlanOrderDropStatus();
        if (errors != null && errors.size() > 0) {
            errorMap.putAll(errors);
            this.updateFailResultInfo(errors, type);
        }
        planOrderIds = dropPlanOrderResult.getPlanOrderIds();
        DynamicObject[] planorders = BusinessDataServiceHelper.load((String)entityNumber, (String)selectfield.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", planOrderIds)});
        if (planorders != null && planorders.length > 0) {
            this.doBizOp(planorders, type, planOrderIdQtyMap, orderIdNumberMap, dropLogMap, billtoconfig, targetEntity, successIds, errorMap, entityNumber, sourceLoadField, dropConfigure, loadRule);
        }
    }

    private void setError(String error, List<Long> orderIdsList, Map<Long, String> orderIdNumberMap, Map<Long, String> errorMap, Map<Long, String> errorMapToLog) {
        for (Long orderId : orderIdsList) {
            String number = orderIdNumberMap.get(orderId);
            errorMap.put(orderId, String.format(error, number));
            errorMapToLog.put(orderId, String.format(error, number));
        }
    }

    private void doBizOp(DynamicObject[] orders, String type, Map<Long, BigDecimal> planOrderIdQtyMap, Map<Long, String> planOrderIdBillNo, Map<Long, Map<String, Object>> dropLogMap, String billtoconfig, String targetEntity, List<Long> successIds, Map<Long, String> errorMap, String entityNumber, String sourceLoadField, DynamicObject dropConfigure, ConvertRuleElement loadRule) {
        ArrayList<Long> sourceBillPks = new ArrayList<Long>(orders.length);
        ArrayList<String> orderidsstr = new ArrayList<String>(orders.length);
        HashMap<Long, DynamicObject> orderMap = new HashMap<Long, DynamicObject>(orders.length);
        for (DynamicObject order : orders) {
            Long id = order.getLong("id");
            sourceBillPks.add(id);
            orderidsstr.add(id.toString());
            orderMap.put(id, order);
        }
        IDropDataCtrlService dropDataCtrlService = this.getDropDataCtrlPlugin(dropConfigure.getDynamicObject("algoregister"));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        PushOrderResult pushResult = PlanOrderHelper.push((String)entityNumber, (String)targetEntity, sourceBillPks, (DynamicObject[])orders, planOrderIdQtyMap, dropLogMap, (String)billtoconfig, (MainEntityType)dataEntityType);
        List targetBills = pushResult.getTargetOrders();
        if (pushResult.getErrorMap() != null && pushResult.getErrorMap().size() > 0) {
            errorMap.putAll(pushResult.getErrorMap());
            this.updateFailResultInfo(pushResult.getErrorMap(), type);
        }
        if (targetBills == null || targetBills.isEmpty()) {
            PlanOrderCacheMrg.clearCaches((String)type, (String[])orderidsstr.toArray(new String[0]));
            return;
        }
        DynamicObject[] dynamicObjects = new DynamicObject[targetBills.size()];
        targetBills.toArray(dynamicObjects);
        Date nowdate = new Date();
        ArrayList<DynamicObject> planOrdersList = new ArrayList<DynamicObject>(targetBills.size());
        int batchQty = dropConfigure.getInt("batchqty");
        int batchSaveQty = PlanOrderHelper.getBatchSaveQty((String)targetEntity, (DynamicObject)dropConfigure);
        if (batchSaveQty > 0) {
            batchQty = batchSaveQty;
        }
        String customOperation = "save";
        if (dropDataCtrlService != null) {
            customOperation = dropDataCtrlService.getCustomOperation(targetEntity);
        }
        HashMap<Object, DynamicObject> targetOrderMap = new HashMap<Object, DynamicObject>(batchQty);
        ArrayList<Object> successPkIds = new ArrayList<Object>(16);
        HashMap<Long, Map<String, Object>> dropSuccessLogMap = new HashMap<Long, Map<String, Object>>(16);
        HashMap<Long, String> errorSaveMap = new HashMap<Long, String>(16);
        ArrayList sourceBillAllIds = new ArrayList(16);
        if (targetBills != null && targetBills.size() >= 1) {
            for (int i = 0; i < targetBills.size(); ++i) {
                DynamicObject targetBill;
                List sourceBillIds;
                if (i >= batchQty) {
                    this.batchSaveTargetOrder(planOrdersList, targetEntity, targetOrderMap.values().toArray(new DynamicObject[0]), targetOrderMap, planOrderIdQtyMap, dropLogMap, nowdate, sourceLoadField, dataEntityType, customOperation, successPkIds, dropSuccessLogMap, errorSaveMap);
                    targetOrderMap.clear();
                    planOrdersList.clear();
                }
                if ((sourceBillIds = PlanOrderHelper.getAllSourceBillIds((DynamicObject)(targetBill = (DynamicObject)targetBills.get(i)))).isEmpty()) continue;
                for (Long l : sourceBillIds) {
                    DynamicObject planOrder = (DynamicObject)orderMap.get(l);
                    if (orderMap.get(l) == null) continue;
                    planOrdersList.add(planOrder);
                }
                sourceBillAllIds.addAll(sourceBillIds);
                targetBill.set("createtime", (Object)nowdate);
                if ("om_mftorder".equals(targetEntity) || "pom_mftorder".equals(targetEntity)) {
                    DynamicObjectCollection materialentrys = targetBill.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject materialentry : materialentrys) {
                        if (materialentry == null) continue;
                        Long material = 0L;
                        if (materialentry.get("material") instanceof DynamicObject) {
                            material = ((DynamicObject)materialentry.get("material")).getLong("id");
                        } else if (materialentry.get("material") instanceof Long) {
                            material = (Long)materialentry.get("material");
                        }
                        log.info("\u6765\u6e90\u5355" + targetBill.get("billno") + "\u4e0b\u63a8\u67e5\u8be2\u7269\u6599\u4e1a\u52a1\u4fe1\u606fid\u4e3a" + material);
                    }
                }
                targetOrderMap.put(targetBill.getLong("id"), targetBill);
            }
            sourceBillPks.removeAll(sourceBillAllIds);
            if (!sourceBillPks.isEmpty()) {
                String error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u4e0b\u6e38\u5355\u636e\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u7684\u672a\u751f\u6210\u76ee\u6807\u5355\u636e\u3002", (String)"PlanOrderDropServiceImpl_5", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
                HashMap<Long, String> errMapToLog = new HashMap<Long, String>(sourceBillPks.size());
                this.setError(error, sourceBillPks, planOrderIdBillNo, errorMap, errMapToLog);
                PlanOrderHelper.recordDropFailLog(sourceBillPks, errMapToLog, orderMap, (String)entityNumber, planOrderIdQtyMap);
            }
            PushOrderResult saveResult = new PushOrderResult();
            if (!planOrdersList.isEmpty()) {
                this.batchSaveTargetOrder(planOrdersList, targetEntity, targetOrderMap.values().toArray(new DynamicObject[0]), targetOrderMap, planOrderIdQtyMap, dropLogMap, nowdate, sourceLoadField, dataEntityType, customOperation, successPkIds, dropSuccessLogMap, errorSaveMap);
            }
            if (errorSaveMap != null && errorSaveMap.size() > 0) {
                errorMap.putAll(errorSaveMap);
                saveResult.setErrorMap(errorMap);
                this.updateFailResultInfo(errorSaveMap, type);
                if (dropDataCtrlService != null) {
                    dropDataCtrlService.failCustomHanleData(planOrdersList.toArray(new DynamicObject[0]), errorMap, targetEntity);
                }
            }
            if (successPkIds != null && successPkIds.size() > 0) {
                HashMap<Object, Object> map = new HashMap<Object, Object>(successPkIds.size());
                ArrayList<String> successIdStrs = new ArrayList<String>(successPkIds.size());
                for (Object e : successPkIds) {
                    DynamicObject targetOrder = (DynamicObject)targetOrderMap.get(e);
                    List sourceBillIds = PlanOrderHelper.getAllSourceBillIds((DynamicObject)targetOrder);
                    successIds.addAll(sourceBillIds);
                    HashSet ids = new HashSet(sourceBillIds);
                    for (Long sourceBillId : ids) {
                        successIdStrs.add(sourceBillId.toString());
                        map.put(sourceBillId, successPkIds);
                    }
                }
                if (successIdStrs.size() > 0) {
                    this.writeBackPlanOrder(successIds, dropSuccessLogMap, dropDataCtrlService, nowdate, dataEntityType, errorMap, planOrderIdQtyMap, saveResult, successPkIds, targetOrderMap, map, targetEntity);
                    PlanOrderCacheMrg.clearCaches((String)type, (String[])successIdStrs.toArray(new String[0]));
                }
            }
        }
    }

    private void batchSaveTargetOrder(List<DynamicObject> planOrdersList, String targetEntity, DynamicObject[] dynamicObjects, Map<Object, DynamicObject> targetOrderMap, Map<Long, BigDecimal> planOrderIdQtyMap, Map<Long, Map<String, Object>> dropLogMap, Date nowdate, String sourceLoadField, MainEntityType dataEntityType, String customOperation, List<Object> successPkIds, Map<Long, Map<String, Object>> dropSuccessLogMap, Map<Long, String> errorSaveMap) {
        if (planOrdersList == null || planOrdersList.size() == 0) {
            return;
        }
        PushOrderResult saveResult = PlanOrderHelper.saveTargetOrder((DynamicObject[])planOrdersList.toArray(new DynamicObject[0]), (String)targetEntity, (DynamicObject[])dynamicObjects, targetOrderMap, planOrderIdQtyMap, dropLogMap, (Date)nowdate, (String)sourceLoadField, (MainEntityType)dataEntityType, (String)customOperation);
        if (saveResult.getSuccessPkIds() != null) {
            successPkIds.addAll(saveResult.getSuccessPkIds());
        }
        if (saveResult.getDropLogMap() != null) {
            dropSuccessLogMap.putAll(saveResult.getDropLogMap());
        }
        if (saveResult.getErrorMap() != null) {
            errorSaveMap.putAll(saveResult.getErrorMap());
        }
    }

    private void writeBackPlanOrder(List<Long> successIds, Map<Long, Map<String, Object>> dropSuccessLogMap, IDropDataCtrlService dropDataCtrlService, Date nowdate, MainEntityType dataEntityType, Map<Long, String> errorMap, Map<Long, BigDecimal> planOrderIdQtyMap, PushOrderResult saveResult, List<Object> successPkIds, Map<Object, DynamicObject> targetOrderMap, Map<Object, Object> map, String targetEntity) {
        DynamicObject[] planorders = null;
        try {
            for (DynamicObject planorder : planorders = BusinessDataServiceHelper.load((Object[])successIds.toArray(new Object[0]), (DynamicObjectType)dataEntityType)) {
                BigDecimal orderQty = planorder.getBigDecimal("orderqty");
                BigDecimal dropQty = planorder.getBigDecimal("dropqty");
                if (dropQty.compareTo(orderQty) == 0) {
                    planorder.set("billstatus", (Object)"D");
                }
                planorder.set("schedule", (Object)" ");
                planorder.set("droptime", (Object)nowdate);
                PlanOrderHelper.dealDropRequireqty((DynamicObject)planorder, (BigDecimal)dropQty);
            }
            List customHanleData = new ArrayList();
            Collections.addAll(customHanleData, planorders);
            if (dropDataCtrlService != null) {
                customHanleData = dropDataCtrlService.customHanleData(planorders, map, targetOrderMap, targetEntity);
            }
            SaveServiceHelper.save((DynamicObject[])customHanleData.toArray(new DynamicObject[0]));
            PlanOrderHelper.recordDropPlanorderLog(dropSuccessLogMap, (String)DropPlanOrderConst.DropStatusEnum.D.name(), (String)" ");
        }
        catch (Exception e) {
            log.error("\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage(), (Throwable)e);
            String errorStr = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u4fdd\u5b58\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u6295\u653e\u7cfb\u7edf\u7e41\u5fd9\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a", (String)"PlanOrderDropServiceImpl_3", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]);
            StringBuilder error = new StringBuilder();
            error.append(errorStr);
            error.append(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PlanOrderDropServiceImpl_4", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), e.getMessage()));
            PlanOrderHelper.failInfoUpdate((String)error.toString(), (DynamicObject[])planorders, (PushOrderResult)saveResult, errorMap, planOrderIdQtyMap, dropSuccessLogMap);
            if (dropDataCtrlService != null) {
                dropDataCtrlService.failCustomHanleData(planorders, errorMap, targetEntity);
            }
            return;
        }
    }

    private IDropDataCtrlService getDropDataCtrlPlugin(DynamicObject dynamicObject) {
        IDropDataCtrlService dropDataCtrlService = null;
        try {
            if (dynamicObject != null) {
                String algoimpletcalss = dynamicObject.getString("algoimpletcalss");
                dropDataCtrlService = (IDropDataCtrlService)Class.forName(algoimpletcalss).newInstance();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException exp) {
            log.error(exp.getMessage(), (Throwable)exp);
        }
        return dropDataCtrlService;
    }

    private void updateFailResultInfo(Map<Long, String> errorMap, String type) {
        if (errorMap == null || errorMap.size() == 0) {
            return;
        }
        ArrayList<String> errorIds = new ArrayList<String>(errorMap.size());
        for (Long id : errorMap.keySet()) {
            errorIds.add(id.toString());
        }
        PlanOrderCacheMrg.clearCaches((String)type, (String[])errorIds.toArray(new String[0]));
    }
}

