/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.mrp.planorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.common.cache.PLanOrderCache;
import kd.mpscmm.common.cache.PlanOrderCacheMrg;
import kd.mpscmm.common.enums.MaterialAttrEnum;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;

public class PlanOrderSplitServiceImpl {
    public Map<String, Object> splitPlanOrder(DynamicObject planOrder, int count, Date startDate, Date endDate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String errorStr = "";
        result.put("error", errorStr);
        ArrayList successIds = new ArrayList(100);
        result.put("success", successIds);
        String oldbillid = planOrder.getString("id");
        boolean planOrderSplitStatus = PLanOrderCache.getPlanOrderSplitStatus((String)oldbillid);
        if (planOrderSplitStatus) {
            errorStr = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u201c%s\u201d\u6709\u5176\u4ed6\u7528\u6237\u6b63\u5728\u62c6\u5206\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u62c6\u5206\u3002", (String)"PlanOrderSplitServiceImpl_0", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), planOrder.getString("billno"));
            return result;
        }
        String type = PlanOrderCacheMrg.getType4PlanOrderSplitStatus();
        PLanOrderCache.updatePlanOrderSplitCache((String)oldbillid, (String)"true");
        DynamicObject material = planOrder.getDynamicObject("material");
        DynamicObject supplyOrg = planOrder.getDynamicObject("proorpurorg");
        Long supplyOrgId = supplyOrg == null ? 0L : supplyOrg.getLong("id");
        DynamicObject entryMaterialPlan = PlanOrderHelper.getMaterialInfo((Long)material.getLong("id"), (Long)supplyOrgId, (String)"mpdm_materialplan", (String)"id,createorg,leadtimetype,materialattr,fixedleadtime,changeleadtime,changebatch,preprocessingtime,postprocessingtime", null);
        if (entryMaterialPlan == null) {
            errorStr = String.format(ResManager.loadKDString((String)"\u7269\u6599%s\u4e0d\u5b58\u5728\u5df2\u5ba1\u6838\u3001\u53ef\u7528\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"PlanOrderSplitServiceImpl_1", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), material.getString("number"));
            PlanOrderCacheMrg.clearCache((String)type, (String)oldbillid);
            return result;
        }
        String materialattr = entryMaterialPlan.getString("materialattr");
        String dbRouteKey = planOrder.getDataEntityType().getDBRouteKey();
        BigDecimal oldOrderQty = planOrder.getBigDecimal("orderqty");
        BigDecimal oldorderQty = planOrder.getBigDecimal("orderqty");
        ArrayList<Long> orderIds = new ArrayList<Long>(16);
        IDataEntityType planOrderType = planOrder.getDataEntityType();
        long[] ids = DB.genLongIds((String)planOrder.getDataEntityType().getAlias(), (int)count);
        int precision = 2;
        DynamicObject unit = planOrder.getDynamicObject("unit");
        if (unit != null) {
            precision = unit.get("precision") == null ? 2 : unit.getInt("precision");
        }
        BigDecimal ceilQty = oldOrderQty.divide(new BigDecimal(count), precision, RoundingMode.CEILING);
        BigDecimal floorQty = oldOrderQty.divide(new BigDecimal(count), precision, RoundingMode.FLOOR);
        ArrayList<DynamicObject> newOrders = new ArrayList<DynamicObject>(count);
        HashMap<Long, Integer> newOrderIdMap = new HashMap<Long, Integer>(count);
        boolean flag = false;
        for (int i = 0; i < count; ++i) {
            DynamicObject newOrder = (DynamicObject)OrmUtils.clone((Object)planOrder, (IDataEntityType)planOrderType, (boolean)true, (boolean)true);
            newOrder.set("id", (Object)ids[i]);
            orderIds.add(ids[i]);
            Object billno = CodeRuleServiceHelper.getNumber((String)planOrderType.getName(), (DynamicObject)newOrder, (String)supplyOrgId.toString());
            if (billno == null || ((String)billno).length() == 0) {
                billno = Long.valueOf(ids[i]).toString();
            }
            if (flag) {
                this.setSplitData(newOrder, floorQty, startDate, endDate);
            } else {
                BigDecimal bigDecimal;
                BigDecimal bigDecimal1 = oldOrderQty.subtract(ceilQty);
                if (bigDecimal1.compareTo(bigDecimal = floorQty.multiply(new BigDecimal(count - i - 1 + ""))) >= 0) {
                    this.setSplitData(newOrder, ceilQty, startDate, endDate);
                    oldOrderQty = oldOrderQty.subtract(ceilQty);
                } else {
                    this.setSplitData(newOrder, floorQty, startDate, endDate);
                    flag = true;
                }
            }
            newOrder.set("billno", billno);
            BigDecimal yield = newOrder.getBigDecimal("yield");
            BigDecimal newOrderQty = newOrder.getBigDecimal("orderqty");
            BigDecimal endproqty = newOrder.getBigDecimal("orderqty").multiply(yield);
            newOrder.set("endproqty", (Object)endproqty);
            newOrder.set("billstatus", (Object)"A");
            this.recalCulation(newOrder, materialattr, planOrder, supplyOrg, newOrderQty, oldorderQty, startDate);
            newOrders.add(newOrder);
            newOrderIdMap.put(ids[i], i);
        }
        OperationResult op = SaveServiceHelper.saveOperate((String)planOrderType.getName(), (DynamicObject[])newOrders.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!op.isSuccess()) {
            StringBuilder error = new StringBuilder();
            for (IOperateInfo info : op.getAllErrorOrValidateInfo()) {
                Object pkValue = info.getPkValue();
                if (pkValue == null) continue;
                Integer i = (Integer)newOrderIdMap.get(Long.valueOf(pkValue.toString()));
                error.append(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u62c6\u5206\u7b2c%1$s\u6761\u6570\u636e\uff0c%2$s", (String)"PlanOrderSplitServiceImpl_2", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), i + 1, info.getMessage()));
            }
            if (error.length() == 0) {
                error.append(op.getMessage());
            }
            errorStr = error.toString();
            PlanOrderCacheMrg.clearCache((String)type, (String)oldbillid);
            return result;
        }
        successIds.addAll(op.getSuccessPkIds());
        planOrder.set("billstatus", (Object)"D");
        BigDecimal newOrderQty = BigDecimal.ZERO;
        planOrder.set("orderqty", (Object)newOrderQty);
        BigDecimal yield = planOrder.getBigDecimal("yield");
        BigDecimal endproqty = planOrder.getBigDecimal("orderqty").multiply(yield);
        planOrder.set("endproqty", (Object)endproqty);
        this.recalCulation(planOrder, materialattr, planOrder, supplyOrg, newOrderQty, oldorderQty, null);
        SaveServiceHelper.update((DynamicObject)planOrder);
        this.addSplitRel(oldbillid, orderIds, dbRouteKey);
        PlanOrderCacheMrg.clearCache((String)type, (String)oldbillid);
        return result;
    }

    public Map<String, Object> splitBatchPlanOrder(List<DynamicObject> planOrders, Map<Long, Integer> countMap, Map<Long, Date> startDateMap, Map<Long, Date> endDateMap, Map<Long, DynamicObject> entryMaterialPlanMap, Long supplyOrgId, String operation) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String errorStr = "";
        HashMap<Long, String> errorMap = new HashMap<Long, String>(100);
        result.put("errors", errorMap);
        HashMap successMapIds = new HashMap(100);
        result.put("success", successMapIds);
        if (planOrders == null || planOrders.isEmpty()) {
            return result;
        }
        int countsum = 0;
        for (Integer count : countMap.values()) {
            countsum += count.intValue();
        }
        String customOperation = "save";
        if (operation != null && ("save".equals(operation) || "submit".equals(operation))) {
            customOperation = operation;
        }
        HashMap<Long, Long> newPlanorderIdToOldPlanorderMap = new HashMap<Long, Long>(1000);
        ArrayList<Object> newPlanorders = new ArrayList<DynamicObject>(1000);
        HashMap<Long, Object> oldPlanorderMaps = new HashMap<Long, DynamicObject>(1000);
        HashMap<Object, Integer> newOrderIdMap = new HashMap<Object, Integer>(1000);
        DynamicObject defplanOrder = planOrders.get(0);
        IDataEntityType planOrderType = planOrders.get(0).getDataEntityType();
        long[] ids = DB.genLongIds((String)planOrderType.getAlias(), (int)countsum);
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)planOrderType.getName(), (DynamicObject)defplanOrder, (String)supplyOrgId.toString(), (int)countsum);
        int n = 0;
        String type = PlanOrderCacheMrg.getType4PlanOrderSplitStatus();
        for (DynamicObject planOrder : planOrders) {
            String oldbillid = planOrder.getString("id");
            Long planorderid = Long.valueOf(oldbillid);
            Integer count = countMap.get(planorderid);
            Date startDate = startDateMap.get(planorderid);
            Date endDate = endDateMap.get(planorderid);
            DynamicObject entryMaterialPlan = entryMaterialPlanMap.get(planorderid);
            boolean planOrderSplitStatus = PLanOrderCache.getPlanOrderSplitStatus((String)oldbillid);
            if (planOrderSplitStatus) {
                errorStr = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u201c%s\u201d\u6709\u5176\u4ed6\u7528\u6237\u6b63\u5728\u62c6\u5206\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u62c6\u5206\u3002", (String)"PlanOrderSplitServiceImpl_0", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), planOrder.getString("billno"));
                errorMap.put(planorderid, errorStr);
                continue;
            }
            PLanOrderCache.updatePlanOrderSplitCache((String)oldbillid, (String)"true");
            DynamicObject material = planOrder.getDynamicObject("material");
            DynamicObject supplyOrg = planOrder.getDynamicObject("proorpurorg");
            if (entryMaterialPlan == null) {
                errorStr = String.format(ResManager.loadKDString((String)"\u7269\u6599%s\u4e0d\u5b58\u5728\u5df2\u5ba1\u6838\u3001\u53ef\u7528\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"PlanOrderSplitServiceImpl_1", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), material.getString("number"));
                PlanOrderCacheMrg.clearCache((String)type, (String)oldbillid);
                errorMap.put(planorderid, errorStr);
                continue;
            }
            String materialattr = entryMaterialPlan.getString("materialattr");
            BigDecimal oldOrderQty = planOrder.getBigDecimal("orderqty");
            BigDecimal oldorderQty = planOrder.getBigDecimal("orderqty");
            int precision = 2;
            DynamicObject unit = planOrder.getDynamicObject("unit");
            if (unit != null) {
                precision = unit.get("precision") == null ? 2 : unit.getInt("precision");
            }
            BigDecimal ceilQty = oldOrderQty.divide(new BigDecimal(count), precision, RoundingMode.CEILING);
            BigDecimal floorQty = oldOrderQty.divide(new BigDecimal(count), precision, RoundingMode.FLOOR);
            ArrayList<DynamicObject> newOrders = new ArrayList<DynamicObject>(count);
            boolean flag = false;
            for (int i = 0; i < count; ++i) {
                DynamicObject newOrder = (DynamicObject)OrmUtils.clone((Object)planOrder, (IDataEntityType)planOrderType, (boolean)true, (boolean)true);
                Long newId = ids[n];
                newOrder.set("id", (Object)newId);
                String billno = batchNumber[n];
                if (billno == null || billno.length() == 0) {
                    billno = Long.valueOf(ids[i]).toString();
                }
                if (flag) {
                    this.setSplitData(newOrder, floorQty, startDate, endDate);
                } else {
                    BigDecimal bigDecimal;
                    BigDecimal bigDecimal1 = oldOrderQty.subtract(ceilQty);
                    if (bigDecimal1.compareTo(bigDecimal = floorQty.multiply(new BigDecimal(count - i - 1 + ""))) >= 0) {
                        this.setSplitData(newOrder, ceilQty, startDate, endDate);
                        oldOrderQty = oldOrderQty.subtract(ceilQty);
                    } else {
                        this.setSplitData(newOrder, floorQty, startDate, endDate);
                        flag = true;
                    }
                }
                newOrder.set("billno", (Object)billno);
                BigDecimal yield = newOrder.getBigDecimal("yield");
                BigDecimal newOrderQty = newOrder.getBigDecimal("orderqty");
                BigDecimal endproqty = newOrder.getBigDecimal("orderqty").multiply(yield);
                newOrder.set("endproqty", (Object)endproqty);
                newOrder.set("billstatus", (Object)"A");
                this.recalCulation(newOrder, materialattr, planOrder, supplyOrg, newOrderQty, oldorderQty, startDate);
                newOrders.add(newOrder);
                newOrderIdMap.put(newId, i);
                newPlanorderIdToOldPlanorderMap.put(newId, planorderid);
                ++n;
            }
            newPlanorders.addAll(newOrders);
            planOrder.set("billstatus", (Object)"D");
            BigDecimal newOrderQty = BigDecimal.ZERO;
            planOrder.set("orderqty", (Object)newOrderQty);
            BigDecimal yield = planOrder.getBigDecimal("yield");
            BigDecimal endproqty = planOrder.getBigDecimal("orderqty").multiply(yield);
            planOrder.set("endproqty", (Object)endproqty);
            this.recalCulation(planOrder, materialattr, planOrder, supplyOrg, newOrderQty, oldorderQty, null);
            oldPlanorderMaps.put(planorderid, planOrder);
            if (newPlanorders.size() <= 1000) continue;
            this.operatePlanorder(newPlanorderIdToOldPlanorderMap, customOperation, planOrderType, newPlanorders, newOrderIdMap, errorMap, oldPlanorderMaps, type);
            newPlanorderIdToOldPlanorderMap = new HashMap(1000);
            newPlanorders = new ArrayList(1000);
            oldPlanorderMaps = new HashMap(1000);
            newOrderIdMap = new HashMap(1000);
        }
        if (newPlanorders.size() > 0) {
            this.operatePlanorder(newPlanorderIdToOldPlanorderMap, customOperation, planOrderType, newPlanorders, newOrderIdMap, errorMap, oldPlanorderMaps, type);
        }
        return result;
    }

    private void operatePlanorder(Map<Long, Long> newPlanorderIdToOldPlanorderMap, String customOperation, IDataEntityType planOrderType, List<DynamicObject> newPlanorders, Map<Object, Integer> newOrderIdMap, HashMap<Long, String> errorMap, Map<Long, DynamicObject> oldPlanorderMaps, String type) {
        ArrayList<String> keys = new ArrayList<String>(100);
        OperateOption option = OperateOption.create();
        option.setVariableValue("planOrderSplit", "planOrderSplit");
        OperationResult op = OperationServiceHelper.executeOperate((String)customOperation, (String)planOrderType.getName(), (DynamicObject[])newPlanorders.toArray(new DynamicObject[0]), (OperateOption)option);
        if (!op.isSuccess()) {
            StringBuilder error = new StringBuilder();
            for (IOperateInfo info : op.getAllErrorOrValidateInfo()) {
                Object pkValue = info.getPkValue();
                if (pkValue == null) continue;
                Long newbillId = Long.valueOf(pkValue.toString());
                Long oldbillId = newPlanorderIdToOldPlanorderMap.get(newbillId);
                Integer i = newOrderIdMap.get(newbillId);
                error.append(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u62c6\u5206\u7b2c%1$s\u6761\u6570\u636e\uff0c%2$s", (String)"PlanOrderSplitServiceImpl_2", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), i + 1, info.getMessage()));
                String opErrorStr = errorMap.getOrDefault(oldbillId, "");
                errorMap.put(oldbillId, opErrorStr.concat(error.toString()));
                keys.add(oldbillId.toString());
            }
        }
        List successPkIds = op.getSuccessPkIds();
        HashSet<DynamicObject> successDatas = new HashSet<DynamicObject>(100);
        HashMap<Long, Long> orderIdoldbillidMap = new HashMap<Long, Long>(100);
        for (Object successPkId : successPkIds) {
            Long newSuccessPkId = Long.valueOf(successPkId.toString());
            Long oldbill = newPlanorderIdToOldPlanorderMap.get(newSuccessPkId);
            if (errorMap.keySet().contains(oldbill)) continue;
            orderIdoldbillidMap.put(newSuccessPkId, oldbill);
            DynamicObject oldPlanorder = oldPlanorderMaps.get(oldbill);
            successDatas.add(oldPlanorder);
            keys.add(oldbill.toString());
        }
        SaveServiceHelper.update((DynamicObject[])successDatas.toArray(new DynamicObject[0]));
        this.addBatchSplitRel(orderIdoldbillidMap, planOrderType.getDBRouteKey());
        PlanOrderCacheMrg.clearCaches((String)type, (String[])keys.toArray(new String[0]));
    }

    private void addBatchSplitRel(Map<Long, Long> orderIdoldbillidMap, String dbRouteKey) {
        if (orderIdoldbillidMap.isEmpty()) {
            return;
        }
        long[] ids = DB.genLongIds((String)"t_mrp_planordersplitrel", (int)orderIdoldbillidMap.size());
        String insertSql = " insert into  t_mrp_planordersplitrel (fid, FSOUCEID, FRESULTID) values (?,?,?) ";
        ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(orderIdoldbillidMap.size());
        Object[] params = null;
        int m = 0;
        for (Map.Entry<Long, Long> orderIdoldbillidEntry : orderIdoldbillidMap.entrySet()) {
            params = new Object[]{ids[m], orderIdoldbillidEntry.getValue(), orderIdoldbillidEntry.getKey()};
            insertParamsList.add(params);
            ++m;
        }
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, insertParamsList);
    }

    private void addSplitRel(String oldbillid, List<Long> orderIds, String dbRouteKey) {
        Long billid = Long.valueOf(oldbillid);
        long[] ids = DB.genLongIds((String)"t_mrp_planordersplitrel", (int)orderIds.size());
        String insertSql = " insert into  t_mrp_planordersplitrel (fid, FSOUCEID, FRESULTID) values (?,?,?) ";
        ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(orderIds.size());
        Object[] params = null;
        for (int i = 0; i < orderIds.size(); ++i) {
            params = new Object[]{ids[i], billid, orderIds.get(i)};
            insertParamsList.add(params);
        }
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, insertParamsList);
    }

    private void recalCulation(DynamicObject newOrder, String materialattr, DynamicObject planOrder, DynamicObject supplyOrg, BigDecimal newOrderQty, BigDecimal oldOrderQty, Date startDate) {
        DynamicObjectCollection planOrderEntrys = newOrder.getDynamicObjectCollection("entryentity");
        if (planOrderEntrys != null && !planOrderEntrys.isEmpty()) {
            for (int j = 0; j < planOrderEntrys.size(); ++j) {
                DynamicObject planOrderEntry = (DynamicObject)planOrderEntrys.get(j);
                this.recalCulationDate(planOrderEntry, newOrder, materialattr, supplyOrg, startDate);
                DynamicObject entryreplaceplan = planOrderEntry.getDynamicObject("entryreplaceplan");
                BigDecimal entryrequireqty = planOrderEntry.getBigDecimal("entryrequireqty");
                if (entryreplaceplan != null && BigDecimal.ZERO.compareTo(entryrequireqty) == 0) continue;
                PlanOrderHelper.recalCulationQty((DynamicObject)planOrderEntry, (DynamicObject)planOrder, (DynamicObject)planOrderEntry, (int)j, (BigDecimal)newOrderQty, (BigDecimal)oldOrderQty);
            }
        }
        DynamicObjectCollection copEntrys = newOrder.getDynamicObjectCollection("copentry");
        PlanOrderHelper.recalCulationCopentrysQty((DynamicObjectCollection)copEntrys, (BigDecimal)newOrderQty);
    }

    private void recalCulationDate(DynamicObject planOrderEntry, DynamicObject planOrder, String materialattr, DynamicObject supplyOrg, Date startDate) {
        if (startDate == null) {
            return;
        }
        Date date = null;
        if (!MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            date = this.getRecentWorkDate(planOrder.getDate("startdate"), supplyOrg);
        }
        if (date == null) {
            date = planOrder.getDate("startdate");
        }
        Integer leadtime = planOrderEntry.getInt("entryleadtime");
        Date reqDate = PlanOrderHelper.getReqDate((Date)date, (Integer)leadtime, (Long)supplyOrg.getLong("id"), (String)materialattr);
        planOrderEntry.set("entryrequiredate", (Object)reqDate);
    }

    private Date getRecentWorkDate(Date date, DynamicObject supplyOrg) {
        if (date == null) {
            return date;
        }
        Set calendarIds = PlanOrderHelper.getCalendarIds((Long)supplyOrg.getLong("id"));
        if (calendarIds == null || calendarIds.isEmpty()) {
            return date;
        }
        Date workDate = PlanOrderHelper.getRecentWorkDate((Date)date, (Long)supplyOrg.getLong("id"));
        return workDate;
    }

    private void setSplitData(DynamicObject newOrder, BigDecimal ceilQty, Date startDate, Date endDate) {
        newOrder.set("orderqty", (Object)ceilQty);
        if (startDate != null) {
            newOrder.set("startdate", (Object)startDate);
        }
        if (endDate != null) {
            newOrder.set("enddate", (Object)endDate);
        }
    }
}

