/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.mrp.runner;

import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.runner.CacheManager;

public class CalcStateManager {
    private final ExecutionEnv ctx;
    private static final DistributeSessionlessCache cache = CacheManager.getCache();
    private final String stateKey;
    private final String exceptionKey;
    private final String masterKeepAliveKey;
    private static final String STATE_TERMINATED = "terminated";
    private static final String STATE_MASTER_TERMINATED = "master_terminated";
    private static final String STATE_MANUTERMINATED = "manu_terminated";
    private int masterCheckPeriod = 10000;
    private int workerCheckPeriod = 10000;
    private int masterKeepAlivePeriod = 30000;
    private long masterKeepAliveTimeout = 78000L;
    private ScheduledExecutorService timer = null;
    private ScheduledExecutorService keepAliveTimer = null;
    private ScheduledExecutorService wokerKeepAliveTimer = null;
    private TimerTask workerTimeTask = new TimerTask(){

        @Override
        public void run() {
            if (CalcStateManager.this.isMasterTerminated()) {
                CalcStateManager.this.ctx.setMasterStopped();
                CalcStateManager.this.stopWorkerThread();
            } else if (CalcStateManager.this.isMasterLost()) {
                CalcStateManager.this.stopWorkerThread();
            }
        }
    };
    private TimerTask masterTimeTask = new TimerTask(){

        @Override
        public void run() {
            if (CalcStateManager.this.isWorkerTerminated()) {
                CalcStateManager.this.ctx.setWorkerStopped();
                CalcStateManager.this.stopMasterWorker();
            }
            if (CalcStateManager.this.isManuTerminated()) {
                CalcStateManager.this.ctx.setManuStopped();
                CalcStateManager.this.stopMasterWorker();
            }
        }
    };
    private TimerTask masterKeepAliveTimeTask = new TimerTask(){

        @Override
        public void run() {
            CalcStateManager.this.setMasterKeepAlive();
        }
    };

    public CalcStateManager(ExecutionEnv ctx) {
        this.ctx = ctx;
        this.stateKey = CalcStateManager.makeStateKey(String.valueOf(ctx.getCtxId()));
        this.exceptionKey = this.makeExceptionKey();
        this.masterKeepAliveKey = this.makeKeepAliveKey();
    }

    private static String makeStateKey(String ctxId) {
        return "mrpcalc-state-CalcStateManager-" + ctxId;
    }

    private String makeExceptionKey() {
        return "mrpcalc-exception-CalcStateManager-" + this.ctx.getCtxId();
    }

    private String makeKeepAliveKey() {
        return "mrpcalc-keepalive-CalcStateManager-" + this.ctx.getCtxId();
    }

    public void startWorkerCheckThread() {
        this.timer = new ScheduledThreadPoolExecutor(1);
        this.timer.scheduleAtFixedRate(this.workerTimeTask, this.workerCheckPeriod, this.workerCheckPeriod, TimeUnit.MILLISECONDS);
    }

    public void startWorkerCheckThread(final String runStepId) {
        this.setWorkerKeepAlive(runStepId);
        this.timer = new ScheduledThreadPoolExecutor(1);
        TimerTask curWorkerTimeTask = new TimerTask(){

            @Override
            public void run() {
                if (CalcStateManager.this.isMasterTerminated()) {
                    CalcStateManager.this.ctx.setMasterStopped();
                    CalcStateManager.this.stopWorkerThread();
                } else if (CalcStateManager.this.isMasterLost()) {
                    CalcStateManager.this.stopWorkerThread();
                } else if (CalcStateManager.this.isWorkerLost(runStepId)) {
                    CalcStateManager.this.stopWorkerThread();
                }
            }
        };
        this.timer.scheduleAtFixedRate(curWorkerTimeTask, this.workerCheckPeriod, this.workerCheckPeriod, TimeUnit.MILLISECONDS);
        this.wokerKeepAliveTimer = new ScheduledThreadPoolExecutor(1);
        TimerTask workerKeepAliveTimeTask = new TimerTask(){

            @Override
            public void run() {
                CalcStateManager.this.setWorkerKeepAlive(runStepId);
            }
        };
        this.wokerKeepAliveTimer.scheduleAtFixedRate(workerKeepAliveTimeTask, 10L, this.masterKeepAlivePeriod, TimeUnit.MILLISECONDS);
    }

    public void startMasterCheckThread() {
        this.timer = new ScheduledThreadPoolExecutor(1);
        this.timer.scheduleAtFixedRate(this.masterTimeTask, this.masterCheckPeriod, this.masterCheckPeriod, TimeUnit.MILLISECONDS);
        this.keepAliveTimer = new ScheduledThreadPoolExecutor(1);
        this.keepAliveTimer.scheduleAtFixedRate(this.masterKeepAliveTimeTask, 10L, this.masterKeepAlivePeriod, TimeUnit.MILLISECONDS);
        this.setMasterKeepAlive();
    }

    public void stopWorkerThread() {
        if (this.timer != null && !this.timer.isShutdown()) {
            this.timer.shutdown();
            this.timer = null;
        }
        if (this.wokerKeepAliveTimer != null && !this.wokerKeepAliveTimer.isShutdown()) {
            this.wokerKeepAliveTimer.shutdown();
            this.wokerKeepAliveTimer = null;
        }
    }

    public void stopMasterWorker() {
        if (this.timer != null && !this.timer.isShutdown()) {
            this.timer.shutdown();
            this.timer = null;
            this.keepAliveTimer.shutdown();
            this.keepAliveTimer = null;
        }
        if (this.wokerKeepAliveTimer != null && !this.wokerKeepAliveTimer.isShutdown()) {
            this.wokerKeepAliveTimer.shutdown();
            this.wokerKeepAliveTimer = null;
        }
    }

    private void setMasterKeepAlive() {
        cache.put(this.masterKeepAliveKey, (Object)("" + System.currentTimeMillis()));
    }

    private void setWorkerKeepAlive(String runStepId) {
        cache.put(this.masterKeepAliveKey + runStepId, (Object)("" + System.currentTimeMillis()));
    }

    public boolean isMasterLost() {
        String value = (String)cache.get(this.masterKeepAliveKey);
        if (value == null) {
            return true;
        }
        long timestamp = Long.parseLong(value);
        return System.currentTimeMillis() - timestamp > this.masterKeepAliveTimeout;
    }

    public boolean isWorkerLost(String runStepId) {
        String value = (String)cache.get(this.masterKeepAliveKey + runStepId);
        if (value == null) {
            return true;
        }
        long timestamp = Long.parseLong(value);
        return System.currentTimeMillis() - timestamp > this.masterKeepAliveTimeout;
    }

    public boolean isMasterTerminated() {
        String value = (String)cache.get(this.stateKey);
        return STATE_MASTER_TERMINATED.equals(value);
    }

    public boolean isWorkerTerminated() {
        String value = (String)cache.get(this.stateKey);
        return value != null && STATE_TERMINATED.equals(value);
    }

    public String getTerminatedException() {
        return (String)cache.get(this.exceptionKey);
    }

    public void setTerminated(String exception) {
        if (cache.get(this.stateKey) == null) {
            cache.put(this.stateKey, (Object)STATE_TERMINATED);
            if (StringUtils.isNotEmpty((String)exception)) {
                cache.put(this.exceptionKey, (Object)exception);
            }
        }
    }

    public void setMasterTerminated() {
        cache.put(this.stateKey, (Object)STATE_MASTER_TERMINATED);
    }

    public boolean isManuTerminated() {
        String value = (String)cache.get(this.stateKey);
        return value != null && STATE_MANUTERMINATED.equals(value);
    }

    public static void setManuTerminated(String ctxId) {
        cache.put(CalcStateManager.makeStateKey(ctxId), (Object)STATE_MANUTERMINATED);
    }
}

