/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.mrp.runner;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msplan.mservice.service.mrp.ExecuteStatus;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.runner.StepRunner;
import kd.mpscmm.msplan.mservice.service.mrp.step.EndStep;
import kd.mpscmm.msplan.mservice.service.mrp.step.MSStep;
import kd.mpscmm.msplan.mservice.service.mrp.step.ParallelMSStep;
import kd.mpscmm.msplan.mservice.service.mrp.step.StartStep;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ConfigStepMSRunner {
    private static final Log log = LogFactory.getLog(ConfigStepMSRunner.class);
    private Long bizPlanId;
    private Long planOrgId;
    private String runMode;
    private String planOrgName;
    private String runModeName;

    public ConfigStepMSRunner(Long bizPlanId, Long planOrgId, String planOrgName, String runMode, String runModeName) {
        this.bizPlanId = bizPlanId;
        this.planOrgId = planOrgId;
        this.planOrgName = planOrgName;
        this.runMode = runMode;
        this.runModeName = runModeName;
    }

    public Long run(String logEntityNumber, Long ctxId) {
        DynamicObject bizPlan = this.getBizPlan();
        if (bizPlan == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u7ec4\u7ec7\uff08%1$s\uff09- \u8ba1\u7b97\u65b9\u6848\u914d\u7f6e - (%2$s)\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u672a\u627e\u5230", (String)"ConfigStepMSRunner_1", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), this.planOrgName, this.runModeName));
        }
        ExecutionEnv ctx = null;
        ctx = ctxId == null ? ExecutionEnv.initEnvByMaster(logEntityNumber) : ExecutionEnv.loadEnv(logEntityNumber, ctxId);
        this.runlogBaseDataAddnewHandler(ctx.getRunLog());
        ArrayList<MSStep> stepList = new ArrayList<MSStep>();
        stepList.add(new StartStep(ctx));
        this.initStepByConfig(bizPlan, stepList, ctx);
        ThreadPools.executeOnceIncludeRequestContext((String)("MRPMainRunner-lognum-" + this.bizPlanId), (Runnable)new StepRunner(ctx, stepList));
        return ctx.getCtxId();
    }

    private void runlogBaseDataAddnewHandler(DynamicObject runLog) {
        if (runLog == null) {
            return;
        }
        try {
            runLog.set("createorg", (Object)this.planOrgId);
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])new DynamicObject[]{runLog});
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
    }

    public Long run(String logEntityNumber) {
        return this.run(logEntityNumber, null);
    }

    private DynamicObject getBizPlan() {
        if (this.bizPlanId != null) {
            return QueryServiceHelper.queryOne((String)"mrp_businessplan", (String)"xml_tag, cellsdata_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.bizPlanId)});
        }
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = new QFilter("createorg", "=", (Object)this.planOrgId);
        QFilter qFilter = new QFilter("entryentity.runtype", "=", (Object)this.runMode);
        DynamicObject calPlan = QueryServiceHelper.queryOne((String)"mrp_calplanconfig", (String)"entryentity.bizplan bizplan", (QFilter[])new QFilter[]{qFilter, qFilterEnable, qFilterOrg, qFilterStatus});
        if (calPlan != null) {
            this.bizPlanId = calPlan.getLong("bizplan");
            return QueryServiceHelper.queryOne((String)"mrp_businessplan", (String)"xml_tag, cellsdata_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.bizPlanId)});
        }
        return null;
    }

    protected void initStepByConfig(DynamicObject bizPlan, List<MSStep> stepList, ExecutionEnv ctx) {
        try {
            String xmlStr = bizPlan.getString("xml_tag");
            String cellsdata = bizPlan.getString("cellsdata_tag");
            Map cellsDataMap = (Map)JSON.parse((String)cellsdata);
            Document document = DocumentHelper.parseText((String)xmlStr);
            Element root = document.getRootElement();
            List mxCellElements = root.elements();
            HashMap<String, Set<String>> targetRelations = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> sourceRelations = new HashMap<String, Set<String>>();
            HashMap<String, MSStep> steps = new HashMap<String, MSStep>();
            Boolean isParallel = false;
            for (Element cell : mxCellElements) {
                String vertex = cell.attributeValue("vertex");
                if ("1".equals(vertex)) {
                    String id = cell.attributeValue("id");
                    MSStep step = this.getIMRPStep(cellsDataMap, id, ctx);
                    steps.put(id, step);
                    continue;
                }
                String edge = cell.attributeValue("edge");
                if (!"1".equalsIgnoreCase(edge)) continue;
                String sourceId = cell.attributeValue("source");
                String targetId = cell.attributeValue("target");
                Set targets = targetRelations.getOrDefault(sourceId, new HashSet());
                targets.add(targetId);
                targetRelations.put(sourceId, targets);
                Set sources = sourceRelations.getOrDefault(targetId, new HashSet());
                sources.add(sourceId);
                sourceRelations.put(targetId, sources);
                if (isParallel.booleanValue()) continue;
                isParallel = targets.size() > 1;
            }
            if (isParallel.booleanValue()) {
                stepList.add(new ParallelMSStep(ctx).initialize(targetRelations, sourceRelations, steps));
            } else {
                this.setSteps(stepList, mxCellElements, cellsDataMap, ctx);
            }
            stepList.add(new EndStep(ctx, null, ExecuteStatus.FINISHED));
        }
        catch (Exception e) {
            stepList.clear();
            stepList.add(new EndStep(ctx, e, ExecuteStatus.ERROR_STOP));
        }
    }

    private void setSteps(List<MSStep> stepList, List<Element> mxCellElements, Map<?, ?> cellsDataMap, ExecutionEnv ctx) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        HashMap<String, Set<String>> setMap = new HashMap<String, Set<String>>();
        HashSet<String> root = new HashSet<String>();
        setMap.put("-1", root);
        for (Element cell : mxCellElements) {
            String vertex = cell.attributeValue("vertex");
            String id = cell.attributeValue("id");
            if (!"1".equals(vertex)) continue;
            root.add(id);
        }
        for (Element cell : mxCellElements) {
            String edge = cell.attributeValue("edge");
            String sourceId = cell.attributeValue("source");
            String targetId = cell.attributeValue("target");
            if (!"1".equalsIgnoreCase(edge)) continue;
            Set target = setMap.getOrDefault(sourceId, new HashSet());
            target.add(targetId);
            setMap.put(sourceId, target);
            root.remove(targetId);
        }
        this.dfsSetStep(stepList, root, setMap, cellsDataMap, ctx);
    }

    private void dfsSetStep(List<MSStep> stepList, Set<String> root, Map<String, Set<String>> setMap, Map<?, ?> cellsDataMap, ExecutionEnv ctx) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (root == null) {
            return;
        }
        for (String sourceId : root) {
            MSStep step = this.getIMRPStep(cellsDataMap, sourceId, ctx);
            if (step != null) {
                stepList.add(step);
            }
            Set<String> next = setMap.get(sourceId);
            this.dfsSetStep(stepList, next, setMap, cellsDataMap, ctx);
        }
    }

    private MSStep getIMRPStep(Map<?, ?> cellsDataMap, String sourceId, ExecutionEnv ctx) {
        Map data = (Map)cellsDataMap.get(sourceId);
        if (data == null) {
            return null;
        }
        String algoModuleId = (String)data.get("algomodel");
        String selectName = (String)data.get("selectname");
        DynamicObject algoModule = QueryServiceHelper.queryOne((String)"mrp_algoregister", (String)"algoimpletcalss,name, appid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(algoModuleId))});
        String implClassName = algoModule.getString("algoimpletcalss");
        if (StringUtils.isEmpty((CharSequence)selectName)) {
            selectName = algoModule.getString("name");
        }
        String stepDesc = selectName;
        String appId = algoModule.getString("appid");
        return new MSStep(ctx, implClassName, stepDesc, appId);
    }
}

