/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.mrp.runner;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msplan.mservice.service.mrp.runner.IExecuteLogRecorder;

public class StepLogRecorder
implements IExecuteLogRecorder,
Runnable {
    private static final Log logger = LogFactory.getLog(StepLogRecorder.class);
    private static final String Runlog = "mrp_caculate_log";
    private static final String DOT = ".";
    private ORM orm;
    private DynamicObject runLog;
    private AtomicBoolean isUpdating = new AtomicBoolean();

    public StepLogRecorder(ORM orm, DynamicObject runLog) {
        this.orm = orm;
        this.runLog = runLog;
    }

    @Override
    public void initMRPRunLog() {
        if (this.runLog.getString("id") == null) {
            this.orm.insert(this.runLog);
            BaseDataServiceHelper.clearCache((DynamicObject)this.runLog);
        } else {
            this.orm.delete("mrp_caculate_log.entryentity", new QFilter[]{new QFilter("id", "=", (Object)this.runLog.getLong("id"))});
            this.orm.update(this.runLog);
            BaseDataServiceHelper.clearCache((DynamicObject)this.runLog);
        }
    }

    @Override
    public void updateRunLog(String key, Object value) {
        this.runLog.set(key, value);
    }

    @Override
    public synchronized void createStepLog(int stepIdx, String stepDesc) {
        DynamicObject entryLogInfo = this.orm.newDynamicObject("mrp_caculate_log.entryentity");
        entryLogInfo.setParent((Object)this.runLog);
        entryLogInfo.set("entrystepseq", (Object)String.valueOf(stepIdx));
        entryLogInfo.set("entrystepname", (Object)stepDesc);
        entryLogInfo.set("entryprocessdata", (Object)0);
        DynamicObjectCollection collection = this.runLog.getDynamicObjectCollection("entryentity");
        if (collection == null) {
            collection = new DynamicObjectCollection(entryLogInfo.getDynamicObjectType(), (Object)this.runLog);
            this.runLog.set("entryentity", (Object)collection);
        }
        collection.add((Object)entryLogInfo);
        LOCAL.set(new Wrapper(entryLogInfo));
    }

    @Override
    public int getLogIdx() {
        return ((Wrapper)LOCAL.get()).entryLogInfo.getInt("entrystepseq");
    }

    @Override
    public synchronized void saveStepLog(boolean isClear) {
        if (isClear) {
            ((Wrapper)LOCAL.get()).entryLogInfo = null;
            ((Wrapper)LOCAL.get()).subs.clear();
            LOCAL.set(null);
        }
        if (this.isUpdating.compareAndSet(false, true)) {
            this.run();
        }
    }

    @Override
    public synchronized void updateStepLog(String key, Object value) {
        if (LOCAL.get() == null) {
            return;
        }
        ((Wrapper)LOCAL.get()).entryLogInfo.set(key, value);
    }

    @Override
    public void findStepLog(int stepIdx) {
        if (LOCAL.get() == null && this.runLog != null) {
            String stepStr = String.valueOf(stepIdx);
            DynamicObjectCollection entrys = this.runLog.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (!stepStr.equals(entry.getString("entrystepseq"))) continue;
                LOCAL.set(new Wrapper(entry));
                break;
            }
        }
    }

    @Override
    public synchronized void createSubStepLog(int stepIdx, String stepDesc, int parentStepLevel) {
        DynamicObject logInfo = this.orm.newDynamicObject("mrp_caculate_log.entryentity");
        logInfo.setParent((Object)this.runLog);
        logInfo.set("entrystepseq", (Object)(String.valueOf(parentStepLevel) + "-" + String.valueOf(stepIdx)));
        logInfo.set("entrystepname", (Object)stepDesc);
        logInfo.set("entryprocessdata", (Object)0);
        ((Wrapper)LOCAL.get()).subs.add(logInfo);
        DynamicObjectCollection collection = this.runLog.getDynamicObjectCollection("entryentity");
        if (collection == null) {
            collection = new DynamicObjectCollection(((Wrapper)LOCAL.get()).entryLogInfo.getDynamicObjectType(), (Object)this.runLog);
            this.runLog.set("entryentity", (Object)collection);
        }
        collection.add((Object)logInfo);
        if (this.isUpdating.compareAndSet(false, true)) {
            this.run();
        }
    }

    @Override
    public synchronized void updateSubStepLog(int stepIdx, String key, Object value) {
        if (LOCAL.get() == null) {
            return;
        }
        if (((Wrapper)LOCAL.get()).subs == null || stepIdx >= ((Wrapper)LOCAL.get()).subs.size()) {
            ((Wrapper)LOCAL.get()).entryLogInfo.set(key, value);
            return;
        }
        DynamicObject logInfo = (DynamicObject)((Wrapper)LOCAL.get()).subs.get(stepIdx);
        logInfo.set(key, value);
    }

    @Override
    public Date getLogStartDate() {
        return this.runLog.getDate("startdate");
    }

    @Override
    public String getLogEntryStatus() {
        return ((Wrapper)LOCAL.get()).entryLogInfo.getString("entryresult");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            logger.error("mrprunner-log-recorder-updater-failed", (Throwable)e);
        }
        StepLogRecorder stepLogRecorder = this;
        synchronized (stepLogRecorder) {
            if (this.isUpdating.get()) {
                try {
                    this.orm.update(this.runLog);
                }
                finally {
                    this.isUpdating.set(false);
                }
            }
        }
    }

    @Override
    public void deleteRunLog() {
        if (this.runLog.getString("id") != null) {
            this.orm.delete(this.runLog);
        }
    }

    public static class Wrapper {
        private DynamicObject entryLogInfo;
        private ArrayList<DynamicObject> subs;

        public Wrapper(DynamicObject entryLogInfo) {
            if (entryLogInfo == null) {
                throw new RuntimeException("entryLogInfo can not be null");
            }
            this.entryLogInfo = entryLogInfo;
            this.subs = new ArrayList();
        }
    }
}

