/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.mrp.runner;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.NetAddressUtils;
import kd.mpscmm.msplan.mservice.service.mrp.ExecuteStatus;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.runner.CalcStateManager;
import kd.mpscmm.msplan.mservice.service.mrp.runner.IExecuteLogRecorder;
import kd.mpscmm.msplan.mservice.service.mrp.step.EndStep;
import kd.mpscmm.msplan.mservice.service.mrp.step.MSStep;
import kd.mpscmm.msplan.mservice.service.mrp.step.ParallelMSStep;

public class StepRunner
implements Runnable {
    private String ipAddress;
    private ExecutionEnv ctx;
    private List<MSStep> steps;
    private static final Log logger = LogFactory.getLog(StepRunner.class);
    private CalcStateManager stateManager;

    public StepRunner(ExecutionEnv ctx, List<MSStep> steps) {
        this.ctx = ctx;
        this.steps = steps;
        this.stateManager = new CalcStateManager(ctx);
    }

    public CalcStateManager getStateManager() {
        return this.stateManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int percent = 0;
        int i = 0;
        IExecuteLogRecorder lr = this.ctx.createLogRecorder();
        logger.warn(String.format("ctxid: %s, mrprunner-main-inst, ip: %s", this.ctx.getCtxId(), this.getIP()));
        try {
            this.stateManager.startMasterCheckThread();
            int n = new BigDecimal("100").divide(new BigDecimal(this.steps.size()), 0, RoundingMode.UP).intValue();
            if (n >= 100) {
                n = 90;
            }
            lr.initMRPRunLog();
            int stepSize = this.steps.size();
            Iterator<MSStep> iter = this.steps.iterator();
            while (iter.hasNext()) {
                ++i;
                MSStep step = iter.next();
                if ((percent += n) > 100) {
                    percent = 100;
                }
                if (percent == 100 && i != stepSize) {
                    percent = 99;
                }
                long stepStartTime = System.currentTimeMillis();
                step.createStepLog(i, percent);
                lr.updateStepLog("entryresult", ExecuteStatus.RUNNING.getAlias());
                lr.saveStepLog(false);
                this.ctx.testEnvStatus();
                step.execute();
                if (step instanceof ParallelMSStep) {
                    int innerCount = ((ParallelMSStep)step).getInnerStepCount() - 1;
                    stepSize = stepSize - i + innerCount;
                    i = innerCount;
                }
                iter.remove();
                this.ctx.testEnvStatus();
                this.curStepEnd(stepStartTime);
            }
        }
        catch (Throwable e) {
            logger.error("MRPRunner:", e);
            ExecuteStatus status = this.ctx.isManuStopped() ? ExecuteStatus.MANU_STOP : ExecuteStatus.ERROR_STOP;
            EndStep step = new EndStep(this.ctx, e, status);
            try {
                step.createStepLog(i + 1, 100);
                step.execute();
                lr.saveStepLog(true);
            }
            catch (Throwable t) {
                logger.error("MRPRunner", t);
            }
        }
        finally {
            this.onTerminated();
        }
    }

    private void curStepEnd(long stepStartTime) {
        IExecuteLogRecorder lr = this.ctx.createLogRecorder();
        ExecuteStatus status = ExecuteStatus.FINISHED;
        lr.updateStepLog("entryresult", status.getAlias());
        long endTime = System.currentTimeMillis();
        long stepSecond = endTime / 1000L - stepStartTime / 1000L;
        BigDecimal stepTime = new BigDecimal(stepSecond).divide(new BigDecimal(60), 4, RoundingMode.CEILING);
        lr.updateStepLog("entryoperatmin", stepTime);
        Date startDate = lr.getLogStartDate();
        long second = (System.currentTimeMillis() - startDate.getTime()) / 1000L;
        BigDecimal time = new BigDecimal(second).divide(new BigDecimal(60), 2, RoundingMode.CEILING);
        lr.updateRunLog("summin", time);
        lr.saveStepLog(true);
    }

    private void onTerminated() {
        this.stateManager.setMasterTerminated();
        this.stateManager.stopMasterWorker();
        logger.info("MRPRunner (ctxId=" + this.ctx.getCtxId() + ") terminated");
    }

    public String getIP() {
        if (this.ipAddress != null) {
            return this.ipAddress;
        }
        this.ipAddress = NetAddressUtils.getLocalIpAddress();
        return this.ipAddress;
    }
}

