/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.mrp.step;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.mpscmm.msplan.mservice.service.datasync.utils.DataSyncUtils;
import kd.mpscmm.msplan.mservice.service.mrp.ExecuteStatus;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.runner.IExecuteLogRecorder;
import kd.mpscmm.msplan.mservice.service.mrp.step.MSStep;

public class EndStep
extends MSStep {
    private Throwable e;
    private ExecuteStatus status;

    public EndStep(ExecutionEnv ctx, Throwable e, ExecuteStatus status) {
        super(ctx, null, ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u675f", (String)"EndStep_0", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), null);
        this.e = e;
        this.status = status;
    }

    @Override
    public void execute() {
        this.ctx.clearCache();
        IExecuteLogRecorder lr = this.ctx.createLogRecorder();
        lr.updateStepLog("entryresult", this.status.getAlias());
        if (this.e != null) {
            String errorMsg = this.e.getMessage();
            if (errorMsg != null && errorMsg.length() >= 125) {
                errorMsg = errorMsg.substring(0, 125);
            }
            lr.updateStepLog("entrydetailmsg", errorMsg);
            lr.updateStepLog("entrydetailmsg_tag", DataSyncUtils.getStackTrace(this.e));
        }
        lr.updateRunLog("calculatestatus", this.status.getValue());
        Date startDate = lr.getLogStartDate();
        Date endDate = new Date();
        lr.updateRunLog("enddate", endDate);
        long second = endDate.getTime() / 1000L - startDate.getTime() / 1000L;
        BigDecimal time = new BigDecimal(second).divide(new BigDecimal(60), 2, RoundingMode.CEILING);
        lr.updateRunLog("summin", time);
    }
}

