/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.mrp.step;

import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.service.mrp.ExecuteStatus;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.runner.CacheManager;
import kd.mpscmm.msplan.mservice.service.mrp.runner.CalcStateManager;
import kd.mpscmm.msplan.mservice.service.mrp.runner.IExecuteLogRecorder;

public class MSStep {
    private static final Log logger = LogFactory.getLog(MSStep.class);
    protected String className;
    protected String stepDesc;
    protected String appId;
    protected ExecutionEnv ctx;
    protected DynamicObject runLog;
    protected int stepIdx;

    public MSStep(ExecutionEnv ctx, String className, String stepDesc, String appId) {
        this.ctx = ctx;
        this.className = className;
        this.stepDesc = stepDesc;
        this.appId = appId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getAppId() {
        return this.appId;
    }

    public void createStepLog(int stepIdx, int percent) {
        this.stepIdx = stepIdx;
        IExecuteLogRecorder lr = this.ctx.createLogRecorder();
        lr.createStepLog(stepIdx, this.stepDesc);
        lr.updateRunLog("calculatepro", percent);
    }

    public void execute() {
        String msg = "";
        if (StringUtils.isNotEmpty((String)this.className)) {
            String cloud = this.findCloudIdByAppId(this.appId);
            String app = this.findAppByAppId(this.appId);
            String runStepId = (String)DispatchServiceHelper.invokeBizService((String)cloud, (String)app, (String)"IMRPCalcRuntimeService", (String)"runStep", (Object[])new Object[]{this.className, this.stepIdx, this.ctx.getLogEntityNumber(), this.ctx.getCtxId()});
            CalcStateManager manager = new CalcStateManager(this.ctx);
            DistributeSessionlessCache cache = CacheManager.getCache();
            do {
                String success;
                if (StringUtils.isNotEmpty((String)(success = this.getCache(cache, runStepId)))) {
                    msg = this.getCache(cache, runStepId + "msg");
                    if (!"false".equals(success)) break;
                    msg = "error";
                    break;
                }
                try {
                    Thread.sleep(200L);
                    logger.info("isWorkerliving Thread.sleep");
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            } while (!manager.isWorkerLost(runStepId));
            if (manager.isWorkerLost(runStepId)) {
                logger.info("isWorkerLost");
            }
        }
        this.stepLog(msg);
    }

    private String getCache(DistributeSessionlessCache cache, String runStepId) {
        return (String)cache.get(runStepId);
    }

    private void stepLog(String pMsg) {
        String msg;
        IExecuteLogRecorder lr = this.ctx.createLogRecorder();
        String msgShort = msg = pMsg;
        if ("error".equalsIgnoreCase(msg)) {
            this.ctx.setWorkerStopped();
            CalcStateManager manager = new CalcStateManager(this.ctx);
            msgShort = msg = manager.getTerminatedException();
            lr.updateStepLog("entryresult", ExecuteStatus.ERROR_STOP.getAlias());
        }
        if (StringUtils.isNotEmpty((String)msg) && msg.length() >= 125) {
            msgShort = msg.substring(0, 125);
        }
        lr.updateStepLog("entrydetailmsg_tag", msg);
        lr.updateStepLog("entrydetailmsg", msgShort);
        lr.saveStepLog(false);
    }

    private String findCloudIdByAppId(String appId) {
        DynamicObject cloud;
        String cloudNumber = "mmc";
        if (StringUtils.isNotEmpty((String)appId) && (cloud = BizCloudServiceHelp.getBizCloudByAppID((String)appId)) != null) {
            cloudNumber = cloud.getString("number").toLowerCase();
        }
        return cloudNumber;
    }

    private String findAppByAppId(String appId) {
        String temp;
        String appNumber = "mrp";
        if (StringUtils.isNotEmpty((String)appId) && !StringUtils.isEmpty((String)(temp = BizAppServiceHelp.getAppNumByAppId((String)appId)))) {
            appNumber = temp;
        }
        return appNumber;
    }
}

