/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.planscope;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanScopeHelper;

public class PlanScopeServiceimpl {
    private static final Log log = LogFactory.getLog(PlanScopeServiceimpl.class);

    public Long getDefPlanScope(Long orgId) {
        return PlanScopeHelper.getPlanScope((Long)orgId);
    }

    public Map<String, Long> getDefInwareInfo(DynamicObject planscope, DynamicObject material, DynamicObject supplyOrg) {
        Map<String, Long> inwareInfo = new HashMap<String, Long>(3);
        if (planscope == null || supplyOrg == null || material == null) {
            inwareInfo.put("inwarorg", 0L);
            inwareInfo.put("inwarehouse", 0L);
            inwareInfo.put("inwarelocation", 0L);
            return inwareInfo;
        }
        DynamicObject materialMftInfo = PlanOrderHelper.getMaterialMftInfo((Long)material.getLong("id"), (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)"bd_materialmftinfo", (String)"id,createorg,masterid,inwarorg,inwarehouse,inwarelocation", null);
        String type = planscope.getString("type");
        Long planScopeId = planscope.getLong("id");
        Long supplyOrgId = supplyOrg.getLong("id");
        Long materialId = material.getLong("id");
        if ("A".equals(type)) {
            if (materialMftInfo != null) {
                DynamicObject inwarorg = materialMftInfo.getDynamicObject("inwarorg");
                DynamicObject inwarehouse = materialMftInfo.getDynamicObject("inwarehouse");
                DynamicObject inwarelocation = materialMftInfo.getDynamicObject("inwarelocation");
                inwareInfo.put("inwarorg", inwarorg == null ? 0L : inwarorg.getLong("id"));
                inwareInfo.put("inwarehouse", inwarehouse == null ? 0L : inwarehouse.getLong("id"));
                inwareInfo.put("inwarelocation", inwarelocation == null ? 0L : inwarelocation.getLong("id"));
            }
        } else if ("B".equals(type) && ((inwareInfo = PlanScopeHelper.getInwareInfo((Long)planScopeId, (Long)supplyOrgId, (Long)materialId)) == null || inwareInfo.get("inwarehouse") == 0L)) {
            inwareInfo = PlanScopeHelper.getInwareInfoByPlanscope((Long)planScopeId, (Long)supplyOrgId, (Boolean)true);
        }
        return inwareInfo;
    }

    public Map<String, Long> getDefSupplierInfoConsiderInterAssist(DynamicObject bomEntry, DynamicObject entrymaterial, DynamicObject entrysupplyorg, DynamicObject interAssistType, DynamicObject manuVersiontInfo) {
        HashMap<String, Long> supplyInfo = new HashMap(3);
        DynamicObject masterid = entrymaterial.getDynamicObject("masterid");
        Long materialId = masterid.getLong("id");
        if (interAssistType != null && "B".equals(interAssistType.getString("type"))) {
            DynamicObject supplyOrg = interAssistType.getDynamicObject("supply_org");
            DynamicObject materialMftInfo = PlanOrderHelper.getMaterialMftInfo((Long)entrymaterial.getLong("id"), (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)"bd_materialmftinfo", (String)"id,warehouse,supplyorgunitid,location,createorg", null);
            if (materialMftInfo != null) {
                DynamicObject supplyorgunitid = materialMftInfo.getDynamicObject("supplyorgunitid");
                DynamicObject warehouse = materialMftInfo.getDynamicObject("warehouse");
                DynamicObject location = materialMftInfo.getDynamicObject("location");
                supplyInfo.put("entrysupplyorgunitid", supplyorgunitid == null ? 0L : supplyorgunitid.getLong("id"));
                supplyInfo.put("entrywarehouse", warehouse == null ? 0L : warehouse.getLong("id"));
                supplyInfo.put("entrylocation", location == null ? 0L : location.getLong("id"));
                this.dealPlanScopeSupplerInfo(supplyInfo, supplyOrg == null ? 0L : supplyOrg.getLong("id"), materialId);
                supplyInfo.put("entrysupplyorg", (Long)supplyInfo.get("entrysupplyorgunitid"));
            }
        } else {
            supplyInfo = this.getDefSupplierInfo(bomEntry, entrymaterial, entrysupplyorg, manuVersiontInfo);
        }
        return supplyInfo;
    }

    public String getBatchDefSupplierInfoConsiderInterAssist(String redisKey) {
        Map params = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache().getAll(redisKey);
        String bomEntryIdMapStr = (String)params.get("bomEntryIdMap");
        String entrymaterialIdMapStr = (String)params.get("entrymaterialIdMap");
        String entrysupplyorgIdMapStr = (String)params.get("entrysupplyorgIdMap");
        String interAssistTypeIdMapStr = (String)params.get("interAssistTypeIdMap");
        String manuVersiontIdMapStr = (String)params.get("manuVersiontIdMap");
        Map bomEntryIds = (Map)SerializationUtils.fromJsonString((String)bomEntryIdMapStr, Map.class);
        Map entrymaterialIds = (Map)SerializationUtils.fromJsonString((String)entrymaterialIdMapStr, Map.class);
        Map entrysupplyorgIds = (Map)SerializationUtils.fromJsonString((String)entrysupplyorgIdMapStr, Map.class);
        Map interAssistTypeIds = (Map)SerializationUtils.fromJsonString((String)interAssistTypeIdMapStr, Map.class);
        Map manuVersiontIds = (Map)SerializationUtils.fromJsonString((String)manuVersiontIdMapStr, Map.class);
        Map<String, Long> bomEntryIdMap = this.ConvertLongMap(bomEntryIds);
        Map<String, Long> entrymaterialIdMap = this.ConvertLongMap(entrymaterialIds);
        Map<String, Long> entrysupplyorgIdMap = this.ConvertLongMap(entrysupplyorgIds);
        Map<String, Long> interAssistTypeIdMap = this.ConvertLongMap(interAssistTypeIds);
        Map<String, Long> manuVersiontIdMap = this.ConvertLongMap(manuVersiontIds);
        Map materialmftinfos = BusinessDataServiceHelper.loadFromCache((String)"bd_materialmftinfo", (String)"id,masterid,createorg,masterid,supplyorgunitid,warehouse,location,invinfosrc,isstockallot", (QFilter[])new QFilter[]{new QFilter("id", "in", entrymaterialIdMap.values())});
        QFilter[] filters = new QFilter[]{new QFilter("entry.id", "in", bomEntryIdMap.values())};
        HashMap<Long, Map> bomMaps = new HashMap<Long, Map>(bomEntryIdMap.size());
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanScopeServiceimpl.class.getName(), (String)"pdm_mftbom", (String)"entry.id,entry.entrysupplyorg,entry.entrywarehouse,entry.entrylocation", (QFilter[])filters, null);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                Long bomEntryId = row.getLong(0);
                Long entrysupplyorg = row.getLong(1);
                Long entrywarehouse = row.getLong(2);
                Long entrylocation = row.getLong(3);
                Map map = bomMaps.computeIfAbsent(bomEntryId, k -> new HashMap(16));
                map.put("entrysupplyorgunitid", entrysupplyorg);
                map.put("entrywarehouse", entrywarehouse);
                map.put("entrylocation", entrylocation);
            }
            dataset.close();
        }
        Map manuVersionMap = BusinessDataServiceHelper.loadFromCache((String)"pdm_manuversion", (String)"id,supstockorgid,supwarehouseid,suplocationid", (QFilter[])new QFilter[]{new QFilter("id", "in", manuVersiontIdMap.values())});
        HashMap<String, Map<String, Long>> supplyInfo = new HashMap<String, Map<String, Long>>(interAssistTypeIdMap.size());
        Set<String> noInterAssistTypeKey = interAssistTypeIdMap.keySet();
        this.initializeSupplyInfo(supplyInfo, noInterAssistTypeKey);
        HashMap<String, Long> keyWarehouses = new HashMap<String, Long>(16);
        HashMap<Long, Map> orgWarehouseMaterial = new HashMap<Long, Map>(16);
        HashMap<String, Map<String, Long>> supplyInfoMft = new HashMap<String, Map<String, Long>>(16);
        for (String string : noInterAssistTypeKey) {
            DynamicObject manuVersion;
            Long manuVersiontId;
            Long l = entrymaterialIdMap.get(string);
            DynamicObject materialInfo = (DynamicObject)materialmftinfos.get(l);
            if (materialInfo == null) continue;
            DynamicObject material = materialInfo.getDynamicObject("masterid");
            Long materialId = material.getLong("id");
            String invinfosrc = materialInfo.getString("invinfosrc");
            Long orgId = entrysupplyorgIdMap.get(string);
            Map map = orgWarehouseMaterial.computeIfAbsent(orgId, k -> new HashMap(16));
            if ("A".equals(invinfosrc)) {
                Long bomEntryId = bomEntryIdMap.get(string);
                Map bomMap = (Map)bomMaps.get(bomEntryId);
                if (bomMap == null) continue;
                this.updateSupplyInfoBomEntry(supplyInfo, string, bomMap);
                continue;
            }
            if ("B".equals(invinfosrc)) {
                this.updateSupplyInfoMaterialMft(supplyInfo, string, materialInfo, map, materialId, keyWarehouses);
                continue;
            }
            if ("C".equals(invinfosrc)) {
                manuVersiontId = manuVersiontIdMap.get(string);
                manuVersion = (DynamicObject)manuVersionMap.get(manuVersiontId);
                if (manuVersion == null) continue;
                this.updateSupplyInfoManuVersion(supplyInfo, string, manuVersion, map, materialId, keyWarehouses);
                continue;
            }
            if (!"D".equals(invinfosrc)) continue;
            manuVersiontId = manuVersiontIdMap.get(string);
            manuVersion = (DynamicObject)manuVersionMap.get(manuVersiontId);
            if (manuVersion == null) {
                this.updateSupplyInfoMaterialMft(supplyInfo, string, materialInfo, map, materialId, keyWarehouses);
                continue;
            }
            DynamicObject warehouse = manuVersion.getDynamicObject("supwarehouseid");
            Long entrywarehouseId = warehouse == null ? 0L : warehouse.getLong("id");
            log.info("\u83b7\u53d6\u751f\u4ea7\u7248\u672c\u4ed3\u5e93id\uff1a", (Object)entrywarehouseId.toString());
            if (entrywarehouseId == 0L) {
                this.updateSupplyInfoMaterialMft(supplyInfo, string, materialInfo, map, materialId, keyWarehouses);
                continue;
            }
            Set materials = map.computeIfAbsent(entrywarehouseId, k -> new HashSet());
            materials.add(materialId);
            keyWarehouses.put(string, entrywarehouseId);
            this.updateSupplyInfoMaterialMft(supplyInfoMft, string, materialInfo, map, materialId, null);
        }
        HashMap supplierInfos = new HashMap(16);
        for (Map.Entry entry : orgWarehouseMaterial.entrySet()) {
            Long orgId = (Long)entry.getKey();
            Map warehouseMaterial = (Map)entry.getValue();
            Set warehouseIds = warehouseMaterial.keySet();
            Map warehousesPlanscopes = PlanScopeHelper.getPlanscopeBywarehouses(warehouseIds, (Long)orgId);
            for (Map.Entry entry2 : warehousesPlanscopes.entrySet()) {
                Long planscopeId = (Long)entry2.getValue();
                if (planscopeId == null) continue;
                Long warehouseId = (Long)entry2.getKey();
                Set materialIds = (Set)warehouseMaterial.get(warehouseId);
                Map supplierInfo = PlanScopeHelper.getSupplierInfo((Long)planscopeId, (Long)orgId, (Long)warehouseId, (Set)materialIds);
                supplierInfos.putAll(supplierInfo);
            }
        }
        for (Map.Entry entry : keyWarehouses.entrySet()) {
            String key = (String)entry.getKey();
            Long warehouseId = (Long)entry.getValue();
            Long materialInfoId = entrymaterialIdMap.get(key);
            DynamicObject materialInfo = (DynamicObject)materialmftinfos.get(materialInfoId);
            if (materialInfo == null) continue;
            DynamicObject material = materialInfo.getDynamicObject("masterid");
            Long l = material.getLong("id");
            Long orgId = entrysupplyorgIdMap.get(key);
            String supplierInfoKey = l + "" + orgId + "" + warehouseId;
            Map supplierInfo = (Map)supplierInfos.get(supplierInfoKey);
            if (supplierInfo == null || supplierInfo.isEmpty() || (Long)supplierInfo.get("entrywarehouse") == 0L) {
                Map map = (Map)supplyInfoMft.get(key);
                if (map == null || map.isEmpty() || (Long)map.get("entrywarehouse") == 0L) continue;
                supplyInfo.put(key, map);
                Long entrywarehouse = (Long)map.get("entrywarehouse");
                String supplierKey = l + "" + orgId + "" + entrywarehouse;
                Map supplier = (Map)supplierInfos.get(supplierKey);
                if (supplier == null || supplier.isEmpty() || (Long)supplier.get("entrywarehouse") == 0L) continue;
                this.updateSupplyInfoPlanScope(supplyInfo, key, supplier);
                continue;
            }
            this.updateSupplyInfoPlanScope(supplyInfo, key, supplierInfo);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        String string = SerializationUtils.toJsonString(supplyInfo);
        hashMap.put("supplyInfoStr", string);
        String accountId = RequestContext.get().getAccountId();
        String rediskey = accountId + UUID.randomUUID() + "BatchDefSupplierInfo";
        CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache().put(rediskey, hashMap);
        return rediskey;
    }

    public boolean isEnablePlanScope() {
        return PlanScopeHelper.isEnablePlanScope();
    }

    public boolean isDisablePlanScope() {
        return !this.isEnablePlanScope();
    }

    private Map<String, Long> ConvertLongMap(Map<?, ?> map) {
        HashMap<String, Long> result = new HashMap<String, Long>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result.put(entry.getKey().toString(), Long.parseLong(entry.getValue().toString()));
        }
        return result;
    }

    private void updateSupplyInfoPlanScope(Map<String, Map<String, Long>> supplyInfo, String key, Map<String, Long> supplierInfo) {
        Long entrysupplyorgunit = supplierInfo.get("entrysupplyorgunitid");
        Long entrywarehouse = supplierInfo.get("entrywarehouse");
        Long entrylocation = supplierInfo.get("entrylocation");
        Map supplyInfoMap = supplyInfo.computeIfAbsent(key, k -> new HashMap());
        supplyInfoMap.put("entrysupplyorg", entrysupplyorgunit);
        supplyInfoMap.put("entrywarehouse", entrywarehouse);
        supplyInfoMap.put("entrylocation", entrylocation);
    }

    private void updateSupplyInfoManuVersion(Map<String, Map<String, Long>> supplyInfo, String key, DynamicObject manuVersiontInfo, Map<Long, Set<Long>> materialWarehouse, Long materialId, Map<String, Long> keyWarehouses) {
        DynamicObject supplyorgunitid = manuVersiontInfo.getDynamicObject("supstockorgid");
        Long entrysupplyorgunitid = supplyorgunitid == null ? 0L : supplyorgunitid.getLong("id");
        DynamicObject warehouse = manuVersiontInfo.getDynamicObject("supwarehouseid");
        Long entrywarehouseId = warehouse == null ? 0L : warehouse.getLong("id");
        DynamicObject location = manuVersiontInfo.getDynamicObject("suplocationid");
        Long entrylocationId = location == null ? 0L : location.getLong("id");
        Map supplyInfoMap = supplyInfo.computeIfAbsent(key, k -> new HashMap());
        supplyInfoMap.put("entrysupplyorg", entrysupplyorgunitid);
        supplyInfoMap.put("entrywarehouse", entrywarehouseId);
        supplyInfoMap.put("entrylocation", entrylocationId);
        if (entrywarehouseId == 0L) {
            return;
        }
        Set materials = materialWarehouse.computeIfAbsent(entrywarehouseId, k -> new HashSet());
        materials.add(materialId);
        keyWarehouses.put(key, entrywarehouseId);
    }

    private void updateSupplyInfoBomEntry(Map<String, Map<String, Long>> supplyInfo, String key, Map<String, Long> bomMap) {
        Long entrysupplyorgunit = bomMap.get("entrysupplyorgunitid");
        Long entrywarehouse = bomMap.get("entrywarehouse");
        Long entrylocation = bomMap.get("entrylocation");
        Map supplyInfoMap = supplyInfo.computeIfAbsent(key, k -> new HashMap());
        supplyInfoMap.put("entrysupplyorg", entrysupplyorgunit);
        supplyInfoMap.put("entrywarehouse", entrywarehouse);
        supplyInfoMap.put("entrylocation", entrylocation);
    }

    private void updateSupplyInfoMaterialMft(Map<String, Map<String, Long>> supplyInfo, String key, DynamicObject entryMaterialMft, Map<Long, Set<Long>> materialWarehouse, Long materialId, Map<String, Long> keyWarehouses) {
        Map supplyInfoMap = supplyInfo.computeIfAbsent(key, k -> new HashMap());
        DynamicObject supplyorgunitid = entryMaterialMft.getDynamicObject("supplyorgunitid");
        DynamicObject warehouse = entryMaterialMft.getDynamicObject("warehouse");
        DynamicObject location = entryMaterialMft.getDynamicObject("location");
        Long warehouseId = warehouse == null ? 0L : warehouse.getLong("id");
        supplyInfoMap.put("entrysupplyorg", supplyorgunitid == null ? 0L : supplyorgunitid.getLong("id"));
        supplyInfoMap.put("entrywarehouse", warehouseId);
        supplyInfoMap.put("entrylocation", location == null ? 0L : location.getLong("id"));
        if (warehouseId == 0L) {
            return;
        }
        Set materials = materialWarehouse.computeIfAbsent(warehouseId, k -> new HashSet());
        materials.add(materialId);
        if (keyWarehouses == null) {
            return;
        }
        keyWarehouses.put(key, warehouseId);
    }

    private void initializeSupplyInfo(Map<String, Map<String, Long>> supplyInfo, Set<String> keys) {
        for (String key : keys) {
            HashMap<String, Long> supplyInfoMap = new HashMap<String, Long>(3);
            supplyInfoMap.put("entrysupplyorg", 0L);
            supplyInfoMap.put("entrywarehouse", 0L);
            supplyInfoMap.put("entrylocation", 0L);
            supplyInfo.put(key, supplyInfoMap);
        }
    }

    public Map<String, Long> getDefSupplierInfo(DynamicObject bomEntry, DynamicObject entrymaterial, DynamicObject entrysupplyorg, DynamicObject manuVersiontInfo) {
        HashMap<String, Long> supplyInfo = new HashMap<String, Long>(3);
        DynamicObject masterid = entrymaterial.getDynamicObject("masterid");
        String invinfosrc = entrymaterial.getString("invinfosrc");
        Long entrysupplyorgunitid = 0L;
        Long entrywarehouseId = 0L;
        Long entrylocationId = 0L;
        HashMap<String, Long> supplyInfoMap = new HashMap<String, Long>(3);
        supplyInfoMap.put("entrysupplyorgunitid", entrysupplyorgunitid);
        supplyInfoMap.put("entrywarehouse", entrywarehouseId);
        supplyInfoMap.put("entrylocation", entrylocationId);
        Long entrysupplyorgId = entrysupplyorg.getLong("id");
        Long materialId = masterid.getLong("id");
        if ("A".equals(invinfosrc)) {
            if (bomEntry != null) {
                DynamicObject entrysupplyorgunit = bomEntry.getDynamicObject("entrysupplyorg");
                entrysupplyorgunitid = entrysupplyorgunit == null ? 0L : entrysupplyorgunit.getLong("id");
                DynamicObject entrywarehouse = bomEntry.getDynamicObject("entrywarehouse");
                entrywarehouseId = entrywarehouse == null ? 0L : entrywarehouse.getLong("id");
                DynamicObject entrylocation = bomEntry.getDynamicObject("entrylocation");
                entrylocationId = entrylocation == null ? 0L : entrylocation.getLong("id");
                supplyInfoMap.put("entrysupplyorgunitid", entrysupplyorgunitid);
                supplyInfoMap.put("entrywarehouse", entrywarehouseId);
                supplyInfoMap.put("entrylocation", entrylocationId);
            }
        } else if ("B".equals(invinfosrc)) {
            this.dealMftInfoSupplyInfo(supplyInfoMap, entrymaterial, entrysupplyorgId, materialId);
        } else if ("C".equals(invinfosrc)) {
            if (manuVersiontInfo != null) {
                DynamicObject supplyorgunitid = manuVersiontInfo.getDynamicObject("supstockorgid");
                entrysupplyorgunitid = supplyorgunitid == null ? 0L : supplyorgunitid.getLong("id");
                DynamicObject warehouse = manuVersiontInfo.getDynamicObject("supwarehouseid");
                entrywarehouseId = warehouse == null ? 0L : warehouse.getLong("id");
                DynamicObject location = manuVersiontInfo.getDynamicObject("suplocationid");
                entrylocationId = location == null ? 0L : location.getLong("id");
                supplyInfoMap.put("entrysupplyorgunitid", entrysupplyorgunitid);
                supplyInfoMap.put("entrywarehouse", entrywarehouseId);
                supplyInfoMap.put("entrylocation", entrylocationId);
                this.dealPlanScopeSupplerInfo(supplyInfoMap, entrysupplyorgId, materialId);
            }
        } else if ("D".equals(invinfosrc)) {
            this.dealManuversionForD(supplyInfoMap, entrymaterial, entrysupplyorgId, materialId, manuVersiontInfo);
        }
        supplyInfo.put("entrysupplyorg", (Long)supplyInfoMap.get("entrysupplyorgunitid"));
        supplyInfo.put("entrywarehouse", (Long)supplyInfoMap.get("entrywarehouse"));
        supplyInfo.put("entrylocation", (Long)supplyInfoMap.get("entrylocation"));
        return supplyInfo;
    }

    private void dealManuversionForD(Map<String, Long> supplyInfoMap, DynamicObject entrymaterial, Long entrysupplyorgId, Long materialId, DynamicObject manuVersiontInfo) {
        Long entrywarehouseId = supplyInfoMap.get("entrywarehouse");
        log.info("\u83b7\u53d6\u751f\u4ea7\u7248\u672cid\uff1a", (Object)(manuVersiontInfo == null ? "0" : manuVersiontInfo.getString("id")));
        if (manuVersiontInfo == null) {
            this.dealMftInfoSupplyInfo(supplyInfoMap, entrymaterial, entrysupplyorgId, materialId);
            return;
        }
        DynamicObject warehouse = manuVersiontInfo.getDynamicObject("supwarehouseid");
        entrywarehouseId = warehouse == null ? 0L : warehouse.getLong("id");
        log.info("\u83b7\u53d6\u751f\u4ea7\u7248\u672c\u4ed3\u5e93id\uff1a", (Object)entrywarehouseId.toString());
        if (entrywarehouseId == 0L) {
            this.dealMftInfoSupplyInfo(supplyInfoMap, entrymaterial, entrysupplyorgId, materialId);
        } else {
            supplyInfoMap.put("entrywarehouse", entrywarehouseId);
            boolean isdiscover = this.dealPlanScopeSupplerInfo(supplyInfoMap, entrysupplyorgId, materialId);
            if (!isdiscover) {
                isdiscover = this.dealMftInfoSupplyInfo(supplyInfoMap, entrymaterial, entrysupplyorgId, materialId);
            }
        }
    }

    private boolean dealMftInfoSupplyInfo(Map<String, Long> supplyInfoMap, DynamicObject entrymaterial, Long entrysupplyorgId, Long materialId) {
        log.info("\u83b7\u53d6\u751f\u4ea7\u4fe1\u606fid\uff1a", (Object)(entrymaterial == null ? "0" : entrymaterial.getString("id")));
        if (entrymaterial == null) {
            return false;
        }
        DynamicObject supplyorgunitid = entrymaterial.getDynamicObject("supplyorgunitid");
        DynamicObject warehouse = entrymaterial.getDynamicObject("warehouse");
        DynamicObject location = entrymaterial.getDynamicObject("location");
        supplyInfoMap.put("entrysupplyorgunitid", supplyorgunitid == null ? 0L : supplyorgunitid.getLong("id"));
        supplyInfoMap.put("entrywarehouse", warehouse == null ? 0L : warehouse.getLong("id"));
        supplyInfoMap.put("entrylocation", location == null ? 0L : location.getLong("id"));
        log.info("\u83b7\u53d6\u751f\u4ea7\u4fe1\u606fid\uff1a", (Object)supplyInfoMap.get("entrywarehouse").toString());
        boolean issupplerinfo = this.dealPlanScopeSupplerInfo(supplyInfoMap, entrysupplyorgId, materialId);
        if (issupplerinfo) {
            return true;
        }
        return supplyInfoMap.get("entrywarehouse") != 0L;
    }

    private boolean dealPlanScopeSupplerInfo(Map<String, Long> supplyInfoMap, Long entrysupplyorg, Long materialId) {
        Long entrywarehouseId = supplyInfoMap.get("entrywarehouse");
        log.info("\u83b7\u53d6\u4ed3\u5e93id\uff1a", (Object)entrywarehouseId.toString());
        Map supplierInfo = PlanScopeHelper.getSupplierInfo((Long)entrywarehouseId, (Long)entrysupplyorg, (Long)materialId);
        if (supplierInfo == null || supplierInfo.isEmpty()) {
            return false;
        }
        supplyInfoMap.put("entrysupplyorgunitid", (Long)supplierInfo.get("entrysupplyorgunitid"));
        supplyInfoMap.put("entrywarehouse", (Long)supplierInfo.get("entrywarehouse"));
        supplyInfoMap.put("entrylocation", (Long)supplierInfo.get("entrylocation"));
        return true;
    }
}

