/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.reportext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;

public class OrgConvertHelper {
    private static final ThreadLocal<Map<String, Long>> orgConvertThreadLocal = new ThreadLocal();
    private static final Log logger = LogFactory.getLog(OrgConvertHelper.class);

    public static long getCacheConvertOrgId(long fromOrgId, String fromOrgType, String toOrgType) {
        String mapKeys = OrgConvertHelper.genUnionString(fromOrgId, fromOrgType, toOrgType);
        Map<String, Long> threadCacheMap = orgConvertThreadLocal.get();
        if (threadCacheMap == null) {
            threadCacheMap = new HashMap<String, Long>(16);
            orgConvertThreadLocal.set(threadCacheMap);
        }
        if (threadCacheMap.containsKey(mapKeys)) {
            return threadCacheMap.get(mapKeys);
        }
        long toOrgId = OrgConvertHelper.getConvertOrgId(fromOrgId, fromOrgType, toOrgType);
        logger.info("---OrgConvertHelper.getCacheConvertOrgId,fromOrgId=" + fromOrgId + ",fromOrgType=" + fromOrgType + ",toOrgType=" + toOrgType + ",toOrgId=" + toOrgId);
        threadCacheMap.put(mapKeys, toOrgId);
        return toOrgId;
    }

    public static long getConvertOrgId(long fromOrgId, String fromOrgType, String toOrgType) {
        if (OrgConvertHelper.checkOrgIsToTypeOrg(fromOrgId, toOrgType)) {
            return fromOrgId;
        }
        List allToOrg = "04".equals(fromOrgType) ? ("02".equals(toOrgType) ? OrgUnitServiceHelper.getAllToOrg((String)"", (String)toOrgType, (Long)fromOrgId) : OrgUnitServiceHelper.getAllToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId)) : OrgUnitServiceHelper.getAllToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId);
        ArrayList filterList = new ArrayList();
        if (allToOrg != null && !allToOrg.isEmpty()) {
            filterList.addAll(allToOrg);
        }
        return filterList.isEmpty() ? 0L : (Long)filterList.get(0);
    }

    private static boolean checkOrgIsAccount(Long orgid) {
        DynamicObject dyOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org", (String)"fisaccounting");
        return dyOrg.getBoolean("fisaccounting");
    }

    private static boolean checkOrgIsToTypeOrg(Long orgid, String toOrgType) {
        String fieldNumber = OrgConvertHelper.getFieldString(toOrgType);
        if (StringUtils.isEmpty((String)fieldNumber)) {
            return false;
        }
        DynamicObject dyOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org", (String)fieldNumber);
        return dyOrg.getBoolean(fieldNumber);
    }

    private static String getFieldString(String toOrgType) {
        String fieldNumber = "";
        switch (toOrgType) {
            case "10": {
                fieldNumber = "fisaccounting";
                break;
            }
            case "05": {
                fieldNumber = "fisinventory";
                break;
            }
            case "02": {
                fieldNumber = "fispurchase";
                break;
            }
            case "04": {
                fieldNumber = "fisproduce";
                break;
            }
            case "01": {
                fieldNumber = "fisadministrative";
                break;
            }
            case "03": {
                fieldNumber = "fissale";
                break;
            }
            case "06": {
                fieldNumber = "fisqc";
                break;
            }
            case "07": {
                fieldNumber = "fissettlement";
                break;
            }
            case "08": {
                fieldNumber = "fisbankroll";
                break;
            }
            case "09": {
                fieldNumber = "fisasset";
                break;
            }
            case "11": {
                fieldNumber = "fishr";
                break;
            }
            case "12": {
                fieldNumber = "fisscc";
                break;
            }
            case "13": {
                fieldNumber = "fisbudget";
                break;
            }
            case "14": {
                fieldNumber = "fiscontrolunit";
                break;
            }
        }
        return fieldNumber;
    }

    private static String genUnionString(long fromOrgId, String fromOrgType, String toOrgType) {
        return String.valueOf(fromOrgId) + "_" + fromOrgType + "_" + toOrgType;
    }
}

