/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.reportext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.service.datafetch.custom.CustomMethodStruct;
import kd.mpscmm.msplan.mservice.service.datafetch.custom.CustomMethodUtils;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;
import kd.mpscmm.msplan.mservice.service.reportext.BillTransferEntryModel;
import kd.mpscmm.msplan.mservice.service.reportext.EntityQueryModel;
import kd.mpscmm.msplan.mservice.service.reportext.ReportUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ReportExtModelService {
    private static final Log log = LogFactory.getLog(ReportExtModelService.class);
    private String reportEntityPK;
    private static final int MAXONSIZE = 5;
    private static final String ADDSORTSEQFIELD = "datasetsortseqfield";
    private static final int IDBATCHMAXSIZE = 50000;
    private static ReportExtModelService impl;

    public static ReportExtModelService getInstance() {
        if (impl == null) {
            impl = new ReportExtModelService();
        }
        return impl;
    }

    public DataSet convertDataSet(DataSet reportDataSet, String reportEntity) {
        if (StringUtils.isEmpty((String)reportEntity)) {
            return reportDataSet;
        }
        this.reportEntityPK = reportEntity;
        DynamicObject reportModel = this.getReportExtModel(this.reportEntityPK);
        if (reportModel == null) {
            return reportDataSet;
        }
        return this.genModelExtDataSet(reportModel, reportDataSet);
    }

    private DataSet genModelExtDataSet(DynamicObject reportModel, DataSet reportDataSet) {
        Map<String, Set<Object>> reportFieldIdMap;
        Map<String, DataSet> extDsMap;
        DynamicObjectCollection columnColl = reportModel.getDynamicObjectCollection("columnentryentity");
        DynamicObjectCollection dsColl = reportModel.getDynamicObjectCollection("entryentity");
        int size = columnColl.size();
        HashSet<String> srcDsNumberSet = new HashSet<String>(16);
        HashMap<String, Set<Object>> queryDsMap = new HashMap<String, Set<Object>>(16);
        HashMap<String, List<String>> queryDsSelectFieldMap = new HashMap<String, List<String>>(16);
        HashMap<String, BillTransferEntryModel> reportFunctionMap = new HashMap<String, BillTransferEntryModel>(16);
        HashMap<String, Map<String, BillTransferEntryModel>> extFunctionMap = new HashMap<String, Map<String, BillTransferEntryModel>>(16);
        MainEntityType reportType = MetadataServiceHelper.getDataEntityType((String)this.reportEntityPK);
        String reportTypeName = reportType.getName();
        Map<String, IDataEntityProperty> reportAllFields = DataSourceFetchDataUtil.getAllEntityProp(reportType);
        boolean hasColumnCompute = false;
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)columnColl.get(i);
            boolean isUnvisible = entry.getBoolean("fieldunvisible");
            if (isUnvisible) continue;
            String srcDsNumber = entry.getString("srcdsnumber");
            DynamicObject srcDataSourceEntity = entry.getDynamicObject("datasourceentity");
            String destField = entry.getString("fieldnumber");
            String srcField = "";
            String string = entry.getString("calculateexc_tag");
            String type = entry.getString("converttype");
            boolean isDynamicField = entry.getBoolean("isdynamicfield");
            if ("6".equals(type)) {
                hasColumnCompute = true;
                continue;
            }
            if (StringUtils.isEmpty((String)srcDsNumber) || srcDataSourceEntity == null) {
                BillTransferEntryModel reportTransModel;
                if (StringUtils.isEmpty((String)string) || (reportTransModel = this.getTransferModel(srcField, destField, type, string, reportTypeName, reportAllFields, (Long)entry.getPkValue(), isDynamicField)).getCustomMethodStruct() == null && !isDynamicField) continue;
                reportTransModel.setSrcRenameField(destField);
                reportFunctionMap.put(destField, reportTransModel);
                continue;
            }
            MainEntityType srcType = MetadataServiceHelper.getDataEntityType((String)srcDataSourceEntity.getString("id"));
            String srcTypeName = srcType.getName();
            Map<String, IDataEntityProperty> allFields = DataSourceFetchDataUtil.getAllEntityProp(srcType);
            srcDsNumberSet.add(srcDsNumber);
            if (this.isReportExtModelDs(srcDataSourceEntity)) continue;
            BillTransferEntryModel transModel = this.getTransferModel(srcField, destField, type, string, srcTypeName, allFields, (Long)entry.getPkValue(), isDynamicField);
            transModel.setSrcRenameField(destField);
            if (transModel.getCustomMethodStruct() != null) {
                HashMap<String, BillTransferEntryModel> extMap = (HashMap<String, BillTransferEntryModel>)extFunctionMap.get(srcDsNumber);
                if (extMap == null) {
                    extMap = new HashMap<String, BillTransferEntryModel>(16);
                }
                extMap.put(destField, transModel);
                extFunctionMap.put(srcDsNumber, extMap);
                Set<String> paramSet = transModel.getFormulaSrcFields();
                if (ReportUtils.isNullSet(paramSet)) continue;
                for (String field : paramSet) {
                    this.addValueToMap(queryDsMap, srcDsNumber, field);
                    String renameFields = field + " as " + field;
                    this.addValueToListMap(queryDsSelectFieldMap, srcDsNumber, renameFields);
                }
                continue;
            }
            String queryFieldNumber = transModel.getFormulaStr();
            if (StringUtils.isEmpty((String)queryFieldNumber)) continue;
            this.addValueToMap(queryDsMap, srcDsNumber, queryFieldNumber);
            String renameFields = queryFieldNumber + " as " + destField;
            this.addValueToListMap(queryDsSelectFieldMap, srcDsNumber, renameFields);
        }
        DataSet resultDataSet = reportDataSet;
        if (!ReportUtils.isNullMap(reportFunctionMap)) {
            resultDataSet = this.computeMapFunction(this.reportEntityPK, reportFunctionMap, resultDataSet);
        }
        HashSet<String> allReportFilterFieldSet = new HashSet<String>(16);
        HashMap<String, EntityQueryModel> dsFilterModelMap = new HashMap<String, EntityQueryModel>(16);
        if (dsColl != null && !dsColl.isEmpty()) {
            int dsCollSize = dsColl.size();
            for (int i = 0; i < dsCollSize; ++i) {
                DynamicObject dsEntry = (DynamicObject)dsColl.get(i);
                String dsNumber = dsEntry.getString("dsnumber");
                if (!srcDsNumberSet.contains(dsNumber)) continue;
                DynamicObject dynamicObject = dsEntry.getDynamicObject("extentity");
                String extEntityNumber = (String)dynamicObject.getPkValue();
                DynamicObject matchDimensions = dsEntry.getDynamicObject("matchdimensions");
                String filterrulevalue = dsEntry.getString("filterrulevalue_tag");
                QFilter extFilter = null;
                if (null != filterrulevalue && !"".equals(filterrulevalue)) {
                    extFilter = this.getQFilter(filterrulevalue, extEntityNumber);
                }
                matchDimensions = BusinessDataServiceHelper.loadSingle((Object)matchDimensions.getPkValue(), (String)"mrp_billfieldtransfer");
                Map<String, BillTransferEntryModel> billTransMap = this.genBillTransEntryData(matchDimensions);
                resultDataSet = this.computeMapFunction(matchDimensions.getString("number"), billTransMap, resultDataSet);
                Set<String> reportFilterFieldSet = this.getFilterReportEntityFieldSet(matchDimensions, billTransMap);
                boolean isFieldFull = true;
                for (String reportFields : reportFilterFieldSet) {
                    if (ReportUtils.isContainsField(reportFields, resultDataSet)) continue;
                    isFieldFull = false;
                    break;
                }
                if (!isFieldFull) continue;
                Set<String> extFilterFieldSet = this.getFilterExtEntityFieldSet(matchDimensions, billTransMap);
                ReportUtils.addToSet(allReportFilterFieldSet, reportFilterFieldSet);
                Set extQueryFieldSet = (Set)queryDsMap.get(dsNumber);
                ReportUtils.addToSet(extQueryFieldSet, extFilterFieldSet);
                String extSelectProperties = this.getSelectFields(extQueryFieldSet);
                String algoStr = ReportExtModelService.class.getName() + "_query_" + extEntityNumber;
                EntityQueryModel queryModel = new EntityQueryModel(dsNumber, extSelectProperties, extEntityNumber, extFilter, billTransMap, matchDimensions, algoStr);
                dsFilterModelMap.put(dsNumber, queryModel);
            }
        }
        if ((extDsMap = this.queryExtEntityDataSet(reportFieldIdMap = this.getReportFieldIdSet(allReportFilterFieldSet, resultDataSet), dsFilterModelMap, extFunctionMap)) != null && !extDsMap.isEmpty()) {
            resultDataSet = resultDataSet.addBalanceField("1", ADDSORTSEQFIELD);
            HashSet<String> execUpSet = new HashSet<String>(16);
            for (Map.Entry entry : extDsMap.entrySet()) {
                List extList;
                String dsNumber = (String)entry.getKey();
                DataSet extDs = (DataSet)entry.getValue();
                if (extDs == null || ReportUtils.isNullList(extList = (List)queryDsSelectFieldMap.get(dsNumber))) continue;
                String[] reportFields = this.getRowMetaFields(resultDataSet);
                String[] extFields = extList.toArray(new String[extList.size()]);
                EntityQueryModel queryModel = (EntityQueryModel)dsFilterModelMap.get(dsNumber);
                boolean isSrcReport = this.isSrcReport(queryModel.getMatchDimensions());
                Map<String, BillTransferEntryModel> billTransMap = queryModel.getBillTransMap();
                resultDataSet = this.updateWhereNullData(resultDataSet, billTransMap, isSrcReport, true, execUpSet);
                extDs = this.updateWhereNullData(extDs, billTransMap, isSrcReport, false, execUpSet);
                JoinDataSet js = resultDataSet.leftJoin(extDs);
                js = this.buildDataSetOnValue(js, billTransMap, isSrcReport);
                resultDataSet = js.select(reportFields, extFields).finish();
            }
            resultDataSet.orderBy(new String[]{ADDSORTSEQFIELD});
        }
        if (hasColumnCompute) {
            for (int i = 0; i < size; ++i) {
                DynamicObject entry = (DynamicObject)columnColl.get(i);
                boolean bl = entry.getBoolean("fieldunvisible");
                if (bl) continue;
                String destField = entry.getString("fieldnumber");
                String formula = entry.getString("calculateexc");
                String type = entry.getString("converttype");
                if (!"6".equals(type) || formula == null || "".equals(formula)) continue;
                resultDataSet = resultDataSet.addField(formula, destField);
            }
        }
        return resultDataSet;
    }

    public DataSet computeMapFunction(String billTransNumber, Map<String, BillTransferEntryModel> billTransMap, DataSet reportDataSet) {
        DataSet reportDataSetA = reportDataSet;
        String[] reportFields = this.getRowMetaFields(reportDataSetA);
        ArrayList<String> addFieldList = new ArrayList<String>(16);
        for (Map.Entry<String, BillTransferEntryModel> mps : billTransMap.entrySet()) {
            long startTime = System.currentTimeMillis();
            BillTransferEntryModel fieldModel = mps.getValue();
            String functionFieldNumber = fieldModel.getSrcRenameField();
            String forumlStr = fieldModel.getFormulaStr();
            CustomMethodStruct customMethod = fieldModel.getCustomMethodStruct();
            if (customMethod == null) {
                if (!fieldModel.isDynamicField() || StringUtils.isEmpty((String)forumlStr)) continue;
                reportDataSetA = reportDataSetA.addField(forumlStr, functionFieldNumber);
                addFieldList.add(functionFieldNumber);
                continue;
            }
            reportDataSetA = reportDataSetA.addNullField(functionFieldNumber);
            addFieldList.add(functionFieldNumber);
            String targetField = functionFieldNumber;
            MapFunction function = CustomMethodUtils.buildAlgoMapFunction(reportDataSetA.getRowMeta(), targetField, customMethod);
            if (function != null) {
                reportDataSetA = reportDataSetA.map(function);
            }
            long enddate = System.currentTimeMillis() - startTime;
            log.info("---ReportExtModelService.computeMapFunction---matchDimensions:" + billTransNumber + ",functionFieldNumber = " + functionFieldNumber + ",targetField = " + targetField + ",customMethod=" + customMethod.getMethodName() + ",cost=" + enddate + "ms");
        }
        if (!addFieldList.isEmpty()) {
            addFieldList.addAll(Arrays.asList(reportFields));
            String[] allFields = addFieldList.toArray(new String[addFieldList.size()]);
            reportDataSetA = reportDataSetA.select(allFields);
        }
        return reportDataSetA;
    }

    private String[] getRowMetaFields(DataSet ds) {
        return ds.getRowMeta().getFieldNames();
    }

    private JoinDataSet buildDataSetOnValue(JoinDataSet dataSet, Map<String, BillTransferEntryModel> billTransMap, boolean isSrcReport) {
        for (Map.Entry<String, BillTransferEntryModel> entrys : billTransMap.entrySet()) {
            String destField = entrys.getKey();
            BillTransferEntryModel transModel = entrys.getValue();
            String srcField = transModel.getSrcField();
            if (StringUtils.isEmpty((String)srcField)) {
                srcField = transModel.getCustomMethodStruct() != null ? transModel.getSrcRenameField() : this.getFieldNumber(transModel.getFormulaSrcFields());
            }
            if (isSrcReport) {
                dataSet = dataSet.on(srcField, destField);
                continue;
            }
            dataSet = dataSet.on(destField, srcField);
        }
        return dataSet;
    }

    private String getSrcField(BillTransferEntryModel transModel) {
        String srcField = transModel.getSrcField();
        if (StringUtils.isEmpty((String)srcField)) {
            srcField = transModel.getCustomMethodStruct() != null ? transModel.getSrcRenameField() : this.getFieldNumber(transModel.getFormulaSrcFields());
        }
        return srcField;
    }

    private DataSet updateWhereNullData(DataSet dataSet, Map<String, BillTransferEntryModel> billTransMap, boolean isSrcReport, boolean isReportDataSet, Set<String> execUpSet) {
        for (Map.Entry<String, BillTransferEntryModel> entrys : billTransMap.entrySet()) {
            String fieldNumber = entrys.getKey();
            BillTransferEntryModel transModel = entrys.getValue();
            if (isSrcReport && isReportDataSet || !isSrcReport && !isReportDataSet) {
                fieldNumber = this.getSrcField(transModel);
            }
            if (isReportDataSet && !execUpSet.add(fieldNumber) || !ReportUtils.isContainsField(fieldNumber, dataSet)) continue;
            String exp = "case when " + fieldNumber + " is null then " + this.getNullValue(dataSet, fieldNumber) + " else " + fieldNumber + " end";
            dataSet = dataSet.updateField(fieldNumber, exp);
        }
        return dataSet;
    }

    private String getNullValue(DataSet dataSet, String fieldNumber) {
        DataType dataType = ReportUtils.getDataType(fieldNumber, dataSet);
        if (dataType == null) {
            return "''";
        }
        if (dataType.equals((Object)DataType.LongType) || dataType.equals((Object)DataType.IntegerType) || dataType.equals((Object)DataType.BigDecimalType)) {
            return " 0 ";
        }
        if (dataType.equals((Object)DataType.BooleanType)) {
            return " false ";
        }
        return " '' ";
    }

    private Map<String, DataSet> queryExtEntityDataSet(Map<String, Set<Object>> reportFieldIdMap, Map<String, EntityQueryModel> dsFilterModelMap, Map<String, Map<String, BillTransferEntryModel>> extFunctionMap) {
        HashMap<String, DataSet> resultMap = new HashMap<String, DataSet>(16);
        if (ReportUtils.isNullMap(reportFieldIdMap) || ReportUtils.isNullMap(dsFilterModelMap)) {
            return resultMap;
        }
        long startTime = System.currentTimeMillis();
        for (Map.Entry<String, EntityQueryModel> entrys : dsFilterModelMap.entrySet()) {
            EntityQueryModel model = entrys.getValue();
            String selectProperties = model.getSelectProperties();
            QFilter qfiter = model.getExtQFilter();
            String entityNumber = model.getEntityNumber();
            Map<String, BillTransferEntryModel> billTransMap = model.getBillTransMap();
            if (ReportUtils.isNullMap(billTransMap)) {
                log.info("---ReportExtModelService.queryExtEntityDataSet---entityNumber:" + entityNumber + ",selectProperties = " + selectProperties + ",billTransMap is null,continue ");
                continue;
            }
            DynamicObject matchDimensions = model.getMatchDimensions();
            String alogStr = model.getAlgoStr();
            String dsNumber = model.getDsNumber();
            boolean isSrcReport = this.isSrcReport(matchDimensions);
            QFilter allFieldQFilter = null;
            for (Map.Entry<String, BillTransferEntryModel> trans : billTransMap.entrySet()) {
                String destField = trans.getKey();
                BillTransferEntryModel entryModel = trans.getValue();
                Set<String> formulaSrcFields = entryModel.getFormulaSrcFields();
                CustomMethodStruct customMethod = entryModel.getCustomMethodStruct();
                String queryfieldNumber = this.getFieldNumber(formulaSrcFields);
                if (customMethod != null) {
                    queryfieldNumber = entryModel.getSrcRenameField();
                }
                QFilter fieldQFilter = isSrcReport ? this.buildQFilter(destField, queryfieldNumber, reportFieldIdMap) : this.buildQFilter(queryfieldNumber, destField, reportFieldIdMap);
                if (allFieldQFilter == null) {
                    allFieldQFilter = fieldQFilter;
                    continue;
                }
                allFieldQFilter.and(fieldQFilter);
            }
            if (qfiter != null) {
                if (allFieldQFilter == null) {
                    allFieldQFilter = qfiter;
                } else {
                    allFieldQFilter.and(qfiter);
                }
            }
            long childStartTime = System.currentTimeMillis();
            DataSet ds = QueryServiceHelper.queryDataSet((String)alogStr, (String)entityNumber, (String)selectProperties, (QFilter[])new QFilter[]{allFieldQFilter}, (String)"");
            long childenddate = System.currentTimeMillis() - childStartTime;
            log.info("---ReportExtModelService.queryExtEntityDataSet---entityNumber:" + entityNumber + ",selectProperties = " + selectProperties + ",allFieldQFilter = " + allFieldQFilter + "--------cost:" + childenddate + "ms");
            Map<String, BillTransferEntryModel> extMap = extFunctionMap.get(entrys.getKey());
            if (!ReportUtils.isNullMap(extMap)) {
                ds = this.computeMapFunction(dsNumber, extMap, ds);
            }
            resultMap.put(dsNumber, ds);
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("---ReportExtModelService.queryExtEntityDataSet---allcost:" + enddate + "ms");
        return resultMap;
    }

    private QFilter buildQFilter(String destField, String queryfieldNumber, Map<String, Set<Object>> reportFieldIdMap) {
        Set<Object> reportFieldValueSet = reportFieldIdMap.get(queryfieldNumber);
        QFilter fieldQFilter = null;
        if (ReportUtils.isNullSet(reportFieldValueSet)) {
            fieldQFilter = new QFilter("1", "!=", (Object)"1", true);
        } else {
            List<Set<Object>> splitList = this.splitIdData(reportFieldValueSet);
            for (Set<Object> splitSet : splitList) {
                if (fieldQFilter == null) {
                    fieldQFilter = new QFilter(destField, "in", splitSet);
                    continue;
                }
                fieldQFilter = fieldQFilter.or(new QFilter(destField, "in", splitSet));
            }
        }
        return fieldQFilter;
    }

    private String getFieldNumber(Set<String> formulaSrcFields) {
        String fieldNumber = "";
        Iterator<String> iterator = formulaSrcFields.iterator();
        while (iterator.hasNext()) {
            String fs;
            fieldNumber = fs = iterator.next();
        }
        return fieldNumber;
    }

    private Map<String, Set<Object>> getReportFieldIdSet(Set<String> allReportFilterFieldSet, DataSet reportDataSet) {
        HashMap<String, Set<Object>> reportDataMap = new HashMap<String, Set<Object>>(16);
        if (ReportUtils.isNullSet(allReportFilterFieldSet)) {
            return reportDataMap;
        }
        long startTime = System.currentTimeMillis();
        DataSet copyReportDataSet = reportDataSet.copy();
        int allSize = 0;
        for (Row arow : copyReportDataSet) {
            ++allSize;
            for (String field : allReportFilterFieldSet) {
                if (!ReportUtils.isContainsField(field, copyReportDataSet)) continue;
                Object value = arow.get(field);
                this.addValueToMap(reportDataMap, field, value);
            }
        }
        copyReportDataSet.close();
        for (String field : allReportFilterFieldSet) {
            Set valueSet = (Set)reportDataMap.get(field);
            log.info("---ReportExtModelService.getReportFieldIdSet---field:" + field + ",allSize = " + allSize + ",valueSet.Size=" + (valueSet == null ? 0 : valueSet.size()));
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info("---ReportExtModelService.getReportFieldIdSet---cost:" + enddate + "ms");
        return reportDataMap;
    }

    private String getSelectFields(Set<Object> fieldSet) {
        StringBuilder sb = new StringBuilder();
        for (Object field : fieldSet) {
            sb.append(field).append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    private Set<String> getFilterReportEntityFieldSet(DynamicObject matchDimensions, Map<String, BillTransferEntryModel> billTransMap) {
        return this.getFilterFieldSet(matchDimensions, billTransMap, true);
    }

    private Set<String> getFilterExtEntityFieldSet(DynamicObject matchDimensions, Map<String, BillTransferEntryModel> billTransMap) {
        return this.getFilterFieldSet(matchDimensions, billTransMap, false);
    }

    private boolean isSrcReport(DynamicObject matchDimensions) {
        DynamicObject srcBillEntity = matchDimensions.getDynamicObject("srcbill");
        return this.isReportExtModelDs(srcBillEntity);
    }

    private Set<String> getFilterFieldSet(DynamicObject matchDimensions, Map<String, BillTransferEntryModel> billTransMap, boolean isReport) {
        boolean queryMode;
        HashSet<String> fieldSet = new HashSet<String>(16);
        boolean srcIsReport = this.isSrcReport(matchDimensions);
        boolean bl = isReport ? srcIsReport : (queryMode = !srcIsReport);
        if (queryMode) {
            for (Map.Entry<String, BillTransferEntryModel> mps : billTransMap.entrySet()) {
                BillTransferEntryModel fieldModel = mps.getValue();
                Set<String> queryFieldSet = this.getSrcFieldNumberSet(fieldModel);
                CustomMethodStruct customMethod = fieldModel.getCustomMethodStruct();
                String functionFieldNumber = fieldModel.getSrcRenameField();
                if (customMethod != null) {
                    fieldSet.add(functionFieldNumber);
                    continue;
                }
                if (ReportUtils.isNullSet(queryFieldSet)) continue;
                fieldSet.addAll(queryFieldSet);
            }
        } else {
            fieldSet.addAll(billTransMap.keySet());
        }
        return fieldSet;
    }

    private void addValueToMap(Map<String, Set<Object>> map, String mapKeys, Object value) {
        Set<Object> set = map.get(mapKeys);
        if (set == null) {
            set = new HashSet<Object>(16);
        }
        set.add(value);
        map.put(mapKeys, set);
    }

    private void addValueToListMap(Map<String, List<String>> map, String mapKeys, String value) {
        List<String> list = map.get(mapKeys);
        if (list == null) {
            list = new ArrayList<String>(16);
        }
        list.add(value);
        map.put(mapKeys, list);
    }

    private Set<String> getSrcFieldNumberSet(BillTransferEntryModel fieldModel) {
        return fieldModel.getFormulaSrcFields();
    }

    private boolean isReportExtModelDs(DynamicObject ds) {
        return ds == null || this.reportEntityPK.equals((String)ds.getPkValue());
    }

    private Map<String, BillTransferEntryModel> genBillTransEntryData(DynamicObject transferDyn) {
        DynamicObjectCollection fieldMappingAll = transferDyn.getDynamicObjectCollection("entryentity");
        int size = fieldMappingAll.size();
        if (size > 5) {
            throw new KDBizException(new ErrorCode("valideMaxOnSize", String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04[%1$s]\u5bf9\u5e94\u7684\u5b57\u6bb5\u6620\u5c04\u4fe1\u606f\u884c\u6570[%2$s]\uff0c\u8d85\u8fc7\u4e86\u6700\u5927\u9650\u5b9a\u503c[%3$s],\u8bf7\u8c03\u6574.", (String)"ReportExtModelService_02", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), transferDyn.getString("number"), size, 5)), new Object[0]);
        }
        DynamicObject srcBillEntity = transferDyn.getDynamicObject("srcbill");
        MainEntityType srcType = MetadataServiceHelper.getDataEntityType((String)srcBillEntity.getString("id"));
        String srcTypeName = srcType.getName();
        Map<String, IDataEntityProperty> allFields = DataSourceFetchDataUtil.getAllEntityProp(srcType);
        HashMap<String, BillTransferEntryModel> resultMap = new HashMap<String, BillTransferEntryModel>(16);
        for (DynamicObject mapping : fieldMappingAll) {
            String destField = mapping.getString("destfieldflag");
            String srcField = mapping.getString("sourcefieldflag");
            String formula = mapping.getString("calculateexc_tag");
            String type = mapping.getString("converttype");
            resultMap.put(destField, this.getTransferModel(srcField, destField, type, formula, srcTypeName, allFields, (Long)mapping.getPkValue(), false));
        }
        return resultMap;
    }

    public BillTransferEntryModel getTransferModel(String srcField, String destField, String type, String formula, String srcTypeName, Map<String, IDataEntityProperty> allFields, Long entyId, boolean isDynamicField) {
        String formulaStr;
        HashSet<String> formulaSrcFields = new HashSet<String>(8);
        CustomMethodStruct customMethod = null;
        if (StringUtils.isEmpty((String)srcField)) {
            if (Objects.equals(type, "2")) {
                CRValByConditions valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)formula, CRValByConditions.class);
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)srcTypeName);
                StringBuilder sb = new StringBuilder(128);
                sb.append("CASE");
                for (CRValByCondition item : valByConditions.getItems()) {
                    String upperCase;
                    FilterCondition filterCondition = item.getCondition().getFilterCondition();
                    FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
                    String[] strings = filterBuilder.buildFilterScript();
                    String conditionFormula = strings[0];
                    String valFormula = item.getFormula().getExpression();
                    valFormula = valFormula.replace(srcTypeName + ".", "");
                    IDataEntityProperty prop = allFields.get(valFormula);
                    if ("entryentity.material".equalsIgnoreCase(destField) || "entryentity.comboxmateriel".equalsIgnoreCase(destField)) {
                        valFormula = DataSourceFetchDataUtil.transMaterial(null, null, allFields, valFormula);
                    }
                    if ((upperCase = valFormula.toUpperCase(Locale.ENGLISH)).startsWith("NOW(") || upperCase.startsWith("DATE(") || upperCase.startsWith("TO_DATE(") || upperCase.startsWith("DATEADD(")) {
                        valFormula = "cast(" + valFormula + " AS Timestamp)";
                    }
                    valFormula = DataSourceFetchDataUtil.getFormulaVariable(valFormula, formulaSrcFields);
                    conditionFormula = DataSourceFetchDataUtil.getConditionFormulaVariable(conditionFormula, formulaSrcFields, mainEntityType);
                    sb.append(" WHEN ").append(conditionFormula).append(" THEN ").append(valFormula);
                }
                formulaStr = sb.append(" END").toString();
            } else {
                boolean isUnSet = StringUtils.isEmpty((String)formula);
                JSONObject jo = isUnSet ? null : JSON.parseObject((String)formula);
                String string = formulaStr = jo == null ? null : jo.getString("expression");
                if (formulaStr != null && !StringUtils.isEmpty((String)formulaStr)) {
                    formulaStr = formulaStr.replace(srcTypeName + ".", "");
                    IDataEntityProperty prop = allFields.get(formulaStr);
                    if ("entryentity.material".equalsIgnoreCase(destField) || "entryentity.comboxmateriel".equalsIgnoreCase(destField)) {
                        formulaStr = DataSourceFetchDataUtil.transMaterial(null, null, allFields, formulaStr);
                    }
                    if (Objects.equals(type, "3") && !NumberUtils.isNumber((String)formulaStr)) {
                        formulaStr = String.format("'%s'", formulaStr);
                    } else if (!Objects.equals(type, "3")) {
                        formulaStr = DataSourceFetchDataUtil.getFormulaVariable(formulaStr, formulaSrcFields);
                    }
                }
            }
            if (!entyId.equals(0L)) {
                customMethod = CustomMethodUtils.getCustomMethodStructByCalFields(formulaStr);
            }
        } else {
            formulaStr = srcField;
            IDataEntityProperty prop = allFields.get(formulaStr);
            if ("entryentity.material".equalsIgnoreCase(destField) || "entryentity.comboxmateriel".equalsIgnoreCase(destField)) {
                formulaStr = DataSourceFetchDataUtil.transMaterial(null, null, allFields, formulaStr);
            }
            formulaStr = DataSourceFetchDataUtil.getFormulaVariable(formulaStr, formulaSrcFields);
        }
        return new BillTransferEntryModel(destField, srcField, formulaStr, formulaSrcFields, type, customMethod, entyId, isDynamicField);
    }

    private String getSelectProperties() {
        StringBuilder sf = new StringBuilder(200);
        sf.append("id").append(",");
        sf.append("number").append(",");
        sf.append("reportentity").append(",");
        sf.append("entryentity").append(".").append("extentity").append(",");
        sf.append("entryentity").append(".").append("matchdimensions").append(",");
        sf.append("entryentity").append(".").append("filterrule").append(",");
        sf.append("entryentity").append(".").append("filterrulevalue_tag").append(",");
        sf.append("entryentity").append(".").append("dsnumber").append(",");
        sf.append("columnentryentity").append(".").append("fieldnumber").append(",");
        sf.append("columnentryentity").append(".").append("fieldname").append(",");
        sf.append("columnentryentity").append(".").append("fieldunvisible").append(",");
        sf.append("columnentryentity").append(".").append("converttype").append(",");
        sf.append("columnentryentity").append(".").append("srcdsnumber").append(",");
        sf.append("columnentryentity").append(".").append("datasourceentity").append(",");
        sf.append("columnentryentity").append(".").append("calculateexc").append(",");
        sf.append("columnentryentity").append(".").append("calculateexc_tag").append(",");
        sf.append("columnentryentity").append(".").append("calculatetext").append(",");
        sf.append("columnentryentity").append(".").append("isdynamicfield").append(",");
        sf.append("columnentryentity").append(".").append("fieldparam_tag").append("");
        return sf.toString();
    }

    private DynamicObject getReportExtModel(String reportEntity) {
        QFilter qFilter = new QFilter("reportentity", "=", (Object)reportEntity);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"msplan_reportextmodel", (String)this.getSelectProperties(), (QFilter[])new QFilter[]{qFilter});
    }

    private QFilter getQFilter(String filterContent, String entityName) {
        FilterBuilder fb = this.getFilterBuilder(filterContent, entityName);
        return fb.getQFilter();
    }

    private FilterBuilder getFilterBuilder(String filterContent, String entityName) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterContent, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(entityType, filterCondition);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        return fb;
    }

    private List<Set<Object>> splitIdData(Set<Object> objectSet) {
        int size = objectSet.size();
        ArrayList<Set<Object>> splitList = new ArrayList<Set<Object>>(16);
        if (size <= 50000) {
            splitList.add(objectSet);
            return splitList;
        }
        int times = size / 50000;
        if (size % 50000 > 0) {
            ++times;
        }
        ArrayList<Object> allList = new ArrayList<Object>(objectSet);
        for (int i = 1; i <= times; ++i) {
            List subList = i < times ? allList.subList(50000 * (i - 1), 50000 * i) : allList.subList(50000 * (i - 1), size);
            splitList.add(new HashSet(subList));
        }
        return splitList;
    }
}

