/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.resourcecheck;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.resourcecheck.IResourceCheckExecService;
import kd.mpscmm.msplan.mservice.service.resourcecheck.exec.ConfigResourceCheckExecService;
import kd.mpscmm.msplan.mservice.service.resourcecheck.exec.JavaResourceCheckExecService;
import kd.mpscmm.msplan.mservice.service.resourcecheck.exec.SqlResourceCheckExecService;
import kd.mpscmm.msplan.resourcecheck.utils.CheckLogicUtils;
import kd.mpscmm.msplan.resourcecheck.utils.ResourceCheckUtils;

public class ResourceCheckDataValidService {
    private static final String APPPARAM = "mpscmm-msplan-mservice";
    private static final String[] DML_CHAR = new String[]{"INSERT", "DELETE", "UPDATE", "MODIFY", "TRUNCATE", "ALTER", "DROP"};

    public Map<String, Object> checkData(DynamicObject data, String opKey, boolean isExec) {
        DynamicObject mainEntity = data.getDynamicObject("mainentity");
        String checkRange = data.getString("checkrange");
        String checkType = data.getString("checktype");
        String number = data.get("number") == null ? "" : data.getString("number");
        StringBuilder errorMsg = new StringBuilder();
        if (mainEntity == null) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u5bf9\u5e94\u7684\u68c0\u67e5\u8303\u56f4\u4e3a\u7a7a\u3002", (String)"ResourceCheckDataValidService_01", (String)APPPARAM, (Object[])new Object[0]), number));
            return this.buildErrrorResult(errorMsg.toString());
        }
        if (!this.checIdSetFieldData(errorMsg, data)) {
            return this.buildErrrorResult(errorMsg.toString());
        }
        if ("B".equals(checkRange)) {
            if (!this.checkGroupCheckEntry(errorMsg, data)) {
                return this.buildErrrorResult(errorMsg.toString());
            }
        } else {
            if ("A".equals(checkType) ? !this.checkConfigureData(errorMsg, data, isExec) : ("B".equals(checkType) ? !this.checkSqlData(errorMsg, data, isExec) : "C".equals(checkType) && !this.checkJavaData(errorMsg, data, isExec))) {
                return this.buildErrrorResult(errorMsg.toString());
            }
            if (!this.checkResultFieldEntry(errorMsg, data)) {
                return this.buildErrrorResult(errorMsg.toString());
            }
        }
        return this.buildSuccessResult("");
    }

    private boolean checIdSetFieldData(StringBuilder errorMsg, DynamicObject data) {
        String number = data.get("number") == null ? "" : data.getString("number");
        String idSetFieldTag = data.getString("idsetfieldtag");
        if (StringUtils.isEmpty((String)idSetFieldTag)) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u201c\u8fd4\u56de\u5b57\u6bb5\u6807\u8bc6\u201d\u672a\u5f55\u5165\u3002", (String)"ResourceCheckDataValidService_06", (String)APPPARAM, (Object[])new Object[0]), number));
            return false;
        }
        if ("id".equalsIgnoreCase(idSetFieldTag)) {
            return true;
        }
        String[] fieldArray = idSetFieldTag.split("[.]");
        int splitLength = fieldArray.length;
        if (splitLength == 1 || !"id".equalsIgnoreCase(fieldArray[splitLength - 1])) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u201c\u8fd4\u56de\u5b57\u6bb5\u6807\u8bc6\u201d\u5b57\u6bb5\u5f55\u5165\u4e0d\u7b26\u5408\u89c4\u8303\uff1a\u53ea\u5141\u8bb8\u5f55\u5165id\u6216\u8005\u5206\u5f55\u6807\u8bc6.id\u7684\u6570\u636e\u3002", (String)"ResourceCheckDataValidService_21", (String)APPPARAM, (Object[])new Object[0]), number));
            return false;
        }
        String entryField = fieldArray[0];
        DynamicObject mainEntity = data.getDynamicObject("mainentity");
        Map allFields = ResourceCheckUtils.getEntityEntryFields((String)((String)mainEntity.getPkValue()), (String)entryField);
        if (allFields == null || allFields.isEmpty()) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u201c\u8fd4\u56de\u5b57\u6bb5\u6807\u8bc6\u201d%2$s\u4e0d\u5b58\u5728\u4e8e\u68c0\u67e5\u8303\u56f4\u4e2d\u3002", (String)"ResourceCheckDataValidService_22", (String)APPPARAM, (Object[])new Object[0]), number, idSetFieldTag));
            return false;
        }
        return true;
    }

    private boolean checkConfigureData(StringBuilder errorMsg, DynamicObject data, boolean isExec) {
        String number = data.get("number") == null ? "" : data.getString("number");
        DynamicObjectCollection matchColl = data.getDynamicObjectCollection("fieldmatchentry");
        DynamicObject srcEntity = data.getDynamicObject("srcentity");
        if (srcEntity != null && (matchColl == null || matchColl.isEmpty())) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u5b58\u5728\u68c0\u67e5\u5bf9\u8c61\uff0c\u4f46\u662f\u672a\u7ef4\u62a4\u5b57\u6bb5\u5339\u914d\u4fe1\u606f\u5206\u5f55\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ResourceCheckDataValidService_15", (String)APPPARAM, (Object[])new Object[0]), number));
            return false;
        }
        for (int i = 0; i < matchColl.size(); ++i) {
            DynamicObject matchEntry = (DynamicObject)matchColl.get(i);
            String targetFieldNumber = matchEntry.getString("targetfieldnumber");
            String srcFieldNumber = matchEntry.getString("srcfieldnumber");
            String calCulateText = matchEntry.getString("calculatetext");
            if (StringUtils.isEmpty((String)targetFieldNumber)) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u5b57\u6bb5\u5339\u914d\u4fe1\u606f\u5206\u5f55\u4e2d\uff0c\u7b2c\u201c%2$s\u201d\u884c\u672a\u7ef4\u62a4\u68c0\u67e5\u8303\u56f4\u5b57\u6bb5\u7f16\u7801\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ResourceCheckDataValidService_16", (String)APPPARAM, (Object[])new Object[0]), number, i + 1));
                return false;
            }
            String converttype = matchEntry.getString("converttype");
            if ("0".equals(converttype)) {
                if (!StringUtils.isEmpty((String)srcFieldNumber)) continue;
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u5b57\u6bb5\u5339\u914d\u4fe1\u606f\u5206\u5f55\u4e2d\uff0c\u7b2c\u201c%2$s\u201d\u884c\u6620\u5c04\u7c7b\u578b\u4e3a\u6e90\u5355\u5b57\u6bb5\uff0c\u4f46\u672a\u7ef4\u62a4\u68c0\u67e5\u5bf9\u8c61\u5b57\u6bb5\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ResourceCheckDataValidService_17", (String)APPPARAM, (Object[])new Object[0]), number, i + 1));
                return false;
            }
            if (!"1".equals(converttype) || !StringUtils.isEmpty((String)calCulateText)) continue;
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u5b57\u6bb5\u5339\u914d\u4fe1\u606f\u5206\u5f55\u4e2d\uff0c\u7b2c\u201c%2$s\u201d\u884c\u6620\u5c04\u7c7b\u578b\u4e3a\u8ba1\u7b97\u516c\u5f0f\uff0c\u4f46\u672a\u7ef4\u62a4\u8ba1\u7b97\u516c\u5f0f\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ResourceCheckDataValidService_18", (String)APPPARAM, (Object[])new Object[0]), number, i + 1));
            return false;
        }
        DynamicObjectCollection checkLogicColl = data.getDynamicObjectCollection("checklogicentry");
        if (!checkLogicColl.isEmpty()) {
            int size = checkLogicColl.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject logicEntry = (DynamicObject)checkLogicColl.get(i);
                String filterType = logicEntry.getString("entryfiltertype");
                String leftFieldNumber = logicEntry.getString("entryleftfieldnumber");
                String rightFieldNumber = logicEntry.getString("entryrightfieldnumber");
                String condition = logicEntry.getString("condition");
                if ("A".equals(filterType)) {
                    if (StringUtils.isEmpty((String)leftFieldNumber)) {
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u5b57\u6bb5\u68c0\u67e5\u903b\u8f91\u5206\u5f55\u4e2d\uff0c\u7b2c\u201c%2$s\u201d\u884c\u672a\u5f55\u5165\u201c\u6e90\u5b9e\u4f53\u5b57\u6bb5\u201d\u6570\u636e\u3002", (String)"ResourceCheckDataValidService_19", (String)APPPARAM, (Object[])new Object[0]), number, i + 1));
                        return false;
                    }
                    if (StringUtils.isEmpty((String)condition)) {
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u5b57\u6bb5\u68c0\u67e5\u903b\u8f91\u5206\u5f55\u4e2d\uff0c\u7b2c\u201c%2$s\u201d\u884c\u672a\u5f55\u5165\u201c\u6761\u4ef6\u201d\u5b57\u6bb5\u6570\u636e\u3002", (String)"ResourceCheckDataValidService_24", (String)APPPARAM, (Object[])new Object[0]), number, i + 1));
                        return false;
                    }
                    if (CheckLogicUtils.isNull((String)condition) || CheckLogicUtils.isNotNull((String)condition)) {
                        if (StringUtils.isEmpty((String)rightFieldNumber)) continue;
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u5b57\u6bb5\u68c0\u67e5\u903b\u8f91\u5206\u5f55\u4e2d\uff0c\u7b2c\u201c%2$s\u201d\u884c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u68c0\u67e5\u8303\u56f4\u5b57\u6bb5\u201d\u6570\u636e\u3002", (String)"ResourceCheckDataValidService_23", (String)APPPARAM, (Object[])new Object[0]), number, i + 1));
                        return false;
                    }
                    if (!StringUtils.isEmpty((String)rightFieldNumber)) continue;
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u5b57\u6bb5\u68c0\u67e5\u903b\u8f91\u5206\u5f55\u4e2d\uff0c\u7b2c\u201c%2$s\u201d\u884c\u672a\u5f55\u5165\u201c\u68c0\u67e5\u8303\u56f4\u5b57\u6bb5\u201d\u6570\u636e\u3002", (String)"ResourceCheckDataValidService_20", (String)APPPARAM, (Object[])new Object[0]), number, i + 1));
                    return false;
                }
                String filterValue = logicEntry.getString("entryfiltervalue_tag");
                if (!StringUtils.isEmpty((String)filterValue)) continue;
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u5b57\u6bb5\u68c0\u67e5\u903b\u8f91\u5206\u5f55\u4e2d\uff0c\u7b2c\u201c%2$s\u201d\u884c\u672a\u5f55\u5165\u201c\u503c\u8fc7\u6ee4\u6761\u4ef6\u201d\u6570\u636e\u3002", (String)"ResourceCheckDataValidService_25", (String)APPPARAM, (Object[])new Object[0]), number, i + 1));
                return false;
            }
        }
        if (isExec) {
            return isExec ? this.validDataByService(errorMsg, data, isExec, new ConfigResourceCheckExecService()) : true;
        }
        return true;
    }

    private boolean isError(Map<String, Object> execResultMap) {
        return execResultMap != null && execResultMap.get("result") != null && (Boolean)execResultMap.get("result") == false;
    }

    private String getErrorMsg(Map<String, Object> execResultMap) {
        return execResultMap == null ? "" : (execResultMap.get("msg") == null ? "" : (String)execResultMap.get("msg"));
    }

    private boolean checkJavaData(StringBuilder errorMsg, DynamicObject data, boolean isExec) {
        String number = data.get("number") == null ? "" : data.getString("number");
        String classPlugin = data.getString("javapluginclass");
        if (StringUtils.isEmpty((String)classPlugin)) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u68c0\u67e5\u63d2\u4ef6\u7c7b\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ResourceCheckDataValidService_09", (String)APPPARAM, (Object[])new Object[0]), number));
            return false;
        }
        if (isExec) {
            return this.validDataByService(errorMsg, data, isExec, new JavaResourceCheckExecService());
        }
        return true;
    }

    private boolean checkSqlData(StringBuilder errorMsg, DynamicObject data, boolean isExec) {
        String number = data.get("number") == null ? "" : data.getString("number");
        String txtSql = data.getString("txtsql_tag");
        if (StringUtils.isEmpty((String)txtSql)) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684SQL\u8bed\u53e5\u672a\u5f55\u5165\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ResourceCheckDataValidService_07", (String)APPPARAM, (Object[])new Object[0]), number));
            return false;
        }
        String tmpsql = txtSql.toUpperCase(Locale.ENGLISH);
        for (String dmlStr : DML_CHAR) {
            int firstIndex = tmpsql.indexOf(dmlStr);
            if (firstIndex != 0 && !tmpsql.contains(" " + dmlStr + " ")) continue;
            errorMsg.append(String.format(ResManager.loadKDString((String)"SQL\u8bed\u53e5\u4e0d\u5141\u8bb8\u5305\u542b\u201c%1$s\u201d\u7b49\u5b57\u7b26\u3002", (String)"ResourceCheckDataValidService_27", (String)APPPARAM, (Object[])new Object[0]), dmlStr));
            return false;
        }
        if (isExec) {
            return this.validDataByService(errorMsg, data, isExec, new SqlResourceCheckExecService());
        }
        return true;
    }

    private boolean validDataByService(StringBuilder errorMsg, DynamicObject data, boolean isExec, IResourceCheckExecService service) {
        try {
            Map execResultMap = service.validData(data);
            if (this.isError(execResultMap)) {
                errorMsg.append(this.getErrorMsg(execResultMap));
                return false;
            }
        }
        catch (Exception ex) {
            String ext = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u6267\u884c\u53d1\u751f\u9519\u8bef\uff1a%1$s", (String)"ResourceCheckDataValidService_08", (String)APPPARAM, (Object[])new Object[0]), ext));
            return false;
        }
        return true;
    }

    private String getChildSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",").append("idsetfieldtag");
        sb.append(",").append("mainentity");
        sb.append(",").append("number");
        return sb.toString();
    }

    private boolean checkGroupCheckEntry(StringBuilder errorMsg, DynamicObject data) {
        String number = data.get("number") == null ? "" : data.getString("number");
        DynamicObjectCollection checkColl = data.getDynamicObjectCollection("groupcheckentry");
        if (checkColl == null || checkColl.isEmpty()) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u4e3a\u7ec4\u5408\u68c0\u67e5\uff0c\u4f46\u8d44\u6e90\u68c0\u67e5\u7ec4\u5408\u9879\u5206\u5f55\u65e0\u6570\u636e\u3002", (String)"ResourceCheckDataValidService_02", (String)APPPARAM, (Object[])new Object[0]), number));
            return false;
        }
        HashSet<Long> repeatIdSet = new HashSet<Long>(16);
        HashSet<String> repeatNumberSet = new HashSet<String>(16);
        HashSet<String> repeatEntityNumberSet = new HashSet<String>(16);
        int size = checkColl.size();
        String itemSelectProperties = this.getChildSelectProperties();
        String idSetFieldTag = data.getString("idsetfieldtag");
        for (int i = 0; i < size; ++i) {
            DynamicObject checkItemEntry = (DynamicObject)checkColl.get(i);
            DynamicObject checkItem = checkItemEntry.getDynamicObject("resourcecheckitem");
            if (checkItem == null) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u7ec4\u5408\u68c0\u67e5\u5206\u5f55\u4e2d\uff0c\u7b2c\u201c%2$s\u201d\u884c\u672a\u8bbe\u7f6e\u201c\u8d44\u6e90\u68c0\u67e5\u9879\u7f16\u7801\u201d\u3002", (String)"ResourceCheckDataValidService_03", (String)APPPARAM, (Object[])new Object[0]), number, i + 1));
                continue;
            }
            if (!repeatIdSet.add((Long)checkItem.getPkValue())) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u7ec4\u5408\u68c0\u67e5\u5206\u5f55\u4e2d\uff0c\u7b2c\u201c%2$s\u201d\u884c\u7684\u201c\u8d44\u6e90\u68c0\u67e5\u9879\u7f16\u7801\u201d\u91cd\u590d\u3002", (String)"ResourceCheckDataValidService_04", (String)APPPARAM, (Object[])new Object[0]), number, i + 1));
                continue;
            }
            if (!idSetFieldTag.equalsIgnoreCase((checkItem = BusinessDataServiceHelper.loadSingleFromCache((Object)checkItem.getPkValue(), (String)"msplan_resourcecheck", (String)itemSelectProperties)).getString("idsetfieldtag"))) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u7ec4\u5408\u68c0\u67e5\u5206\u5f55\u4e2d\uff0c\u7b2c\u201c%2$s\u201d\u884c\u7684\u201c\u8fd4\u56de\u5b57\u6bb5\u6807\u8bc6\u201d\u4e0e\u7ec4\u5408\u9879\u7684\u201c\u8fd4\u56de\u5b57\u6bb5\u6807\u8bc6\u201d\u4e0d\u4e00\u81f4\u3002", (String)"ResourceCheckDataValidService_10", (String)APPPARAM, (Object[])new Object[0]), number, i + 1));
                continue;
            }
            repeatEntityNumberSet.add((String)checkItem.getDynamicObject("mainentity").getPkValue());
            repeatNumberSet.add(checkItem.getString("number"));
        }
        if (repeatEntityNumberSet.size() > 1) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u7ec4\u5408\u68c0\u67e5\u5206\u5f55\u4e2d\uff0c\u5b58\u5728\u4e0d\u540c\u7684\u201c\u68c0\u67e5\u8303\u56f4\u5b9e\u4f53\u201d\u7684\u7ec4\u5408\u9879\u3002%2$s", (String)"ResourceCheckDataValidService_11", (String)APPPARAM, (Object[])new Object[0]), number, repeatEntityNumberSet));
        }
        if (!repeatIdSet.isEmpty()) {
            QFilter qfilter = new QFilter("id", "in", repeatIdSet);
            qfilter.and(new QFilter("enable", "=", (Object)"1"));
            qfilter.and(new QFilter("status", "=", (Object)"C"));
            DynamicObjectCollection coll2 = QueryServiceHelper.query((String)"msplan_resourcecheck", (String)"number,id", (QFilter[])new QFilter[]{qfilter});
            Set enableNumberSet = coll2.stream().map(p -> p.getString("number")).collect(Collectors.toSet());
            if (!enableNumberSet.isEmpty()) {
                repeatNumberSet.removeAll(enableNumberSet);
            }
            if (!repeatNumberSet.isEmpty()) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u7ec4\u5408\u68c0\u67e5\u5206\u5f55\u4e2d\uff0c\u8d44\u6e90\u68c0\u67e5\u9879\u7f16\u7801\u201c%2$s\u201d\u4e0d\u5904\u4e8e\u5ba1\u6838\u53ef\u7528\u72b6\u6001\u3002", (String)"ResourceCheckDataValidService_05", (String)APPPARAM, (Object[])new Object[0]), number, repeatNumberSet));
            }
        }
        return errorMsg.length() == 0;
    }

    private boolean checkResultFieldEntry(StringBuilder errorMsg, DynamicObject data) {
        String number = data.get("number") == null ? "" : data.getString("number");
        String resultFieldSetType = "B";
        DynamicObject resultentitynumber = data.getDynamicObject("resultentitynumber");
        if (resultentitynumber == null) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7ed3\u679c\u8868\u5b9e\u4f53\u6807\u8bc6\u672a\u5f55\u5165\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ResourceCheckDataValidService_12", (String)APPPARAM, (Object[])new Object[0]), number));
            return false;
        }
        String idTagSet = data.getString("idsetfieldtag");
        if ("B".equals(resultFieldSetType)) {
            DynamicObjectCollection fieldColl = data.getDynamicObjectCollection("resultfieldentry");
            if (fieldColl == null || fieldColl.isEmpty()) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u7ed3\u679c\u8868\u5b57\u6bb5\u5206\u5f55\u4e2d\uff0c\u672a\u8bbe\u7f6e\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u5206\u5f55\u6570\u636e\u3002", (String)"ResourceCheckDataValidService_13", (String)APPPARAM, (Object[])new Object[0]), number));
                return false;
            }
            boolean hasSet = false;
            boolean idTagSetExists = false;
            for (DynamicObject fieldEntry : fieldColl) {
                String srcField = fieldEntry.getString("resultsrcfieldflag");
                String calculatetext = fieldEntry.getString("resultcalculatetext");
                if (!StringUtils.isEmpty((String)srcField) || !StringUtils.isEmpty((String)calculatetext)) {
                    hasSet = true;
                }
                String calculateExec = fieldEntry.getString("resultcalculateexc_tag");
                if (!idTagSet.equals(srcField) && !idTagSet.equals(calculateExec)) continue;
                idTagSetExists = true;
            }
            if (!hasSet) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u7ed3\u679c\u8868\u5b57\u6bb5\u5206\u5f55\u4e2d\uff0c\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u5206\u5f55\u6570\u636e\u672a\u8bbe\u7f6e\u4efb\u4f55\u6620\u5c04\u5173\u7cfb\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ResourceCheckDataValidService_14", (String)APPPARAM, (Object[])new Object[0]), number));
                return false;
            }
            if (!idTagSetExists) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u7ed3\u679c\u8868\u5b57\u6bb5\u5206\u5f55\u4e2d\uff0c\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u5206\u5f55\u6570\u636e\u672a\u8bbe\u7f6e\u201c\u8fd4\u56de\u5b57\u6bb5\u6807\u8bc6\u201d%2$s\u5bf9\u5e94\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ResourceCheckDataValidService_26", (String)APPPARAM, (Object[])new Object[0]), number, idTagSet));
                return false;
            }
        }
        return true;
    }

    private Map<String, Object> buildErrrorResult(String errorMsg) {
        return this.buildResult(errorMsg, Boolean.FALSE);
    }

    private Map<String, Object> buildSuccessResult(String msg) {
        return this.buildResult(msg, Boolean.TRUE);
    }

    private Map<String, Object> buildResult(String msg, boolean resultValue) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("msg", msg);
        resultMap.put("result", resultValue);
        return resultMap;
    }
}

