/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.resourcecheck;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.service.resourcecheck.sqlparam.AbstractSqlParamService;

public class SqlParamHelper {
    private static final Log logger = LogFactory.getLog(SqlParamHelper.class);

    public static String getValue(String paramNumber) {
        QFilter qfilter = new QFilter("number", "=", (Object)paramNumber);
        String selectFields = "type,pluginclass,paramvalue";
        Object value = null;
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"msplan_sqlparam", (String)selectFields, (QFilter[])new QFilter[]{qfilter});
        if (coll != null && !coll.isEmpty()) {
            String type = ((DynamicObject)coll.get(0)).getString("type");
            String paramvalue = ((DynamicObject)coll.get(0)).getString("paramvalue");
            if ("B".equals(type)) {
                return paramvalue;
            }
            String pluginclass = ((DynamicObject)coll.get(0)).getString("pluginclass");
            if (!StringUtils.isEmpty((String)pluginclass)) {
                try {
                    Object object = Class.forName(pluginclass).newInstance();
                    if (AbstractSqlParamService.class.isInstance(object)) {
                        value = ((AbstractSqlParamService)object).getParamValue();
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e1) {
                    logger.error((Throwable)e1);
                }
            }
        }
        return value == null ? "" : (String)value;
    }

    public static String formatParamSql(String sql) {
        if (StringUtils.isEmpty((String)sql)) {
            return sql;
        }
        if (!sql.contains("@@")) {
            return sql;
        }
        sql = sql + " ";
        Pattern pattern = Pattern.compile("@@([^\\s']+)(?=\\s|')");
        Matcher matcher = pattern.matcher(sql);
        ArrayList<String> paramNumberList = new ArrayList<String>(16);
        while (matcher.find()) {
            paramNumberList.add(matcher.group());
        }
        if (!paramNumberList.isEmpty()) {
            for (String paramNumber : paramNumberList) {
                String value = SqlParamHelper.getValue(paramNumber);
                sql = sql.replaceAll(paramNumber, value);
            }
        }
        return sql;
    }
}

