/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.resourcecheck.exec;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.resourcecheck.IResourceCheckExecService;
import kd.mpscmm.msplan.mservice.service.resourcecheck.task.ExecUtils;
import kd.mpscmm.msplan.resourcecheck.utils.CheckLogicUtils;
import kd.mpscmm.msplan.resourcecheck.utils.ResourceCheckUtils;
import kd.mpscmm.msplan.resourcecheck.utils.SqlParamUtils;

public class AbstractResourceCheckExecService
implements IResourceCheckExecService {
    public static final String APPPARAM = "mpscmm-msplan-mservice";
    private DynamicObject resourceCheckObj;
    private DynamicObject resultTableDataObj;

    public DynamicObject getResourceCheckObj() {
        return this.resourceCheckObj;
    }

    public void setResourceCheckObj(DynamicObject resourceCheck) {
        this.resourceCheckObj = resourceCheck;
    }

    public DynamicObject getResultTableDataObj() {
        return this.resultTableDataObj;
    }

    public void setResultTableDataObj(DynamicObject resultTableData) {
        this.resultTableDataObj = resultTableData;
    }

    public Map<String, Object> exec(DynamicObject resourceCheckObj, DynamicObject resultTableDataObj) throws KDException {
        this.setResourceCheckObj(resourceCheckObj);
        this.setResultTableDataObj(resultTableDataObj);
        this.deleteHisResultData();
        return this.buildSuccessResult("");
    }

    public Map<String, Object> validData(DynamicObject resourceCheckObj) throws KDException {
        this.setResourceCheckObj(resourceCheckObj);
        return this.buildSuccessResult("");
    }

    public Set<Long> getDataRangeIdSet() {
        DynamicObject resultTableData = this.getResultTableDataObj();
        String ids = resultTableData.getString("execdatas_tag");
        return ResourceCheckUtils.getDataRangeIdSet((String)ids, (String)this.getIdSetTag(), (String)this.getMainEntityNumber());
    }

    public Map<String, Object> buildErrrorResult(String errorMsg) {
        return this.buildResult(errorMsg, Boolean.FALSE);
    }

    public Map<String, Object> buildSuccessResult(String msg) {
        return this.buildResult(msg, Boolean.TRUE);
    }

    public Map<String, Object> buildResult(String msg, boolean resultValue) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("msg", msg);
        resultMap.put("result", resultValue);
        return resultMap;
    }

    public int getErrorLimitCount() {
        DynamicObject resourceCheck = this.getResourceCheckObj();
        return resourceCheck.getInt("errcountlimit");
    }

    public String getResultEntityNumber() {
        DynamicObject resourceCheck = this.getResourceCheckObj();
        DynamicObject resultEntity = resourceCheck.getDynamicObject("resultentitynumber");
        return resultEntity == null ? "msplan_checkresult" : resultEntity.getString("number");
    }

    public Object getInfoMsg(Object id, Map<Object, Object> queryResultMap, Object defaultInfo) {
        return queryResultMap == null || queryResultMap.get(id) == null ? defaultInfo : queryResultMap.get(id);
    }

    public void closeDataSet(DataSet ds) {
        if (ds != null) {
            ds.close();
        }
    }

    public void addToResultTable(Set<Object> bizIdSet, Map<Object, Object> queryResultMap) {
        DynamicObject resourceCheck = this.getResourceCheckObj();
        DynamicObject resultTableData = this.getResultTableDataObj();
        DynamicObjectCollection resultColl = resultTableData.getDynamicObjectCollection("entryentity");
        Set<Long> convertBizIdSet = bizIdSet.stream().map(p -> (Long)p).collect(Collectors.toSet());
        Map<Long, JSONObject> dataMap = ExecUtils.queryBizFieldData(convertBizIdSet, resourceCheck);
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        int errorLimitData = this.getErrorLimitCount();
        int size = 0;
        for (Map.Entry<Long, JSONObject> datas : dataMap.entrySet()) {
            JSONObject dataObject = datas.getValue();
            if (++size > errorLimitData) break;
            DynamicObject entry = resultColl.addNew();
            Set fieldNumberSet = dataObject.keySet();
            for (String fieldNumber : fieldNumberSet) {
                if ("bizotherinfo".equals(fieldNumber)) {
                    entry.set(fieldNumber, this.getInfoMsg(dataObject.get((Object)"bizbillid"), queryResultMap, dataObject.get((Object)fieldNumber)));
                    continue;
                }
                entry.set(fieldNumber, dataObject.get((Object)fieldNumber));
            }
        }
    }

    public void addToResultTable(Set<Object> idSet) {
        this.addToResultTable(idSet, null);
    }

    public QFilter getQFilter(String filterContent, String entityName) {
        return CheckLogicUtils.getQFilter((String)filterContent, (String)entityName);
    }

    public String getIdSetTag() {
        DynamicObject resourceCheck = this.getResourceCheckObj();
        String idTag = resourceCheck.getString("idsetfieldtag");
        return StringUtils.isEmpty((String)idTag) ? "id" : idTag;
    }

    public String getMainEntityNumber() {
        DynamicObject resourceCheck = this.getResourceCheckObj();
        return (String)resourceCheck.getDynamicObject("mainentity").getPkValue();
    }

    public String getSrcEntityNumber() {
        DynamicObject resourceCheck = this.getResourceCheckObj();
        return resourceCheck.getDynamicObject("srcentity") == null ? "" : (String)resourceCheck.getDynamicObject("srcentity").getPkValue();
    }

    public void deleteHisResultData() {
        DynamicObject resourceCheck = this.getResourceCheckObj();
        int saveDays = resourceCheck.getInt("checklogsavedays");
        if (saveDays <= 0 || saveDays >= 99999) {
            return;
        }
        Date endDate = SqlParamUtils.addDay((Date)new Date(), (int)(0 - saveDays));
        String resultEntityNumber = this.getResultEntityNumber();
        QFilter qfilter = new QFilter("createtime", "<", (Object)endDate);
        qfilter.and(new QFilter("resourcecheck", "=", resourceCheck.getPkValue()));
        DeleteServiceHelper.delete((String)resultEntityNumber, (QFilter[])new QFilter[]{qfilter});
        DeleteServiceHelper.delete((String)"msplan_bizbillcheckresult", (QFilter[])new QFilter[]{new QFilter("createtime", "<", (Object)endDate)});
    }

    public DataSet renameField(DataSet ds, String afterChar) {
        Field[] dsFields = ds.getRowMeta().getFields();
        StringBuilder selects = new StringBuilder();
        int index = 0;
        for (Field field : dsFields) {
            if (++index > 1) {
                selects.append(",");
            }
            selects.append(field.getName()).append(" as ").append(field.getName()).append(afterChar);
        }
        return ds.select(selects.toString());
    }

    public String[] getDataSetFields(DataSet ds) {
        return ds.getRowMeta().getFieldNames();
    }

    public QFilter mergeIdRangeSetData(QFilter oldFilter) {
        Set<Long> idSet = this.getDataRangeIdSet();
        if (!idSet.isEmpty()) {
            QFilter idFilter = new QFilter(this.getIdSetTag(), "in", idSet);
            oldFilter = oldFilter == null ? idFilter : oldFilter.and(idFilter);
        }
        return oldFilter;
    }
}

