/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.resourcecheck.exec;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;
import kd.mpscmm.msplan.mservice.service.reportext.BillTransferEntryModel;
import kd.mpscmm.msplan.mservice.service.reportext.ReportUtils;
import kd.mpscmm.msplan.mservice.service.resourcecheck.exec.AbstractResourceCheckExecService;
import kd.mpscmm.msplan.mservice.service.resourcecheck.task.ExecUtils;
import kd.mpscmm.msplan.resourcecheck.utils.CheckLogicUtils;

public class ConfigResourceCheckExecService
extends AbstractResourceCheckExecService {
    private static final Log logger = LogFactory.getLog(ConfigResourceCheckExecService.class);

    @Override
    public Map<String, Object> exec(DynamicObject resourceCheckObj, DynamicObject resultTableDataObj) throws KDException {
        try {
            Map<String, Object> resultMap = super.exec(resourceCheckObj, resultTableDataObj);
            QFilter mainFilter = this.getQFilterByType(resourceCheckObj, "A");
            mainFilter = this.mergeIdRangeSetData(mainFilter);
            QFilter srcEntityFilter = this.getQFilterByType(resourceCheckObj, "B");
            DataSet queryDataSet = this.buildDataSet(resourceCheckObj, mainFilter, srcEntityFilter);
            String idtag = this.getIdSetTag();
            HashSet<Object> queryIdSet = new HashSet<Object>(16);
            for (Row arow : queryDataSet) {
                queryIdSet.add(arow.getLong(idtag));
            }
            this.closeDataSet(queryDataSet);
            this.addToResultTable(queryIdSet);
            return resultMap;
        }
        catch (Exception ex) {
            String ext = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u6570\u636e\u89e3\u6790\u4e0e\u6267\u884c\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s", (String)"ConfigResourceCheckExecService_01", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), ext);
            return this.buildErrrorResult(errorMsg);
        }
    }

    public DataSet buildDataSet(DynamicObject resourceCheckObj, QFilter mainFilter, QFilter srcEntityFilter) {
        DataSet dsA = this.buildDataSetA(resourceCheckObj, mainFilter);
        DataSet dsB = this.buildDataSetB(resourceCheckObj, srcEntityFilter);
        dsA = this.unionMatchDataSet(resourceCheckObj, dsA, dsB);
        String filterStr = CheckLogicUtils.buildFilter((DynamicObject)resourceCheckObj, (DataSet)dsA);
        logger.info("---ConfigResourceCheckExecService.buildDataSet,number = " + resourceCheckObj.getString("number") + ",filterStr=" + filterStr);
        if (!StringUtils.isEmpty((String)filterStr)) {
            dsA = dsA.filter(filterStr);
        }
        this.closeDataSet(dsB);
        return dsA;
    }

    public DataSet buildDataSetA(DynamicObject resourceCheckObj, QFilter mainFilter) {
        String mainEntityNumber = this.getMainEntityNumber();
        Set<Object> mainSelectFields = this.getQuerySelectFields(resourceCheckObj, "A", null);
        logger.info("---ConfigResourceCheckExecService.buildDataSetA,number = " + resourceCheckObj.getString("number") + ",mainEntityNumber=" + mainEntityNumber + ",mainFilter=" + (mainFilter == null ? "" : mainFilter));
        logger.info("---ConfigResourceCheckExecService.buildDataSetA,number = " + resourceCheckObj.getString("number") + ",mainEntityNumber=" + mainEntityNumber + ",mainSelectFields=" + (mainSelectFields == null ? "" : mainSelectFields.toString()));
        DataSet dsA = QueryServiceHelper.queryDataSet((String)(ConfigResourceCheckExecService.class.getName() + "_a"), (String)mainEntityNumber, (String)ExecUtils.getSelectFields(mainSelectFields), (QFilter[])new QFilter[]{mainFilter}, (String)"");
        dsA = this.convertBooleanFieldDs(dsA);
        return dsA;
    }

    public DataSet buildDataSetB(DynamicObject resourceCheckObj, QFilter srcEntityFilter) {
        HashMap<String, BillTransferEntryModel> srcEntityFunctionMap = new HashMap<String, BillTransferEntryModel>(16);
        String srcEntityNumber = this.getSrcEntityNumber();
        boolean hasSrcEntity = !StringUtils.isEmpty((String)srcEntityNumber);
        Set<Object> srcSelectFields = hasSrcEntity ? this.getQuerySelectFields(resourceCheckObj, "B", srcEntityFunctionMap) : null;
        DataSet dsB = null;
        if (hasSrcEntity) {
            dsB = QueryServiceHelper.queryDataSet((String)(ConfigResourceCheckExecService.class.getName() + "_b"), (String)srcEntityNumber, (String)ExecUtils.getSelectFields(srcSelectFields), (QFilter[])new QFilter[]{srcEntityFilter}, (String)"");
            if (!ReportUtils.isNullMap(srcEntityFunctionMap)) {
                dsB = ExecUtils.computeMapFunction("", srcEntityFunctionMap, dsB);
            }
            logger.info("---ConfigResourceCheckExecService.buildDataSetB,number = " + resourceCheckObj.getString("number") + ",srcEntityNumber=" + srcEntityNumber + ",srcEntityFilter=" + (srcEntityFilter == null ? "" : srcEntityFilter));
            logger.info("---ConfigResourceCheckExecService.buildDataSetB,number = " + resourceCheckObj.getString("number") + ",srcEntityNumber=" + srcEntityNumber + ",srcSelectFields=" + (srcSelectFields == null ? "" : srcSelectFields.toString()));
        }
        dsB = this.convertBooleanFieldDs(dsB);
        return dsB;
    }

    public DataSet convertBooleanFieldDs(DataSet ds) {
        if (ds != null) {
            RowMeta rowMeta = ds.getRowMeta();
            String[] fieldNames = rowMeta.getFieldNames();
            StringBuilder str = new StringBuilder();
            boolean hasBooleanField = false;
            int size = 0;
            for (String fieldName : fieldNames) {
                DataType fieldType = rowMeta.getField(fieldName).getDataType();
                if (size > 0) {
                    str.append(",");
                }
                if (fieldType instanceof BooleanType) {
                    hasBooleanField = true;
                    str.append("(case when ").append(fieldName).append(" then '1' else '0' end ) as ").append(fieldName);
                } else {
                    str.append(fieldName);
                }
                ++size;
            }
            if (!hasBooleanField) {
                return ds;
            }
            ds = ds.select(str.toString());
        }
        return ds;
    }

    public QFilter getQFilterByType(DynamicObject resourceCheckObj, String entityType) {
        DynamicObjectCollection filterEntryColl = resourceCheckObj.getDynamicObjectCollection("filterentry");
        for (DynamicObject filterEntry : filterEntryColl) {
            if (!entityType.equals(filterEntry.getString("entitytype"))) continue;
            DynamicObject entityObject = filterEntry.getDynamicObject("filterentity");
            String filterRuleValue = filterEntry.getString("filterrulevalue_tag");
            if (null == entityObject || null == filterRuleValue || "".equals(filterRuleValue)) continue;
            return this.getQFilter(filterRuleValue, (String)entityObject.getPkValue());
        }
        return null;
    }

    public DataSet unionMatchDataSet(DynamicObject resourceCheckObj, DataSet dsA, DataSet dsB) {
        if (dsB == null) {
            return dsA;
        }
        dsB = this.renameField(dsB, "B");
        String[] fieldsA = this.getDataSetFields(dsA);
        String[] fieldsB = this.getDataSetFields(dsB);
        DynamicObjectCollection matchEntryColl = resourceCheckObj.getDynamicObjectCollection("fieldmatchentry");
        int size = matchEntryColl.size();
        JoinDataSet joinDs = dsA.leftJoin(dsB);
        for (int i = 0; i < size; ++i) {
            String checkMsg;
            DynamicObject matchEntry = (DynamicObject)matchEntryColl.get(i);
            String fieldNumberA = matchEntry.getString("targetfieldnumber");
            String fieldNumberB = "fmatch_" + i + "B";
            String fieldNameB = matchEntry.getString("srcfieldname");
            if (StringUtils.isEmpty((String)fieldNameB)) {
                fieldNameB = matchEntry.getString("calculatetext");
            }
            if (!StringUtils.isEmpty((String)(checkMsg = this.checkFieldMatch(dsA, dsB, fieldNumberA, fieldNumberB, matchEntry.getString("targetfieldname"), fieldNameB)))) {
                throw new KDBizException(new ErrorCode("ValidData", checkMsg), new Object[0]);
            }
            joinDs = joinDs.on(fieldNumberA, fieldNumberB);
        }
        return joinDs.select(fieldsA, fieldsB).finish();
    }

    public String checkFieldMatch(DataSet dsA, DataSet dsB, String fieldNumberA, String fieldNumberB, String fieldNameA, String fieldNameB) {
        DataType fieldTypeB;
        DataType fieldTypeA;
        Field fieldBObj;
        StringBuilder errorMsg = new StringBuilder();
        Field fieldAObj = this.getField(dsA, fieldNumberA);
        if (fieldAObj == null) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u8303\u56f4\u7684\u6570\u636e\u96c6\u6ca1\u6709\u5339\u914d\u5230\u5b57\u6bb5\uff1a%1$s\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u5339\u914d\u4fe1\u606f\u7684\u914d\u7f6e\u3002", (String)"ConfigResourceCheckExecService_02", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), fieldNameA));
        }
        if ((fieldBObj = this.getField(dsB, fieldNumberB)) == null) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u5bf9\u8c61\u7684\u6570\u636e\u96c6\u6ca1\u6709\u5339\u914d\u5230\u5b57\u6bb5\uff1a%1$s\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u5339\u914d\u4fe1\u606f\u7684\u914d\u7f6e\u3002", (String)"ConfigResourceCheckExecService_03", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), fieldNameB));
        }
        if (fieldAObj != null && fieldBObj != null && !(fieldTypeA = fieldAObj.getDataType()).equals((Object)(fieldTypeB = fieldBObj.getDataType()))) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u8303\u56f4\u7684\u7684\u5339\u914d\u7ef4\u5ea6\u5b57\u6bb5\u201c%1$s\u201d\u4e0e\u68c0\u67e5\u5bf9\u8c61\u7684\u5339\u914d\u7ef4\u5ea6\u5b57\u6bb5\u201c%2$s\u201d\u7684\u6570\u636e\u7c7b\u578b\uff08%3$s\u3001%4$s\uff09\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u5339\u914d\u4fe1\u606f\u7684\u914d\u7f6e\u3002", (String)"ConfigResourceCheckExecService_04", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), fieldNameA, fieldNameB, fieldTypeA.getName(), fieldTypeB.getName()));
        }
        return errorMsg.toString();
    }

    public Field getField(DataSet ds, String fieldNumber) {
        return ds.getRowMeta().getField(fieldNumber, false);
    }

    public Set<Object> getQuerySelectFields(DynamicObject resourceCheckObj, String entityNumberType, Map<String, BillTransferEntryModel> srcEntityFunctionMap) {
        HashSet<Object> queryFieldSet = new HashSet<Object>(16);
        boolean isMainEntity = "A".equals(entityNumberType);
        if (isMainEntity) {
            queryFieldSet.add(this.getIdSetTag());
        }
        DynamicObjectCollection matchEntryColl = resourceCheckObj.getDynamicObjectCollection("fieldmatchentry");
        int size = matchEntryColl.size();
        String srcEntityNumber = this.getSrcEntityNumber();
        HashMap<String, IDataEntityProperty> srcEntityAllFields = new HashMap(16);
        if (!isMainEntity && !StringUtils.isEmpty((String)srcEntityNumber)) {
            MainEntityType srcEntityType = MetadataServiceHelper.getDataEntityType((String)srcEntityNumber);
            srcEntityAllFields = DataSourceFetchDataUtil.getAllEntityProp(srcEntityType);
        }
        for (int i = 0; i < size; ++i) {
            DynamicObject matchEntry = (DynamicObject)matchEntryColl.get(i);
            DynamicObject srcEntity = matchEntry.getDynamicObject("entrysrcentity");
            if (!isMainEntity && srcEntity != null) {
                String convertType = matchEntry.getString("converttype");
                String formula = matchEntry.getString("calculateexc_tag");
                String srcField = matchEntry.getString("srcfieldnumber");
                String destField = "fmatch_" + i;
                if (!StringUtils.isEmpty((String)formula)) {
                    BillTransferEntryModel transModel = ExecUtils.getTransferModel(srcField, destField, convertType, formula, srcEntityNumber, srcEntityAllFields, (Long)matchEntry.getPkValue());
                    transModel.setSrcRenameField(destField);
                    if (transModel.getCustomMethodStruct() != null) {
                        srcEntityFunctionMap.put(destField, transModel);
                        Set<String> paramSet = transModel.getFormulaSrcFields();
                        if (!ReportUtils.isNullSet(paramSet)) {
                            for (String field : paramSet) {
                                queryFieldSet.add(field);
                            }
                        }
                    } else {
                        String queryFieldNumber = transModel.getFormulaStr();
                        if (!StringUtils.isEmpty((String)queryFieldNumber)) {
                            queryFieldSet.add(queryFieldNumber + " as " + destField);
                        }
                    }
                } else if (!StringUtils.isEmpty((String)srcField)) {
                    queryFieldSet.add(srcField + " as " + destField);
                }
            }
            if (!isMainEntity) continue;
            String fieldNumber = matchEntry.getString("targetfieldnumber");
            queryFieldSet.add(fieldNumber);
        }
        DynamicObjectCollection checkLogicEntryColl = resourceCheckObj.getDynamicObjectCollection("checklogicentry");
        for (DynamicObject checkLogicEntry : checkLogicEntryColl) {
            QFilter qfilter;
            String filterType = checkLogicEntry.getString("entryfiltertype");
            String entryLeftEntityType = checkLogicEntry.getString("entryleftentitytype");
            String entryLeftEntityNumber = (String)checkLogicEntry.getDynamicObject("entryleftentity").getPkValue();
            String entryRightEntityType = checkLogicEntry.getString("entryrightentitytype");
            String entryLeftFieldNumber = checkLogicEntry.getString("entryleftfieldnumber");
            String entryRightFieldNumber = checkLogicEntry.getString("entryrightfieldnumber");
            String filterValue = checkLogicEntry.getString("entryfiltervalue_tag");
            if ("A".equals(filterType)) {
                if (entityNumberType.equals(entryLeftEntityType) && !StringUtils.isEmpty((String)entryLeftFieldNumber)) {
                    queryFieldSet.add(entryLeftFieldNumber);
                }
                if (!entityNumberType.equals(entryRightEntityType) || StringUtils.isEmpty((String)entryRightFieldNumber)) continue;
                queryFieldSet.add(entryRightFieldNumber);
                continue;
            }
            if (!entityNumberType.equals(entryLeftEntityType) || (qfilter = this.getQFilter(filterValue, entryLeftEntityNumber)) == null) continue;
            queryFieldSet.addAll(CheckLogicUtils.getQFilterFields((QFilter)qfilter));
        }
        return queryFieldSet;
    }

    public String getEntityNumberByObj(DynamicObject resourceCheckObj) {
        return resourceCheckObj == null ? "" : (String)resourceCheckObj.getPkValue();
    }

    @Override
    public Map<String, Object> validData(DynamicObject resourceCheckObj) throws KDException {
        try {
            Map<String, Object> resultMap = super.validData(resourceCheckObj);
            QFilter mainFilter = new QFilter("id", "=", (Object)-1L);
            QFilter srcEntityFilter = new QFilter("id", "=", (Object)-1L);
            DataSet queryDataSet = this.buildDataSet(resourceCheckObj, mainFilter, srcEntityFilter);
            this.closeDataSet(queryDataSet);
            return resultMap;
        }
        catch (Exception ex) {
            String ext = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u6570\u636e\u89e3\u6790\u4e0e\u6267\u884c\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s", (String)"ConfigResourceCheckExecService_01", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), ext);
            return this.buildErrrorResult(errorMsg);
        }
    }
}

