/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.resourcecheck.exec;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.util.ExceptionUtils;
import kd.mpscmm.msplan.mservice.service.resourcecheck.SqlParamHelper;
import kd.mpscmm.msplan.mservice.service.resourcecheck.exec.AbstractResourceCheckExecService;

public class SqlResourceCheckExecService
extends AbstractResourceCheckExecService {
    @Override
    public Map<String, Object> exec(DynamicObject resourceCheckObj, DynamicObject resultTableDataObj) throws KDException {
        StringBuilder errorMsg = new StringBuilder();
        Map<String, Object> resultMap = super.exec(resourceCheckObj, resultTableDataObj);
        String dbRoute = resourceCheckObj.getString("sqlexecdb");
        String txtSql = resourceCheckObj.getString("txtsql_tag");
        String formatSql = SqlParamHelper.formatParamSql(txtSql);
        Set<Long> idSet = this.getDataRangeIdSet();
        boolean hasRangeData = !idSet.isEmpty();
        HashSet<Object> queryIdSet = new HashSet<Object>(64);
        try (DataSet ds = DB.queryDataSet((String)(SqlResourceCheckExecService.class.getName() + "_checkSqlData"), (DBRoute)new DBRoute(dbRoute), (String)formatSql);){
            int i = 0;
            int maxSize = this.getErrorLimitCount();
            for (Row arow : ds) {
                Long id = (Long)arow.get(0);
                if (hasRangeData && !idSet.contains(id)) continue;
                queryIdSet.add(id);
                if (++i <= maxSize) continue;
                break;
            }
            this.addToResultTable(queryIdSet);
        }
        catch (Exception ex) {
            String ext = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            errorMsg.append(String.format(ResManager.loadKDString((String)"SQL\u6267\u884c\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s SQL\u8bed\u53e5\u5982\u4e0b\uff1a%2$s", (String)"SqlResourceCheckExecService_01", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), ext, formatSql));
            return this.buildErrrorResult(errorMsg.toString());
        }
        return resultMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> validData(DynamicObject resourceCheckObj) throws KDException {
        StringBuilder errorMsg = new StringBuilder();
        Map<String, Object> resultMap = super.validData(resourceCheckObj);
        String dbRoute = resourceCheckObj.getString("sqlexecdb");
        String txtSql = resourceCheckObj.getString("txtsql_tag");
        String formatSql = SqlParamHelper.formatParamSql(txtSql);
        try (DataSet ds = DB.queryDataSet((String)(SqlResourceCheckExecService.class.getName() + "_checkSqlData"), (DBRoute)new DBRoute(dbRoute), (String)formatSql).limit(0, 1);){
            Map<String, Object> throwable3 = resultMap;
            return throwable3;
        }
        catch (Exception ex) {
            String ext = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            errorMsg.append(String.format(ResManager.loadKDString((String)"SQL\u6267\u884c\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s SQL\u8bed\u53e5\u5982\u4e0b\uff1a%2$s", (String)"SqlResourceCheckExecService_01", (String)"mpscmm-msplan-mservice", (Object[])new Object[0]), ext, formatSql));
            return this.buildErrrorResult(errorMsg.toString());
        }
    }
}

