/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.resourcecheck.task;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.resourcecheck.IResourceCheckExecService;
import kd.mpscmm.msplan.mservice.service.resourcecheck.exec.ConfigResourceCheckExecService;
import kd.mpscmm.msplan.mservice.service.resourcecheck.exec.JavaResourceCheckExecService;
import kd.mpscmm.msplan.mservice.service.resourcecheck.exec.SqlResourceCheckExecService;
import kd.mpscmm.msplan.resourcecheck.utils.ResourceCheckUtils;
import kd.mpscmm.msplan.resourcecheck.utils.SqlParamUtils;

public class ExecDataService {
    private static final Log log = LogFactory.getLog(ExecDataService.class);
    private static ExecDataService impl;
    private static final DBRoute scmDBRoute;
    private static final String UPDATELASTSQL = " update t_msplan_checkresource set flastchecker = ?,flastchecktime = ?,flastcheckresult = ?,flastcheckresultid = ? where fid = ? ";
    private static final String APPPARAM = "mpscmm-msplan-mservice";
    private static final BigDecimal ONE000;

    public static ExecDataService getInstance() {
        if (impl == null) {
            impl = new ExecDataService();
        }
        return impl;
    }

    public boolean execSingleData(Map<String, Object> paramMap) {
        DynamicObject resourceCheck = this.getResourceCheckObjectByMap(paramMap);
        DynamicObject resultTableData = this.getResultTableObjectByMap(paramMap);
        long startTime = System.currentTimeMillis();
        this.setResultTableExecing(resultTableData);
        String errorMsg = "";
        try {
            IResourceCheckExecService service = this.getService(resourceCheck);
            Map execResultMap = service.exec(resourceCheck, resultTableData);
            if (this.isError(execResultMap)) {
                errorMsg = this.getErrorMsg(execResultMap);
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            errorMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"ExecDataService_01", (String)APPPARAM, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
        }
        resultTableData.set("checkstatus", (Object)"C");
        if (!StringUtils.isEmpty((String)errorMsg)) {
            resultTableData.set("checkstatus", (Object)"D");
        }
        resultTableData.set("cost", (Object)this.getCost(startTime));
        resultTableData.set("remark", (Object)this.buildRemarkStr());
        resultTableData.set("errormsg", (Object)SqlParamUtils.getSimpleSql((String)errorMsg));
        resultTableData.set("errormsg_tag", (Object)errorMsg);
        resultTableData.set("errorcount", (Object)resultTableData.getDynamicObjectCollection("entryentity").size());
        this.saveOperateOption(resultTableData);
        this.updateLastUpdateInfo(resultTableData, resourceCheck);
        return true;
    }

    private BigDecimal getCost(Long startTime) {
        return new BigDecimal(System.currentTimeMillis() - startTime + "").divide(ONE000, new MathContext(10)).setScale(4);
    }

    private String buildRemarkStr() {
        StringBuilder sb = new StringBuilder();
        sb.append("traceid:").append(RequestContext.get().getTraceId()).append(",instanceName:").append(Instance.getInstanceId());
        return sb.toString();
    }

    private String getResultTableFieldSelectProp() {
        StringBuilder sb = new StringBuilder();
        sb.append("checkstatus");
        sb.append(",");
        sb.append("errorcount");
        sb.append(",");
        sb.append("errormsg_tag");
        return sb.toString();
    }

    private DynamicObject queryResultTableObj(Long tagId, String resultEntity, Long resourceCheckId) {
        QFilter qfilter = new QFilter("tagid", "=", (Object)tagId);
        qfilter.and(new QFilter("resourcecheck", "=", (Object)resourceCheckId));
        return QueryServiceHelper.queryOne((String)resultEntity, (String)this.getResultTableFieldSelectProp(), (QFilter[])new QFilter[]{qfilter});
    }

    public boolean execGroupCheckData(Map<String, Object> paramMap) {
        DynamicObject resourceCheck = this.getResourceCheckObjectByMap(paramMap);
        DynamicObject resultTableData = this.getResultTableObjectByMap(paramMap);
        Long tagId = resultTableData.getLong("tagid");
        long startTime = System.currentTimeMillis();
        this.setResultTableExecing(resultTableData);
        boolean hasException = false;
        StringBuilder errorMsg = new StringBuilder();
        int sumErrorCount = 0;
        try {
            DynamicObjectCollection groupCheckColl = resourceCheck.getDynamicObjectCollection("groupcheckentry");
            int seq = 0;
            for (DynamicObject groupCheckEntry : groupCheckColl) {
                ++seq;
                DynamicObject childResourceCheck = groupCheckEntry.getDynamicObject("resourcecheckitem");
                DynamicObject childResultTableData = this.queryResultTableObj(tagId, (String)childResourceCheck.getDynamicObject("resultentitynumber").getPkValue(), childResourceCheck.getLong("id"));
                int errorCount = 0;
                String msg = "";
                if (childResultTableData == null) {
                    msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5b50\u9879\u6267\u884c\u8bb0\u5f55\u3002", (String)"ExecDataService_02", (String)APPPARAM, (Object[])new Object[0]);
                    hasException = true;
                } else {
                    String checkStatus = childResultTableData.getString("checkstatus");
                    if ("D".equals(checkStatus)) {
                        msg = ResManager.loadKDString((String)"\u5b50\u9879\u6267\u884c\u53d1\u751f\u9519\u8bef\u3002", (String)"ExecDataService_06", (String)APPPARAM, (Object[])new Object[0]);
                        hasException = true;
                        errorMsg.append(childResultTableData.getString("errormsg_tag"));
                    } else {
                        msg = ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"ExecDataService_03", (String)APPPARAM, (Object[])new Object[0]);
                        errorCount = childResultTableData.getInt("errorcount");
                    }
                }
                sumErrorCount += errorCount;
                DynamicObject addSumEntry = resultTableData.getDynamicObjectCollection("sumentry").addNew();
                addSumEntry.set("seq", (Object)seq);
                addSumEntry.set("detialitem", (Object)childResourceCheck);
                addSumEntry.set("detialitemerrcount", (Object)errorCount);
                addSumEntry.set("detialitemremark", (Object)SqlParamUtils.getSimpleSql((String)msg));
            }
            resultTableData.set("checkstatus", (Object)"C");
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            hasException = true;
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u6267\u884c\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"ExecDataService_01", (String)APPPARAM, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
        }
        if (hasException) {
            resultTableData.set("checkstatus", (Object)"D");
        }
        resultTableData.set("cost", (Object)this.getCost(startTime));
        resultTableData.set("remark", (Object)this.buildRemarkStr());
        resultTableData.set("errormsg", (Object)SqlParamUtils.getSimpleSql((String)errorMsg.toString()));
        resultTableData.set("errormsg_tag", (Object)errorMsg);
        resultTableData.set("errorcount", (Object)sumErrorCount);
        this.saveOperateOption(resultTableData);
        this.updateLastUpdateInfo(resultTableData, resourceCheck);
        return true;
    }

    private IResourceCheckExecService getService(DynamicObject resourceCheck) {
        if ("A".equals(resourceCheck.getString("checktype"))) {
            return new ConfigResourceCheckExecService();
        }
        if ("B".equals(resourceCheck.getString("checktype"))) {
            return new SqlResourceCheckExecService();
        }
        return new JavaResourceCheckExecService();
    }

    private void setResultTableExecing(DynamicObject resultData) {
        resultData.set("checkstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resultData});
    }

    private void updateLastUpdateInfo(DynamicObject resultTableData, DynamicObject resourceCheck) {
        String resultMsg = this.getExecResultMsg(resultTableData);
        Object[] objs = new Object[]{RequestContext.get().getCurrUserId(), new Date(), resultMsg, resultTableData.getPkValue(), resourceCheck.getPkValue()};
        DB.execute((DBRoute)scmDBRoute, (String)UPDATELASTSQL, (Object[])objs);
    }

    private String getExecResultMsg(DynamicObject resultTableData) {
        if ("D".equals(resultTableData.getString("checkstatus"))) {
            return ResManager.loadKDString((String)"\u6267\u884c\u53d1\u751f\u5f02\u5e38\u3002", (String)"ExecDataService_04", (String)APPPARAM, (Object[])new Object[0]);
        }
        int size = resultTableData.getDynamicObjectCollection("entryentity").size();
        if (size == 0) {
            DynamicObjectCollection coll = resultTableData.getDynamicObjectCollection("sumentry");
            for (DynamicObject entry : coll) {
                size += entry.getInt("detialitemerrcount");
            }
        }
        if (size == 0) {
            return ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"ExecDataService_03", (String)APPPARAM, (Object[])new Object[0]);
        }
        return String.format(ResManager.loadKDString((String)"\u5f02\u5e38\u6570\u636e\uff1a%1$s\u6761\u3002", (String)"ExecDataService_05", (String)APPPARAM, (Object[])new Object[0]), size);
    }

    private boolean saveOperateOption(DynamicObject resultTableData) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)resultTableData.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{resultTableData}, (OperateOption)operateOption);
        String errorMsg = ResourceCheckUtils.getErrorMsg((OperationResult)operationResult);
        if (!StringUtils.isEmpty((String)errorMsg)) {
            throw new KDBizException(new ErrorCode("saveOperateOption error", errorMsg), new Object[0]);
        }
        return true;
    }

    private boolean isError(Map<String, Object> execResultMap) {
        return execResultMap != null && execResultMap.get("result") != null && (Boolean)execResultMap.get("result") == false;
    }

    private String getErrorMsg(Map<String, Object> execResultMap) {
        return execResultMap == null ? "" : (execResultMap.get("msg") == null ? "" : (String)execResultMap.get("msg"));
    }

    private DynamicObject getResultTableObject(Long id, String resultEntity) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)resultEntity);
    }

    private DynamicObject getResourceCheckObject(Long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"msplan_resourcecheck");
    }

    private DynamicObject getResourceCheckObjectByMap(Map<String, Object> paramMap) {
        Object obj = paramMap.get("resourceCheckObj");
        if (obj != null) {
            return (DynamicObject)obj;
        }
        Long id = Long.parseLong(paramMap.get("resourceCheckId").toString());
        return this.getResourceCheckObject(id);
    }

    private DynamicObject getResultTableObjectByMap(Map<String, Object> paramMap) {
        Long id = Long.parseLong(paramMap.get("resultTableId").toString());
        String resultEntityNumber = paramMap.get("resultTableEntityNumber").toString();
        return this.getResultTableObject(id, resultEntityNumber);
    }

    static {
        scmDBRoute = new DBRoute("scm");
        ONE000 = new BigDecimal("1000");
    }
}

