/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.resourcecheck.task;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;
import kd.mpscmm.msplan.mservice.service.resourcecheck.task.ExecDataService;
import kd.mpscmm.msplan.mservice.service.resourcecheck.task.ExecUtils;
import kd.mpscmm.msplan.mservice.service.resourcecheck.task.batch.BatchComputeTaskEvent;
import kd.mpscmm.msplan.resourcecheck.consts.ResourceCheckConsts;
import kd.mpscmm.msplan.resourcecheck.utils.ResourceCheckUtils;
import kd.mpscmm.msplan.resourcecheck.utils.SqlParamUtils;

public class ExecResourceCheckTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ExecResourceCheckTask.class);
    private static final String APPPARAM = "mpscmm-msplan-mservice";
    private static final BigDecimal ALLSTEP = new BigDecimal("80");
    private static final long BATCHCOMPUTE_TIMELONG = 0x6DDD00L;
    private static final int BATCH_SIZE = 1000;

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u8d44\u6e90\u68c0\u67e5\u5de5\u5177\u5f02\u6b65\u6267\u884c\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"ExecResourceCheckTask_01", (String)APPPARAM, (Object[])new Object[0]);
        this.feedbackProgress(0, desc, null);
        try {
            if (this.loopExecData(rc, params)) {
                this.feedbackProgress(98, ResManager.loadKDString((String)"\u8d44\u6e90\u68c0\u67e5\u5de5\u5177\u5f02\u6b65\u6267\u884c\u5b8c\u6bd5\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d...", (String)"ExecResourceCheckTask_02", (String)APPPARAM, (Object[])new Object[0]), null);
            }
        }
        catch (Exception e) {
            log.warn("ExecResourceCheckTask.execute error", (Throwable)e);
            this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u8d44\u6e90\u68c0\u67e5\u53d1\u751f\u5931\u8d25\u6216\u7ec8\u6b62\u64cd\u4f5c:", (String)"ExecResourceCheckTask_03", (String)APPPARAM, (Object[])new Object[0]) + e.getMessage(), null);
        }
    }

    private Long getTagId(Map<String, Object> params) {
        return params.get("tagid") == null ? 0L : Long.parseLong(params.get("tagid").toString());
    }

    private Map<Long, Set<Long>> getSrcMap(Map<String, Object> params) {
        Object srcMapObj = params.get("srcmap");
        HashMap<Long, Set<Long>> newSrcMap = new HashMap<Long, Set<Long>>(16);
        if (srcMapObj != null) {
            if (srcMapObj instanceof JSONObject) {
                JSONObject srcJsonObject = (JSONObject)srcMapObj;
                for (String keyId : srcJsonObject.keySet()) {
                    String values = srcJsonObject.getString(keyId);
                    Set itemSet = SqlParamUtils.ParseStringToLongSet((String)values);
                    Long keyItem = Long.parseLong(keyId);
                    newSrcMap.put(keyItem, itemSet);
                }
                return newSrcMap;
            }
            HashMap srcMap = (HashMap)srcMapObj;
            for (Map.Entry mapEntrys : srcMap.entrySet()) {
                String ids = mapEntrys.getKey().toString();
                String values = mapEntrys.getValue().toString();
                Set itemSet = SqlParamUtils.ParseStringToLongSet((String)values);
                Long keyItem = Long.parseLong(ids);
                newSrcMap.put(keyItem, itemSet);
            }
        }
        return newSrcMap;
    }

    private Set<Long> getResourceCheckIdSet(Map<String, Object> params) {
        String ids = params.get("resourcecheckids") == null ? "" : params.get("resourcecheckids").toString();
        return SqlParamUtils.ParseStringToLongSet((String)ids);
    }

    private Long getResultDataId(Long tagId, String resultEntity, Long resourceCheckId) {
        QFilter qfilter = new QFilter("tagid", "=", (Object)tagId);
        qfilter.and(new QFilter("checkstatus", "=", (Object)"A"));
        qfilter.and(new QFilter("resourcecheck", "=", (Object)resourceCheckId));
        DynamicObject dy = QueryServiceHelper.queryOne((String)resultEntity, (String)"id", (QFilter[])qfilter.toArray());
        return dy.getLong("id");
    }

    public int getOneStepCount(int allSize) {
        if (allSize <= 0) {
            return ALLSTEP.intValue();
        }
        int oneStep = ALLSTEP.divide(new BigDecimal(allSize + ""), new MathContext(10)).intValue();
        return oneStep == 0 ? 1 : oneStep;
    }

    public int getCurrentSetp(int currentSeq, int oneStepCount) {
        BigDecimal step = new BigDecimal(currentSeq + "").multiply(new BigDecimal(oneStepCount + ""));
        return step.compareTo(ALLSTEP) > 0 ? ALLSTEP.intValue() : step.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loopExecData(RequestContext rc, Map<String, Object> params) throws KDException {
        Long tagId = this.getTagId(params);
        Set<Long> resourceCheckIds = this.getResourceCheckIdSet(params);
        Map<Long, Set<Long>> srcMap = this.getSrcMap(params);
        Map checkItemMap = BusinessDataServiceHelper.loadFromCache((Object[])resourceCheckIds.toArray(), (String)"msplan_resourcecheck");
        String batchQueue = this.getBatchQueue();
        boolean isBatchComoute = this.isBatchCompute() && !StringUtils.isEmpty((String)batchQueue) && checkItemMap.size() > 1;
        int oneStepCount = this.getOneStepCount(checkItemMap.size());
        int size = 0;
        BatchTask task = null;
        if (isBatchComoute) {
            task = BatchTask.create(this.getTaskName());
            task.setQueueName(batchQueue);
            task.registBizClass(BatchComputeTaskEvent.class);
            task.setTimeOut(0x6DDD00L);
        }
        HashMap<String, HashSet<Long>> resultTableIdMap = new HashMap<String, HashSet<Long>>(16);
        for (Map.Entry checkEntrys : checkItemMap.entrySet()) {
            String resultEntity;
            Long resultTableDataId;
            if (this.isReturn()) {
                return false;
            }
            DynamicObject resourceCheck = (DynamicObject)checkEntrys.getValue();
            if (!"A".equals(resourceCheck.getString("checkrange")) || (resultTableDataId = this.getResultDataId(tagId, resultEntity = resourceCheck.getDynamicObject("resultentitynumber") == null ? "msplan_checkresult" : (String)resourceCheck.getDynamicObject("resultentitynumber").getPkValue(), resourceCheck.getLong("id"))) == null || resultTableDataId.equals(0L)) continue;
            HashSet<Long> tableIds = (HashSet<Long>)resultTableIdMap.get(resultEntity);
            if (tableIds == null) {
                tableIds = new HashSet<Long>(16);
            }
            tableIds.add(resultTableDataId);
            resultTableIdMap.put(resultEntity, tableIds);
            HashMap<String, Object> queryParamMap = new HashMap<String, Object>(16);
            queryParamMap.put("execSize", ++size);
            queryParamMap.put("resultTableId", resultTableDataId);
            queryParamMap.put("resultTableEntityNumber", resultEntity);
            if (isBatchComoute) {
                queryParamMap.put("resourceCheckId", resourceCheck.getPkValue());
                if (task == null) continue;
                task.addEvent(queryParamMap);
                continue;
            }
            int currentSetp = this.getCurrentSetp(size, oneStepCount);
            String currentDesc = String.format(ResManager.loadKDString((String)"\u6267\u884c\u68c0\u67e5\u9879\u70b9:%1$s", (String)"ExecResourceCheckTask_05", (String)APPPARAM, (Object[])new Object[0]), resourceCheck.getString("number"));
            this.feedbackProgress(currentSetp, currentDesc, null);
            queryParamMap.put("resourceCheckObj", resourceCheck);
            this.execSingleData(queryParamMap);
        }
        if (isBatchComoute && task != null) {
            boolean successful = true;
            String errorMsg = "";
            try {
                int currentSetp = 50;
                String currentDesc = ResManager.loadKDString((String)"\u6b63\u5728\u8c03\u7528\u5206\u5e03\u5f0f\u6267\u884c\u8d44\u6e90\u68c0\u67e5\u4efb\u52a1\u3002", (String)"ExecResourceCheckTask_07", (String)APPPARAM, (Object[])new Object[0]);
                this.feedbackProgress(currentSetp, currentDesc, null);
                task.startTask();
            }
            catch (Exception e) {
                String s = ResManager.loadKDString((String)"ExecResourceCheckTask_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a", (String)"ExecResourceCheckTask_12", (String)APPPARAM, (Object[])new Object[0]);
                log.error(s + e.getMessage(), (Throwable)e);
                successful = false;
                errorMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            }
            finally {
                task.terminate();
            }
            if (!successful) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u68c0\u67e5\u5206\u5e03\u5f0f\u8fd0\u7b97\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7%1$s\u3002", (String)"ExecResourceCheckTask_06", (String)APPPARAM, (Object[])new Object[0]), errorMsg));
            }
        }
        for (Map.Entry checkEntrys : checkItemMap.entrySet()) {
            if (this.isReturn()) {
                return false;
            }
            DynamicObject resourceCheck = (DynamicObject)checkEntrys.getValue();
            if (!"B".equals(resourceCheck.getString("checkrange"))) continue;
            int currentSetp = this.getCurrentSetp(++size, oneStepCount);
            String currentDesc = String.format(ResManager.loadKDString((String)"\u6267\u884c\u68c0\u67e5\u9879\u70b9:%1$s", (String)"ExecResourceCheckTask_05", (String)APPPARAM, (Object[])new Object[0]), resourceCheck.getString("number"));
            this.feedbackProgress(currentSetp, currentDesc, null);
            String resultEntity = resourceCheck.getDynamicObject("resultentitynumber") == null ? "msplan_checkresult" : (String)resourceCheck.getDynamicObject("resultentitynumber").getPkValue();
            Long resultTableDataId = this.getResultDataId(tagId, resultEntity, resourceCheck.getLong("id"));
            if (resultTableDataId == null || resultTableDataId.equals(0L)) continue;
            HashMap<String, Object> queryParamMap = new HashMap<String, Object>(16);
            queryParamMap.put("execSize", size);
            queryParamMap.put("resultTableId", resultTableDataId);
            queryParamMap.put("resultTableEntityNumber", resultEntity);
            queryParamMap.put("resourceCheckObj", resourceCheck);
            this.execGroupCheckData(queryParamMap);
        }
        this.feedbackProgress(90, ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u4e1a\u52a1\u5bf9\u8c61\u68c0\u67e5\u7ed3\u679c\u8868\u6570\u636e\u3002", (String)"ExecResourceCheckTask_08", (String)APPPARAM, (Object[])new Object[0]), null);
        String resultSelectProp = this.getResultProperties();
        String bizResultSelectProp = this.getBizResultProperties();
        HashMap<String, DynamicObject> allBizResults = new HashMap<String, DynamicObject>(64);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String yp = sdf.format(new Date());
        int seq = 0;
        HashMap<String, Map<Long, JSONObject>> cacheBizMap = new HashMap<String, Map<Long, JSONObject>>(64);
        HashMap<String, Set> cacheBizIdSetMap = new HashMap<String, Set>(64);
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(64);
        for (Map.Entry resultTables : resultTableIdMap.entrySet()) {
            DynamicObject[] results;
            String resultEntity = (String)resultTables.getKey();
            Set resultTableIds = (Set)resultTables.getValue();
            for (DynamicObject result : results = BusinessDataServiceHelper.load((String)resultEntity, (String)resultSelectProp, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)resultTableIds)})) {
                if (this.isReturn()) {
                    return false;
                }
                resultList.add(result);
                DynamicObject resourceCheck = result.getDynamicObject("resourcecheck");
                resourceCheck = (DynamicObject)checkItemMap.get(resourceCheck.getPkValue());
                String idSetTag = resourceCheck.getString("idsetfieldtag");
                String bizEntityNumber = (String)resourceCheck.getDynamicObject("mainentity").getPkValue();
                boolean isBillId = "id".equalsIgnoreCase(idSetTag);
                String bizKeys = idSetTag + "_" + (String)bizEntityNumber;
                Map<Long, JSONObject> bizDataMap = (Map<Long, JSONObject>)cacheBizMap.get(bizKeys);
                if (bizDataMap == null) {
                    String execDatas = result.getString("execdatas_tag");
                    Set selectBizIdSet = ResourceCheckUtils.getDataRangeIdSet((String)execDatas, (String)idSetTag, (String)bizEntityNumber);
                    bizDataMap = ExecUtils.queryBizFieldData(selectBizIdSet, resourceCheck);
                    cacheBizMap.put(bizKeys, bizDataMap);
                    cacheBizIdSetMap.put(bizKeys, selectBizIdSet);
                }
                Set selectBizIdSet = (Set)cacheBizIdSetMap.get(bizKeys);
                DynamicObjectCollection resultEntryColl = result.getDynamicObjectCollection("entryentity");
                HashSet<Long> allBizIdSet = new HashSet<Long>(16);
                this.addToSet(allBizIdSet, selectBizIdSet);
                for (DynamicObject resultEntry : resultEntryColl) {
                    Long bizBillEnryId = resultEntry.getLong("bizbillentryid");
                    Long bizBillId = resultEntry.getLong("bizbillid");
                    Long bizId = isBillId ? bizBillId : bizBillEnryId;
                    if (bizId == null || bizId.equals(0L)) continue;
                    allBizIdSet.add(bizId);
                }
                cacheBizIdSetMap.put(bizKeys, allBizIdSet);
            }
        }
        for (DynamicObject result : resultList) {
            if (this.isReturn()) {
                return false;
            }
            DynamicObject resourceCheck = result.getDynamicObject("resourcecheck");
            resourceCheck = (DynamicObject)checkItemMap.get(resourceCheck.getPkValue());
            String idSetTag = resourceCheck.getString("idsetfieldtag");
            String bizEntityNumber = (String)resourceCheck.getDynamicObject("mainentity").getPkValue();
            boolean isBillId = "id".equalsIgnoreCase(idSetTag);
            String bizKeys = idSetTag + "_" + bizEntityNumber;
            Map bizDataMap = (Map)cacheBizMap.get(bizKeys);
            Set allBizIdSet = (Set)cacheBizIdSetMap.get(bizKeys);
            DynamicObjectCollection resultEntryColl = result.getDynamicObjectCollection("entryentity");
            HashMap<Long, DynamicObject> errorEntryMap = new HashMap<Long, DynamicObject>(resultEntryColl.size());
            for (DynamicObject resultEntry : resultEntryColl) {
                Long bizBillEnryId = resultEntry.getLong("bizbillentryid");
                Long bizBillId = resultEntry.getLong("bizbillid");
                Long bizId = isBillId ? bizBillId : bizBillEnryId;
                if (bizId == null || bizId.equals(0L)) continue;
                errorEntryMap.put(bizId, resultEntry);
            }
            Set<Long> srcIdSet = srcMap.get((Long)resourceCheck.getPkValue());
            for (Long srcRosourceCheckId : srcIdSet) {
                if (allBizIdSet.isEmpty()) continue;
                Set<Long> notIds = this.getNotExistsBizResult(allBizResults, allBizIdSet, bizEntityNumber, idSetTag, srcRosourceCheckId);
                this.getBizResultTableData(allBizResults, notIds, resourceCheck, bizResultSelectProp, resourceCheckIds, srcRosourceCheckId);
                for (Long bizId : allBizIdSet) {
                    String keyStr = this.getKeyString(bizId, idSetTag, bizEntityNumber, srcRosourceCheckId);
                    DynamicObject bizResult = (DynamicObject)allBizResults.get(keyStr);
                    bizResult.set("tagid", (Object)tagId);
                    if (StringUtils.isEmpty((String)bizResult.getString("billno"))) {
                        bizResult.set("billno", (Object)("B_" + yp + "_" + ++seq));
                    }
                    this.buildBizResultEntry(bizResult, (DynamicObject)errorEntryMap.get(bizId), result, bizDataMap);
                }
                if (allBizResults.size() < 1000) continue;
                this.saveBizResultData(allBizResults);
            }
        }
        if (allBizResults.size() > 0) {
            this.saveBizResultData(allBizResults);
        }
        this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6bd5", (String)"ExecResourceCheckTask_04", (String)APPPARAM, (Object[])new Object[0]), 3000);
        return true;
    }

    private void saveBizResultData(Map<String, DynamicObject> allBizResults) {
        ArrayList<DynamicObject> dataListA = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> dataListB = new ArrayList<DynamicObject>(16);
        for (Map.Entry<String, DynamicObject> entrys : allBizResults.entrySet()) {
            DynamicObject data = entrys.getValue();
            this.resetBizResultHeadStatus(data);
            if (data.getPkValue() == null || data.getPkValue().equals(0L)) {
                dataListA.add(data);
                continue;
            }
            dataListB.add(data);
        }
        this.saveListData(dataListA);
        this.saveListData(dataListB);
        allBizResults.clear();
    }

    private void saveListData(List<DynamicObject> dataList) {
        if (dataList != null && !dataList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dataList.toArray(new DynamicObject[dataList.size()]), (OperateOption)OperateOption.create());
        }
    }

    private void buildBizResultEntry(DynamicObject bizResult, DynamicObject errorResultEntry, DynamicObject result, Map<Long, JSONObject> bizDataMap) {
        DynamicObjectCollection coll = bizResult.getDynamicObjectCollection("entryentity");
        DynamicObject entry = this.getBizResultEntry(coll, result.getDynamicObject("resourcecheck"));
        Long bizId = bizResult.getLong("bizbillid");
        entry.set("seq", (Object)coll.size());
        entry.set("entryresourcecheck", (Object)result.getDynamicObject("resourcecheck"));
        entry.set("entryresultbillid", result.getPkValue());
        entry.set("entryresultbillno", (Object)result.getString("billno"));
        entry.set("entrycheckresult", (Object)"A");
        if (errorResultEntry != null) {
            entry.set("entrycheckresult", (Object)"B");
            bizResult.set("bizbillno", errorResultEntry.get("bizbillno"));
            bizResult.set("bizorg", (Object)ResourceCheckUtils.getLongId((DynamicObject)errorResultEntry, (String)"bizorg"));
            bizResult.set("bizmaterial", (Object)ResourceCheckUtils.getLongId((DynamicObject)errorResultEntry, (String)"bizmaterial"));
            bizResult.set("checkresult", (Object)"B");
        } else {
            JSONObject bizDataJsonObject = bizDataMap.get(bizId);
            if (bizDataJsonObject != null) {
                bizResult.set("bizbillno", bizDataJsonObject.get((Object)"bizbillno"));
                bizResult.set("bizorg", bizDataJsonObject.get((Object)"bizorg"));
                bizResult.set("bizmaterial", bizDataJsonObject.get((Object)"bizmaterial"));
            }
        }
        if ("D".equals(result.getString("checkstatus"))) {
            entry.set("entrycheckresult", (Object)"C");
            bizResult.set("checkresult", (Object)"C");
        }
    }

    private DynamicObject getBizResultEntry(DynamicObjectCollection coll, DynamicObject resourceCheck) {
        for (DynamicObject entry : coll) {
            if (!entry.getDynamicObject("entryresourcecheck").getPkValue().equals(resourceCheck.getPkValue())) continue;
            return entry;
        }
        return coll.addNew();
    }

    private Set<Long> getNotExistsBizResult(Map<String, DynamicObject> allBizResults, Set<Long> allBizIdSet, String entityNumber, String idSetTag, Long srcResourceId) {
        HashSet<Long> ids = new HashSet<Long>(16);
        for (Long id : allBizIdSet) {
            String keyStr = this.getKeyString(id, idSetTag, entityNumber, srcResourceId);
            if (allBizResults.containsKey(keyStr)) continue;
            ids.add(id);
        }
        return ids;
    }

    private void addBizResultTableData(Map<String, DynamicObject> allBizResults, Long bizId, DynamicObject resourceCheck, Long srcRosourceCheckId) {
        DynamicObject mainEntity = resourceCheck.getDynamicObject("mainentity");
        DynamicObject bizResult = BusinessDataServiceHelper.newDynamicObject((String)"msplan_bizbillcheckresult");
        bizResult.set("createtime", (Object)new Date());
        bizResult.set("creator", (Object)RequestContext.get().getCurrUserId());
        bizResult.set("billstatus", (Object)"A");
        bizResult.set("bizentity", (Object)mainEntity);
        bizResult.set("bizbillid", (Object)bizId);
        bizResult.set("bizidtag", (Object)resourceCheck.getString("idsetfieldtag"));
        bizResult.set("tagid", (Object)0L);
        bizResult.set("checkresult", (Object)"A");
        bizResult.set("bizbillno", (Object)"");
        bizResult.set("bizorg", null);
        bizResult.set("bizmaterial", null);
        bizResult.set("srcresourcecheck", (Object)srcRosourceCheckId);
        allBizResults.put(this.getKeyString(bizId, resourceCheck.getString("idsetfieldtag"), (String)mainEntity.getPkValue(), srcRosourceCheckId), bizResult);
    }

    private String genRemark(DynamicObject bizResult) {
        String checkResult = bizResult.getString("checkresult");
        return this.getBizResultStr(checkResult);
    }

    private String getBizResultStr(String checkResult) {
        if ("A".equals(checkResult)) {
            return ResManager.loadKDString((String)"\u901a\u8fc7", (String)"ExecResourceCheckTask_09", (String)APPPARAM, (Object[])new Object[0]);
        }
        if ("B".equals(checkResult)) {
            return ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"ExecResourceCheckTask_10", (String)APPPARAM, (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u68c0\u67e5\u5f02\u5e38", (String)"ExecResourceCheckTask_11", (String)APPPARAM, (Object[])new Object[0]);
    }

    private void resetBizResultHeadStatus(DynamicObject bizResult) {
        DynamicObjectCollection coll = bizResult.getDynamicObjectCollection("entryentity");
        bizResult.set("checkresult", (Object)"A");
        for (DynamicObject entry : coll) {
            if ("B".equals(entry.getString("entrycheckresult"))) {
                bizResult.set("checkresult", (Object)"B");
                continue;
            }
            if (!"C".equals(entry.getString("entrycheckresult"))) continue;
            bizResult.set("checkresult", (Object)"C");
            break;
        }
        bizResult.set("checkremark", (Object)this.genRemark(bizResult));
    }

    private void getBizResultTableData(Map<String, DynamicObject> allBizResults, Set<Long> bizIdSet, DynamicObject resourceCheck, String selectProperties, Set<Long> resourceCheckIds, Long srcRosourceCheckId) {
        if (bizIdSet != null && !bizIdSet.isEmpty()) {
            String idSetTag = resourceCheck.getString("idsetfieldtag");
            String bizEntityNumber = (String)resourceCheck.getDynamicObject("mainentity").getPkValue();
            QFilter qfilter = new QFilter("bizbillid", "in", bizIdSet);
            qfilter.and(new QFilter("bizentity", "=", (Object)bizEntityNumber));
            qfilter.and(new QFilter("bizidtag", "=", (Object)idSetTag));
            qfilter.and(new QFilter("srcresourcecheck", "=", (Object)srcRosourceCheckId));
            DynamicObject[] bizResults = BusinessDataServiceHelper.load((String)"msplan_bizbillcheckresult", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
            for (DynamicObject bizResult : bizResults) {
                DynamicObjectCollection coll = bizResult.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection removeColl = new DynamicObjectCollection();
                for (DynamicObject entry : coll) {
                    DynamicObject entryResourceCheck = entry.getDynamicObject("entryresourcecheck");
                    if (entryResourceCheck != null && resourceCheckIds.contains(entryResourceCheck.getLong("id"))) continue;
                    removeColl.add((Object)entry);
                }
                if (!removeColl.isEmpty()) {
                    for (DynamicObject entry : removeColl) {
                        coll.remove((Object)entry);
                    }
                }
                bizResult.set("createtime", (Object)new Date());
                bizResult.set("creator", (Object)RequestContext.get().getCurrUserId());
                String keyStr = this.getKeyString(bizResult.getLong("bizbillid"), idSetTag, bizEntityNumber, srcRosourceCheckId);
                allBizResults.put(keyStr, bizResult);
            }
            for (Long bizId : bizIdSet) {
                String keyStr = this.getKeyString(bizId, idSetTag, bizEntityNumber, srcRosourceCheckId);
                DynamicObject dy = allBizResults.get(keyStr);
                if (dy != null) continue;
                this.addBizResultTableData(allBizResults, bizId, resourceCheck, srcRosourceCheckId);
            }
        }
    }

    private String getKeyString(Long bizId, String idSetTag, String entityNumber, Long srcResourceId) {
        StringBuilder sb = new StringBuilder();
        sb.append(bizId).append("_").append(idSetTag).append("_").append(entityNumber).append("_").append(srcResourceId);
        return sb.toString();
    }

    private boolean isReturn() {
        if (this.isStop()) {
            this.stop();
            return true;
        }
        return false;
    }

    private void addToSet(Set<Long> setA, Set<Long> setB) {
        if (setB != null && !setB.isEmpty()) {
            setA.addAll(setB);
        }
    }

    private String getResultProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",").append("billno");
        sb.append(",").append("checkstatus");
        sb.append(",").append("execdatas_tag");
        sb.append(",").append("resourcecheck");
        sb.append(",").append("tagid");
        sb.append(",").append("entryentity").append(".").append("bizbillentryid");
        sb.append(",").append("entryentity").append(".").append("bizbillid");
        sb.append(",").append("entryentity").append(".").append("bizbillno");
        sb.append(",").append("entryentity").append(".").append("bizmaterial");
        sb.append(",").append("entryentity").append(".").append("bizorg");
        return sb.toString();
    }

    private String getBizResultProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",").append("billno");
        sb.append(",").append("billstatus");
        sb.append(",").append("bizentity");
        sb.append(",").append("bizbillid");
        sb.append(",").append("bizbillno");
        sb.append(",").append("bizidtag");
        sb.append(",").append("bizorg");
        sb.append(",").append("bizmaterial");
        sb.append(",").append("checkresult");
        sb.append(",").append("checkremark");
        sb.append(",").append("createtime");
        sb.append(",").append("creator");
        sb.append(",").append("modifytime");
        sb.append(",").append("modifier");
        sb.append(",").append("tagid");
        sb.append(",").append("entryentity").append(".").append("entryresourcecheck");
        sb.append(",").append("entryentity").append(".").append("entrycheckresult");
        sb.append(",").append("entryentity").append(".").append("entryresultbillid");
        sb.append(",").append("entryentity").append(".").append("entryresultbillno");
        sb.append(",").append("entryentity").append(".").append("seq");
        sb.append(",entryentity.modifierfield");
        sb.append(",entryentity.modifydatefield");
        sb.append(",auditor");
        sb.append(",auditdate");
        return sb.toString();
    }

    private boolean execSingleData(Map<String, Object> queryParamMap) {
        return ExecDataService.getInstance().execSingleData(queryParamMap);
    }

    private boolean execGroupCheckData(Map<String, Object> queryParamMap) {
        return ExecDataService.getInstance().execGroupCheckData(queryParamMap);
    }

    private String getTaskName() {
        return "msplan_ExecResourceCheck";
    }

    private void wrapFeedBack(boolean success, String msgType, String msg, Integer showTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msgType", msgType);
        result.put("msg", msg);
        if (null != showTime) {
            result.put("showTime", showTime);
        }
        this.feedbackCustomdata(result);
    }

    private boolean isBatchCompute() {
        DynamicObject dy = this.getParamSetConfig();
        return dy.getBoolean("isbatchcompute");
    }

    private String getBatchQueue() {
        DynamicObject dy = this.getParamSetConfig();
        return dy.getString("execqueue");
    }

    private DynamicObject getParamSetConfig() {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)ResourceCheckConsts.KEY_PARAMDEFID, (String)"msplan_rc_paramset", (String)"id,isbatchcompute,execqueue");
    }
}

