/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mservice.service.resourcecheck.task;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;
import kd.mpscmm.msplan.mservice.service.reportext.BillTransferEntryModel;
import kd.mpscmm.msplan.mservice.service.reportext.ReportExtModelService;
import kd.mpscmm.msplan.mservice.service.reportext.ReportUtils;
import kd.mpscmm.msplan.mservice.service.resourcecheck.exec.AbstractResourceCheckExecService;

public class ExecUtils {
    public static Map<String, IDataEntityProperty> getAllFieldProperty(String entityNumber) {
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection propColl = targetMainType.getProperties();
        HashMap<String, IDataEntityProperty> fieldMap = new HashMap<String, IDataEntityProperty>(16);
        int size = propColl.size();
        for (int j = 0; j < size; ++j) {
            String proname = ((IDataEntityProperty)propColl.get(j)).getName();
            if (!StringUtils.isNotEmpty((String)proname)) continue;
            fieldMap.put(proname.toLowerCase(), (IDataEntityProperty)propColl.get(j));
        }
        return fieldMap;
    }

    public static String getDefSelectProperties(String entityname, String idTag) {
        Map<String, String> fieldMap = ExecUtils.getDefFieldTransferMap(entityname, idTag);
        StringBuilder sb = new StringBuilder();
        int size = 0;
        for (Map.Entry<String, String> entrys : fieldMap.entrySet()) {
            String fromField = entrys.getValue();
            String toField = entrys.getKey();
            if (StringUtils.isEmpty((String)fromField) || StringUtils.isEmpty((String)toField)) continue;
            sb.append(size > 0 ? "," : "").append(fromField).append(" ").append(toField);
            ++size;
        }
        return sb.toString();
    }

    public static Map<String, String> getDefFieldTransferMap(String entityname, String idTag) {
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        dataMap.put("bizbillid", "id");
        dataMap.put("bizbillno", "number");
        dataMap.put("bizotherinfo", "name");
        dataMap.put("bizorg", "createorg");
        boolean isIdtag = "id".equalsIgnoreCase(idTag);
        if ("pdm_mftbom".equalsIgnoreCase(entityname) || "pdm_ecobom".equalsIgnoreCase(entityname)) {
            dataMap.put("bizmaterial", isIdtag ? "materialid" : "entry.entrymaterialid");
            dataMap.put("bizbillentryid", isIdtag ? "" : "entry.id");
        } else if ("bd_materialmftinfo".equalsIgnoreCase(entityname) || "bd_materialpurchaseinfo".equalsIgnoreCase(entityname) || "bd_materialsalinfo".equalsIgnoreCase(entityname) || "bd_materialinventoryinfo".equalsIgnoreCase(entityname) || "bd_inspect_cfg".equalsIgnoreCase(entityname) || "mpdm_materialplan".equalsIgnoreCase(entityname)) {
            dataMap.put("bizmaterial", "masterid");
        } else if ("pdm_route".equalsIgnoreCase(entityname) || "pdm_manuversion".equalsIgnoreCase(entityname) || "msplan_matplanscop".equalsIgnoreCase(entityname)) {
            dataMap.put("bizmaterial", "material");
        } else if ("pdm_bom_eco".equalsIgnoreCase(entityname)) {
            dataMap.put("bizbillno", "billno");
            dataMap.put("bizotherinfo", "name");
            dataMap.put("bizorg", "org");
            dataMap.put("bizbillentryid", isIdtag ? "" : "pentry.id");
            dataMap.put("bizmaterial", isIdtag ? "" : "pentry.proentrymaterialid");
        } else {
            Map<String, IDataEntityProperty> allFieldMap = ExecUtils.getAllFieldProperty(entityname);
            dataMap.put("bizbillno", allFieldMap.containsKey("number") ? "number" : (allFieldMap.containsKey("billno") ? "billno" : ""));
            dataMap.put("bizotherinfo", allFieldMap.containsKey("name") ? "name" : "");
            dataMap.put("bizorg", allFieldMap.containsKey("createorg") ? "createorg" : (allFieldMap.containsKey("org") ? "org" : ""));
            dataMap.put("bizbillentryid", isIdtag ? "" : idTag);
        }
        return dataMap;
    }

    public static BillTransferEntryModel getTransferModel(String srcField, String destField, String type, String formula, String srcTypeName, Map<String, IDataEntityProperty> allFields, Long entyId) {
        return ReportExtModelService.getInstance().getTransferModel(srcField, destField, type, formula, srcTypeName, allFields, entyId, false);
    }

    public static DataSet computeMapFunction(String billTransNumber, Map<String, BillTransferEntryModel> billTransMap, DataSet reportDataSet) {
        return ReportExtModelService.getInstance().computeMapFunction(billTransNumber, billTransMap, reportDataSet);
    }

    public static String getSelectFields(Set<Object> fieldSet) {
        StringBuilder sb = new StringBuilder();
        for (Object field : fieldSet) {
            if (StringUtils.isEmpty((String)((String)field))) continue;
            sb.append(field).append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    public static Map<Long, JSONObject> queryBizFieldData(Set<Long> bizIdSet, DynamicObject resourceCheck) {
        HashMap<Long, JSONObject> dataMap = new HashMap<Long, JSONObject>(bizIdSet.size());
        if (bizIdSet == null || bizIdSet.isEmpty()) {
            return dataMap;
        }
        String idTag = resourceCheck.getString("idsetfieldtag");
        String queryEntityNumber = (String)resourceCheck.getDynamicObject("mainentity").getPkValue();
        QFilter qFilter = new QFilter(idTag, "in", bizIdSet);
        boolean isId = "id".equalsIgnoreCase(idTag);
        DynamicObjectCollection resultFieldColl = resourceCheck.getDynamicObjectCollection("resultfieldentry");
        int loopSize = resultFieldColl.size();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)queryEntityNumber);
        String mainEntityTypeName = mainEntityType.getName();
        Map<String, IDataEntityProperty> mainEntntyAllFields = DataSourceFetchDataUtil.getAllEntityProp(mainEntityType);
        HashMap<String, BillTransferEntryModel> mainEntityFunctionMap = new HashMap<String, BillTransferEntryModel>(16);
        HashSet<Object> queryFieldSet = new HashSet<Object>(16);
        HashSet<String> resultColumnFieldSet = new HashSet<String>(16);
        HashSet<String> resultColumnFieldSetB = new HashSet<String>(16);
        for (int i = 0; i < loopSize; ++i) {
            DynamicObject fieldEntry = (DynamicObject)resultFieldColl.get(i);
            String convertType = fieldEntry.getString("resultconverttype");
            String formula = fieldEntry.getString("resultcalculateexc_tag");
            String destField = fieldEntry.getString("resultfieldflag");
            String srcField = fieldEntry.getString("resultsrcfieldflag");
            if (!StringUtils.isEmpty((String)formula)) {
                BillTransferEntryModel transModel = ExecUtils.getTransferModel(srcField, destField, convertType, formula, mainEntityTypeName, mainEntntyAllFields, (Long)fieldEntry.getPkValue());
                transModel.setSrcRenameField(destField);
                if (transModel.getCustomMethodStruct() != null) {
                    mainEntityFunctionMap.put(destField, transModel);
                    Set<String> paramSet = transModel.getFormulaSrcFields();
                    if (!ReportUtils.isNullSet(paramSet)) {
                        for (String field : paramSet) {
                            queryFieldSet.add(field + " as " + field);
                        }
                    }
                } else {
                    String queryFieldNumber = transModel.getFormulaStr();
                    if (!StringUtils.isEmpty((String)queryFieldNumber)) {
                        queryFieldSet.add(queryFieldNumber + " as " + destField);
                    }
                }
            } else if (!StringUtils.isEmpty((String)srcField)) {
                queryFieldSet.add(srcField + " as " + destField);
            }
            resultColumnFieldSet.add(destField);
        }
        String selectProperties = ExecUtils.getSelectFields(queryFieldSet);
        String alogStr = AbstractResourceCheckExecService.class.getName() + "_queryResultFields";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)alogStr, (String)mainEntityTypeName, (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)"");
        if (!ReportUtils.isNullMap(mainEntityFunctionMap)) {
            dataSet = ExecUtils.computeMapFunction("", mainEntityFunctionMap, dataSet);
        }
        for (String fieldNumber : resultColumnFieldSet) {
            if (!ReportUtils.isContainsField(fieldNumber, dataSet)) continue;
            resultColumnFieldSetB.add(fieldNumber);
        }
        if (!resultColumnFieldSetB.isEmpty()) {
            boolean isContainEntryId = ReportUtils.isContainsField("bizbillentryid", dataSet);
            while (dataSet.hasNext()) {
                Row arow = dataSet.next();
                Object billId = arow.get("bizbillid");
                Object billEntryId = isContainEntryId ? arow.get("bizbillentryid") : Long.valueOf(0L);
                Long bizId = isId ? (Long)billId : (Long)billEntryId;
                JSONObject dataJsonObject = new JSONObject(16);
                for (String fieldNumber : resultColumnFieldSetB) {
                    if (!ReportUtils.isContainsField(fieldNumber, dataSet)) continue;
                    dataJsonObject.put(fieldNumber, arow.get(fieldNumber));
                }
                dataMap.put(bizId, dataJsonObject);
            }
        }
        dataSet.close();
        return dataMap;
    }
}

